/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.util.SparseArray;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.graphics2d.TexturePaint;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.RendererSettings;
import armyc2.c2sd.renderer.utilities.ShapeInfo;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import java.util.ArrayList;

public class MilStdSymbol {
    private SparseArray<String> _Properties = null;
    private ArrayList<Double> _X_Altitude = null;
    private ArrayList<Double> _AM_Distance = null;
    private ArrayList<Double> _AN_Azimuth = null;
    private String _symbolID = "";
    private String _UUID = null;
    private ArrayList<ShapeInfo> _SymbolShapes;
    private ArrayList<ShapeInfo> _ModifierShapes;
    private ArrayList<Point2D> _Coordinates;
    private int _UnitSize = 0;
    private double _scale = 0.0;
    private Boolean _KeepUnitRatio = true;
    Integer _LineWidth = 3;
    Color _LineColor = null;
    Color _FillColor = null;
    Color _TextColor = null;
    Color _TextBackgroundColor = null;
    double _Rotation = 0.0;
    boolean _Outline = false;
    Color _OutLineColor = null;
    int _OutLineWidth = 0;
    TexturePaint _tp = null;
    boolean _fs = false;
    int _patternFillType = 0;
    public static final int Symbology_2525Bch2_USAS_13_14 = 0;
    public static final int Symbology_2525C = 1;
    private static int _SymbologyStandard = 0;
    private static String _AltitudeMode = "";
    private static boolean _useDashArray = true;
    private static boolean _hideOptionalLabels = false;
    private static boolean _DrawAffiliationModifierAsLabel = true;
    private static boolean _UseLineInterpolation = false;
    Object _Tag = null;
    private boolean _wasClipped = false;

    public MilStdSymbol(String symbolID, String uniqueID, ArrayList<Point2D> Coordinates, SparseArray<String> modifiers) {
        this(symbolID, uniqueID, Coordinates, modifiers, true);
    }

    public MilStdSymbol(String symbolID, String uniqueID, ArrayList<Point2D> Coordinates, SparseArray<String> modifiers, Boolean keepUnitRatio) {
        this._Properties = modifiers == null ? new SparseArray() : modifiers;
        this._UUID = uniqueID;
        this.setCoordinates(Coordinates);
        this.setSymbolID(symbolID);
        this.setLineColor(SymbolUtilities.getLineColorOfAffiliation(this._symbolID));
        if (SymbolUtilities.hasDefaultFill(this._symbolID)) {
            this.setFillColor(SymbolUtilities.getFillColorOfAffiliation(this._symbolID));
        }
        this.setSymbologyStandard(RendererSettings.getInstance().getSymbologyStandard());
        _DrawAffiliationModifierAsLabel = RendererSettings.getInstance().getDrawAffiliationModifierAsLabel();
        _UseLineInterpolation = RendererSettings.getInstance().getUseLineInterpolation();
    }

    public void setSymbologyStandard(int standard) {
        _SymbologyStandard = standard;
    }

    public TexturePaint getFillStyle() {
        return this._tp;
    }

    public void setFillStyle(TexturePaint value) {
        this._tp = value;
    }

    public boolean getUseFillPattern() {
        return this._fs;
    }

    public void setUseFillPattern(boolean value) {
        this._fs = value;
    }

    public int getPatternFillType() {
        return this._patternFillType;
    }

    public void setPatternFillType(int value) {
        this._patternFillType = value;
    }

    public int getSymbologyStandard() {
        return _SymbologyStandard;
    }

    public String getAltitudeMode() {
        return _AltitudeMode;
    }

    public void setAltitudeMode(String value) {
        _AltitudeMode = value;
    }

    public boolean getUseDashArray() {
        return _useDashArray;
    }

    public void setUseDashArray(boolean value) {
        _useDashArray = value;
    }

    public boolean getHideOptionalLabels() {
        return _hideOptionalLabels;
    }

    public void setHideOptionalLabels(boolean value) {
        _hideOptionalLabels = value;
    }

    public void setUseLineInterpolation(boolean value) {
        _UseLineInterpolation = value;
    }

    public boolean getUseLineInterpolation() {
        return _UseLineInterpolation;
    }

    public void setDrawAffiliationModifierAsLabel(boolean value) {
        _DrawAffiliationModifierAsLabel = value;
    }

    public boolean getDrawAffiliationModifierAsLabel() {
        return _DrawAffiliationModifierAsLabel;
    }

    public SparseArray<String> getModifierMap() {
        return this._Properties;
    }

    public void setModifierMap(SparseArray<String> modifiers) {
        this._Properties = modifiers;
    }

    public String getModifier(int modifier) {
        if (this._Properties.indexOfKey(modifier) >= 0) {
            return (String)this._Properties.get(modifier);
        }
        return this.getModifier(modifier, 0);
    }

    public void setModifier(int modifier, String value) {
        if (!value.equals("")) {
            if (modifier != 16 || modifier == 17 || modifier == 14) {
                this._Properties.put(modifier, (Object)value);
            } else {
                this.setModifier(modifier, value, 0);
            }
        }
    }

    public String getModifier(int modifier, int index) {
        if (this._Properties.indexOfKey(modifier) >= 0) {
            return (String)this._Properties.get(modifier);
        }
        if (modifier == 16 || modifier == 17 || modifier == 14) {
            String value = String.valueOf(this.getModifier_AM_AN_X(modifier, index));
            if (value != null && !value.equalsIgnoreCase("null") && !value.equalsIgnoreCase("")) {
                return value;
            }
            return null;
        }
        return null;
    }

    public Double getModifier_AM_AN_X(int modifier, int index) {
        ArrayList<Double> modifiers = null;
        if (modifier == 16) {
            modifiers = this._AM_Distance;
        } else if (modifier == 17) {
            modifiers = this._AN_Azimuth;
        } else if (modifier == 14) {
            modifiers = this._X_Altitude;
        } else {
            return null;
        }
        if (modifiers != null && modifiers.size() > index) {
            Double value = null;
            value = modifiers.get(index);
            if (value != null) {
                return value;
            }
            return null;
        }
        return null;
    }

    public void setModifier(int modifier, String value, int index) {
        if (!value.equals("")) {
            if (modifier != 16 && modifier != 17 && modifier != 14) {
                this._Properties.put(modifier, (Object)value);
            } else {
                Double dblValue = Double.valueOf(value);
                if (dblValue != null) {
                    this.setModifier_AM_AN_X(modifier, dblValue, index);
                }
            }
        }
    }

    public void setModifier_AM_AN_X(int modifier, Double value, int index) {
        if (modifier == 16 || modifier == 17 || modifier == 14) {
            ArrayList<Double> modifiers = null;
            if (modifier == 16) {
                if (this._AM_Distance == null) {
                    this._AM_Distance = new ArrayList();
                }
                modifiers = this._AM_Distance;
            } else if (modifier == 17) {
                if (this._AN_Azimuth == null) {
                    this._AN_Azimuth = new ArrayList();
                }
                modifiers = this._AN_Azimuth;
            } else if (modifier == 14) {
                if (this._X_Altitude == null) {
                    this._X_Altitude = new ArrayList();
                }
                modifiers = this._X_Altitude;
            }
            if (index + 1 > modifiers.size()) {
                modifiers.add(value);
            } else {
                modifiers.set(index, value);
            }
        }
    }

    public ArrayList<Double> getModifiers_AM_AN_X(int modifier) {
        if (modifier == 16) {
            return this._AM_Distance;
        }
        if (modifier == 17) {
            return this._AN_Azimuth;
        }
        if (modifier == 14) {
            return this._X_Altitude;
        }
        return null;
    }

    public void setModifiers_AM_AN_X(int modifier, ArrayList<Double> modifiers) {
        if (modifier == 16) {
            this._AM_Distance = modifiers;
        } else if (modifier == 17) {
            this._AN_Azimuth = modifiers;
        } else if (modifier == 14) {
            this._X_Altitude = modifiers;
        }
    }

    public void setFillColor(Color value) {
        this._FillColor = value;
    }

    public Color getFillColor() {
        return this._FillColor;
    }

    public void setTextColor(Color value) {
        this._TextColor = value;
    }

    public Color getTextColor() {
        return this._TextColor;
    }

    public void setTextBackgroundColor(Color value) {
        this._TextBackgroundColor = value;
    }

    public Color getTextBackgroundColor() {
        return this._TextBackgroundColor;
    }

    public void setLineWidth(int value) {
        this._LineWidth = value;
    }

    public int getLineWidth() {
        return this._LineWidth;
    }

    public void setLineColor(Color value) {
        if (value != null) {
            this._LineColor = value;
        }
    }

    public Color getLineColor() {
        return this._LineColor;
    }

    public void setOutlineColor(Color value) {
        this._OutLineColor = value;
    }

    public Color getOutlineColor() {
        return this._OutLineColor;
    }

    public void setTag(Object value) {
        this._Tag = value;
    }

    public Object getTag() {
        return this._Tag;
    }

    public void setCoordinates(ArrayList<Point2D> value) {
        this._Coordinates = value;
    }

    public ArrayList<Point2D> getCoordinates() {
        return this._Coordinates;
    }

    public void setModifierShapes(ArrayList<ShapeInfo> value) {
        this._ModifierShapes = value;
    }

    public ArrayList<ShapeInfo> getModifierShapes() {
        return this._ModifierShapes;
    }

    public void setSymbolShapes(ArrayList<ShapeInfo> value) {
        this._SymbolShapes = value;
    }

    public ArrayList<ShapeInfo> getSymbolShapes() {
        return this._SymbolShapes;
    }

    public String getSymbolID() {
        return this._symbolID;
    }

    public String getUUID() {
        return this._UUID;
    }

    public void setUUID(String ID) {
        this._UUID = ID;
    }

    public void setSymbolID(String value) {
        String current = this._symbolID;
        try {
            String basicID;
            if (value != null && !value.equals("") && !current.equals(value)) {
                this._symbolID = value;
            }
            if (SymbolUtilities.getAffiliation(value) == 'H' && (SymbolUtilities.isObstacle(basicID = SymbolUtilities.getBasicSymbolID(value)) || basicID.equals("G*M*NZ----****X") || basicID.equals("G*M*NEB---****X") || basicID.equals("G*M*NEC---****X"))) {
                this.setModifier(6, "ENY");
            }
        }
        catch (Exception e) {
            ErrorLogger.LogException("MilStdSymbol", "setSymbolID - Did not fall under TG or FE", e);
        }
    }

    public void set_WasClipped(boolean value) {
        this._wasClipped = value;
    }

    public boolean get_WasClipped() {
        return this._wasClipped;
    }
}

