/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import armyc2.c2sd.renderer.utilities.RectUtilities;

public class ImageInfo {
    private Point _centerPoint = null;
    private Rect _symbolBounds = null;
    private Rect _imageBounds = null;
    private Bitmap _image = null;

    public ImageInfo(ImageInfo original) {
        this._centerPoint = new Point(original.getCenterPoint());
        this._symbolBounds = new Rect(original.getSymbolBounds());
        this._image = original.getImage();
        this._imageBounds = new Rect(original.getImageBounds());
    }

    public ImageInfo(Bitmap image, Point centerPoint, Rect symbolBounds) {
        this._centerPoint = centerPoint;
        this._symbolBounds = symbolBounds;
        this._image = image;
        this._imageBounds = RectUtilities.makeRect(0, 0, image.getWidth(), image.getHeight());
    }

    public ImageInfo getLightClone() {
        return new ImageInfo(this._image, new Point(this._centerPoint), new Rect(this._symbolBounds));
    }

    public ImageInfo getClone(ImageInfo original) {
        Point centerPoint = new Point(original.getCenterPoint());
        Rect symbolBounds = new Rect(original.getSymbolBounds());
        Bitmap image = original.getImage().copy(Bitmap.Config.ARGB_8888, false);
        return new ImageInfo(this._image, new Point(this._centerPoint), new Rect(this._symbolBounds));
    }

    public Bitmap getImage() {
        return this._image;
    }

    public Point getCenterPoint() {
        return this._centerPoint;
    }

    public Rect getSymbolBounds() {
        return this._symbolBounds;
    }

    public Rect getImageBounds() {
        return this._imageBounds;
    }

    public ImageInfo getSquareImageInfo() {
        int y;
        int x;
        int iheight;
        int iwidth;
        ImageInfo ii = null;
        int width = this._imageBounds.width();
        int height = this._imageBounds.height();
        if (this._imageBounds.width() > this._imageBounds.height()) {
            iwidth = this._imageBounds.width();
            iheight = this._imageBounds.width();
            x = 0;
            y = (iheight - height) / 2;
        } else if (this._imageBounds.width() < this._imageBounds.height()) {
            iwidth = this._imageBounds.height();
            iheight = this._imageBounds.height();
            x = (iwidth - width) / 2;
            y = 0;
        } else {
            iwidth = this._imageBounds.width();
            iheight = this._imageBounds.height();
            x = 0;
            y = 0;
        }
        Bitmap bmp = Bitmap.createBitmap((int)iwidth, (int)iheight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas ctx = new Canvas(bmp);
        ctx.drawBitmap(this._image, (float)x, (float)y, null);
        Point center = new Point(this._centerPoint);
        center.offset(x, y);
        Rect symbolBounds = new Rect(this._symbolBounds);
        symbolBounds.offset(x, y);
        ii = new ImageInfo(bmp, center, symbolBounds);
        return ii;
    }
}

