/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.Log;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

public class FontManager {
    public static String FONT_UNIT = "UF";
    public static String FONT_SPTG = "SF";
    public static String FONT_MPTG = "MF";
    private static FontManager _instance = null;
    private static Boolean _initSuccess = false;
    private Typeface _tfUnits = null;
    private Typeface _tfSP = null;
    private Typeface _tfTG = null;
    private String unitFontName = "unitfont.ttf";
    private String spFontName = "singlepointfont.ttf";
    private String tgFontName = "tacticalgraphicsfont.ttf";
    private String _cacheDir = "";

    private FontManager() {
    }

    public static synchronized FontManager getInstance() {
        if (_instance == null) {
            _instance = new FontManager();
        }
        return _instance;
    }

    public synchronized void init(String cacheDir) {
        if (!_initSuccess.booleanValue()) {
            this._cacheDir = cacheDir;
            this._tfUnits = this.loadFont(this.unitFontName);
            this._tfSP = this.loadFont(this.spFontName);
            this._tfTG = this.loadFont(this.tgFontName);
            if (this._tfUnits != null && this._tfSP != null && this._tfTG != null) {
                _initSuccess = true;
            } else {
                throw new Error("FontManager:  failed to load font files using " + cacheDir + " as the cache directory.");
            }
        }
    }

    public Typeface getTypeface(String fontName) {
        if (_initSuccess.booleanValue()) {
            if (fontName == FONT_UNIT) {
                return this._tfUnits;
            }
            if (fontName == FONT_SPTG) {
                return this._tfSP;
            }
            if (fontName == FONT_MPTG) {
                return this._tfTG;
            }
            return null;
        }
        throw new Error("FontManager:  Must call \".init(String cacheDir)\" before using");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Typeface loadFont(String fontName) {
        String fontFolder = "res/raw/";
        Typeface tf = null;
        InputStream is = null;
        is = this.getClass().getClassLoader().getResourceAsStream(fontFolder + fontName);
        if (is == null) {
            Typeface typeface = null;
            this.silentClose(is);
            return typeface;
        }
        {
            catch (Exception exc) {
                try {
                    Log.wtf((String)"SPR.getFont", (String)exc.getMessage(), (Throwable)exc);
                    if (exc != null) {
                        ErrorLogger.LogException("SPR", "getFont", exc);
                    }
                    this.silentClose(is);
                    return tf;
                }
                catch (Throwable throwable) {
                    this.silentClose(is);
                    throw throwable;
                }
            }
            String cacheDir = this._cacheDir;
            String path = cacheDir + "/secrenderer/" + UUID.randomUUID().toString();
            File f = new File(path);
            if (!f.exists() && !f.mkdirs()) {
                Log.wtf((String)"SPR.getFont", (String)("make temp SD dir \"" + path + "\" fail"));
            }
            String outPath = path + "/secraw.dat";
            try {
                File f3;
                File f2;
                byte[] buffer = new byte[is.available()];
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outPath));
                int l = 0;
                while ((l = is.read(buffer)) > 0) {
                    bos.write(buffer, 0, l);
                }
                bos.close();
                bos = null;
                tf = Typeface.createFromFile((String)outPath);
                if (tf != null) {
                    // empty if block
                }
                if ((f2 = new File(outPath)).delete()) {
                    // empty if block
                }
                if (!(f3 = new File(path)).delete()) {
                    // empty if block
                }
            }
            catch (IOException ioe) {
                Typeface typeface = null;
                this.silentClose(is);
                return typeface;
            }
            catch (Exception exc) {}
            {
                Typeface typeface = null;
                this.silentClose(is);
                return typeface;
            }
        }
        {
            if (tf == null) {
                Log.wtf((String)"SPR.getFont", (String)"NO TYPEFACE");
            }
            Typeface typeface = tf;
            this.silentClose(is);
            return typeface;
        }
    }

    private void silentClose(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testFontFiles() {
        Paint fillPaint = new Paint();
        fillPaint.setStyle(Paint.Style.FILL);
        fillPaint.setColor(Color.black.toARGB());
        fillPaint.setTextSize(48.0f);
        fillPaint.setAntiAlias(true);
        fillPaint.setTextAlign(Paint.Align.CENTER);
        fillPaint.setTypeface(this._tfUnits);
        block8: for (int i = 57999; i < 63132; ++i) {
            Rect bounds = new Rect();
            String strFill = String.valueOf((char)i);
            fillPaint.getTextBounds(strFill, 0, 1, bounds);
            if (bounds.left >= 0) {
                System.err.println("Char: " + String.valueOf(i) + " has normal width: " + String.valueOf(bounds.toString()) + " W: " + String.valueOf(bounds.width()) + " H: " + String.valueOf(bounds.width()) + ", invalid");
            }
            switch (i) {
                case 59166: {
                    i = 60000;
                    continue block8;
                }
                case 60084: {
                    i = 60999;
                    continue block8;
                }
                case 61085: {
                    i = 61500;
                    continue block8;
                }
                case 61533: {
                    i = 62000;
                    continue block8;
                }
                case 62261: {
                    i = 63000;
                    continue block8;
                }
                case 63131: {
                    i = 63500;
                    continue block8;
                }
            }
        }
    }
}

