/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

public class ErrorLogger {
    public static final String LoggerName = "SECRenderer ErrorLogger";
    private static Level _level = Level.INFO;
    private static Boolean _LoggingEnabled = false;
    private static SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aa ");

    public static Boolean getLoggingStatus() {
        return _LoggingEnabled;
    }

    public static String getStackTrace(Throwable thrown) {
        try {
            String eol = System.getProperty("line.separator");
            StringBuilder sb = new StringBuilder();
            sb.append(thrown.toString());
            sb.append(eol);
            for (StackTraceElement element : thrown.getStackTrace()) {
                sb.append("        at ");
                sb.append(element);
                sb.append(eol);
            }
            return sb.toString();
        }
        catch (Exception exc) {
            Log.e((String)"ErrorLogger.getStackTrace", (String)exc.getMessage());
            return "Error - couldn't retrieve stack trace";
        }
    }

    public static void EnableLogging(Boolean enable) {
        _LoggingEnabled = enable;
    }

    public static void setLoggingPath(String path) {
    }

    public static void CleanupOldFiles(int DaysOld) {
    }

    public static synchronized void setLevel(Level newLevel) {
        ErrorLogger.setLevel(newLevel, false);
    }

    public static synchronized void setLevel(Level newLevel, Boolean setConsoleHandler) {
        _level = newLevel;
    }

    public static void setUseParentHandlers(boolean useParentHandlers) {
    }

    public static synchronized Level getLevel() {
        return _level;
    }

    private static String getFileName() {
        String fileName = "";
        return fileName;
    }

    public static void Entering(String sourceClass, String sourceMethod) {
        if (_level.intValue() <= Level.FINER.intValue()) {
            Log.i((String)(sourceClass + "." + sourceMethod), (String)("Entering: " + sourceClass + "." + sourceMethod));
        }
    }

    public static void Entering(String sourceClass, String sourceMethod, Object param1) {
        if (_level.intValue() <= Level.FINER.intValue()) {
            Log.i((String)(sourceClass + "." + sourceMethod), (String)("Entering: " + sourceClass + "." + sourceMethod + " - " + String.valueOf(param1)));
        }
    }

    public static void Entering(String sourceClass, String sourceMethod, Object[] params) {
        if (_level.intValue() <= Level.FINER.intValue()) {
            Log.i((String)(sourceClass + "." + sourceMethod), (String)("Entering: " + sourceClass + "." + sourceMethod + "with params:"));
            if (params != null) {
                for (Object param : params) {
                    System.out.println(String.valueOf(param));
                }
            }
        }
    }

    public static void Exiting(String sourceClass, String sourceMethod) {
        if (_level.intValue() <= Level.FINER.intValue()) {
            Log.i((String)(sourceClass + "." + sourceMethod), (String)("Exiting: " + sourceClass + "." + sourceMethod));
        }
    }

    public static void Exiting(String sourceClass, String sourceMethod, Object result) {
        if (_level.intValue() <= Level.FINER.intValue()) {
            Log.i((String)(sourceClass + "." + sourceMethod), (String)("Entering: " + sourceClass + "." + sourceMethod + " - " + String.valueOf(result)));
        }
    }

    public static void LogMessage(String message) {
        ErrorLogger.LogMessage(message, Level.INFO, false);
    }

    public static void LogMessage(String message, Boolean showMessageBox) {
        ErrorLogger.LogMessage(message, Level.INFO, showMessageBox);
    }

    public static void LogMessage(String message, Level lvl, Boolean showMessageBox) {
        if (lvl.intValue() >= _level.intValue()) {
            Log.i((String)"ErrorLogger", (String)(sdf.format(new Date()) + LoggerName));
            Log.i((String)"ErrorLogger", (String)("INFO: " + message));
        }
    }

    public static void LogMessage(String sourceClass, String sourceMethod, String message) {
        ErrorLogger.LogMessage(sourceClass, sourceMethod, message, Level.INFO, false);
    }

    public static void LogMessage(String sourceClass, String sourceMethod, String message, Boolean showMessageBox) {
        ErrorLogger.LogMessage(sourceClass, sourceMethod, message, Level.INFO, showMessageBox);
    }

    public static void LogMessage(String sourceClass, String sourceMethod, String message, Level lvl) {
        ErrorLogger.LogMessage(sourceClass, sourceMethod, message, lvl, false);
    }

    public static void LogMessage(String sourceClass, String sourceMethod, String message, Level lvl, Boolean showMessageBox) {
        if (lvl.intValue() >= _level.intValue()) {
            Log.i((String)(sourceClass + "." + sourceMethod), (String)(sdf.format(new Date()) + sourceClass + "." + sourceMethod));
            Log.i((String)(sourceClass + "." + sourceMethod), (String)(lvl.toString() + ": " + message));
        }
    }

    public static void LogMessage(String sourceClass, String sourceMethod, String message, Level lvl, Object param1, Boolean showMessageBox) {
        Object[] params = new Object[]{param1};
        ErrorLogger.LogMessage(sourceClass, sourceMethod, message, lvl, params, showMessageBox);
    }

    public static void LogMessage(String sourceClass, String sourceMethod, String message, Level lvl, Object[] params, Boolean showMessageBox) {
        if (lvl.intValue() >= _level.intValue()) {
            Log.i((String)(sourceClass + "." + sourceMethod), (String)(sdf.format(new Date()) + sourceClass + "." + sourceMethod));
            Log.i((String)(sourceClass + "." + sourceMethod), (String)(lvl.toString() + ": " + message));
            for (Object param : params) {
                Log.i((String)(sourceClass + "." + sourceMethod), (String)String.valueOf(param));
            }
        }
    }

    public static void LogException(String sourceClass, String sourceMethod, Exception exc) {
        ErrorLogger.LogException(sourceClass, sourceMethod, exc, Level.INFO, false);
    }

    public static void LogException(String sourceClass, String sourceMethod, Exception exc, Boolean showMessageBox) {
        ErrorLogger.LogException(sourceClass, sourceMethod, exc, Level.INFO, showMessageBox);
    }

    public static void LogException(String sourceClass, String sourceMethod, Exception exc, Level lvl) {
        ErrorLogger.LogException(sourceClass, sourceMethod, exc, lvl, false);
    }

    public static void LogException(String sourceClass, String sourceMethod, Exception exc, Level lvl, Boolean showMessageBox) {
        if (lvl.intValue() >= _level.intValue()) {
            Log.e((String)(sourceClass + "." + sourceMethod), (String)(sdf.format(new Date()) + sourceClass + "." + sourceMethod));
            Log.e((String)(sourceClass + "." + sourceMethod), (String)(lvl.toString() + ": " + exc.getMessage()));
            Log.e((String)(sourceClass + "." + sourceMethod), (String)ErrorLogger.getStackTrace(exc));
        }
    }

    private static String PrintList(ArrayList list) {
        String message = "";
        for (Object item : list) {
            message = message + item.toString() + "\n";
        }
        return message;
    }

    private static String PrintObjectMap(Map<String, Object> map) {
        Iterator<Object> itr = map.values().iterator();
        String message = "";
        String temp = null;
        while (itr.hasNext()) {
            temp = String.valueOf(itr.next());
            if (temp == null) continue;
            message = message + temp + "\n";
        }
        return message;
    }
}

