/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ImageInfo;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import armyc2.c2sd.renderer.utilities.TacticalGraphicLookup;

public class TacticalGraphicIconRenderer {
    private static int fontSizeForTGIcons = 60;
    private static Typeface _TGMP = null;
    private static final Object _TGFontMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInfo getIcon(String symbolID, int size, Color color, int symStd) {
        int charSymbolIndex;
        ImageInfo ii = null;
        if (SymbolUtilities.isWeather(symbolID)) {
            color = SymbolUtilities.getFillColorOfWeather(symbolID);
            if (color == null) {
                color = SymbolUtilities.getLineColorOfWeather(symbolID);
            }
        } else if (color == null) {
            color = SymbolUtilities.getLineColorOfAffiliation(symbolID);
        }
        if ((charSymbolIndex = TacticalGraphicLookup.getInstance().getCharCodeFromSymbol(symbolID, symStd)) > 0) {
            float fontSize = fontSizeForTGIcons;
            float ratio = (float)size / 40.0f;
            Point centerPoint = new Point(size / 2, size / 2);
            if (ratio > 0.0f) {
                fontSize *= ratio;
            }
            Paint fillPaint = null;
            fillPaint = new Paint();
            fillPaint.setStyle(Paint.Style.FILL);
            fillPaint.setColor(color.toARGB());
            fillPaint.setTextSize(fontSize);
            fillPaint.setAntiAlias(true);
            fillPaint.setTextAlign(Paint.Align.CENTER);
            fillPaint.setTypeface(_TGMP);
            Bitmap bmp = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bmp);
            String strSymbol = null;
            if (charSymbolIndex > 0) {
                strSymbol = String.valueOf((char)charSymbolIndex);
            }
            if (strSymbol != null) {
                Object object = _TGFontMutex;
                synchronized (object) {
                    canvas.drawText(strSymbol, (float)centerPoint.x, (float)centerPoint.y, fillPaint);
                }
            }
            ii = new ImageInfo(bmp, centerPoint, new Rect(0, 0, size, size));
        }
        return ii;
    }

    public static void setTGTypeFace(Typeface tgtf) {
        _TGMP = tgtf;
    }
}

