/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.Log;
import android.util.SparseArray;
import armyc2.c2sd.renderer.ModifierRenderer;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.ImageInfo;
import armyc2.c2sd.renderer.utilities.ModifierInfo;
import armyc2.c2sd.renderer.utilities.RendererSettings;
import armyc2.c2sd.renderer.utilities.SVGPath;
import armyc2.c2sd.renderer.utilities.SinglePointLookup;
import armyc2.c2sd.renderer.utilities.SinglePointLookupInfo;
import armyc2.c2sd.renderer.utilities.SymbolDimensions;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import armyc2.c2sd.renderer.utilities.UnitFontLookup;
import armyc2.c2sd.renderer.utilities.UnitFontLookupInfo;
import armyc2.c2sd.renderer.utilities.UnitSVGTable;
import java.util.ArrayList;

public class SinglePointSVGRenderer {
    private String TAG = "armyc2.c2sd.singlepointrenderer.SinglePointRenderer";
    private static SinglePointSVGRenderer _instance = null;
    private Typeface _tfUnits = null;
    private Typeface _tfSP = null;
    private Typeface _tfTG = null;

    private SinglePointSVGRenderer() {
    }

    public static synchronized SinglePointSVGRenderer getInstance() {
        if (_instance == null) {
            _instance = new SinglePointSVGRenderer();
        }
        return _instance;
    }

    public ImageInfo RenderUnit(String symbolID, SparseArray<String> modifiers, SparseArray<String> attributes) {
        double L1_5 = 1325.0;
        Bitmap finalBmp = null;
        Bitmap coreBMP = null;
        try {
            Canvas g = null;
            int fillIndex = -1;
            int frameIndex = -1;
            int symbol1Index = -1;
            int symbol2Index = -1;
            int frameAssumeIndex = -1;
            SVGPath svgFill = null;
            SVGPath svgFrame = null;
            SVGPath svgSymbol1 = null;
            SVGPath svgSymbol2 = null;
            int alpha = 255;
            Boolean drawAsIcon = false;
            Boolean keepUnitRatio = true;
            int pixelSize = 0;
            Color fillColor = SymbolUtilities.getFillColorOfAffiliation(symbolID);
            Color lineColor = SymbolUtilities.getLineColorOfAffiliation(symbolID);
            boolean hasDisplayModifiers = false;
            boolean hasTextModifiers = false;
            boolean icon = false;
            int symStd = RendererSettings.getInstance().getSymbologyStandard();
            try {
                if (attributes.indexOfKey(11) >= 0) {
                    symStd = Integer.parseInt((String)attributes.get(11));
                }
                if (symStd > 0) {
                    char affiliation = symbolID.charAt(1);
                    switch (affiliation) {
                        case 'A': 
                        case 'G': 
                        case 'M': 
                        case 'P': 
                        case 'S': {
                            frameAssumeIndex = fillIndex + 2;
                        }
                    }
                }
                pixelSize = attributes.indexOfKey(3) >= 0 ? Integer.parseInt((String)attributes.get(3)) : RendererSettings.getInstance().getDefaultPixelSize();
                if (attributes.indexOfKey(5) >= 0) {
                    keepUnitRatio = Boolean.parseBoolean((String)attributes.get(5));
                }
                if (attributes.indexOfKey(10) >= 0) {
                    icon = Boolean.parseBoolean((String)attributes.get(10));
                }
                if (icon) {
                    keepUnitRatio = false;
                    hasDisplayModifiers = false;
                    hasTextModifiers = false;
                    symbolID = symbolID.substring(0, 10) + "-----";
                } else {
                    hasDisplayModifiers = ModifierRenderer.hasDisplayModifiers(symbolID, modifiers);
                    hasTextModifiers = ModifierRenderer.hasTextModifiers(symbolID, modifiers, attributes);
                }
                if (attributes.indexOfKey(0) >= 0) {
                    lineColor = new Color((String)attributes.get(0));
                }
                if (attributes.indexOfKey(1) >= 0) {
                    fillColor = new Color((String)attributes.get(1));
                }
            }
            catch (Exception excModifiers) {
                ErrorLogger.LogException("MilStdIconRenderer", "RenderUnit", excModifiers);
            }
            UnitFontLookupInfo ufli = UnitFontLookup.getInstance().getLookupInfo(symbolID, 0);
            fillIndex = UnitFontLookup.getFillCode(symbolID, symStd);
            frameIndex = UnitFontLookup.getFrameCode(symbolID, fillIndex);
            if (ufli != null) {
                symbol1Index = ufli.getMapping1(symbolID);
                symbol2Index = ufli.getMapping2();
            }
            if (fillIndex > 0) {
                svgFill = UnitSVGTable.getInstance().getSVGPath(String.valueOf(fillIndex));
            }
            if (frameIndex > 0) {
                svgFrame = UnitSVGTable.getInstance().getSVGPath(String.valueOf(frameIndex));
            }
            if (symbol1Index > 0) {
                svgSymbol1 = UnitSVGTable.getInstance().getSVGPath(String.valueOf(symbol1Index));
            }
            if (symbol2Index > 0) {
                svgSymbol2 = UnitSVGTable.getInstance().getSVGPath(String.valueOf(symbol2Index));
            }
            Matrix matrix = null;
            double heightL = 1.0;
            double widthL = 1.0;
            if (keepUnitRatio.booleanValue()) {
                RectF rectFrame = svgFrame.getBounds();
                double ratio = (double)pixelSize / L1_5 / 1.5;
                widthL = UnitFontLookup.getUnitRatioWidth(fillIndex);
                ratio = widthL > (heightL = (double)UnitFontLookup.getUnitRatioHeight(fillIndex)) ? (ratio *= widthL) : (ratio *= heightL);
                pixelSize = (int)(ratio * L1_5 + 0.5);
            }
            matrix = svgFrame.TransformToFitDimensions(pixelSize, pixelSize);
            RectF rectF = svgFrame.getBounds();
            int w = (int)(rectF.width() + 1.5f);
            int h = (int)(rectF.height() + 1.5f);
            coreBMP = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Point centerPoint = new Point(w / 2, h / 2);
            PointF location = new PointF(0.0f, 0.0f);
            location.x = rectF.width() / 2.0f;
            location.y = -(rectF.height() / 2.0f);
            g = new Canvas(coreBMP);
            if (svgFill != null) {
                svgFill.Transform(matrix);
                svgFill.Draw(g, null, 0.0f, fillColor, null);
            }
            if (svgFrame != null) {
                svgFrame.Draw(g, null, 0.0f, lineColor, null);
            }
            if (svgSymbol2 != null) {
                svgSymbol2.Draw(g, null, 0.0f, ufli.getColor2(), matrix);
            }
            if (svgSymbol1 != null) {
                svgSymbol1.Draw(g, null, 0.0f, ufli.getColor1(), matrix);
            }
            RectF coreDimensions = new RectF(0.0f, 0.0f, (float)w, (float)h);
            Rect finalDimensions = new Rect(0, 0, w, h);
            if (SymbolUtilities.isHQ(symbolID)) {
                Point point1 = new Point();
                Point point2 = new Point();
                String affiliation = symbolID.substring(1, 2);
                if (affiliation == "F" || affiliation == "A" || affiliation == "D" || affiliation == "M" || affiliation == "J" || affiliation == "K" || affiliation == "N" || affiliation == "L") {
                    point1.x = 0;
                    point1.y = coreBMP.getHeight();
                    point2.x = point1.x;
                    point2.y = point1.y + coreBMP.getHeight();
                } else {
                    point1.x = 1;
                    point1.y = coreBMP.getHeight() / 2;
                    point2.x = point1.x;
                    point2.y = point1.y + coreBMP.getHeight();
                }
                centerPoint = point2;
            }
            finalBmp = Bitmap.createBitmap((int)finalDimensions.right, (int)finalDimensions.bottom, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas dest = new Canvas(finalBmp);
            dest.drawBitmap(coreBMP, new Matrix(), null);
            Rect symbolBounds = new Rect(0, 0, finalBmp.getWidth(), finalBmp.getHeight());
            ImageInfo ii = new ImageInfo(finalBmp, new Point(centerPoint.x, centerPoint.y), symbolBounds);
            ImageInfo iinew = null;
            if (hasDisplayModifiers) {
                iinew = ModifierRenderer.processUnitDisplayModifiers(ii, symbolID, modifiers, hasTextModifiers, attributes);
            }
            if (iinew != null) {
                ii = iinew;
            }
            iinew = null;
            if (hasTextModifiers) {
                iinew = ModifierRenderer.processUnitTextModifiers(ii, symbolID, modifiers, attributes);
            }
            if (iinew != null) {
                ii = iinew;
            }
            iinew = null;
            if (icon) {
                return ii.getSquareImageInfo();
            }
            return ii;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SinglePointSVGRenderer", "RenderUnit", exc);
            return null;
        }
    }

    public ImageInfo RenderSP(String symbolID, SparseArray<String> modifiers) {
        ImageInfo temp = null;
        String basicSymbolID = null;
        float fontSize = RendererSettings.getInstance().getSPFontSize();
        Color lineColor = SymbolUtilities.getLineColorOfAffiliation(symbolID);
        Color fillColor = null;
        int alpha = -1;
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        int charFillIndex = -1;
        int charFrameIndex = -1;
        Object sd = null;
        Paint fillPaint = null;
        Paint framePaint = null;
        SinglePointLookupInfo lookup = null;
        Rect symbolBounds = null;
        RectF fullBounds = null;
        Bitmap fullBMP = null;
        try {
            if (modifiers == null) {
                modifiers = new SparseArray();
            }
            if (modifiers.indexOfKey(11) >= 0) {
                symStd = Integer.parseInt((String)modifiers.get(11));
            }
            basicSymbolID = SymbolUtilities.getBasicSymbolID(symbolID);
            lookup = SinglePointLookup.getInstance().getSPLookupInfo(basicSymbolID, symStd);
            if (lookup == null) {
                if (modifiers.get(3) != null) {
                    modifiers.put(4, modifiers.get(3));
                }
                modifiers.put(3, (Object)symbolID.substring(0, 10));
                symbolID = "G" + SymbolUtilities.getAffiliation(symbolID) + "G" + SymbolUtilities.getStatus(symbolID) + "GPP---****X";
                lookup = SinglePointLookup.getInstance().getSPLookupInfo(basicSymbolID, symStd);
                lineColor = SymbolUtilities.getLineColorOfAffiliation(symbolID);
                fillColor = null;
            }
            if (modifiers.indexOfKey(0) >= 0) {
                lineColor = new Color((String)modifiers.get(0));
            }
            if (modifiers.indexOfKey(1) >= 0) {
                lineColor = new Color((String)modifiers.get(1));
            }
            if (SymbolUtilities.isTGSPWithFill(symbolID) && fillColor != null) {
                fillPaint = new Paint();
                fillPaint.setStyle(Paint.Style.FILL);
                fillPaint.setColor(fillColor.toARGB());
                fillPaint.setTextSize(fontSize);
                fillPaint.setAntiAlias(true);
                fillPaint.setTextAlign(Paint.Align.CENTER);
                fillPaint.setTypeface(this._tfSP);
            }
            framePaint = new Paint();
            framePaint.setStyle(Paint.Style.FILL);
            framePaint.setColor(lineColor.toARGB());
            framePaint.setTextSize(fontSize);
            framePaint.setAntiAlias(true);
            framePaint.setTextAlign(Paint.Align.CENTER);
            framePaint.setTypeface(this._tfSP);
            if (symbolID.charAt(1) == 'H' && modifiers.indexOfKey(10) >= 0 && !Boolean.parseBoolean((String)modifiers.get(10))) {
                modifiers.put(6, (Object)"ENY");
            }
        }
        catch (Exception excModifiers) {
            ErrorLogger.LogException("MilStdIconRenderer", "RenderUnit", excModifiers);
        }
        try {
            String fillID;
            charFrameIndex = -1;
            charFillIndex = -1;
            charFrameIndex = SymbolUtilities.getStatus(symbolID).equals("A") ? lookup.getMappingA() : lookup.getMappingP();
            if (SymbolUtilities.isTGSPWithFill(symbolID) && fillColor != null && (fillID = SymbolUtilities.getTGFillSymbolCode(symbolID)) != null) {
                charFillIndex = SinglePointLookup.getInstance().getCharCodeFromSymbol(fillID, symStd);
            }
            RectF rect = new RectF(0.0f, 0.0f, (float)lookup.getWidth(), (float)lookup.getHeight());
            if ((double)fontSize != 60.0) {
                double ratio = fontSize / 60.0f;
                rect = new RectF(0.0f, 0.0f, (float)Math.round((double)rect.width() * ratio), (float)Math.round((double)rect.height() * ratio));
            }
            boolean symbolOutlineEnabled = false;
            int symbolOutlineSize = RendererSettings.getInstance().getSinglePointSymbolOutlineWidth();
            if (!symbolOutlineEnabled) {
                symbolOutlineSize = 0;
            }
            Matrix matrix = new Matrix();
            Point centerPoint = null;
            centerPoint = SymbolDimensions.getSymbolCenter(lookup.getBasicSymbolID(), rect);
            matrix.postTranslate((float)centerPoint.x, (float)centerPoint.y);
            if (symbolOutlineEnabled) {
                matrix.postTranslate((float)symbolOutlineSize, (float)symbolOutlineSize);
                centerPoint.offset(symbolOutlineSize, symbolOutlineSize);
                rect = new RectF(0.0f, 0.0f, rect.width() + (float)(symbolOutlineSize * 2), rect.height() + (float)(symbolOutlineSize * 2));
            }
            Bitmap bmp = Bitmap.createBitmap((int)((int)((double)rect.width() + 0.5)), (int)((int)((double)rect.height() + 0.5)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bmp);
            symbolBounds = new Rect(0, 0, bmp.getWidth(), bmp.getHeight());
            String strFill = null;
            String strFrame = null;
            if (charFillIndex > 0) {
                strFill = String.valueOf((char)charFillIndex);
            }
            if (charFrameIndex > 0) {
                strFrame = String.valueOf((char)charFrameIndex);
            }
            canvas.setMatrix(matrix);
            if (strFill != null) {
                canvas.drawText(strFill, 0.0f, 0.0f, fillPaint);
            }
            if (strFrame != null) {
                canvas.drawText(strFrame, 0.0f, 0.0f, framePaint);
            }
            ImageInfo ii = new ImageInfo(bmp, centerPoint, symbolBounds);
            ArrayList shapes = new ArrayList();
            ModifierInfo miTemp = null;
            if (modifiers == null || modifiers.indexOfKey(10) < 0 || !Boolean.parseBoolean((String)modifiers.get(10))) {
                // empty if block
            }
            float ULX = 0.0f;
            float ULY = 0.0f;
            float LRX = symbolBounds.width();
            float LRY = symbolBounds.height();
            int offset = 0;
            int outlineSize = RendererSettings.getInstance().getTextOutlineWidth();
            int shapesLength = shapes.size();
            if (shapes != null && shapesLength > 0) {
                for (int i = 0; i < shapesLength; ++i) {
                    RectF rTemp;
                    if (((ModifierInfo)shapes.get(i)).getText() != null) {
                        miTemp = (ModifierInfo)shapes.get(i);
                        offset = miTemp.getKey() == "shadow" ? outlineSize : 0;
                        rTemp = miTemp.getBounds();
                        Paint pTemp = miTemp.getPaint();
                        if (rTemp.left - (float)offset < ULX) {
                            ULX = rTemp.left - (float)offset;
                        }
                        if (rTemp.top - rTemp.height() - (float)offset < ULY) {
                            ULY = rTemp.top - rTemp.height() - (float)offset;
                        }
                        if (rTemp.left + rTemp.width() + (float)offset > LRX) {
                            LRX = (float)Math.round(rTemp.left) + rTemp.width() + (float)offset;
                        }
                        if (!(rTemp.top + (float)offset > LRY)) continue;
                        LRY = (float)Math.round(rTemp.top) + pTemp.descent() + (float)offset;
                        continue;
                    }
                    if (((ModifierInfo)shapes.get(i)).getShape() == null) continue;
                    miTemp = (ModifierInfo)shapes.get(i);
                    rTemp = miTemp.getBounds();
                    if (rTemp.left < ULX) {
                        ULX = Math.round(rTemp.left);
                    }
                    if (rTemp.top < ULY) {
                        ULY = Math.round(rTemp.top);
                    }
                    if (rTemp.left + rTemp.width() > LRX) {
                        LRX = Math.round(rTemp.left + rTemp.width());
                    }
                    if (!(rTemp.top + rTemp.height() > LRY)) continue;
                    LRY = Math.round(rTemp.top + rTemp.height());
                }
            }
            fullBounds = new RectF(0.0f, 0.0f, LRX - ULX, LRY - ULY);
            Matrix centerMatrix = new Matrix();
            int transX = 0;
            int transY = 0;
            if (ULX < 0.0f) {
                transX = (int)(ULX * -1.0f);
            }
            if (ULY < 0.0f) {
                transY = (int)(ULY * -1.0f);
            }
            centerMatrix = new Matrix();
            centerMatrix.reset();
            centerMatrix.postTranslate((float)transX, (float)transY);
            fullBMP = Bitmap.createBitmap((int)((int)fullBounds.width()), (int)((int)fullBounds.height()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas fullCanvas = new Canvas(fullBMP);
            Matrix tempMatrix = null;
            if (shapes != null && shapesLength > 0) {
                for (int j = 0; j < shapesLength; ++j) {
                    tempMatrix = new Matrix();
                    tempMatrix.reset();
                    if (((ModifierInfo)shapes.get(j)).getText() != null) {
                        miTemp = (ModifierInfo)shapes.get(j);
                        PointF drawPoint = miTemp.getDrawPoint();
                        tempMatrix.postTranslate((float)((int)drawPoint.x), (float)((int)drawPoint.y));
                        tempMatrix.postTranslate((float)transX, (float)transY);
                        if (miTemp.getKey().equals("shadow")) continue;
                        fullCanvas.setMatrix(tempMatrix);
                        fullCanvas.drawText(miTemp.getText(), 0.0f, 0.0f, miTemp.getPaint());
                        continue;
                    }
                    if (((ModifierInfo)shapes.get(j)).getShape() == null) continue;
                    miTemp = (ModifierInfo)shapes.get(j);
                    tempMatrix.postTranslate((float)transX, (float)transY);
                    fullCanvas.setMatrix(tempMatrix);
                    miTemp.getShape().draw(fullCanvas, miTemp.getPaint());
                }
            }
            Paint ptCopy = new Paint();
            ptCopy.setAntiAlias(false);
            fullCanvas.drawBitmap(bmp, (float)transX, (float)transY, ptCopy);
            centerPoint.x += transX;
            centerPoint.y += transY;
            symbolBounds = new Rect(transX, transY, symbolBounds.width(), symbolBounds.height());
            ii = new ImageInfo(fullBMP, centerPoint, symbolBounds);
            bmp.recycle();
            bmp = null;
            canvas = null;
            symbolBounds = null;
            fullBMP = null;
            fullBounds = null;
            fullCanvas = null;
            centerPoint = null;
            fillPaint = null;
            framePaint = null;
            lookup = null;
            return ii;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdIconRenderer", "RenderSP", exc);
            return temp;
        }
    }

    private UnitFontLookupInfo ResolveUnitFontLookupInfo(String symbolID, int symStd) {
        String id = symbolID;
        UnitFontLookupInfo lookup = null;
        String affiliation = "";
        String status = "";
        if (id != null && id.length() >= 10) {
            StringBuilder sb = new StringBuilder("");
            sb.append(id.charAt(0));
            if (!SymbolUtilities.hasValidAffiliation(id).booleanValue()) {
                sb.append('U');
                affiliation = "U";
            } else {
                sb.append(id.charAt(1));
                affiliation = id.substring(1, 2);
            }
            if (!SymbolUtilities.hasValidBattleDimension(id).booleanValue()) {
                sb.append('Z');
                sb.replace(0, 1, "S");
            } else {
                sb.append(id.charAt(2));
            }
            if (!SymbolUtilities.hasValidStatus(id).booleanValue()) {
                sb.append('P');
                status = "P";
            } else {
                sb.append(id.charAt(3));
                status = id.substring(3, 4);
            }
            sb.append("------");
            if (id.length() >= 15) {
                sb.append(id.substring(10, 15));
            } else {
                sb.append("*****");
            }
            id = sb.toString();
            lookup = UnitFontLookup.getInstance().getLookupInfo(id, symStd);
        } else if (symbolID == null || symbolID.equals("")) {
            lookup = UnitFontLookup.getInstance().getLookupInfo("SUZP------*****", symStd);
        }
        return lookup;
    }

    public Bitmap getTestSymbol() {
        Bitmap temp = null;
        try {
            temp = Bitmap.createBitmap((int)70, (int)70, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(temp);
            if (canvas.isHardwareAccelerated()) {
                System.out.println("HW acceleration supported");
            }
            Typeface tf = this._tfUnits;
            Paint fillPaint = new Paint();
            fillPaint.setStyle(Paint.Style.FILL);
            fillPaint.setColor(Color.CYAN.toInt());
            fillPaint.setTextSize(50.0f);
            fillPaint.setAntiAlias(true);
            fillPaint.setTextAlign(Paint.Align.CENTER);
            fillPaint.setTypeface(tf);
            Paint framePaint = new Paint();
            framePaint.setStyle(Paint.Style.FILL);
            framePaint.setColor(Color.BLACK.toInt());
            framePaint.setTextSize(50.0f);
            framePaint.setAntiAlias(true);
            framePaint.setTextAlign(Paint.Align.CENTER);
            framePaint.setTypeface(tf);
            Paint symbolPaint = new Paint();
            symbolPaint.setStyle(Paint.Style.FILL);
            symbolPaint.setColor(Color.BLACK.toInt());
            symbolPaint.setTextSize(50.0f);
            symbolPaint.setAntiAlias(true);
            symbolPaint.setTextAlign(Paint.Align.CENTER);
            symbolPaint.setTypeface(tf);
            String strFill = String.valueOf('\u0320');
            String strFrame = String.valueOf('\u0321');
            String strSymbol = String.valueOf('\u0461');
            canvas.drawText(strFill, 35.0f, 35.0f, fillPaint);
            canvas.drawText(strFrame, 35.0f, 35.0f, framePaint);
            canvas.drawText(strSymbol, 35.0f, 35.0f, symbolPaint);
            Paint.FontMetrics mf = framePaint.getFontMetrics();
            float height = mf.bottom - mf.top;
            float width = fillPaint.measureText(strFrame);
            Log.i((String)this.TAG, (String)("top: " + String.valueOf(mf.top)));
            Log.i((String)this.TAG, (String)("bottom: " + String.valueOf(mf.bottom)));
            Log.i((String)this.TAG, (String)("ascent: " + String.valueOf(mf.ascent)));
            Log.i((String)this.TAG, (String)("descent: " + String.valueOf(mf.descent)));
            Log.i((String)this.TAG, (String)("leading: " + String.valueOf(mf.leading)));
            Log.i((String)this.TAG, (String)("width: " + String.valueOf(width)));
            Log.i((String)this.TAG, (String)("height: " + String.valueOf(height)));
        }
        catch (Exception exc) {
            Log.e((String)this.TAG, (String)exc.getMessage());
            Log.e((String)this.TAG, (String)this.getStackTrace(exc));
        }
        return temp;
    }

    public void logError(String tag, Throwable thrown) {
        if (tag == null || tag == "") {
            tag = "singlePointRenderer";
        }
        String message = thrown.getMessage();
        String stack = this.getStackTrace(thrown);
        if (message != null) {
            Log.e((String)tag, (String)message);
        }
        if (stack != null) {
            Log.e((String)tag, (String)stack);
        }
    }

    public String getStackTrace(Throwable thrown) {
        try {
            if (thrown != null) {
                if (thrown.getStackTrace() != null) {
                    String eol = System.getProperty("line.separator");
                    StringBuilder sb = new StringBuilder();
                    sb.append(thrown.toString());
                    sb.append(eol);
                    for (StackTraceElement element : thrown.getStackTrace()) {
                        sb.append("        at ");
                        sb.append(element);
                        sb.append(eol);
                    }
                    return sb.toString();
                }
                return thrown.getMessage() + "- no stack trace";
            }
            return "no stack trace";
        }
        catch (Exception exc) {
            Log.e((String)"getStackTrace", (String)exc.getMessage());
            return thrown.getMessage();
        }
    }
}

