/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.Log;
import android.util.LruCache;
import android.util.SparseArray;
import armyc2.c2sd.renderer.ModifierRenderer;
import armyc2.c2sd.renderer.TacticalGraphicIconRenderer;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.FontManager;
import armyc2.c2sd.renderer.utilities.ImageInfo;
import armyc2.c2sd.renderer.utilities.RectUtilities;
import armyc2.c2sd.renderer.utilities.RendererSettings;
import armyc2.c2sd.renderer.utilities.RendererUtilities;
import armyc2.c2sd.renderer.utilities.SettingsChangedEvent;
import armyc2.c2sd.renderer.utilities.SettingsChangedEventListener;
import armyc2.c2sd.renderer.utilities.SinglePointLookup;
import armyc2.c2sd.renderer.utilities.SinglePointLookupInfo;
import armyc2.c2sd.renderer.utilities.SymbolDimensions;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import armyc2.c2sd.renderer.utilities.UnitFontLookup;
import armyc2.c2sd.renderer.utilities.UnitFontLookupInfo;

public class SinglePointRenderer
implements SettingsChangedEventListener {
    private final String TAG = "SinglePointRenderer";
    private static SinglePointRenderer _instance = null;
    private Typeface _tfUnits = null;
    private Typeface _tfSP = null;
    private Typeface _tfTG = null;
    private final Object _SinglePointFontMutex = new Object();
    private final Object _UnitFontMutex = new Object();
    private final Object _ModifierFontMutex = new Object();
    private final Object _SinglePointCacheMutex = new Object();
    private final Object _UnitCacheMutex = new Object();
    private Paint _modifierFont = new Paint();
    private Paint _modifierOutlineFont = new Paint();
    private float _modifierDescent = 2.0f;
    private float _modifierFontHeight = 10.0f;
    private int _deviceDPI = 72;
    private LruCache<String, ImageInfo> _unitCache = new LruCache(1024);
    private LruCache<String, ImageInfo> _tgCache = new LruCache(1024);
    private final int maxMemory = (int)Runtime.getRuntime().maxMemory();
    private int cacheSize = 5;
    private int maxCachedEntrySize = this.cacheSize / 5;

    private SinglePointRenderer() {
        this._tfUnits = FontManager.getInstance().getTypeface(FontManager.FONT_UNIT);
        this._tfSP = FontManager.getInstance().getTypeface(FontManager.FONT_SPTG);
        this._tfTG = FontManager.getInstance().getTypeface(FontManager.FONT_MPTG);
        TacticalGraphicIconRenderer.setTGTypeFace(this._tfTG);
        RendererSettings.getInstance().addEventListener(this);
        this.onSettingsChanged(new SettingsChangedEvent("FONT_CHANGED"));
        this.onSettingsChanged(new SettingsChangedEvent("CACHE_CHANGED"));
    }

    public static synchronized SinglePointRenderer getInstance() {
        if (_instance == null) {
            _instance = new SinglePointRenderer();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo RenderUnit(String symbolID, SparseArray<String> modifiers, SparseArray<String> attributes) {
        ImageInfo temp = null;
        float fontSize = RendererSettings.getInstance().getUnitFontSize();
        Color lineColor = SymbolUtilities.getLineColorOfAffiliation(symbolID);
        Color fillColor = SymbolUtilities.getFillColorOfAffiliation(symbolID);
        Color iconColor = null;
        int alpha = -1;
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        int charFillIndex = -1;
        int charFrameIndex = -1;
        int charSymbol1Index = -1;
        int charSymbol2Index = -1;
        int charFrameAssumeIndex = -1;
        Paint fillPaint = null;
        Paint framePaint = null;
        Paint symbol1Paint = null;
        Paint symbol2Paint = null;
        Paint frameAssumePaint = null;
        UnitFontLookupInfo lookup = null;
        Rect symbolBounds = null;
        Object fullBounds = null;
        Object fullBMP = null;
        boolean hasDisplayModifiers = false;
        boolean hasTextModifiers = false;
        int pixelSize = -1;
        boolean keepUnitRatio = true;
        boolean icon = false;
        float[] dimensions = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        try {
            if (attributes.indexOfKey(11) >= 0) {
                symStd = Integer.parseInt((String)attributes.get(11));
            }
            charFillIndex = UnitFontLookup.getFillCode(symbolID, symStd);
            charFrameIndex = UnitFontLookup.getFrameCode(symbolID, charFillIndex);
            if (symStd > 0) {
                char affiliation = symbolID.charAt(1);
                switch (affiliation) {
                    case 'A': 
                    case 'G': 
                    case 'M': 
                    case 'P': 
                    case 'S': {
                        if (symbolID.charAt(2) == 'U' && (symbolID.substring(4, 6).equals("WM") || symbolID.substring(4, 7).equals("WDM"))) {
                            if (symbolID.charAt(3) != 'A') {
                                ++charFillIndex;
                            }
                            charFrameAssumeIndex = charFillIndex - 1;
                            charFrameIndex = -1;
                            break;
                        }
                        charFrameIndex = charFillIndex + 2;
                        charFrameAssumeIndex = charFillIndex + 1;
                    }
                }
                if (charFrameAssumeIndex > 0) {
                    char c = (char)charFrameAssumeIndex;
                }
            }
            pixelSize = attributes.indexOfKey(3) >= 0 ? Integer.parseInt((String)attributes.get(3)) : RendererSettings.getInstance().getDefaultPixelSize();
            if (attributes.indexOfKey(5) >= 0) {
                keepUnitRatio = Boolean.parseBoolean((String)attributes.get(5));
            }
            if (attributes.indexOfKey(10) >= 0) {
                icon = Boolean.parseBoolean((String)attributes.get(10));
            }
            if (icon) {
                keepUnitRatio = false;
                hasDisplayModifiers = false;
                hasTextModifiers = false;
                symbolID = symbolID.substring(0, 10) + "-----";
            } else {
                hasDisplayModifiers = ModifierRenderer.hasDisplayModifiers(symbolID, modifiers);
                hasTextModifiers = ModifierRenderer.hasTextModifiers(symbolID, modifiers, attributes);
            }
            if (attributes.indexOfKey(0) >= 0) {
                lineColor = new Color((String)attributes.get(0));
            }
            if (attributes.indexOfKey(1) >= 0) {
                fillColor = new Color((String)attributes.get(1));
            }
            if (attributes.indexOfKey(17) >= 0) {
                iconColor = new Color((String)attributes.get(17));
            }
            if (attributes.indexOfKey(6) >= 0) {
                alpha = Integer.parseInt((String)attributes.get(6));
            }
            if ((lookup = UnitFontLookup.getInstance().getLookupInfo(symbolID, symStd)) == null) {
                lookup = this.ResolveUnitFontLookupInfo(symbolID, symStd);
            }
            dimensions = SymbolDimensions.getUnitBounds(charFillIndex, 50.0f);
            symbolBounds = RectUtilities.makeRect(0.0f, 0.0f, dimensions[2], dimensions[3]);
            Rect rect = new Rect(symbolBounds);
            float ratio = -1.0f;
            if (pixelSize > 0 && keepUnitRatio) {
                float widthRatio;
                float heightRatio = UnitFontLookup.getUnitRatioHeight(charFillIndex);
                pixelSize = heightRatio > (widthRatio = UnitFontLookup.getUnitRatioWidth(charFillIndex)) ? (int)((float)pixelSize / 1.5f * heightRatio) : (int)((float)pixelSize / 1.5f * widthRatio);
            }
            if (pixelSize > 0) {
                float p = pixelSize;
                float h = rect.height();
                float w = rect.width();
                ratio = Math.min(p / h, p / w);
                float fontsize = 50.0f;
                fontSize = fontsize * ratio;
                dimensions = SymbolDimensions.getUnitBounds(charFillIndex, 50.0f * ratio);
                symbolBounds = RectUtilities.makeRect(0.0f, 0.0f, dimensions[2], dimensions[3]);
            }
            fillPaint = new Paint();
            fillPaint.setStyle(Paint.Style.FILL);
            fillPaint.setColor(fillColor.toARGB());
            fillPaint.setTextSize(fontSize);
            fillPaint.setAntiAlias(true);
            fillPaint.setTextAlign(Paint.Align.CENTER);
            fillPaint.setTypeface(this._tfUnits);
            if (alpha != -1) {
                fillPaint.setAlpha(alpha);
            }
            framePaint = new Paint();
            framePaint.setStyle(Paint.Style.FILL);
            framePaint.setColor(lineColor.toARGB());
            framePaint.setTextSize(fontSize);
            framePaint.setAntiAlias(true);
            framePaint.setTextAlign(Paint.Align.CENTER);
            framePaint.setTypeface(this._tfUnits);
            if (alpha != -1) {
                framePaint.setAlpha(alpha);
            }
            symbol1Paint = new Paint();
            symbol1Paint.setStyle(Paint.Style.FILL);
            if (iconColor != null) {
                symbol1Paint.setColor(iconColor.toARGB());
            } else {
                symbol1Paint.setColor(lookup.getColor1().toARGB());
            }
            symbol1Paint.setTextSize(fontSize);
            symbol1Paint.setAntiAlias(true);
            symbol1Paint.setTextAlign(Paint.Align.CENTER);
            symbol1Paint.setTypeface(this._tfUnits);
            if (alpha != -1) {
                symbol1Paint.setAlpha(alpha);
            }
            symbol2Paint = new Paint();
            symbol2Paint.setStyle(Paint.Style.FILL);
            symbol2Paint.setColor(lookup.getColor2().toARGB());
            symbol2Paint.setTextSize(fontSize);
            symbol2Paint.setAntiAlias(true);
            symbol2Paint.setTextAlign(Paint.Align.CENTER);
            symbol2Paint.setTypeface(this._tfUnits);
            if (alpha != -1) {
                symbol2Paint.setAlpha(alpha);
            }
            frameAssumePaint = new Paint();
            frameAssumePaint.setStyle(Paint.Style.FILL);
            frameAssumePaint.setColor(Color.WHITE.toARGB());
            frameAssumePaint.setTextSize(fontSize);
            frameAssumePaint.setAntiAlias(true);
            frameAssumePaint.setTextAlign(Paint.Align.CENTER);
            frameAssumePaint.setTypeface(this._tfUnits);
            if (alpha != -1) {
                frameAssumePaint.setAlpha(alpha);
            }
            if (symbolID.charAt(2) == 'U' && symbolID.substring(4, 6).equals("WM")) {
                if (symStd == 0) {
                    fillPaint.setColor(fillColor.toARGB());
                    if (alpha != -1) {
                        fillPaint.setAlpha(alpha);
                    }
                    symbol1Paint.setColor(lineColor.toARGB());
                    if (alpha != -1) {
                        symbol1Paint.setAlpha(alpha);
                    }
                } else if (symStd == 1) {
                    fillPaint.setColor(lineColor.toARGB());
                    if (alpha != -1) {
                        fillPaint.setAlpha(alpha);
                    }
                }
            } else if (symbolID.charAt(2) == 'S' && symbolID.charAt(4) == 'O') {
                fillPaint.setColor(lineColor.toARGB());
                if (alpha != -1) {
                    fillPaint.setAlpha(alpha);
                }
            }
        }
        catch (Exception excModifiers) {
            ErrorLogger.LogException("MilStdIconRenderer", "RenderUnit", excModifiers);
        }
        try {
            ImageInfo ii = null;
            String key = SinglePointRenderer.makeCacheKey(symbolID, lineColor.toInt(), fillColor.toInt(), symbol1Paint.getColor(), pixelSize, keepUnitRatio, symStd);
            ii = (ImageInfo)this._unitCache.get((Object)key);
            if (ii == null) {
                if (lookup != null) {
                    charSymbol1Index = lookup.getMapping1(symbolID);
                    charSymbol2Index = lookup.getMapping2();
                }
                Point centerPoint = new Point(Math.round(symbolBounds.width() / 2), Math.round(symbolBounds.height() / 2));
                Point centerCache = new Point(centerPoint);
                symbolBounds.top = 0;
                Bitmap bmp = Bitmap.createBitmap((int)symbolBounds.width(), (int)symbolBounds.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bmp);
                String strFill = null;
                String strFrame = null;
                String strSymbol1 = null;
                String strSymbol2 = null;
                String strFrameAssume = null;
                if (charFillIndex > 0) {
                    strFill = String.valueOf((char)charFillIndex);
                }
                if (charFrameIndex > 0) {
                    strFrame = String.valueOf((char)charFrameIndex);
                }
                if (charSymbol1Index > 0) {
                    strSymbol1 = String.valueOf((char)charSymbol1Index);
                }
                if (charSymbol2Index > 0) {
                    strSymbol2 = String.valueOf((char)charSymbol2Index);
                }
                if (charFrameAssumeIndex > 0) {
                    strFrameAssume = String.valueOf((char)charFrameAssumeIndex);
                }
                Object object = this._UnitFontMutex;
                synchronized (object) {
                    if (strFrameAssume != null && charFillIndex == -1) {
                        canvas.drawText(strFrameAssume, (float)centerPoint.x, (float)(centerPoint.y + (int)dimensions[1]), symbol2Paint);
                        strFrameAssume = null;
                    }
                    if (strFill != null) {
                        canvas.drawText(strFill, (float)centerPoint.x, (float)(centerPoint.y + (int)dimensions[1]), fillPaint);
                    }
                    if (strFrameAssume != null) {
                        canvas.drawText(strFrameAssume, (float)centerPoint.x, (float)(centerPoint.y + (int)dimensions[1]), frameAssumePaint);
                    }
                    if (strFrame != null) {
                        canvas.drawText(strFrame, (float)centerPoint.x, (float)(centerPoint.y + (int)dimensions[1]), framePaint);
                    }
                    if (strSymbol2 != null) {
                        canvas.drawText(strSymbol2, (float)centerPoint.x, (float)(centerPoint.y + (int)dimensions[1]), symbol2Paint);
                    }
                    if (strSymbol1 != null) {
                        canvas.drawText(strSymbol1, (float)centerPoint.x, (float)(centerPoint.y + (int)dimensions[1]), symbol1Paint);
                    }
                }
                if (SymbolUtilities.isHQ(symbolID)) {
                    PointF point1 = new PointF();
                    PointF point2 = new PointF();
                    char affiliation = symbolID.charAt(1);
                    if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' || affiliation == 'N' || affiliation == 'L') {
                        point1.x = symbolBounds.left;
                        point1.y = symbolBounds.top + symbolBounds.height();
                        point2.x = point1.x;
                        point2.y = point1.y + (float)symbolBounds.height();
                    } else {
                        point1.x = symbolBounds.left + 1;
                        point1.y = symbolBounds.top + symbolBounds.height() / 2;
                        point2.x = point1.x;
                        point2.y = point1.y + (float)symbolBounds.height();
                    }
                    centerPoint = new Point((int)point2.x, (int)point2.y);
                }
                ii = new ImageInfo(bmp, centerPoint, symbolBounds);
                if (!icon && bmp.getByteCount() <= this.maxCachedEntrySize) {
                    object = this._UnitCacheMutex;
                    synchronized (object) {
                        if (this._unitCache.get((Object)key) == null) {
                            this._unitCache.put((Object)key, (Object)new ImageInfo(bmp, new Point(centerCache), new Rect(symbolBounds)));
                        }
                    }
                }
            }
            ImageInfo iinew = null;
            if (hasDisplayModifiers) {
                iinew = ModifierRenderer.processUnitDisplayModifiers(ii, symbolID, modifiers, hasTextModifiers, attributes);
            }
            if (iinew != null) {
                ii = iinew;
            }
            iinew = null;
            if (hasTextModifiers) {
                iinew = ModifierRenderer.processUnitTextModifiers(ii, symbolID, modifiers, attributes);
            }
            if (iinew != null) {
                ii = iinew;
            }
            iinew = null;
            symbolBounds = null;
            fullBMP = null;
            fullBounds = null;
            fillPaint = null;
            framePaint = null;
            symbol1Paint = null;
            symbol2Paint = null;
            lookup = null;
            if (icon) {
                return ii.getSquareImageInfo();
            }
            return ii;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdIconRenderer", "RenderUnit", exc);
            return temp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo RenderSP(String symbolID, SparseArray<String> modifiers, SparseArray<String> attributes) {
        Object temp = null;
        String basicSymbolID = null;
        float fontSize = RendererSettings.getInstance().getSPFontSize();
        Color lineColor = SymbolUtilities.getLineColorOfAffiliation(symbolID);
        Color fillColor = null;
        int alpha = -1;
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        int charFillIndex = -1;
        int charFrameIndex = -1;
        String fillID = null;
        Object sd = null;
        Paint fillPaint = null;
        Paint framePaint = null;
        SinglePointLookupInfo lookup = null;
        Rect symbolBounds = null;
        Object fullBounds = null;
        Object fullBMP = null;
        boolean drawAsIcon = false;
        int pixelSize = -1;
        boolean keepUnitRatio = true;
        boolean hasDisplayModifiers = false;
        boolean hasTextModifiers = false;
        int symbolOutlineWidth = RendererSettings.getInstance().getSinglePointSymbolOutlineWidth();
        float scale = -999.0f;
        try {
            if (modifiers == null) {
                modifiers = new SparseArray();
            }
            if (attributes != null && attributes.indexOfKey(11) >= 0) {
                symStd = Integer.parseInt((String)attributes.get(11));
            }
            basicSymbolID = SymbolUtilities.getBasicSymbolIDStrict(symbolID);
            lookup = SinglePointLookup.getInstance().getSPLookupInfo(basicSymbolID, symStd);
            if (lookup == null) {
                if (modifiers.get(3) != null) {
                    modifiers.put(4, modifiers.get(3));
                }
                modifiers.put(3, (Object)symbolID.substring(0, 10));
                symbolID = "G" + SymbolUtilities.getAffiliation(symbolID) + "G" + SymbolUtilities.getStatus(symbolID) + "GPP---****X";
                basicSymbolID = SymbolUtilities.getBasicSymbolIDStrict(symbolID);
                lookup = SinglePointLookup.getInstance().getSPLookupInfo(basicSymbolID, symStd);
                lineColor = SymbolUtilities.getLineColorOfAffiliation(symbolID);
                fillColor = null;
            }
            if (SymbolUtilities.hasDefaultFill(symbolID)) {
                fillColor = SymbolUtilities.getFillColorOfAffiliation(symbolID);
            }
            if (SymbolUtilities.isTGSPWithFill(symbolID)) {
                fillID = SymbolUtilities.getTGFillSymbolCode(symbolID);
                if (fillID != null) {
                    charFillIndex = SinglePointLookup.getInstance().getCharCodeFromSymbol(fillID, symStd);
                }
            } else if (SymbolUtilities.isWeatherSPWithFill(symbolID)) {
                charFillIndex = charFrameIndex + 1;
                fillColor = SymbolUtilities.getFillColorOfWeather(symbolID);
            }
            if (attributes != null) {
                if (attributes.indexOfKey(5) >= 0) {
                    keepUnitRatio = Boolean.parseBoolean((String)attributes.get(5));
                }
                if (attributes.indexOfKey(0) >= 0) {
                    lineColor = SymbolUtilities.getColorFromHexString((String)attributes.get(0));
                }
                if (attributes.indexOfKey(1) >= 0) {
                    fillColor = SymbolUtilities.getColorFromHexString((String)attributes.get(1));
                }
                if (attributes.indexOfKey(6) >= 0) {
                    alpha = Integer.parseInt((String)attributes.get(6));
                }
                if (attributes.indexOfKey(10) >= 0) {
                    drawAsIcon = Boolean.parseBoolean((String)attributes.get(10));
                }
                if (attributes.indexOfKey(3) >= 0) {
                    pixelSize = Integer.parseInt((String)attributes.get(3));
                } else if (keepUnitRatio) {
                    pixelSize = 35;
                } else {
                    try {
                        Rect sb = SymbolDimensions.getSymbolBounds(SymbolUtilities.getBasicSymbolIDStrict(symbolID), symStd, 60.0f);
                        pixelSize = Math.max(sb.width(), sb.height());
                    }
                    catch (Exception exc) {
                        Log.e((String)"SinglePointRenderer", (String)exc.getMessage());
                        exc.printStackTrace();
                    }
                }
            }
            if (drawAsIcon) {
                keepUnitRatio = false;
                hasDisplayModifiers = false;
                hasTextModifiers = false;
                symbolOutlineWidth = 0;
            } else {
                hasDisplayModifiers = ModifierRenderer.hasDisplayModifiers(symbolID, (SparseArray<String>)modifiers);
                hasTextModifiers = ModifierRenderer.hasTextModifiers(symbolID, (SparseArray<String>)modifiers, attributes);
            }
            int outlineOffset = symbolOutlineWidth;
            outlineOffset = outlineOffset > 2 ? (outlineOffset - 1) / 2 : 0;
            Rect rect = null;
            float ratio = 0.0f;
            if (pixelSize > 0) {
                symbolBounds = SymbolDimensions.getSymbolBounds(basicSymbolID, symStd, fontSize);
                rect = new Rect(symbolBounds);
                if (keepUnitRatio) {
                    scale = (float)pixelSize / 35.0f;
                }
                float fPixelSize = pixelSize;
                ratio = Math.min(fPixelSize / (float)rect.height(), fPixelSize / (float)rect.width());
            }
            if (scale != -999.0f) {
                ratio = scale;
            }
            if (ratio > 0.0f) {
                fontSize *= ratio;
            }
            if (SymbolUtilities.isTGSPWithFill(symbolID) && fillColor != null) {
                fillPaint = new Paint();
                fillPaint.setStyle(Paint.Style.FILL);
                fillPaint.setColor(fillColor.toARGB());
                fillPaint.setTextSize(fontSize);
                fillPaint.setAntiAlias(true);
                fillPaint.setTextAlign(Paint.Align.CENTER);
                fillPaint.setTypeface(this._tfSP);
                if (alpha != -1) {
                    fillPaint.setAlpha(alpha);
                }
            }
            framePaint = new Paint();
            framePaint.setStyle(Paint.Style.FILL);
            framePaint.setColor(lineColor.toARGB());
            framePaint.setTextSize(fontSize);
            framePaint.setAntiAlias(true);
            framePaint.setTextAlign(Paint.Align.CENTER);
            framePaint.setTypeface(this._tfSP);
            if (alpha != -1) {
                framePaint.setAlpha(alpha);
            }
            if (symbolID.charAt(1) == 'H' && modifiers.indexOfKey(10) >= 0 && !Boolean.parseBoolean((String)modifiers.get(10))) {
                modifiers.put(6, (Object)"ENY");
            }
        }
        catch (Exception excModifiers) {
            ErrorLogger.LogException("MilStdIconRenderer", "RenderUnit", excModifiers);
        }
        try {
            String key;
            ImageInfo ii = null;
            int intFill = -1;
            if (fillColor != null) {
                intFill = fillColor.toInt();
            }
            if ((ii = (ImageInfo)this._tgCache.get((Object)(key = SinglePointRenderer.makeCacheKey(symbolID, lineColor.toInt(), intFill, pixelSize, keepUnitRatio, symStd)))) == null) {
                charFrameIndex = -1;
                charFillIndex = -1;
                charFrameIndex = SymbolUtilities.getStatus(symbolID).equals("A") ? lookup.getMappingA() : lookup.getMappingP();
                if (SymbolUtilities.isTGSPWithFill(symbolID) && fillColor != null && (fillID = SymbolUtilities.getTGFillSymbolCode(symbolID)) != null) {
                    charFillIndex = SinglePointLookup.getInstance().getCharCodeFromSymbol(fillID, symStd);
                }
                RectF rect = new RectF(0.0f, 0.0f, (float)lookup.getWidth(), (float)lookup.getHeight());
                if ((double)fontSize != 60.0) {
                    double ratio = fontSize / 60.0f;
                    rect = new RectF(0.0f, 0.0f, (float)Math.round((double)rect.width() * ratio), (float)Math.round((double)rect.height() * ratio));
                }
                Matrix matrix = new Matrix();
                Point centerPoint = null;
                centerPoint = SymbolDimensions.getSymbolCenter(lookup.getBasicSymbolID(), rect);
                if (symbolOutlineWidth > 0) {
                    matrix.postTranslate((float)(centerPoint.x + symbolOutlineWidth), (float)(centerPoint.y + symbolOutlineWidth));
                    centerPoint.offset(symbolOutlineWidth, symbolOutlineWidth);
                    rect = new RectF(0.0f, 0.0f, rect.width() + (float)(symbolOutlineWidth * 2), rect.height() + (float)(symbolOutlineWidth * 2));
                } else {
                    matrix.postTranslate((float)centerPoint.x, (float)centerPoint.y);
                }
                Bitmap bmp = Bitmap.createBitmap((int)((int)((double)rect.width() + 0.5)), (int)((int)((double)rect.height() + 0.5)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bmp);
                symbolBounds = new Rect(0, 0, bmp.getWidth(), bmp.getHeight());
                String strFill = null;
                String strFrame = null;
                if (charFillIndex > 0) {
                    strFill = String.valueOf((char)charFillIndex);
                }
                if (charFrameIndex > 0) {
                    strFrame = String.valueOf((char)charFrameIndex);
                }
                canvas.setMatrix(matrix);
                Object object = this._SinglePointFontMutex;
                synchronized (object) {
                    if (strFill != null) {
                        canvas.drawText(strFill, 0.0f, 0.0f, fillPaint);
                    }
                    if (strFrame != null) {
                        RendererUtilities.renderSymbolCharacter(canvas, strFrame, 0, 0, framePaint, lineColor, symbolOutlineWidth);
                    }
                }
                ii = new ImageInfo(bmp, centerPoint, symbolBounds);
                if (!drawAsIcon && bmp.getByteCount() <= this.maxCachedEntrySize) {
                    object = this._SinglePointCacheMutex;
                    synchronized (object) {
                        if (this._tgCache.get((Object)key) == null) {
                            this._tgCache.put((Object)key, (Object)ii);
                        }
                    }
                }
            }
            ImageInfo iiNew = null;
            if (!drawAsIcon && (hasTextModifiers || hasDisplayModifiers || SymbolUtilities.isTGSPWithIntegralText(symbolID))) {
                iiNew = SymbolUtilities.isTGSPWithSpecialModifierLayout(symbolID) || SymbolUtilities.isTGSPWithIntegralText(symbolID) ? ModifierRenderer.ProcessTGSPWithSpecialModifierLayout(ii, symbolID, (SparseArray<String>)modifiers, attributes, lineColor) : ModifierRenderer.ProcessTGSPModifiers(ii, symbolID, (SparseArray<String>)modifiers, attributes, lineColor);
            }
            if (iiNew != null) {
                ii = iiNew;
            }
            symbolBounds = null;
            fullBMP = null;
            fullBounds = null;
            fillPaint = null;
            framePaint = null;
            lookup = null;
            if (drawAsIcon) {
                return ii.getSquareImageInfo();
            }
            return ii;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdIconRenderer", "RenderSP", exc);
            return null;
        }
    }

    private UnitFontLookupInfo ResolveUnitFontLookupInfo(String symbolID, int symStd) {
        String id = symbolID;
        UnitFontLookupInfo lookup = null;
        String affiliation = "";
        String status = "";
        if (id != null && id.length() >= 10) {
            StringBuilder sb = new StringBuilder("");
            sb.append(id.charAt(0));
            if (!SymbolUtilities.hasValidAffiliation(id).booleanValue()) {
                sb.append('U');
                affiliation = "U";
            } else {
                sb.append(id.charAt(1));
                affiliation = id.substring(1, 2);
            }
            if (!SymbolUtilities.hasValidBattleDimension(id).booleanValue()) {
                sb.append('Z');
                sb.replace(0, 1, "S");
            } else {
                sb.append(id.charAt(2));
            }
            if (!SymbolUtilities.hasValidStatus(id).booleanValue()) {
                sb.append('P');
                status = "P";
            } else {
                sb.append(id.charAt(3));
                status = id.substring(3, 4);
            }
            sb.append("------");
            if (id.length() >= 15) {
                sb.append(id.substring(10, 15));
            } else {
                sb.append("*****");
            }
            id = sb.toString();
            lookup = UnitFontLookup.getInstance().getLookupInfo(id, symStd);
        } else if (symbolID == null || symbolID.equals("")) {
            lookup = UnitFontLookup.getInstance().getLookupInfo("SUZP------*****", symStd);
        }
        return lookup;
    }

    public Bitmap getTestSymbol() {
        Bitmap temp = null;
        try {
            temp = Bitmap.createBitmap((int)70, (int)70, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(temp);
            if (canvas.isHardwareAccelerated()) {
                System.out.println("HW acceleration supported");
            }
            Typeface tf = this._tfUnits;
            Paint fillPaint = new Paint();
            fillPaint.setStyle(Paint.Style.FILL);
            fillPaint.setColor(Color.CYAN.toInt());
            fillPaint.setTextSize(50.0f);
            fillPaint.setAntiAlias(true);
            fillPaint.setTextAlign(Paint.Align.CENTER);
            fillPaint.setTypeface(tf);
            Paint framePaint = new Paint();
            framePaint.setStyle(Paint.Style.FILL);
            framePaint.setColor(Color.BLACK.toInt());
            framePaint.setTextSize(50.0f);
            framePaint.setAntiAlias(true);
            framePaint.setTextAlign(Paint.Align.CENTER);
            framePaint.setTypeface(tf);
            Paint symbolPaint = new Paint();
            symbolPaint.setStyle(Paint.Style.FILL);
            symbolPaint.setColor(Color.BLACK.toInt());
            symbolPaint.setTextSize(50.0f);
            symbolPaint.setAntiAlias(true);
            symbolPaint.setTextAlign(Paint.Align.CENTER);
            symbolPaint.setTypeface(tf);
            String strFill = String.valueOf('\u0320');
            String strFrame = String.valueOf('\u0321');
            String strSymbol = String.valueOf('\u0461');
            canvas.drawText(strFill, 35.0f, 35.0f, fillPaint);
            canvas.drawText(strFrame, 35.0f, 35.0f, framePaint);
            canvas.drawText(strSymbol, 35.0f, 35.0f, symbolPaint);
            Paint.FontMetrics mf = framePaint.getFontMetrics();
            float height = mf.bottom - mf.top;
            float width = fillPaint.measureText(strFrame);
            Log.i((String)"SinglePointRenderer", (String)("top: " + String.valueOf(mf.top)));
            Log.i((String)"SinglePointRenderer", (String)("bottom: " + String.valueOf(mf.bottom)));
            Log.i((String)"SinglePointRenderer", (String)("ascent: " + String.valueOf(mf.ascent)));
            Log.i((String)"SinglePointRenderer", (String)("descent: " + String.valueOf(mf.descent)));
            Log.i((String)"SinglePointRenderer", (String)("leading: " + String.valueOf(mf.leading)));
            Log.i((String)"SinglePointRenderer", (String)("width: " + String.valueOf(width)));
            Log.i((String)"SinglePointRenderer", (String)("height: " + String.valueOf(height)));
        }
        catch (Exception exc) {
            Log.e((String)"SinglePointRenderer", (String)exc.getMessage());
            Log.e((String)"SinglePointRenderer", (String)this.getStackTrace(exc));
        }
        return temp;
    }

    public static String makeCacheKey(String symbolID, int lineColor, int fillColor, int iconColor, int size, boolean keepUnitRatio, int symStd) {
        String key = symbolID.substring(0, 10) + String.valueOf(lineColor) + String.valueOf(fillColor) + String.valueOf(iconColor) + String.valueOf(size) + String.valueOf(keepUnitRatio) + String.valueOf(symStd);
        return key;
    }

    public static String makeCacheKey(String symbolID, int lineColor, int fillColor, int size, boolean keepUnitRatio, int symStd) {
        String key = symbolID.substring(0, 10) + String.valueOf(lineColor) + String.valueOf(fillColor) + String.valueOf(size) + String.valueOf(keepUnitRatio) + String.valueOf(symStd);
        return key;
    }

    public void logError(String tag, Throwable thrown) {
        if (tag == null || tag.equals("")) {
            tag = "singlePointRenderer";
        }
        String message = thrown.getMessage();
        String stack = this.getStackTrace(thrown);
        if (message != null) {
            Log.e((String)tag, (String)message);
        }
        if (stack != null) {
            Log.e((String)tag, (String)stack);
        }
    }

    public String getStackTrace(Throwable thrown) {
        try {
            if (thrown != null) {
                if (thrown.getStackTrace() != null) {
                    String eol = System.getProperty("line.separator");
                    StringBuilder sb = new StringBuilder();
                    sb.append(thrown.toString());
                    sb.append(eol);
                    for (StackTraceElement element : thrown.getStackTrace()) {
                        sb.append("        at ");
                        sb.append(element);
                        sb.append(eol);
                    }
                    return sb.toString();
                }
                return thrown.getMessage() + "- no stack trace";
            }
            return "no stack trace";
        }
        catch (Exception exc) {
            Log.e((String)"getStackTrace", (String)exc.getMessage());
            return thrown.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSettingsChanged(SettingsChangedEvent sce) {
        int cSize;
        if (sce != null && sce.getEventType().equals("FONT_CHANGED")) {
            Paint paint = this._modifierFont;
            synchronized (paint) {
                this._modifierFont = RendererSettings.getInstance().getModiferFont();
                this._modifierOutlineFont = RendererSettings.getInstance().getModiferFont();
                Paint.FontMetrics fm = new Paint.FontMetrics();
                fm = this._modifierFont.getFontMetrics();
                this._modifierDescent = fm.descent;
                this._modifierFontHeight = fm.bottom - fm.top;
                this._modifierFont.setStrokeWidth((float)RendererSettings.getInstance().getTextOutlineWidth());
                this._modifierOutlineFont.setColor(Color.white.toInt());
                this._deviceDPI = RendererSettings.getInstance().getDeviceDPI();
                ModifierRenderer.setModifierFont(this._modifierFont, this._modifierFontHeight, this._modifierDescent);
            }
        }
        if (sce != null && sce.getEventType().equals("CACHE_CHANGED") && (cSize = RendererSettings.getInstance().getCacheSize() / 2) != this.cacheSize) {
            LruCache<String, ImageInfo> lruCache = this._unitCache;
            synchronized (lruCache) {
                this._unitCache.evictAll();
                this._unitCache = new LruCache<String, ImageInfo>(cSize){

                    protected int sizeOf(String key, ImageInfo ii) {
                        return ii.getImage().getByteCount();
                    }
                };
            }
            lruCache = this._tgCache;
            synchronized (lruCache) {
                this._tgCache.evictAll();
                this._tgCache = new LruCache<String, ImageInfo>(cSize){

                    protected int sizeOf(String key, ImageInfo ii) {
                        return ii.getImage().getByteCount();
                    }
                };
            }
            this.cacheSize = cSize;
            this.maxCachedEntrySize = this.cacheSize >= 5 ? this.cacheSize / 5 : 1;
        }
    }
}

