/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.graphics2d;

import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.graphics2d.Rectangle2D;
import java.io.Serializable;

public abstract class Line2D {
    public Rectangle2D getBounds2D() {
        double x1 = this.getX1();
        double y1 = this.getY1();
        double x2 = this.getX1();
        double y2 = this.getY1();
        double x = x1;
        double y = y1;
        if (x2 < x1) {
            x = x2;
        }
        if (y2 < y1) {
            y = y2;
        }
        double width = Math.abs(x1 - x2);
        double height = Math.abs(y1 - y2);
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
        return rect;
    }

    public boolean intersectsLine(Line2D edge) {
        double x1 = this.getX1();
        double y1 = this.getY1();
        double x2 = this.getX2();
        double y2 = this.getY2();
        double edgex1 = edge.getX1();
        double edgey1 = edge.getY1();
        double edgex2 = edge.getX2();
        double edgey2 = edge.getY2();
        if (x2 == x1 && edgex2 == edgex1) {
            if (x1 != edgex1) {
                return false;
            }
            if (y1 < y2) {
                if (y1 <= edgey1 && edgey1 <= y2) {
                    return true;
                }
                return y1 <= edgey2 && edgey2 <= y2;
            }
            if (y2 < y1) {
                if (y2 <= edgey1 && edgey1 <= y1) {
                    return true;
                }
                return y2 <= edgey2 && edgey2 <= y1;
            }
        }
        if (x1 < x2) {
            if (edgex1 < x1 && edgex2 < x1) {
                return false;
            }
            if (edgex1 > x2 && edgex2 > x2) {
                return false;
            }
        } else if (x2 < x1) {
            if (edgex1 < x2 && edgex2 < x2) {
                return false;
            }
            if (edgex1 > x1 && edgex2 > x1) {
                return false;
            }
        }
        if (y1 < y2) {
            if (edgey1 < y1 && edgey2 < x1) {
                return false;
            }
            if (edgey1 > y2 && edgey2 > y2) {
                return false;
            }
        } else if (y2 < y1) {
            if (edgey1 < y2 && edgey2 < y2) {
                return false;
            }
            if (edgey1 > y1 && edgey2 > y1) {
                return false;
            }
        }
        if (x1 == x2) {
            if (x1 < edgex1 && x1 < edgex2) {
                return false;
            }
            if (x1 > edgex1 && x1 > edgex2) {
                return false;
            }
        }
        if (y1 == y2) {
            if (y1 < edgey1 && y1 < edgey2) {
                return false;
            }
            if (y1 > edgey1 && y1 > edgey2) {
                return false;
            }
        }
        double slope = (y2 - y1) / (x2 - x1);
        double b1 = y2 - slope * x2;
        double edgeSlope = (edgey2 - edgey1) / (edgex2 - edgex1);
        double b2 = edgey2 - edgeSlope * edgex2;
        Rectangle2D.Double rect = new Rectangle2D.Double(x1, y1, x2, y2);
        Rectangle2D.Double rect2 = new Rectangle2D.Double(edgex1, edgey1, Math.abs(edgex1 - edgex2), Math.abs(edgey1 - edgey2));
        if (slope == edgeSlope) {
            return b1 == b2 && rect.intersects(rect2);
        }
        double x = (b2 - b1) / (slope - edgeSlope);
        double y = slope * x + b1;
        if (x1 < x2) {
            if (x < x1) {
                return false;
            }
            if (x > x2) {
                return false;
            }
        } else if (x2 < x1) {
            if (x < x2) {
                return false;
            }
            if (x > x1) {
                return false;
            }
        }
        if (y1 < y2) {
            if (y < y1) {
                return false;
            }
            if (y > y2) {
                return false;
            }
        } else if (y2 < y1) {
            if (y < y2) {
                return false;
            }
            if (y > y1) {
                return false;
            }
        }
        if (edgex1 < edgex2) {
            if (x < edgex1) {
                return false;
            }
            if (x > edgex2) {
                return false;
            }
        } else if (edgex2 < edgex1) {
            if (x < edgex2) {
                return false;
            }
            if (x > edgex1) {
                return false;
            }
        }
        if (edgey1 < edgey2) {
            if (y < edgey1) {
                return false;
            }
            if (y > edgey2) {
                return false;
            }
        } else if (edgey2 < edgey1) {
            if (y < edgey2) {
                return false;
            }
            if (y > edgey1) {
                return false;
            }
        }
        return true;
    }

    protected Line2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setLine(double var1, double var3, double var5, double var7);

    public void setLine(Point2D p1, Point2D p2) {
        this.setLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setLine(Line2D l) {
        this.setLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    public static int relativeCCW(double x1, double y1, double x2, double y2, double px, double py) {
        double ccw = (px -= x1) * (y2 -= y1) - (py -= y1) * (x2 -= x1);
        if (ccw == 0.0 && (ccw = px * x2 + py * y2) > 0.0 && (ccw = (px -= x2) * x2 + (py -= y2) * y2) < 0.0) {
            ccw = 0.0;
        }
        return ccw < 0.0 ? -1 : (ccw > 0.0 ? 1 : 0);
    }

    public int relativeCCW(double px, double py) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public static double ptLineDistSq(double x1, double y1, double x2, double y2, double px, double py) {
        double dotprod;
        double projlenSq;
        double lenSq;
        if ((lenSq = (px -= x1) * px + (py -= y1) * py - (projlenSq = (dotprod = px * (x2 -= x1) + py * (y2 -= y1)) * dotprod / (x2 * x2 + y2 * y2))) < 0.0) {
            lenSq = 0.0;
        }
        return lenSq;
    }

    public static double ptLineDist(double x1, double y1, double x2, double y2, double px, double py) {
        return Math.sqrt(Line2D.ptLineDistSq(x1, y1, x2, y2, px, py));
    }

    public double ptLineDistSq(double px, double py) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public double ptLineDistSq(Point2D pt) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), pt.getX(), pt.getY());
    }

    public double ptLineDist(double px, double py) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public double ptLineDist(Point2D pt) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), pt.getX(), pt.getY());
    }

    public boolean contains(double x, double y) {
        return false;
    }

    public boolean contains(Point2D p) {
        return false;
    }

    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public boolean contains(Rectangle2D r) {
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static class Double
    extends Line2D
    implements Serializable {
        public double x1;
        public double y1;
        public double x2;
        public double y2;
        private static final long serialVersionUID = 7979627399746467499L;

        public Double() {
        }

        public Double(double x1, double y1, double x2, double y2) {
            this.setLine(x1, y1, x2, y2);
        }

        public Double(Point2D p1, Point2D p2) {
            this.setLine(p1, p2);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        @Override
        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        public Rectangle2D getBounds2D() {
            double h;
            double y;
            double w;
            double x;
            if (this.x1 < this.x2) {
                x = this.x1;
                w = this.x2 - this.x1;
            } else {
                x = this.x2;
                w = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                y = this.y1;
                h = this.y2 - this.y1;
            } else {
                y = this.y2;
                h = this.y1 - this.y2;
            }
            return new Rectangle2D.Double(x, y, w, h);
        }
    }

    public static class Float
    extends Line2D
    implements Serializable {
        public float x1;
        public float y1;
        public float x2;
        public float y2;
        private static final long serialVersionUID = 6161772511649436349L;

        public Float() {
        }

        public Float(float x1, float y1, float x2, float y2) {
            this.setLine(x1, y1, x2, y2);
        }

        public Float(Point2D p1, Point2D p2) {
            this.setLine(p1, p2);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        @Override
        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }

        public void setLine(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        public Rectangle2D getBounds2D() {
            float h;
            float y;
            float w;
            float x;
            if (this.x1 < this.x2) {
                x = this.x1;
                w = this.x2 - this.x1;
            } else {
                x = this.x2;
                w = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                y = this.y1;
                h = this.y2 - this.y1;
            } else {
                y = this.y2;
                h = this.y1 - this.y2;
            }
            return new Rectangle2D.Double(x, y, w, h);
        }
    }
}

