/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.graphics2d;

import armyc2.c2sd.graphics2d.Line2D;
import armyc2.c2sd.graphics2d.QuadCurve2D;

public final class CubicCurve2D {
    private static final int BELOW = -2;
    private static final int LOWEDGE = -1;
    private static final int INSIDE = 0;
    private static final int HIGHEDGE = 1;
    private static final int ABOVE = 2;

    public static double getFlatnessSq2(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        return Math.max(Line2D.ptLineDistSq(x1, y1, x2, y2, ctrlx1, ctrly1), Line2D.ptLineDistSq(x1, y1, x2, y2, ctrlx2, ctrly2));
    }

    public static double getFlatness(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        return Math.sqrt(CubicCurve2D.getFlatnessSq2(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2));
    }

    public static double getFlatnessSq(double[] coords, int offset) {
        return CubicCurve2D.getFlatnessSq2(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public static double getFlatness2(double[] coords, int offset) {
        return CubicCurve2D.getFlatness(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public static void subdivide(double[] src, int srcoff, double[] left, int leftoff, double[] right, int rightoff) {
        double x1 = src[srcoff + 0];
        double y1 = src[srcoff + 1];
        double ctrlx1 = src[srcoff + 2];
        double ctrly1 = src[srcoff + 3];
        double ctrlx2 = src[srcoff + 4];
        double ctrly2 = src[srcoff + 5];
        double x2 = src[srcoff + 6];
        double y2 = src[srcoff + 7];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 6] = x2;
            right[rightoff + 7] = y2;
        }
        x1 = (x1 + ctrlx1) / 2.0;
        y1 = (y1 + ctrly1) / 2.0;
        x2 = (x2 + ctrlx2) / 2.0;
        y2 = (y2 + ctrly2) / 2.0;
        double centerx = (ctrlx1 + ctrlx2) / 2.0;
        double centery = (ctrly1 + ctrly2) / 2.0;
        ctrlx1 = (x1 + centerx) / 2.0;
        ctrly1 = (y1 + centery) / 2.0;
        ctrlx2 = (x2 + centerx) / 2.0;
        ctrly2 = (y2 + centery) / 2.0;
        centerx = (ctrlx1 + ctrlx2) / 2.0;
        centery = (ctrly1 + ctrly2) / 2.0;
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx1;
            left[leftoff + 5] = ctrly1;
            left[leftoff + 6] = centerx;
            left[leftoff + 7] = centery;
        }
        if (right != null) {
            right[rightoff + 0] = centerx;
            right[rightoff + 1] = centery;
            right[rightoff + 2] = ctrlx2;
            right[rightoff + 3] = ctrly2;
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
    }

    public static int solveCubic(double[] eqn) {
        return CubicCurve2D.solveCubic2(eqn, eqn);
    }

    public static int solveCubic2(double[] eqn, double[] res) {
        double d = eqn[3];
        if (d == 0.0) {
            return QuadCurve2D.solveQuadratic2(eqn, res);
        }
        double a = eqn[2] / d;
        double b = eqn[1] / d;
        double c = eqn[0] / d;
        int roots = 0;
        double Q = (a * a - 3.0 * b) / 9.0;
        double R2 = (2.0 * a * a * a - 9.0 * a * b + 27.0 * c) / 54.0;
        double R22 = R2 * R2;
        double Q3 = Q * Q * Q;
        a /= 3.0;
        if (R22 < Q3) {
            double theta = Math.acos(R2 / Math.sqrt(Q3));
            Q = -2.0 * Math.sqrt(Q);
            if (res == eqn) {
                eqn = new double[4];
                System.arraycopy(res, 0, eqn, 0, 4);
            }
            res[roots++] = Q * Math.cos(theta / 3.0) - a;
            res[roots++] = Q * Math.cos((theta + Math.PI * 2) / 3.0) - a;
            res[roots++] = Q * Math.cos((theta - Math.PI * 2) / 3.0) - a;
            CubicCurve2D.fixRoots(res, eqn);
        } else {
            boolean neg = R2 < 0.0;
            double S = Math.sqrt(R22 - Q3);
            if (neg) {
                R2 = -R2;
            }
            double A = Math.pow(R2 + S, 0.3333333333333333);
            if (!neg) {
                A = -A;
            }
            double B = A == 0.0 ? 0.0 : Q / A;
            res[roots++] = A + B - a;
        }
        return roots;
    }

    private static void fixRoots(double[] res, double[] eqn) {
        double EPSILON = 1.0E-5;
        for (int i = 0; i < 3; ++i) {
            double t = res[i];
            if (Math.abs(t) < 1.0E-5) {
                res[i] = CubicCurve2D.findZero(t, 0.0, eqn);
                continue;
            }
            if (!(Math.abs(t - 1.0) < 1.0E-5)) continue;
            res[i] = CubicCurve2D.findZero(t, 1.0, eqn);
        }
    }

    private static double solveEqn(double[] eqn, int order, double t) {
        double v = eqn[order];
        while (--order >= 0) {
            v = v * t + eqn[order];
        }
        return v;
    }

    private static double findZero(double t, double target, double[] eqn) {
        double[] slopeqn = new double[]{eqn[1], 2.0 * eqn[2], 3.0 * eqn[3]};
        double origdelta = 0.0;
        double origt = t;
        double slope;
        while ((slope = CubicCurve2D.solveEqn(slopeqn, 2, t)) != 0.0) {
            double newt;
            double y = CubicCurve2D.solveEqn(eqn, 3, t);
            if (y == 0.0) {
                return t;
            }
            double delta = -(y / slope);
            if (origdelta == 0.0) {
                origdelta = delta;
            }
            if (t < target) {
                if (delta < 0.0) {
                    return t;
                }
            } else if (t > target) {
                if (delta > 0.0) {
                    return t;
                }
            } else {
                return delta > 0.0 ? target + Double.MIN_VALUE : target - Double.MIN_VALUE;
            }
            if (t == (newt = t + delta)) {
                return t;
            }
            if (delta * origdelta < 0.0) {
                int tag;
                int n = tag = origt < t ? CubicCurve2D.getTag(target, origt, t) : CubicCurve2D.getTag(target, t, origt);
                if (tag != 0) {
                    return (origt + t) / 2.0;
                }
                t = target;
                continue;
            }
            t = newt;
        }
        return t;
    }

    private static void fillEqn(double[] eqn, double val, double c1, double cp1, double cp2, double c2) {
        eqn[0] = c1 - val;
        eqn[1] = (cp1 - c1) * 3.0;
        eqn[2] = (cp2 - cp1 - cp1 + c1) * 3.0;
        eqn[3] = c2 + (cp1 - cp2) * 3.0 - c1;
    }

    private static int getTag(double coord, double low, double high) {
        if (coord <= low) {
            return coord < low ? -2 : -1;
        }
        if (coord >= high) {
            return coord > high ? 2 : 1;
        }
        return 0;
    }

    private static boolean inwards(int pttag, int opt1tag, int opt2tag) {
        switch (pttag) {
            default: {
                return false;
            }
            case -1: {
                return opt1tag >= 0 || opt2tag >= 0;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return opt1tag <= 0 || opt2tag <= 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

