/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.graphics2d;

import armyc2.c2sd.JavaLineArray.POINT2;
import armyc2.c2sd.JavaLineArray.arraysupport;
import armyc2.c2sd.JavaLineArray.lineutility;
import armyc2.c2sd.JavaLineArray.ref;
import armyc2.c2sd.graphics2d.AffineTransform;
import armyc2.c2sd.graphics2d.GeneralPath;
import armyc2.c2sd.graphics2d.PathIterator;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.graphics2d.Polygon;
import armyc2.c2sd.graphics2d.Rectangle;
import armyc2.c2sd.graphics2d.Rectangle2D;
import armyc2.c2sd.graphics2d.Shape;
import armyc2.c2sd.graphics2d.Stroke;
import java.util.ArrayList;

public class BasicStroke
implements Stroke,
Shape {
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    float width;
    int join;
    int cap;
    float miterlimit;
    float[] dash;
    float dash_phase;

    public BasicStroke(float width, int cap, int join, float miterlimit, float[] dash, float dash_phase) {
        if (width < 0.0f) {
            throw new IllegalArgumentException("negative width");
        }
        if (cap != 0 && cap != 1 && cap != 2) {
            throw new IllegalArgumentException("illegal end cap value");
        }
        if (join == 0) {
            if (miterlimit < 1.0f) {
                throw new IllegalArgumentException("miter limit < 1");
            }
        } else if (join != 1 && join != 2) {
            throw new IllegalArgumentException("illegal line join value");
        }
        if (dash != null) {
            if (dash_phase < 0.0f) {
                throw new IllegalArgumentException("negative dash phase");
            }
            boolean allzero = true;
            int n = dash.length;
            for (int i = 0; i < n; ++i) {
                float d = dash[i];
                if ((double)d > 0.0) {
                    allzero = false;
                    continue;
                }
                if (!((double)d < 0.0)) continue;
                throw new IllegalArgumentException("negative dash length");
            }
            if (allzero) {
                throw new IllegalArgumentException("dash lengths all zero");
            }
        }
        this.width = width;
        this.cap = cap;
        this.join = join;
        this.miterlimit = miterlimit;
        if (dash != null) {
            this.dash = (float[])dash.clone();
        }
        this.dash_phase = dash_phase;
    }

    public BasicStroke(float width, int cap, int join, float miterlimit) {
        this(width, cap, join, miterlimit, null, 0.0f);
    }

    public BasicStroke(float width, int cap, int join) {
        this(width, cap, join, 10.0f, null, 0.0f);
    }

    public BasicStroke(float width) {
        this(width, 2, 0, 10.0f, null, 0.0f);
    }

    public BasicStroke() {
        this(1.0f, 2, 0, 10.0f, null, 0.0f);
    }

    @Override
    public Shape createStrokedShape(Shape s) {
        return null;
    }

    public Shape createStrokedShape(Polygon poly) {
        ArrayList<POINT2> pts = poly.getPathIterator(null).getPoints();
        int j = 0;
        GeneralPath gp = new GeneralPath();
        POINT2 pt = null;
        POINT2[] ptsx = new POINT2[pts.size()];
        int n = pts.size();
        for (j = 0; j < n; ++j) {
            ptsx[j] = pt = pts.get(j);
        }
        pts = BasicStroke.GetInteriorPoints(ptsx, pts.size(), 32214000, this.width);
        for (j = 0; j < n; ++j) {
            pt = pts.get(j);
            if (j == 0) {
                gp.moveTo(pt.x, pt.y);
                continue;
            }
            gp.lineTo(pt.x, pt.y);
        }
        return gp;
    }

    public float getLineWidth() {
        return this.width;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.miterlimit;
    }

    public float[] getDashArray() {
        if (this.dash == null) {
            return null;
        }
        return (float[])this.dash.clone();
    }

    public float getDashPhase() {
        return this.dash_phase;
    }

    public int hashCode() {
        int hash = Float.floatToIntBits(this.width);
        hash = hash * 31 + this.join;
        hash = hash * 31 + this.cap;
        hash = hash * 31 + Float.floatToIntBits(this.miterlimit);
        if (this.dash != null) {
            hash = hash * 31 + Float.floatToIntBits(this.dash_phase);
            int n = this.dash.length;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + Float.floatToIntBits(this.dash[i]);
            }
        }
        return hash;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return null;
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }

    @Override
    public boolean contains(int x, int y, int width, int height) {
        return false;
    }

    @Override
    public boolean contains(Point2D pt) {
        return false;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return null;
    }

    @Override
    public Rectangle getBounds() {
        return null;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D rect) {
        return false;
    }

    public static ArrayList<POINT2> GetInteriorPoints(POINT2[] pLinePoints, int vblCounter, int lineType, double dist) {
        int j = 0;
        int index = -1;
        POINT2 pt0 = null;
        POINT2 pt1 = null;
        POINT2 pt2 = null;
        ref<double[]> m01 = new ref<double[]>();
        ref<double[]> m12 = new ref<double[]>();
        ref m1 = new ref();
        ref m2 = new ref();
        int direction = -1;
        POINT2 intersectPt = null;
        ArrayList<POINT2> intersectPoints = new ArrayList<POINT2>();
        double b01 = 0.0;
        double b12 = 0.0;
        for (j = 0; j < vblCounter; ++j) {
            if (j == 0 || j == vblCounter - 1) {
                pt0 = pLinePoints[vblCounter - 2];
                pt1 = pLinePoints[0];
                pt2 = pLinePoints[1];
            } else {
                pt0 = pLinePoints[j - 1];
                pt1 = pLinePoints[j];
                pt2 = pLinePoints[j + 1];
            }
            POINT2 pt00 = null;
            POINT2 pt01 = null;
            POINT2 pt10 = null;
            POINT2 pt11 = null;
            index = j - 1;
            if (index < 0) {
                index = vblCounter - 1;
            }
            direction = arraysupport.GetInsideOutsideDouble2(pt0, pt1, pLinePoints, vblCounter, index, lineType);
            switch (direction) {
                case 0: {
                    pt00 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 1, dist);
                    pt01 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 1, dist);
                    break;
                }
                case 1: {
                    pt00 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 0, dist);
                    pt01 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 0, dist);
                    break;
                }
                case 2: {
                    pt00 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 3, dist);
                    pt01 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 3, dist);
                    break;
                }
                case 3: {
                    pt00 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 2, dist);
                    pt01 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 2, dist);
                }
            }
            index = j;
            if (j == vblCounter - 1) {
                index = 0;
            }
            direction = arraysupport.GetInsideOutsideDouble2(pt1, pt2, pLinePoints, vblCounter, index, lineType);
            switch (direction) {
                case 0: {
                    pt10 = lineutility.ExtendDirectedLine(pt1, pt2, pt1, 1, dist);
                    pt11 = lineutility.ExtendDirectedLine(pt1, pt2, pt2, 1, dist);
                    break;
                }
                case 1: {
                    pt10 = lineutility.ExtendDirectedLine(pt1, pt2, pt1, 0, dist);
                    pt11 = lineutility.ExtendDirectedLine(pt1, pt2, pt2, 0, dist);
                    break;
                }
                case 2: {
                    pt10 = lineutility.ExtendDirectedLine(pt1, pt2, pt1, 3, dist);
                    pt11 = lineutility.ExtendDirectedLine(pt1, pt2, pt2, 3, dist);
                    break;
                }
                case 3: {
                    pt10 = lineutility.ExtendDirectedLine(pt1, pt2, pt1, 2, dist);
                    pt11 = lineutility.ExtendDirectedLine(pt1, pt2, pt2, 2, dist);
                }
            }
            if (pt0.x == pt1.x && pt1.x == pt2.x) {
                intersectPt = new POINT2(pt01);
                intersectPoints.add(intersectPt);
                continue;
            }
            lineutility.CalcTrueSlopeDouble2(pt00, pt01, m01);
            lineutility.CalcTrueSlopeDouble2(pt10, pt11, m12);
            if (((double[])m01.value)[0] == ((double[])m12.value)[0]) {
                intersectPt = new POINT2(pt01);
                intersectPoints.add(intersectPt);
                continue;
            }
            b01 = pt01.y - ((double[])m01.value)[0] * pt01.x;
            b12 = pt11.y - ((double[])m12.value)[0] * pt11.x;
            intersectPt = lineutility.CalcTrueIntersectDouble2(((double[])m01.value)[0], b01, ((double[])m12.value)[0], b12, 1, 1, 0.0, 0.0);
            intersectPoints.add(intersectPt);
        }
        return intersectPoints;
    }
}

