/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.graphics2d;

import armyc2.c2sd.graphics2d.AffineTransform;
import armyc2.c2sd.graphics2d.ArcIterator;
import armyc2.c2sd.graphics2d.Line2D;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.graphics2d.Rectangle2D;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Arc2D {
    public static final int OPEN = 0;
    public static final int CHORD = 1;
    public static final int PIE = 2;
    public double x;
    public double y;
    public double width;
    public double height;
    public double start;
    public double extent;
    private static final long serialVersionUID = 728264085846882001L;
    private int type;

    public Arc2D(double x, double y, double w, double h, double start, double extent, int type) {
        this.setArcType(type);
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.start = start;
        this.extent = extent;
    }

    public Arc2D(Rectangle2D ellipseBounds, double start, double extent, int type) {
        this.setArcType(type);
        this.x = ellipseBounds.getX();
        this.y = ellipseBounds.getY();
        this.width = ellipseBounds.getWidth();
        this.height = ellipseBounds.getHeight();
        this.start = start;
        this.extent = extent;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getAngleStart() {
        return this.start;
    }

    public double getAngleExtent() {
        return this.extent;
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public void setArc(double x, double y, double w, double h, double angSt, double angExt, int closure) {
        this.setArcType(closure);
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.start = angSt;
        this.extent = angExt;
    }

    public void setAngleStart(double angSt) {
        this.start = angSt;
    }

    public void setAngleExtent(double angExt) {
        this.extent = angExt;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeByte(this.getArcType());
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        try {
            this.setArcType(s.readByte());
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidObjectException(iae.getMessage());
        }
    }

    Arc2D() {
        this(0);
    }

    protected Arc2D(int type) {
        this.setArcType(type);
    }

    public int getArcType() {
        return this.type;
    }

    public Point2D getStartPoint() {
        double angle = Math.toRadians(-this.getAngleStart());
        double x = this.getX() + (Math.cos(angle) * 0.5 + 0.5) * this.getWidth();
        double y = this.getY() + (Math.sin(angle) * 0.5 + 0.5) * this.getHeight();
        return new Point2D.Double(x, y);
    }

    public Point2D getEndPoint() {
        double angle = Math.toRadians(-this.getAngleStart() - this.getAngleExtent());
        double x = this.getX() + (Math.cos(angle) * 0.5 + 0.5) * this.getWidth();
        double y = this.getY() + (Math.sin(angle) * 0.5 + 0.5) * this.getHeight();
        return new Point2D.Double(x, y);
    }

    public void setArc2(Rectangle2D rect, double angSt, double angExt, int closure) {
        this.setArc(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), angSt, angExt, closure);
    }

    public void setArc3(Arc2D a) {
        this.setArc(a.getX(), a.getY(), a.getWidth(), a.getHeight(), a.getAngleStart(), a.getAngleExtent(), a.type);
    }

    public void setArcByCenter(double x, double y, double radius, double angSt, double angExt, int closure) {
        this.setArc(x - radius, y - radius, radius * 2.0, radius * 2.0, angSt, angExt, closure);
    }

    public void setArcByTangent(Point2D p1, Point2D p2, Point2D p3, double radius) {
        double ang1 = Math.atan2(p1.getY() - p2.getY(), p1.getX() - p2.getX());
        double ang2 = Math.atan2(p3.getY() - p2.getY(), p3.getX() - p2.getX());
        double diff = ang2 - ang1;
        if (diff > Math.PI) {
            ang2 -= Math.PI * 2;
        } else if (diff < -Math.PI) {
            ang2 += Math.PI * 2;
        }
        double bisect = (ang1 + ang2) / 2.0;
        double theta = Math.abs(ang2 - bisect);
        double dist = radius / Math.sin(theta);
        double x = p2.getX() + dist * Math.cos(bisect);
        double y = p2.getY() + dist * Math.sin(bisect);
        if (ang1 < ang2) {
            ang1 -= 1.5707963267948966;
            ang2 += 1.5707963267948966;
        } else {
            ang1 += 1.5707963267948966;
            ang2 -= 1.5707963267948966;
        }
        ang1 = Math.toDegrees(-ang1);
        ang2 = Math.toDegrees(-ang2);
        diff = ang2 - ang1;
        diff = diff < 0.0 ? (diff += 360.0) : (diff -= 360.0);
        this.setArcByCenter(x, y, radius, ang1, diff, this.type);
    }

    public void setArcType(int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("invalid type for Arc: " + type);
        }
        this.type = type;
    }

    public void setFrame(double x, double y, double w, double h) {
        this.setArc(x, y, w, h, this.getAngleStart(), this.getAngleExtent(), this.type);
    }

    public Rectangle2D getBounds2D() {
        double x1;
        double y1;
        double x2;
        double y2;
        if (this.isEmpty()) {
            return this.makeBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.getArcType() == 2) {
            y2 = 0.0;
            x2 = 0.0;
            y1 = 0.0;
            x1 = 0.0;
        } else {
            y1 = 1.0;
            x1 = 1.0;
            y2 = -1.0;
            x2 = -1.0;
        }
        double angle = 0.0;
        for (int i = 0; i < 6; ++i) {
            if (i < 4) {
                if (!this.containsAngle(angle += 90.0)) {
                    continue;
                }
            } else {
                angle = i == 4 ? this.getAngleStart() : (angle += this.getAngleExtent());
            }
            double rads = Math.toRadians(-angle);
            double xe = Math.cos(rads);
            double ye = Math.sin(rads);
            x1 = Math.min(x1, xe);
            y1 = Math.min(y1, ye);
            x2 = Math.max(x2, xe);
            y2 = Math.max(y2, ye);
        }
        double w = this.getWidth();
        double h = this.getHeight();
        x2 = (x2 - x1) * 0.5 * w;
        y2 = (y2 - y1) * 0.5 * h;
        x1 = this.getX() + (x1 * 0.5 + 0.5) * w;
        y1 = this.getY() + (y1 * 0.5 + 0.5) * h;
        return this.makeBounds(x1, y1, x2, y2);
    }

    protected Rectangle2D makeBounds(double x, double y, double w, double h) {
        return null;
    }

    static double normalizeDegrees(double angle) {
        if (angle > 180.0) {
            if (angle <= 540.0) {
                angle -= 360.0;
            } else if ((angle = Math.IEEEremainder(angle, 360.0)) == -180.0) {
                angle = 180.0;
            }
        } else if (angle <= -180.0) {
            if (angle > -540.0) {
                angle += 360.0;
            } else if ((angle = Math.IEEEremainder(angle, 360.0)) == -180.0) {
                angle = 180.0;
            }
        }
        return angle;
    }

    public boolean containsAngle(double angle) {
        boolean backwards;
        double angExt = this.getAngleExtent();
        boolean bl = backwards = angExt < 0.0;
        if (backwards) {
            angExt = -angExt;
        }
        if (angExt >= 360.0) {
            return true;
        }
        angle = Arc2D.normalizeDegrees(angle) - Arc2D.normalizeDegrees(this.getAngleStart());
        if (backwards) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle >= 0.0 && angle < angExt;
    }

    public boolean contains(double x, double y) {
        double y2;
        double x2;
        double y1;
        boolean inside;
        double ellw = this.getWidth();
        if (ellw <= 0.0) {
            return false;
        }
        double normx = (x - this.getX()) / ellw - 0.5;
        double ellh = this.getHeight();
        if (ellh <= 0.0) {
            return false;
        }
        double normy = (y - this.getY()) / ellh - 0.5;
        double distSq = normx * normx + normy * normy;
        if (distSq >= 0.25) {
            return false;
        }
        double angExt = Math.abs(this.getAngleExtent());
        if (angExt >= 360.0) {
            return true;
        }
        boolean inarc = this.containsAngle(-Math.toDegrees(Math.atan2(normy, normx)));
        if (this.type == 2) {
            return inarc;
        }
        if (inarc) {
            if (angExt >= 180.0) {
                return true;
            }
        } else if (angExt <= 180.0) {
            return false;
        }
        double angle = Math.toRadians(-this.getAngleStart());
        double x1 = Math.cos(angle);
        boolean bl = inside = Line2D.relativeCCW(x1, y1 = Math.sin(angle), x2 = Math.cos(angle += Math.toRadians(-this.getAngleExtent())), y2 = Math.sin(angle), 2.0 * normx, 2.0 * normy) * Line2D.relativeCCW(x1, y1, x2, y2, 0.0, 0.0) >= 0;
        return inarc ? !inside : inside;
    }

    public ArcIterator getPathIterator(AffineTransform at) {
        return new ArcIterator(this, at);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getX());
        bits += Double.doubleToLongBits(this.getY()) * 37L;
        bits += Double.doubleToLongBits(this.getWidth()) * 43L;
        bits += Double.doubleToLongBits(this.getHeight()) * 47L;
        bits += Double.doubleToLongBits(this.getAngleStart()) * 53L;
        bits += Double.doubleToLongBits(this.getAngleExtent()) * 59L;
        return (int)(bits += (long)(this.getArcType() * 61)) ^ (int)(bits >> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Arc2D) {
            Arc2D a2d = (Arc2D)obj;
            return this.getX() == a2d.getX() && this.getY() == a2d.getY() && this.getWidth() == a2d.getWidth() && this.getHeight() == a2d.getHeight() && this.getAngleStart() == a2d.getAngleStart() && this.getAngleExtent() == a2d.getAngleExtent() && this.getArcType() == a2d.getArcType();
        }
        return false;
    }
}

