/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.JavaTacticalRenderer;

import armyc2.c2sd.JavaLineArray.POINT2;
import armyc2.c2sd.JavaLineArray.ref;
import armyc2.c2sd.graphics2d.Rectangle2D;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.RendererException;
import java.util.ArrayList;

public final class mdlGeodesic {
    private static final String _className = "mdlGeodesic";
    private static final double sm_a = 6378137.0;

    private static double DegToRad(double deg) {
        return deg / 180.0 * Math.PI;
    }

    private static double RadToDeg(double rad) {
        return rad / Math.PI * 180.0;
    }

    public static double GetAzimuth(POINT2 c1, POINT2 c2) {
        double theta = 0.0;
        try {
            double lat1 = mdlGeodesic.DegToRad(c1.y);
            double lon1 = mdlGeodesic.DegToRad(c1.x);
            double lat2 = mdlGeodesic.DegToRad(c2.y);
            double lon2 = mdlGeodesic.DegToRad(c2.x);
            double y = Math.sin(lon2 - lon1);
            double x = Math.cos(lat1);
            x *= Math.sin(lat2);
            double z = Math.sin(lat1);
            z *= Math.cos(lat2);
            theta = Math.atan2(y *= Math.cos(lat2), x -= (z *= Math.cos(lon2 - lon1)));
            theta = mdlGeodesic.RadToDeg(theta);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetAzimuth", new RendererException("Failed inside GetAzimuth", exc));
        }
        return theta;
    }

    public static double geodesic_distance(POINT2 c1, POINT2 c2, ref<double[]> a12, ref<double[]> a21) {
        double h = 0.0;
        try {
            if (a12 != null && a21 != null) {
                a12.value = new double[1];
                a21.value = new double[1];
                ((double[])a12.value)[0] = mdlGeodesic.GetAzimuth(c1, c2);
                ((double[])a21.value)[0] = mdlGeodesic.GetAzimuth(c2, c1);
            }
            double dLat = mdlGeodesic.DegToRad(c2.y - c1.y);
            double dLon = mdlGeodesic.DegToRad(c2.x - c1.x);
            double b = 0.0;
            double lat1 = 0.0;
            double lat2 = 0.0;
            double e = 0.0;
            double f = 0.0;
            double g = 0.0;
            double k = 0.0;
            b = Math.sin(dLat / 2.0);
            lat1 = mdlGeodesic.DegToRad(c1.y);
            lat2 = mdlGeodesic.DegToRad(c2.y);
            e = Math.sin(dLon / 2.0);
            f = Math.cos(lat1);
            g = Math.cos(lat2);
            double a = b * b + f * g * e * e;
            h = Math.sqrt(a);
            k = Math.sqrt(1.0 - a);
            h = 2.0 * Math.atan2(h, k);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "geodesic_distance", new RendererException("Failed inside geodesic_distance", exc));
        }
        return 6378137.0 * h;
    }

    public static POINT2 geodesic_coordinate(POINT2 start, double distance, double azimuth) {
        POINT2 pt = null;
        try {
            double a = 0.0;
            double b = 0.0;
            double c = 0.0;
            double d = 0.0;
            double e = 0.0;
            double f = 0.0;
            double g = 0.0;
            double h = 0.0;
            double j = 0.0;
            double k = 0.0;
            double l = 0.0;
            double m = 0.0;
            double n = 0.0;
            double p = 0.0;
            double q = 0.0;
            a = mdlGeodesic.DegToRad(start.y);
            b = Math.cos(a);
            c = mdlGeodesic.DegToRad(azimuth);
            d = Math.sin(a);
            e = Math.cos(distance / 6378137.0);
            f = Math.sin(distance / 6378137.0);
            g = Math.cos(c);
            double lat = mdlGeodesic.RadToDeg(Math.asin(d * e + b * f * g));
            h = Math.sin(c);
            k = Math.sin(h);
            l = Math.cos(a);
            m = mdlGeodesic.DegToRad(lat);
            n = Math.sin(m);
            p = Math.atan2(h * f * b, e - d * n);
            double lon = start.x + mdlGeodesic.RadToDeg(p);
            pt = new POINT2(lon, lat);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "geodesic_coordinate", new RendererException("Failed inside geodesic_coordinate", exc));
        }
        return pt;
    }

    public static ArrayList<POINT2> GetGeodesicArc(POINT2[] pPoints) {
        ArrayList<POINT2> pPoints2 = new ArrayList<POINT2>();
        try {
            if (pPoints == null) {
                return null;
            }
            if (pPoints.length < 3) {
                return null;
            }
            POINT2 ptCenter = new POINT2(pPoints[0]);
            POINT2 pt1 = new POINT2(pPoints[1]);
            POINT2 pt2 = new POINT2(pPoints[2]);
            POINT2 ptTemp = null;
            ref<double[]> a12b = new ref<double[]>();
            double dist2 = 0.0;
            double dist1 = 0.0;
            ref<double[]> a12 = new ref<double[]>();
            ref<double[]> a21 = new ref<double[]>();
            dist1 = mdlGeodesic.geodesic_distance(ptCenter, pt1, a12, a21);
            double saveAzimuth = ((double[])a21.value)[0];
            dist2 = mdlGeodesic.geodesic_distance(ptCenter, pt2, a12b, a21);
            if (Math.abs(((double[])a21.value)[0] - saveAzimuth) <= 1.0) {
                if (((double[])a12.value)[0] < 360.0) {
                    double[] dArray = (double[])a12.value;
                    dArray[0] = dArray[0] + 360.0;
                }
                ((double[])a12b.value)[0] = ((double[])a12.value)[0] + 360.0;
            }
            ref a12c = new ref();
            int j = 0;
            if (((double[])a12b.value)[0] < 0.0) {
                ((double[])a12b.value)[0] = 360.0 + ((double[])a12b.value)[0];
            }
            if (((double[])a12.value)[0] < 0.0) {
                ((double[])a12.value)[0] = 360.0 + ((double[])a12.value)[0];
            }
            if (((double[])a12b.value)[0] < ((double[])a12.value)[0]) {
                ((double[])a12b.value)[0] = ((double[])a12b.value)[0] + 360.0;
            }
            a12c.value = new double[1];
            for (j = 0; j <= 100; ++j) {
                ((double[])a12c.value)[0] = ((double[])a12.value)[0] + (double)j / 100.0 * (((double[])a12b.value)[0] - ((double[])a12.value)[0]);
                ptTemp = mdlGeodesic.geodesic_coordinate(ptCenter, dist1, ((double[])a12c.value)[0]);
                pPoints2.add(ptTemp);
            }
            if (Math.abs(((double[])a21.value)[0] - saveAzimuth) > 1.0) {
                pPoints2.add(ptCenter);
            }
            if (((double[])a12.value)[0] < ((double[])a12b.value)[0]) {
                pPoints2.add(pt1);
            } else {
                pPoints2.add(pt2);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetGeodesicArc", new RendererException("Failed inside GetGeodesicArc", exc));
        }
        return pPoints2;
    }

    public static boolean GetGeodesicArc2(ArrayList<POINT2> pPoints, ArrayList<POINT2> pPoints2) {
        boolean circle = false;
        try {
            POINT2 ptCenter = new POINT2(pPoints.get(0));
            POINT2 pt1 = new POINT2(pPoints.get(1));
            POINT2 pt2 = new POINT2(pPoints.get(2));
            ref<double[]> a12b = new ref<double[]>();
            double dist1 = 0.0;
            ref<double[]> a12 = new ref<double[]>();
            ref<double[]> a21 = new ref<double[]>();
            dist1 = mdlGeodesic.geodesic_distance(ptCenter, pt1, a12, a21);
            double saveAzimuth = ((double[])a21.value)[0];
            double dist2 = mdlGeodesic.geodesic_distance(ptCenter, pt2, a12b, a21);
            if (Math.abs(((double[])a21.value)[0] - saveAzimuth) <= 1.0) {
                if (((double[])a12.value)[0] < 360.0) {
                    double[] dArray = (double[])a12.value;
                    dArray[0] = dArray[0] + 360.0;
                }
                ((double[])a12b.value)[0] = ((double[])a12.value)[0] + 360.0;
                circle = true;
            }
            ref a12c = new ref();
            a12c.value = new double[1];
            int j = 0;
            POINT2 pPoint = new POINT2();
            if (((double[])a12b.value)[0] < 0.0) {
                ((double[])a12b.value)[0] = 360.0 + ((double[])a12b.value)[0];
            }
            if (((double[])a12.value)[0] < 0.0) {
                ((double[])a12.value)[0] = 360.0 + ((double[])a12.value)[0];
            }
            if (((double[])a12b.value)[0] < ((double[])a12.value)[0]) {
                ((double[])a12b.value)[0] = ((double[])a12b.value)[0] + 360.0;
            }
            for (j = 0; j <= 100; ++j) {
                ((double[])a12c.value)[0] = ((double[])a12.value)[0] + (double)j / 100.0 * (((double[])a12b.value)[0] - ((double[])a12.value)[0]);
                pPoint = mdlGeodesic.geodesic_coordinate(ptCenter, dist1, ((double[])a12c.value)[0]);
                pPoints2.add(pPoint);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetGeodesicArc2", new RendererException("Failed inside GetGeodesicArc2", exc));
        }
        return circle;
    }

    public static POINT2 IntersectLines(POINT2 p1, double brng1, POINT2 p2, double brng2) {
        POINT2 ptResult = null;
        try {
            double lat1 = mdlGeodesic.DegToRad(p1.y);
            double lon1 = mdlGeodesic.DegToRad(p1.x);
            double lat2 = mdlGeodesic.DegToRad(p2.y);
            double lon2 = mdlGeodesic.DegToRad(p2.x);
            double brng13 = mdlGeodesic.DegToRad(brng1);
            double brng23 = mdlGeodesic.DegToRad(brng2);
            double dLat = lat2 - lat1;
            double dLon = lon2 - lon1;
            double dist12 = 2.0 * Math.asin(Math.sqrt(Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0)));
            if (dist12 == 0.0) {
                return null;
            }
            double brngA = Math.acos((Math.sin(lat2) - Math.sin(lat1) * Math.cos(dist12)) / (Math.sin(dist12) * Math.cos(lat1)));
            if (Double.isNaN(brngA)) {
                brngA = 0.0;
            }
            double brngB = Math.acos((Math.sin(lat1) - Math.sin(lat2) * Math.cos(dist12)) / (Math.sin(dist12) * Math.cos(lat2)));
            double brng12 = 0.0;
            double brng21 = 0.0;
            if (Math.sin(lon2 - lon1) > 0.0) {
                brng12 = brngA;
                brng21 = Math.PI * 2 - brngB;
            } else {
                brng12 = Math.PI * 2 - brngA;
                brng21 = brngB;
            }
            double alpha1 = (brng13 - brng12 + Math.PI) % (Math.PI * 2) - Math.PI;
            double alpha2 = (brng21 - brng23 + Math.PI) % (Math.PI * 2) - Math.PI;
            if (Math.sin(alpha1) == 0.0 && Math.sin(alpha2) == 0.0) {
                return null;
            }
            if (Math.sin(alpha1) * Math.sin(alpha2) < 0.0) {
                return null;
            }
            double alpha3 = Math.acos(-Math.cos(alpha1) * Math.cos(alpha2) + Math.sin(alpha1) * Math.sin(alpha2) * Math.cos(dist12));
            double dist13 = Math.atan2(Math.sin(dist12) * Math.sin(alpha1) * Math.sin(alpha2), Math.cos(alpha2) + Math.cos(alpha1) * Math.cos(alpha3));
            double lat3 = Math.asin(Math.sin(lat1) * Math.cos(dist13) + Math.cos(lat1) * Math.sin(dist13) * Math.cos(brng13));
            double dLon13 = Math.atan2(Math.sin(brng13) * Math.sin(dist13) * Math.cos(lat1), Math.cos(dist13) - Math.sin(lat1) * Math.sin(lat3));
            double lon3 = lon1 + dLon13;
            lon3 = (lon3 + Math.PI) % (Math.PI * 2) - Math.PI;
            ptResult = new POINT2(mdlGeodesic.RadToDeg(lon3), mdlGeodesic.RadToDeg(lat3));
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "IntersectLines", new RendererException("Failed inside IntersectLines", exc));
        }
        return ptResult;
    }

    public static ArrayList<POINT2> normalize_points(ArrayList<POINT2> geoPoints) {
        ArrayList<POINT2> normalizedPts = null;
        try {
            double minx;
            if (geoPoints == null || geoPoints.isEmpty()) {
                return normalizedPts;
            }
            int j = 0;
            double maxx = minx = geoPoints.get((int)0).x;
            boolean spansIDL = false;
            POINT2 pt = null;
            int n = geoPoints.size();
            for (j = 1; j < n; ++j) {
                pt = geoPoints.get(j);
                if (pt.x < minx) {
                    minx = pt.x;
                }
                if (!(pt.x > maxx)) continue;
                maxx = pt.x;
            }
            if (maxx - minx > 180.0) {
                spansIDL = true;
            }
            if (!spansIDL) {
                return geoPoints;
            }
            normalizedPts = new ArrayList<POINT2>();
            n = geoPoints.size();
            for (j = 0; j < n; ++j) {
                pt = geoPoints.get(j);
                if (pt.x < 0.0) {
                    pt.x += 360.0;
                }
                normalizedPts.add(pt);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "normalize_pts", new RendererException("Failed inside normalize_pts", exc));
        }
        return normalizedPts;
    }

    public static Rectangle2D.Double geodesic_mbr(ArrayList<POINT2> geoPoints) {
        Rectangle2D.Double rect2d = null;
        try {
            double uly;
            double ulx;
            if (geoPoints == null || geoPoints.isEmpty()) {
                return rect2d;
            }
            ArrayList<POINT2> normalizedPts = mdlGeodesic.normalize_points(geoPoints);
            double lrx = ulx = normalizedPts.get((int)0).x;
            double lry = uly = normalizedPts.get((int)0).y;
            int j = 0;
            POINT2 pt = null;
            int n = normalizedPts.size();
            for (j = 1; j < n; ++j) {
                pt = normalizedPts.get(j);
                if (pt.x < ulx) {
                    ulx = pt.x;
                }
                if (pt.x > lrx) {
                    lrx = pt.x;
                }
                if (pt.y > uly) {
                    uly = pt.y;
                }
                if (!(pt.y < lry)) continue;
                lry = pt.y;
            }
            POINT2 ul = new POINT2(ulx, uly);
            POINT2 ur = new POINT2(lrx, uly);
            POINT2 lr = new POINT2(lrx, lry);
            double width = mdlGeodesic.geodesic_distance(ul, ur, null, null);
            double height = mdlGeodesic.geodesic_distance(ur, lr, null, null);
            rect2d = new Rectangle2D.Double(ulx, uly, width, height);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "geodesic_mbr", new RendererException("Failed inside geodesic_mbr", exc));
        }
        return rect2d;
    }

    public static POINT2 geodesic_center(ArrayList<POINT2> geoPoints) {
        POINT2 pt = null;
        try {
            if (geoPoints == null || geoPoints.isEmpty()) {
                return pt;
            }
            Rectangle2D.Double rect2d = mdlGeodesic.geodesic_mbr(geoPoints);
            double deltax = rect2d.getWidth() / 2.0;
            double deltay = rect2d.getHeight() / 2.0;
            POINT2 ul = new POINT2(rect2d.x, rect2d.y);
            POINT2 ptEast = mdlGeodesic.geodesic_coordinate(ul, deltax, 90.0);
            pt = mdlGeodesic.geodesic_coordinate(ptEast, deltay, 180.0);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "geodesic_center", new RendererException("Failed inside geodesic_center", exc));
        }
        return pt;
    }

    private static POINT2 geoRotatePoint(POINT2 ptCenter, POINT2 ptRotate, double rotation) {
        try {
            double bearing = mdlGeodesic.GetAzimuth(ptCenter, ptRotate);
            double dist = mdlGeodesic.geodesic_distance(ptCenter, ptRotate, null, null);
            return mdlGeodesic.geodesic_coordinate(ptCenter, dist, bearing + rotation);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "geoRotatePoint", new RendererException("Failed inside geoRotatePoint", exc));
            return null;
        }
    }

    public static POINT2[] getGeoEllipse(POINT2 ptCenter, double majorRadius, double minorRadius, double rotation) {
        POINT2[] pEllipsePoints = null;
        try {
            pEllipsePoints = new POINT2[37];
            POINT2 pt = null;
            double azimuth = 0.0;
            double a = 0.0;
            double b = 0.0;
            double dist = 0.0;
            double bearing = 0.0;
            POINT2 ptLongitude = null;
            POINT2 ptLatitude = null;
            for (int l = 1; l < 37; ++l) {
                double dFactor = 10.0 * (double)l * Math.PI / 180.0;
                a = majorRadius * Math.cos(dFactor);
                b = minorRadius * Math.sin(dFactor);
                ptLongitude = mdlGeodesic.geodesic_coordinate(ptCenter, a, 90.0);
                ptLatitude = mdlGeodesic.geodesic_coordinate(ptCenter, b, 0.0);
                pt = new POINT2(ptLongitude.x, ptLatitude.y);
                pEllipsePoints[l - 1] = mdlGeodesic.geoRotatePoint(ptCenter, pt, -rotation);
            }
            pEllipsePoints[36] = new POINT2(pEllipsePoints[0]);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetGeoEllipse", new RendererException("GetGeoEllipse", exc));
        }
        return pEllipsePoints;
    }
}

