/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.JavaTacticalRenderer;

import armyc2.c2sd.JavaLineArray.Channels;
import armyc2.c2sd.JavaLineArray.POINT2;
import armyc2.c2sd.JavaLineArray.Shape2;
import armyc2.c2sd.JavaLineArray.lineutility;
import armyc2.c2sd.JavaTacticalRenderer.TGLight;
import armyc2.c2sd.JavaTacticalRenderer.clsUtility;
import armyc2.c2sd.JavaTacticalRenderer.mdlGeodesic;
import armyc2.c2sd.graphics2d.AffineTransform;
import armyc2.c2sd.graphics2d.BasicStroke;
import armyc2.c2sd.graphics2d.BufferedImage;
import armyc2.c2sd.graphics2d.Font;
import armyc2.c2sd.graphics2d.FontMetrics;
import armyc2.c2sd.graphics2d.FontRenderContext;
import armyc2.c2sd.graphics2d.Graphics2D;
import armyc2.c2sd.graphics2d.Line2D;
import armyc2.c2sd.graphics2d.PathIterator;
import armyc2.c2sd.graphics2d.Point;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.graphics2d.Polygon;
import armyc2.c2sd.graphics2d.Rectangle2D;
import armyc2.c2sd.graphics2d.Shape;
import armyc2.c2sd.graphics2d.TextLayout;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.IPointConversion;
import armyc2.c2sd.renderer.utilities.RendererException;
import armyc2.c2sd.renderer.utilities.RendererSettings;
import java.util.ArrayList;
import java.util.HashMap;

public class Modifier2 {
    private POINT2[] textPath = new POINT2[2];
    private String textID;
    private String featureID;
    private String text;
    private int iteration;
    private int justify;
    private int type;
    private double lineFactor;
    private static final String _className = "Modifier2";
    private boolean isIntegral = false;
    private boolean fitsMBR = true;
    private static final int toEnd = 1;
    private static final int aboveMiddle = 2;
    private static final int area = 3;
    private static final int screen = 4;
    private static final int aboveEnd = 5;
    private static double fillAlphaCanObscureText = 50.0;

    Modifier2() {
    }

    private static boolean DoublesBack(POINT2 pt0, POINT2 pt1, POINT2 pt2) {
        boolean result = true;
        try {
            double theta1 = Math.atan2(pt2.y - pt1.y, pt2.x - pt1.x);
            double theta0 = Math.atan2(pt0.y - pt1.y, pt0.x - pt1.x);
            double beta = Math.abs(theta0 - theta1);
            if (beta > 0.1) {
                result = false;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DoublesBack", new RendererException("Failed inside DoublesBack", exc));
        }
        return result;
    }

    private static String GetCenterLabel(TGLight tg) {
        String label = "";
        try {
            switch (tg.get_LineType()) {
                case 22223000: {
                    label = "SAAFR";
                    break;
                }
                case 22221000: {
                    label = "AC";
                    break;
                }
                case 212100000: 
                case 212300000: 
                case 212300001: {
                    label = "S";
                    break;
                }
                case 211900000: {
                    label = "R";
                    break;
                }
                case 211700000: {
                    label = "P";
                    break;
                }
                case 211600000: {
                    label = "O";
                    break;
                }
                case 211400000: {
                    label = "I";
                    break;
                }
                case 211100000: {
                    label = "F";
                    break;
                }
                case 211000000: {
                    label = "D";
                    break;
                }
                case 21400000: 
                case 21500000: {
                    label = "C";
                    break;
                }
                case 21200000: 
                case 21300000: {
                    label = "B";
                    break;
                }
                case 212600000: {
                    label = "C/K";
                    break;
                }
                case 212500000: {
                    label = "C/S";
                    break;
                }
                case 23180000: {
                    label = "UXO";
                    break;
                }
                case 212000000: {
                    label = "R";
                    break;
                }
                case 22623000: 
                case 22623001: {
                    label = "BL ";
                    break;
                }
                case 22612000: 
                case 22612001: {
                    label = "HL ";
                    break;
                }
                case 22124000: {
                    label = "PL ";
                    break;
                }
                case 22125000: {
                    label = "LL";
                    break;
                }
                case 212210000: 
                case 212210001: {
                    label = "S";
                    break;
                }
                case 212230000: 
                case 212230001: {
                    label = "C";
                    break;
                }
                case 212220000: 
                case 212220001: {
                    label = "G";
                    break;
                }
                case 211800000: {
                    label = "RIP";
                    break;
                }
                case 212400000: {
                    label = "W";
                    break;
                }
                case 212410000: {
                    label = "WP";
                    break;
                }
                case 21700000: 
                case 21710000: {
                    label = "CATK";
                    break;
                }
                case 22122000: {
                    label = "FLOT";
                    break;
                }
                case 22132000: {
                    label = "AA";
                    break;
                }
                case 22133000: {
                    label = "EA";
                    break;
                }
                case 22135000: {
                    label = "DZ";
                    break;
                }
                case 22136000: {
                    label = "EZ";
                    break;
                }
                case 22137000: {
                    label = "LZ";
                    break;
                }
                case 22138000: {
                    label = "PZ";
                    break;
                }
                case 22222000: 
                case 22222001: {
                    label = "MRR";
                    break;
                }
                case 22224000: {
                    if (tg.getSymbologyStandard() == 1) {
                        label = "UA";
                        break;
                    }
                    label = "UAV";
                    break;
                }
                case 22224001: {
                    label = "UAV";
                    break;
                }
                case 22225000: {
                    label = "LLTR";
                    break;
                }
                case 22231000: {
                    label = "ROZ";
                    break;
                }
                case 22232000: {
                    if (tg.getSymbologyStandard() == 1) {
                        label = "SHORADEZ";
                        break;
                    }
                    label = "FAADEZ";
                    break;
                }
                case 22233000: {
                    label = "HIDACZ";
                    break;
                }
                case 22234000: {
                    label = "MEZ";
                    break;
                }
                case 22234100: {
                    label = "LOMEZ";
                    break;
                }
                case 22234200: {
                    label = "HIMEZ";
                    break;
                }
                case 22235000: {
                    label = "WFZ";
                    break;
                }
                case 22340000: {
                    label = "M";
                    break;
                }
                case 22350000: 
                case 23164000: {
                    label = "M";
                    break;
                }
                case 22421000: {
                    label = "FEBA";
                    break;
                }
                case 22422000: {
                    label = "(PDF)";
                    break;
                }
                case 22431100: {
                    label = "(P)";
                    break;
                }
                case 22432000: {
                    label = "EA ";
                    break;
                }
                case 22535000: {
                    label = "OBJ ";
                    if (!tg.get_Client().equalsIgnoreCase("ge")) break;
                    label = "OBJ  ";
                    break;
                }
                case 22625000: {
                    label = "NAI";
                    break;
                }
                case 22626000: {
                    label = "TAI";
                    break;
                }
                case 24211000: {
                    label = "SMOKE";
                    break;
                }
                case 24260000: {
                    label = "FPF";
                    break;
                }
                case 22532000: {
                    label = "ATK";
                    break;
                }
                case 22523000: {
                    label = "FINAL CL";
                    break;
                }
                case 22525000: {
                    label = "LOA";
                    break;
                }
                case 22526000: {
                    label = "LD";
                    break;
                }
                case 22528000: {
                    label = "PLD";
                    break;
                }
                case 21800000: {
                    label = "D";
                    break;
                }
                case 22613000: {
                    label = "RL";
                    break;
                }
                case 24314000: {
                    label = "SMOKE";
                    break;
                }
                case 24230000: {
                    label = "NFL";
                    break;
                }
                case 24225000: {
                    label = "MFP";
                    break;
                }
                case 24210000: {
                    label = " FSCL";
                    break;
                }
                case 24220000: {
                    label = "CFL ";
                    break;
                }
                case 24240000: {
                    label = "RFL ";
                    break;
                }
                case 22621000: {
                    label = "AO ";
                    break;
                }
                case 24315000: {
                    label = "BOMB";
                    break;
                }
                case 24226000: {
                    label = "TGMF";
                    break;
                }
                case 24321100: {
                    label = "FSA ";
                    break;
                }
                case 24321200: 
                case 24321300: {
                    label = "FSA";
                    break;
                }
                case 24322100: 
                case 24322200: 
                case 24322300: {
                    label = "ACA";
                    break;
                }
                case 24323100: 
                case 24323200: 
                case 24323300: {
                    label = "FFA";
                    break;
                }
                case 24324100: 
                case 24324200: 
                case 24324300: {
                    label = "NFA";
                    break;
                }
                case 24325100: 
                case 24325200: 
                case 24325300: {
                    label = "RFA";
                    break;
                }
                case 24331100: 
                case 24331200: 
                case 24331300: {
                    label = "ATI ZONE";
                    break;
                }
                case 24326100: 
                case 24326101: 
                case 24326200: 
                case 243100000: {
                    label = "PAA";
                    break;
                }
                case 24332100: 
                case 24332200: 
                case 24332300: {
                    label = "CFF ZONE";
                    break;
                }
                case 24336100: 
                case 24336200: 
                case 24336300: {
                    label = "CF ZONE";
                    break;
                }
                case 24333100: 
                case 24333200: 
                case 24333300: {
                    label = "SENSOR ZONE";
                    break;
                }
                case 24334100: 
                case 24334200: 
                case 24334300: {
                    label = "CENSOR ZONE";
                    break;
                }
                case 24335100: 
                case 24335200: 
                case 24335300: {
                    label = "DA";
                    break;
                }
                case 24337100: 
                case 24337200: 
                case 24337300: {
                    label = "ZOR";
                    break;
                }
                case 24338100: 
                case 24338200: 
                case 24338300: {
                    label = "TBA";
                    break;
                }
                case 24339100: 
                case 24339200: 
                case 24339300: {
                    label = "TVAR";
                    break;
                }
                case 24351000: 
                case 24352000: 
                case 24353000: {
                    label = "BKB";
                    break;
                }
                case 24361000: 
                case 24362000: 
                case 24363000: {
                    label = "PKB";
                    break;
                }
                case 25221000: {
                    label = "MSR ";
                    break;
                }
                case 25222000: {
                    label = "ASR ";
                    break;
                }
                case 25223000: 
                case 25224000: 
                case 25225000: {
                    label = "MSR ";
                    break;
                }
                case 22527000: {
                    label = "LD/LC";
                    break;
                }
                case 22622000: {
                    label = "AIRHEAD LINE";
                    break;
                }
                case 21100000: 
                case 26400000: {
                    label = "B";
                    break;
                }
                case 26410000: {
                    label = "E";
                    break;
                }
                case 26420000: {
                    label = "A";
                    break;
                }
                case 26430000: {
                    label = "T";
                    break;
                }
                case 26440000: {
                    label = "O";
                    break;
                }
                case 25330000: {
                    label = "FARP";
                    break;
                }
                case 25351000: {
                    label = "BSA";
                    break;
                }
                case 25352000: {
                    label = "DSA";
                    break;
                }
                case 25353000: {
                    label = "RSA";
                    break;
                }
                case 21600000: {
                    label = "ENY";
                    break;
                }
                case 23114000: {
                    label = "FREE";
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetCenterLabel", new RendererException("Failed inside GetCenterLabel", exc));
        }
        return label;
    }

    public POINT2[] get_TextPath() {
        return this.textPath;
    }

    protected void set_TextPath(POINT2[] value) {
        this.textPath = value;
    }

    protected void set_IsIntegral(boolean value) {
        this.isIntegral = value;
    }

    protected boolean get_IsIntegral() {
        return this.isIntegral;
    }

    private static void AddOffsetModifier(TGLight tg, String text, int type, double lineFactor, int startIndex, int endIndex, double spaces, String rightOrLeft) {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            if (text.equals("")) {
                return;
            }
            if (tg.Pixels == null || tg.Pixels.size() < 2) {
                return;
            }
            modifier.text = text;
            modifier.set_IsIntegral(false);
            modifier.type = type;
            modifier.lineFactor = lineFactor;
            if (tg.Pixels.size() > endIndex) {
                modifier.textPath[0] = tg.Pixels.get(startIndex);
                modifier.textPath[1] = tg.Pixels.get(endIndex);
                if (rightOrLeft != null) {
                    if (rightOrLeft.equals("left")) {
                        modifier.textPath[0].x -= spaces;
                        modifier.textPath[1].x -= spaces;
                    } else {
                        modifier.textPath[0].x += spaces;
                        modifier.textPath[1].x += spaces;
                    }
                }
                tg.modifiers.add(modifier);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddOffsetModifier", new RendererException("Failed inside AddOffsetModifier", exc));
        }
    }

    private static void AddModifier(TGLight tg, String text, int type, double lineFactor, POINT2 ptStart, POINT2 ptEnd) {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            if (text == null || text.equals("")) {
                return;
            }
            if (tg.Pixels == null || tg.Pixels.size() < 2) {
                return;
            }
            modifier.text = text;
            modifier.set_IsIntegral(false);
            modifier.type = type;
            modifier.lineFactor = lineFactor;
            modifier.textPath[0] = ptStart;
            modifier.textPath[1] = ptEnd;
            tg.modifiers.add(modifier);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifier", new RendererException("Failed inside AddModifier", exc));
        }
    }

    private static void AddModifier2(TGLight tg, String text, int type, double lineFactor, POINT2 pt0, POINT2 pt1, boolean isIntegral) {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            if (text == null || text.equals("")) {
                return;
            }
            modifier.text = text;
            modifier.set_IsIntegral(isIntegral);
            modifier.type = type;
            modifier.lineFactor = lineFactor;
            modifier.textPath[0] = pt0;
            modifier.textPath[1] = pt1;
            modifier.isIntegral = isIntegral;
            tg.modifiers.add(modifier);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifier", new RendererException("Failed inside AddModifier", exc));
        }
    }

    private static void AddModifier2(TGLight tg, String text, int type, double lineFactor, POINT2 pt0, POINT2 pt1, boolean isIntegral, String modifierType) {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            if (text == null || text.equals("")) {
                return;
            }
            modifier.text = text;
            modifier.set_IsIntegral(isIntegral);
            modifier.type = type;
            modifier.lineFactor = lineFactor;
            modifier.textPath[0] = pt0;
            modifier.textPath[1] = pt1;
            modifier.isIntegral = isIntegral;
            modifier.textID = modifierType;
            tg.modifiers.add(modifier);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifier", new RendererException("Failed inside AddModifier", exc));
        }
    }

    private static void AddIntegralModifier(TGLight tg, String text, int type, double lineFactor, int startIndex, int endIndex) {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            modifier.set_IsIntegral(true);
            if (text == null || text.equals("")) {
                return;
            }
            if (tg.Pixels == null || tg.Pixels.isEmpty()) {
                return;
            }
            modifier.text = text;
            modifier.type = type;
            modifier.lineFactor = lineFactor;
            if (tg.Pixels.size() > endIndex) {
                modifier.textPath[0] = tg.Pixels.get(startIndex);
                modifier.textPath[1] = tg.Pixels.get(endIndex);
                tg.modifiers.add(modifier);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifier", new RendererException("Failed inside AddIntegralModifier", exc));
        }
    }

    private static void AddIntegralModifier(TGLight tg, String text, int type, double lineFactor, int startIndex, int endIndex, Boolean isIntegral) {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            modifier.set_IsIntegral(isIntegral);
            if (text.equals("")) {
                return;
            }
            if (tg.Pixels == null || tg.Pixels.isEmpty()) {
                return;
            }
            modifier.text = text;
            modifier.type = type;
            modifier.lineFactor = lineFactor;
            if (tg.Pixels.size() > endIndex) {
                modifier.textPath[0] = tg.Pixels.get(startIndex);
                modifier.textPath[1] = tg.Pixels.get(endIndex);
                tg.modifiers.add(modifier);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifier", new RendererException("Failed inside AddIntegralModifier", exc));
        }
    }

    private static void AddIntegralModifier(TGLight tg, String text, int type, double lineFactor, int startIndex, int endIndex, Boolean isIntegral, String modifierType) {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            modifier.set_IsIntegral(isIntegral);
            if (text == null || text.equals("")) {
                return;
            }
            if (tg.Pixels == null || tg.Pixels.isEmpty()) {
                return;
            }
            modifier.text = text;
            modifier.type = type;
            modifier.lineFactor = lineFactor;
            modifier.textID = modifierType;
            if (tg.Pixels.size() > endIndex) {
                modifier.textPath[0] = tg.Pixels.get(startIndex);
                modifier.textPath[1] = tg.Pixels.get(endIndex);
                tg.modifiers.add(modifier);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifier", new RendererException("Failed inside AddIntegralModifier", exc));
        }
    }

    private static void AddAreaModifier(TGLight tg, String text, int type, double lineFactor, POINT2 pt0, POINT2 pt1) {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            modifier.text = text;
            modifier.set_IsIntegral(true);
            if (pt0 == null || pt1 == null) {
                return;
            }
            modifier.type = type;
            modifier.lineFactor = lineFactor;
            modifier.textPath[0] = pt0;
            modifier.textPath[1] = pt1;
            tg.modifiers.add(modifier);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddAreaModifier", new RendererException("Failed inside AddAreaModifier", exc));
        }
    }

    private static void AddAreaModifier(TGLight tg, String text, int type, double lineFactor, POINT2 pt0, POINT2 pt1, String modifierType) {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            modifier.text = text;
            modifier.set_IsIntegral(true);
            if (pt0 == null || pt1 == null) {
                return;
            }
            modifier.type = type;
            modifier.textID = modifierType;
            modifier.lineFactor = lineFactor;
            modifier.textPath[0] = pt0;
            modifier.textPath[1] = pt1;
            tg.modifiers.add(modifier);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddAreaModifier", new RendererException("Failed inside AddAreaModifier", exc));
        }
    }

    private static void AddIntegralAreaModifier(TGLight tg, String text, int type, double lineFactor, POINT2 pt0, POINT2 pt1, Boolean isIntegral) {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            modifier.set_IsIntegral(isIntegral);
            modifier.text = text;
            if (text == null || text.equals("")) {
                return;
            }
            if (pt0 == null || pt1 == null) {
                return;
            }
            modifier.type = type;
            modifier.lineFactor = lineFactor;
            modifier.textPath[0] = pt0;
            modifier.textPath[1] = pt1;
            tg.modifiers.add(modifier);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddAreaModifier", new RendererException("Failed inside AddAreaModifier", exc));
        }
    }

    private static void AddIntegralAreaModifier(TGLight tg, String text, int type, double lineFactor, POINT2 pt0, POINT2 pt1, Boolean isIntegral, String modifierType) {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            Modifier2 modifier = new Modifier2();
            modifier.set_IsIntegral(isIntegral);
            modifier.text = text;
            if (text.equals("")) {
                return;
            }
            if (pt0 == null || pt1 == null) {
                return;
            }
            modifier.type = type;
            modifier.lineFactor = lineFactor;
            modifier.textPath[0] = pt0;
            modifier.textPath[1] = pt1;
            modifier.textID = modifierType;
            tg.modifiers.add(modifier);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddAreaModifier", new RendererException("Failed inside AddAreaModifier", exc));
        }
    }

    public static void GetMBR(TGLight tg, POINT2 ptUl, POINT2 ptUr, POINT2 ptLr, POINT2 ptLl) {
        try {
            int j = 0;
            double x = 0.0;
            double y = 0.0;
            ptUl.x = tg.Pixels.get((int)0).x;
            ptUl.y = tg.Pixels.get((int)0).y;
            ptUr.x = tg.Pixels.get((int)0).x;
            ptUr.y = tg.Pixels.get((int)0).y;
            ptLl.x = tg.Pixels.get((int)0).x;
            ptLl.y = tg.Pixels.get((int)0).y;
            ptLr.x = tg.Pixels.get((int)0).x;
            ptLr.y = tg.Pixels.get((int)0).y;
            int n = tg.Pixels.size();
            for (j = 1; j < n; ++j) {
                x = tg.Pixels.get((int)j).x;
                y = tg.Pixels.get((int)j).y;
                if (x < ptLl.x) {
                    ptLl.x = x;
                    ptUl.x = x;
                }
                if (x > ptLr.x) {
                    ptLr.x = x;
                    ptUr.x = x;
                }
                if (y > ptLl.y) {
                    ptLl.y = y;
                    ptLr.y = y;
                }
                if (!(y < ptUl.y)) continue;
                ptUl.y = y;
                ptUr.y = y;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetMBR", new RendererException("Failed inside GetMBR", exc));
        }
    }

    private static void GetBoundaryMiddleSegment(TGLight tg, Graphics2D g2d, POINT2 pt0, POINT2 pt1) {
        int middleSegment = tg.Pixels.size() / 2 - 1;
        boolean tooShort = Modifier2.GetLineTooShort(tg, g2d);
        int stringWidthENY = 0;
        int stringWidthEchelonSymbol = 0;
        g2d.setFont(tg.get_Font());
        FontMetrics metrics = g2d.getFontMetrics();
        POINT2 midpt = lineutility.MidPointDouble(tg.Pixels.get(middleSegment), tg.Pixels.get(middleSegment + 1), 0);
        POINT2 ptTemp = null;
        double dist = 0.0;
        if (tooShort) {
            if (tg.get_Affiliation().equals("H")) {
                stringWidthENY = metrics.stringWidth(tg.get_N());
            }
            if (tg.get_EchelonSymbol() != null) {
                stringWidthEchelonSymbol = metrics.stringWidth(tg.get_EchelonSymbol());
            }
            dist = 1.5 * (double)(2 * stringWidthENY + stringWidthEchelonSymbol);
            ptTemp = lineutility.ExtendAlongLineDouble(midpt, tg.Pixels.get(middleSegment), dist / 2.0);
            pt0.x = ptTemp.x;
            pt0.y = ptTemp.y;
            ptTemp = lineutility.ExtendAlongLineDouble(midpt, tg.Pixels.get(middleSegment + 1), dist / 2.0);
            pt1.x = ptTemp.x;
            pt1.y = ptTemp.y;
        } else {
            ptTemp = tg.Pixels.get(middleSegment);
            pt0.x = ptTemp.x;
            pt0.y = ptTemp.y;
            ptTemp = tg.Pixels.get(middleSegment + 1);
            pt1.x = ptTemp.x;
            pt1.y = ptTemp.y;
        }
    }

    private static boolean GetLineTooShort(TGLight tg, Graphics2D g2d) {
        boolean lineTooShort = false;
        try {
            int middleSegment = tg.Pixels.size() / 2 - 1;
            g2d.setFont(tg.get_Font());
            FontMetrics metrics = g2d.getFontMetrics();
            String echelonSymbol = null;
            int stringWidthEchelonSymbol = 0;
            int stringWidthENY = 0;
            POINT2 pt0 = tg.Pixels.get(middleSegment);
            POINT2 pt1 = tg.Pixels.get(middleSegment + 1);
            double dist = lineutility.CalcDistanceDouble(pt0, pt1);
            echelonSymbol = tg.get_EchelonSymbol();
            if (tg.get_Affiliation().equals("H")) {
                stringWidthENY = metrics.stringWidth(tg.get_N());
            }
            if (echelonSymbol != null) {
                stringWidthEchelonSymbol = metrics.stringWidth(echelonSymbol);
            }
            switch (tg.get_LineType()) {
                case 22121000: {
                    if (!(dist < 1.5 * (double)(stringWidthENY * 2 + stringWidthEchelonSymbol))) break;
                    lineTooShort = true;
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetBoundaryLineTooShort", new RendererException("Failed inside GetBoundaryLineTooShort", exc));
        }
        return lineTooShort;
    }

    private static boolean GetBoundarySegmentTooShort(TGLight tg, Graphics2D g2d, int middleSegment) {
        boolean lineTooShort = false;
        try {
            int totalWidth;
            g2d.setFont(tg.get_Font());
            FontMetrics metrics = g2d.getFontMetrics();
            String echelonSymbol = null;
            int stringWidthEchelonSymbol = 0;
            int stringWidthENY = 0;
            POINT2 pt0 = tg.Pixels.get(middleSegment);
            POINT2 pt1 = tg.Pixels.get(middleSegment + 1);
            double dist = lineutility.CalcDistanceDouble(pt0, pt1);
            echelonSymbol = tg.get_EchelonSymbol();
            if (tg.get_Affiliation() != null && tg.get_Affiliation().equals("H")) {
                stringWidthENY = metrics.stringWidth(tg.get_N());
            }
            if (echelonSymbol != null) {
                stringWidthEchelonSymbol = metrics.stringWidth(echelonSymbol);
            }
            int tWidth = 0;
            int t1Width = 0;
            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                tWidth = metrics.stringWidth(tg.get_Name());
            }
            if (tg.get_T1() != null && !tg.get_T1().isEmpty()) {
                t1Width = metrics.stringWidth(tg.get_T1());
            }
            if ((totalWidth = stringWidthENY * 2 + stringWidthEchelonSymbol) < tWidth) {
                totalWidth = tWidth;
            }
            if (totalWidth < t1Width) {
                totalWidth = t1Width;
            }
            switch (tg.get_LineType()) {
                case 22121000: {
                    if (!(dist < 1.25 * (double)totalWidth)) break;
                    lineTooShort = true;
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetBoundaryLineTooShort", new RendererException("Failed inside GetBoundaryLineTooShort", exc));
        }
        return lineTooShort;
    }

    private static void AddBoundaryModifiers(TGLight tg, Graphics2D g2d, Rectangle2D clipBounds) {
        try {
            int j = 0;
            double csFactor = 1.0;
            Boolean foundSegment = false;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 ptLast = null;
            double TLineFactor = 0.0;
            double T1LineFactor = 0.0;
            String affiliation = tg.get_Affiliation();
            Boolean lineTooShort = false;
            if (tg.get_Client().equals("cpof3d")) {
                csFactor = 0.85;
            }
            int middleSegment = Modifier2.getVisibleMiddleSegment(tg, clipBounds);
            int n = tg.Pixels.size();
            for (j = 0; j < n - 1; ++j) {
                if (tg.get_Client().equalsIgnoreCase("ge") && j != middleSegment) continue;
                pt0 = tg.Pixels.get(j);
                pt1 = tg.Pixels.get(j + 1);
                if (pt0.x < pt1.x) {
                    TLineFactor = -1.3;
                    T1LineFactor = 1.0;
                } else if (pt0.x == pt1.x) {
                    if (pt1.y < pt0.y) {
                        TLineFactor = -1.0;
                        T1LineFactor = 1.0;
                    } else {
                        TLineFactor = 1.0;
                        T1LineFactor = -1.0;
                    }
                } else {
                    TLineFactor = 1.0;
                    T1LineFactor = -1.3;
                }
                lineTooShort = Modifier2.GetBoundarySegmentTooShort(tg, g2d, j);
                if (lineTooShort.booleanValue()) continue;
                foundSegment = true;
                Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, TLineFactor * csFactor, j, j + 1, true);
                if (!tg.get_EchelonSymbol().equals("")) {
                    Modifier2.AddIntegralModifier(tg, tg.get_EchelonSymbol(), 2, -0.2 * csFactor, j, j + 1, true);
                }
                Modifier2.AddIntegralModifier(tg, tg.get_T1(), 2, T1LineFactor * csFactor, j, j + 1, true);
                if (affiliation == null || !affiliation.equals("H")) continue;
                ptLast = lineutility.MidPointDouble(pt0, pt1, 0);
                ptLast = lineutility.MidPointDouble(pt0, ptLast, 0);
                Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, ptLast, true);
                ptLast = lineutility.MidPointDouble(pt1, pt0, 0);
                ptLast = lineutility.MidPointDouble(pt1, ptLast, 0);
                Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt1, ptLast, true);
            }
            if (!foundSegment.booleanValue()) {
                pt0 = new POINT2();
                pt1 = new POINT2();
                Modifier2.GetBoundaryMiddleSegment(tg, g2d, pt0, pt1);
                Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, TLineFactor * csFactor, middleSegment, middleSegment + 1, true);
                if (!tg.get_EchelonSymbol().equals("")) {
                    Modifier2.AddIntegralModifier(tg, tg.get_EchelonSymbol(), 2, -0.202 * csFactor, middleSegment, middleSegment + 1, true);
                }
                Modifier2.AddIntegralModifier(tg, tg.get_T1(), 2, T1LineFactor * csFactor, middleSegment, middleSegment + 1, true);
                if (affiliation != null && affiliation.equals("H")) {
                    ptLast = lineutility.MidPointDouble(pt0, pt1, 0);
                    ptLast = lineutility.MidPointDouble(pt0, ptLast, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, ptLast, true);
                    ptLast = lineutility.MidPointDouble(pt1, pt0, 0);
                    ptLast = lineutility.MidPointDouble(pt1, ptLast, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt1, ptLast, true);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddBoundaryModifiers", new RendererException("Failed inside AddBoundaryModifiers", exc));
        }
    }

    private static void AddBoundaryModifiers(TGLight tg, Graphics2D g2d, ArrayList<Point2D> clipBounds) {
        try {
            int j = 0;
            double csFactor = 1.0;
            Boolean foundSegment = false;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 ptLast = null;
            double TLineFactor = 0.0;
            double T1LineFactor = 0.0;
            String affiliation = tg.get_Affiliation();
            Boolean lineTooShort = false;
            if (tg.get_Client().equals("cpof3d")) {
                csFactor = 0.85;
            }
            int middleSegment = Modifier2.getVisibleMiddleSegment(tg, clipBounds);
            int n = tg.Pixels.size();
            for (j = 0; j < n - 1; ++j) {
                if (tg.get_Client().equalsIgnoreCase("ge") && j != middleSegment) continue;
                pt0 = tg.Pixels.get(j);
                pt1 = tg.Pixels.get(j + 1);
                if (pt0.x < pt1.x) {
                    TLineFactor = -1.3;
                    T1LineFactor = 1.0;
                } else if (pt0.x == pt1.x) {
                    if (pt1.y < pt0.y) {
                        TLineFactor = -1.0;
                        T1LineFactor = 1.0;
                    } else {
                        TLineFactor = 1.0;
                        T1LineFactor = -1.0;
                    }
                } else {
                    TLineFactor = 1.0;
                    T1LineFactor = -1.3;
                }
                lineTooShort = Modifier2.GetBoundarySegmentTooShort(tg, g2d, j);
                if (lineTooShort.booleanValue()) continue;
                foundSegment = true;
                Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, TLineFactor * csFactor, j, j + 1, true);
                if (!tg.get_EchelonSymbol().equals("")) {
                    Modifier2.AddIntegralModifier(tg, tg.get_EchelonSymbol(), 2, -0.2 * csFactor, j, j + 1, true);
                }
                Modifier2.AddIntegralModifier(tg, tg.get_T1(), 2, T1LineFactor * csFactor, j, j + 1, true);
                if (affiliation == null || !affiliation.equals("H")) continue;
                ptLast = lineutility.MidPointDouble(pt0, pt1, 0);
                ptLast = lineutility.MidPointDouble(pt0, ptLast, 0);
                Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, ptLast, true);
                ptLast = lineutility.MidPointDouble(pt1, pt0, 0);
                ptLast = lineutility.MidPointDouble(pt1, ptLast, 0);
                Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt1, ptLast, true);
            }
            if (!foundSegment.booleanValue()) {
                pt0 = new POINT2();
                pt1 = new POINT2();
                Modifier2.GetBoundaryMiddleSegment(tg, g2d, pt0, pt1);
                Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, TLineFactor * csFactor, middleSegment, middleSegment + 1, true);
                if (!tg.get_EchelonSymbol().equals("")) {
                    Modifier2.AddIntegralModifier(tg, tg.get_EchelonSymbol(), 2, -0.202 * csFactor, middleSegment, middleSegment + 1, true);
                }
                Modifier2.AddIntegralModifier(tg, tg.get_T1(), 2, T1LineFactor * csFactor, middleSegment, middleSegment + 1, true);
                if (affiliation != null && affiliation.equals("H")) {
                    ptLast = lineutility.MidPointDouble(pt0, pt1, 0);
                    ptLast = lineutility.MidPointDouble(pt0, ptLast, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, ptLast, true);
                    ptLast = lineutility.MidPointDouble(pt1, pt0, 0);
                    ptLast = lineutility.MidPointDouble(pt1, ptLast, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt1, ptLast, true);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddBoundaryModifiers", new RendererException("Failed inside AddBoundaryModifiers", exc));
        }
    }

    private static void AddNameAboveDTG(TGLight tg, FontMetrics metrics) {
        try {
            double csFactor = 1.0;
            if (tg.get_Client().equals("cpof3d")) {
                csFactor = 0.667;
            }
            String label = Modifier2.GetCenterLabel(tg);
            POINT2 pt0 = new POINT2(tg.Pixels.get(0));
            POINT2 pt1 = new POINT2(tg.Pixels.get(1));
            int lastIndex = tg.Pixels.size() - 1;
            int nextToLastIndex = tg.Pixels.size() - 2;
            POINT2 ptLast = new POINT2(tg.Pixels.get(lastIndex));
            POINT2 ptNextToLast = new POINT2(tg.Pixels.get(nextToLastIndex));
            Modifier2.shiftModifierPath(tg, pt0, pt1, ptLast, ptNextToLast);
            double stringWidth = metrics.stringWidth(label + " " + tg.get_Name());
            Modifier2.AddIntegralAreaModifier(tg, label + " " + tg.get_Name(), 1, 0.0, pt0, pt1, false);
            pt1 = lineutility.ExtendAlongLineDouble(tg.Pixels.get(0), tg.Pixels.get(1), -1.5 * stringWidth);
            Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
            Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
            Modifier2.AddIntegralAreaModifier(tg, label + " " + tg.get_Name(), 1, 0.0, ptLast, ptNextToLast, false);
            pt0 = tg.Pixels.get(lastIndex);
            pt1 = lineutility.ExtendAlongLineDouble(tg.Pixels.get(lastIndex), tg.Pixels.get(nextToLastIndex), -1.5 * stringWidth);
            Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
            Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddBoundaryModifiers", new RendererException("Failed inside AddBoundaryModifiers", exc));
        }
    }

    private static String blankString(FontMetrics metrics, int width) {
        String str = "";
        try {
            while (metrics.stringWidth(str) < width) {
                str = str + " ";
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getLowestSegmentIndex", new RendererException("Failed inside getLowestSegmentIndex", exc));
        }
        return str;
    }

    private static void shiftModifierPath(TGLight tg, POINT2 pt0, POINT2 pt1, POINT2 ptLast, POINT2 ptNextToLast) {
        try {
            POINT2 p0 = null;
            POINT2 p1 = null;
            double last = -1.0;
            switch (tg.get_LineType()) {
                case 22121000: {
                    for (int j = 0; j < tg.Pixels.size() - 1; ++j) {
                        p0 = tg.Pixels.get(j);
                        p1 = tg.Pixels.get(j + 1);
                        if (!(Math.abs(p0.x - p1.x) < 1.0)) continue;
                        p1.x += last;
                        last = -last;
                    }
                    break;
                }
                case 22122000: 
                case 22123000: 
                case 22124000: 
                case 22125000: 
                case 22422000: 
                case 22523000: 
                case 22525000: 
                case 22526000: 
                case 22527000: 
                case 22528000: 
                case 22612000: 
                case 22612001: 
                case 22613000: 
                case 22623000: 
                case 22623001: 
                case 24230000: {
                    if (pt0 != null && pt1 != null && Math.abs(pt0.x - pt1.x) < 1.0) {
                        pt1.x += 1.0;
                    }
                    if (ptLast != null && ptNextToLast != null && Math.abs(ptNextToLast.x - ptLast.x) < 1.0) {
                        ptNextToLast.x += 1.0;
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "shiftModifierPath", new RendererException("Failed inside shiftModifierPath", exc));
        }
    }

    private static boolean areasWithTwoLabels(TGLight tg, String label, String eny, Graphics2D g2d) {
        boolean result = false;
        try {
            switch (tg.get_LineType()) {
                case 0x222248: {
                    if (tg.get_Affiliation().equalsIgnoreCase("H")) break;
                    eny = "";
                    break;
                }
                default: {
                    return false;
                }
            }
            FontMetrics metrics = g2d.getFontMetrics();
            double labelLength = metrics.stringWidth(label);
            double enyLength = metrics.stringWidth(eny);
            int j = 0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            String last = eny;
            double dist = 0.0;
            int sumLabel = 0;
            int sumENY = 0;
            for (j = 0; j < tg.Pixels.size() - 1; ++j) {
                if (eny.isEmpty() && last.equalsIgnoreCase(label)) {
                    last = eny;
                }
                if (label.isEmpty() && last.equalsIgnoreCase(eny)) {
                    last = label;
                }
                if ((dist = lineutility.CalcDistanceDouble(pt0 = tg.Pixels.get(j), pt1 = tg.Pixels.get(j + 1))) > 1.5 * labelLength && last.equalsIgnoreCase(eny)) {
                    last = label;
                    ++sumLabel;
                    continue;
                }
                if (!(dist > 1.5 * enyLength) || !last.equalsIgnoreCase(label)) continue;
                ++sumENY;
                last = eny;
            }
            if (eny.isEmpty() && sumENY < 2) {
                sumENY = 2;
            }
            if (sumLabel + sumENY < 4) {
                return false;
            }
            for (j = 0; j < tg.Pixels.size() - 1; ++j) {
                if (eny.isEmpty() && last.equalsIgnoreCase(label)) {
                    last = eny;
                }
                if (label.isEmpty() && last.equalsIgnoreCase(eny)) {
                    last = label;
                }
                if ((dist = lineutility.CalcDistanceDouble(pt0 = tg.Pixels.get(j), pt1 = tg.Pixels.get(j + 1))) > 1.5 * labelLength && last.equalsIgnoreCase(eny)) {
                    if (!label.isEmpty()) {
                        Modifier2.AddIntegralAreaModifier(tg, label, 2, 0.0, pt0, pt1, true);
                    }
                    last = label;
                    continue;
                }
                if (!(dist > 1.5 * enyLength) || !last.equalsIgnoreCase(label)) continue;
                if (!eny.isEmpty()) {
                    Modifier2.AddIntegralAreaModifier(tg, eny, 2, 0.0, pt0, pt1, true);
                }
                last = eny;
            }
            return true;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "areasWithTwoLabels", new RendererException("Failed inside areasWithTwoLabels", exc));
            return result;
        }
    }

    private static void areasWithENY(TGLight tg, Graphics2D g2d) {
        try {
            FontMetrics metrics = g2d.getFontMetrics();
            String label = null;
            int middleSegment = tg.Pixels.size() / 2 - 1;
            int middleSegment2 = tg.Pixels.size() - 2;
            int startIndex = 0;
            int j = 0;
            int linetype = tg.get_LineType();
            String affiliation = tg.get_Affiliation();
            String echelonSymbol = tg.get_EchelonSymbol();
            if (affiliation != null && affiliation.equals("H")) {
                label = tg.get_N();
            }
            if (tg.Pixels.size() > 3) {
                middleSegment = tg.Pixels.size() / 4;
            }
            if (tg.Pixels.size() > 3) {
                middleSegment2 = 3 * tg.Pixels.size() / 4;
            }
            switch (linetype) {
                case 22340000: 
                case 22350000: 
                case 23164000: {
                    label = "M";
                    break;
                }
                case 23180000: {
                    label = "UXO";
                    break;
                }
                case 22431000: 
                case 22431100: {
                    if (echelonSymbol == null || echelonSymbol.isEmpty()) break;
                    startIndex = 1;
                    break;
                }
            }
            if (label == null || label.isEmpty()) {
                return;
            }
            int stringWidth = metrics.stringWidth(label);
            boolean foundLongSegment = false;
            double dist = 0.0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            int n = tg.Pixels.size();
            int northestPtIndex = 0;
            int southestPtIndex = 0;
            POINT2 northestPt = null;
            POINT2 southestPt = null;
            if (!RendererSettings.getInstance().getTwoLabelOnly()) {
                for (j = startIndex; j < n - 1; ++j) {
                    pt0 = tg.Pixels.get(j);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1 = tg.Pixels.get(j + 1));
                    if (!(dist > 1.5 * (double)stringWidth)) continue;
                    foundLongSegment = true;
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, 0.0, pt0, pt1, true);
                }
                if (!foundLongSegment) {
                    if (middleSegment != startIndex) {
                        Modifier2.AddIntegralModifier(tg, label, 2, 0.0, middleSegment, middleSegment + 1, true);
                    }
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, middleSegment2, middleSegment2 + 1, true);
                }
            } else {
                for (j = startIndex; j < n - 1; ++j) {
                    pt0 = tg.Pixels.get(j);
                    if (northestPt == null) {
                        northestPt = pt0;
                        northestPtIndex = j;
                    }
                    if (southestPt == null) {
                        southestPt = pt0;
                        southestPtIndex = j;
                    }
                    if (pt0.y >= northestPt.y) {
                        northestPt = pt0;
                        northestPtIndex = j;
                    }
                    if (!(pt0.y <= southestPt.y)) continue;
                    southestPt = pt0;
                    southestPtIndex = j;
                }
                middleSegment = northestPtIndex;
                middleSegment2 = southestPtIndex;
                if (middleSegment != startIndex) {
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, middleSegment, middleSegment + 1, true);
                }
                Modifier2.AddIntegralModifier(tg, label, 2, 0.0, middleSegment2, middleSegment2 + 1, true);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "areasWithENY", new RendererException("Failed inside areasWithENY", exc));
        }
    }

    private static int getVisibleMiddleSegment(TGLight tg, Rectangle2D clipBounds) {
        int middleSegment = -1;
        try {
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            int j = 0;
            double dist = 0.0;
            POINT2 lastPt = null;
            boolean doublesBack = false;
            long lineType = tg.get_LineType();
            middleSegment = (tg.Pixels.size() + 1) / 2 - 1;
            Boolean foundVisibleSegment = false;
            if (clipBounds == null) {
                return middleSegment;
            }
            int n = tg.Pixels.size();
            for (j = middleSegment; j < n - 1; ++j) {
                pt0 = tg.Pixels.get(j);
                dist = lineutility.CalcDistanceDouble(pt0, pt1 = tg.Pixels.get(j + 1));
                if (dist < 5.0) continue;
                if (j > 0 && lineType == 22121000L) {
                    if (lastPt == null) {
                        lastPt = tg.Pixels.get(j - 1);
                    }
                    if (doublesBack = Modifier2.DoublesBack(lastPt, pt0, pt1)) continue;
                    lastPt = null;
                }
                if (!clipBounds.contains(pt0.x, pt0.y) && !clipBounds.contains(pt1.x, pt1.y)) continue;
                middleSegment = j;
                foundVisibleSegment = true;
                break;
            }
            if (!foundVisibleSegment.booleanValue()) {
                for (j = middleSegment; j > 0; --j) {
                    pt0 = tg.Pixels.get(j);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1 = tg.Pixels.get(j - 1));
                    if (dist < 5.0) continue;
                    if (j > 0 && lineType == 22121000L) {
                        if (lastPt == null) {
                            lastPt = tg.Pixels.get(j - 1);
                        }
                        if (doublesBack = Modifier2.DoublesBack(lastPt, pt0, pt1)) continue;
                        lastPt = null;
                    }
                    if (!clipBounds.contains(pt0.x, pt0.y) && !clipBounds.contains(pt1.x, pt1.y)) continue;
                    middleSegment = j - 1;
                    foundVisibleSegment = true;
                    break;
                }
            }
            if (!foundVisibleSegment.booleanValue()) {
                middleSegment = tg.Pixels.size() / 2 - 1;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getMiddleSegment", new RendererException("Failed inside getMiddleSegment", exc));
        }
        return middleSegment;
    }

    private static int getVisibleMiddleSegment(TGLight tg, ArrayList clipBounds) {
        int middleSegment = -1;
        try {
            Polygon clipBoundsPoly = new Polygon();
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            int j = 0;
            int x = 0;
            int y = 0;
            double dist = 0.0;
            POINT2 lastPt = null;
            long lineType = tg.get_LineType();
            boolean doublesBack = false;
            middleSegment = (tg.Pixels.size() + 1) / 2 - 1;
            Boolean foundVisibleSegment = false;
            if (clipBounds == null) {
                return middleSegment;
            }
            for (j = 0; j < clipBounds.size(); ++j) {
                x = (int)((Point2D)clipBounds.get(j)).getX();
                y = (int)((Point2D)clipBounds.get(j)).getY();
                clipBoundsPoly.addPoint(x, y);
            }
            int n = tg.Pixels.size();
            for (j = middleSegment; j < n - 1; ++j) {
                pt0 = tg.Pixels.get(j);
                dist = lineutility.CalcDistanceDouble(pt0, pt1 = tg.Pixels.get(j + 1));
                if (dist < 5.0) continue;
                if (j > 0 && lineType == 22121000L) {
                    if (lastPt == null) {
                        lastPt = tg.Pixels.get(j - 1);
                    }
                    if (doublesBack = Modifier2.DoublesBack(lastPt, pt0, pt1)) continue;
                    lastPt = null;
                }
                if (!clipBoundsPoly.contains(pt0.x, pt0.y) && !clipBoundsPoly.contains(pt1.x, pt1.y)) continue;
                middleSegment = j;
                foundVisibleSegment = true;
                break;
            }
            if (!foundVisibleSegment.booleanValue()) {
                for (j = middleSegment; j > 0; --j) {
                    pt0 = tg.Pixels.get(j);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1 = tg.Pixels.get(j - 1));
                    if (dist < 5.0) continue;
                    if (j > 0 && lineType == 22121000L) {
                        if (lastPt == null) {
                            lastPt = tg.Pixels.get(j - 1);
                        }
                        if (doublesBack = Modifier2.DoublesBack(lastPt, pt0, pt1)) continue;
                        lastPt = null;
                    }
                    if (!clipBoundsPoly.contains(pt0.x, pt0.y) && !clipBoundsPoly.contains(pt1.x, pt1.y)) continue;
                    middleSegment = j - 1;
                    foundVisibleSegment = true;
                    break;
                }
            }
            if (!foundVisibleSegment.booleanValue()) {
                middleSegment = tg.Pixels.size() / 2 - 1;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getMiddleSegment", new RendererException("Failed inside getMiddleSegment", exc));
        }
        return middleSegment;
    }

    private static void removeModifier(TGLight tg, String modifierType) {
        try {
            int j = 0;
            Modifier2 modifier = null;
            int n = tg.Pixels.size();
            for (j = 0; j < n; ++j) {
                modifier = tg.modifiers.get(j);
                if (modifier.textID == null || !modifier.textID.equalsIgnoreCase(modifierType)) continue;
                tg.modifiers.remove(modifier);
                break;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "removeModifier", new RendererException("Failed inside removeModifier", exc));
        }
    }

    public static void RemoveModifiers(TGLight tg, Graphics2D g2d, boolean isTextFlipped, int iteration) {
        try {
            if (!tg.get_Client().equalsIgnoreCase("cpof2d") && !tg.get_Client().equalsIgnoreCase("cpof3d")) {
                return;
            }
            int j = 0;
            Polygon mbrPoly = null;
            switch (tg.get_LineType()) {
                case 24311000: 
                case 24312000: 
                case 24321200: 
                case 24321300: 
                case 24322200: 
                case 24322300: 
                case 24323200: 
                case 24323300: 
                case 24324200: 
                case 24324300: 
                case 24325200: 
                case 24325300: 
                case 24331200: 
                case 24331300: 
                case 24332200: 
                case 24332300: 
                case 24333200: 
                case 24333300: 
                case 24334200: 
                case 24334300: 
                case 24335200: 
                case 24335300: 
                case 24336200: 
                case 24336300: 
                case 24337200: 
                case 24337300: 
                case 24338200: 
                case 24338300: 
                case 24339200: 
                case 24339300: 
                case 24352000: 
                case 24353000: 
                case 24362000: 
                case 24363000: {
                    if (tg.modifiers == null || tg.modifiers.isEmpty() || iteration != 1) {
                        return;
                    }
                    mbrPoly = new Polygon();
                    int n = tg.Pixels.size();
                    for (j = 0; j < n; ++j) {
                        mbrPoly.addPoint((int)tg.Pixels.get((int)j).x, (int)tg.Pixels.get((int)j).y);
                    }
                    break;
                }
                default: {
                    if (!clsUtility.isClosedPolygon(tg.get_LineType()) || iteration != 0) {
                        return;
                    }
                    if (tg.modifiers == null || tg.modifiers.isEmpty()) {
                        return;
                    }
                    mbrPoly = new Polygon();
                    int t = tg.Pixels.size();
                    for (j = 0; j < t; ++j) {
                        mbrPoly.addPoint((int)tg.Pixels.get((int)j).x, (int)tg.Pixels.get((int)j).y);
                    }
                }
            }
            Font font = null;
            font = tg.get_Font();
            if (font == null) {
                font = g2d.getFont();
            }
            g2d.setFont(font);
            FontMetrics metrics = g2d.getFontMetrics();
            double stringWidth = 0.0;
            double stringHeight = 0.0;
            boolean wfits = true;
            boolean w1fits = true;
            boolean ww1fits = true;
            boolean hfits = true;
            boolean h1fits = true;
            boolean h2fits = true;
            Modifier2 modifier = null;
            String modifierType = "";
            String s = "";
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            Object pt4 = null;
            double lineFactor = 0.0;
            double x = 0.0;
            double y = 0.0;
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            int n = tg.modifiers.size();
            for (j = 0; j < n; ++j) {
                modifier = tg.modifiers.get(j);
                if (modifier.textID == null || modifier.textID.isEmpty()) continue;
                modifierType = modifier.textID;
                lineFactor = modifier.lineFactor;
                if (isTextFlipped) {
                    lineFactor = -lineFactor;
                }
                if ((s = modifier.text) == null || s.equals("")) continue;
                stringWidth = (double)metrics.stringWidth(s) + 1.0;
                stringHeight = font.getSize();
                if (modifier.type == 3) {
                    pt0 = modifier.textPath[0];
                    x1 = pt0.x;
                    y1 = pt0.y;
                    x = (int)x1 - (int)stringWidth / 2;
                    y = (int)y1 + (int)(stringHeight / 2.0) + (int)(1.25 * lineFactor * stringHeight);
                    x2 = (int)x1 + (int)stringWidth / 2;
                    y2 = (int)y1 + (int)(stringHeight / 2.0) + (int)(1.25 * lineFactor * stringHeight);
                    if (mbrPoly.contains(x, y) && mbrPoly.contains(x2, y2)) {
                        modifier.fitsMBR = true;
                        continue;
                    }
                    modifier.fitsMBR = false;
                    continue;
                }
                if (modifier.type == 2) {
                    pt0 = modifier.textPath[0];
                    pt1 = modifier.textPath[1];
                    POINT2 ptCenter = lineutility.MidPointDouble(pt0, pt1, 0);
                    pt0 = lineutility.ExtendAlongLineDouble(ptCenter, pt0, stringWidth / 2.0);
                    pt1 = lineutility.ExtendAlongLineDouble(ptCenter, pt1, stringWidth / 2.0);
                    pt2 = lineFactor >= 0.0 ? lineutility.ExtendDirectedLine(ptCenter, pt0, pt0, 3, Math.abs(lineFactor * stringHeight)) : lineutility.ExtendDirectedLine(ptCenter, pt0, pt0, 2, Math.abs(lineFactor * stringHeight));
                    pt3 = lineFactor >= 0.0 ? lineutility.ExtendDirectedLine(ptCenter, pt1, pt1, 3, Math.abs(lineFactor * stringHeight)) : lineutility.ExtendDirectedLine(ptCenter, pt1, pt1, 2, Math.abs(lineFactor * stringHeight));
                    x1 = pt2.x;
                    y1 = pt2.y;
                    x2 = pt3.x;
                    y2 = pt3.y;
                    if (mbrPoly.contains(x1, y1) && mbrPoly.contains(x2, y2)) {
                        modifier.fitsMBR = true;
                        continue;
                    }
                    modifier.fitsMBR = false;
                    continue;
                }
                modifier.fitsMBR = true;
            }
            n = tg.modifiers.size();
            for (j = 0; j < n; ++j) {
                modifier = tg.modifiers.get(j);
                if (modifier.textID == null || modifier.textID.isEmpty() || modifier.fitsMBR) continue;
                if (modifier.textID.equalsIgnoreCase("W")) {
                    wfits = false;
                    continue;
                }
                if (modifier.textID.equalsIgnoreCase("W1")) {
                    w1fits = false;
                    continue;
                }
                if (modifier.textID.equalsIgnoreCase("W+W1")) {
                    ww1fits = false;
                    continue;
                }
                if (modifier.textID.equalsIgnoreCase("H")) {
                    hfits = false;
                    continue;
                }
                if (modifier.textID.equalsIgnoreCase("H1")) {
                    h1fits = false;
                    continue;
                }
                if (!modifier.textID.equalsIgnoreCase("H2")) continue;
                h2fits = false;
            }
            if (!wfits || !w1fits) {
                Modifier2.removeModifier(tg, "W");
                Modifier2.removeModifier(tg, "W1");
            }
            if (!ww1fits) {
                Modifier2.removeModifier(tg, "W+W1");
            }
            if (!(hfits && h1fits && h2fits)) {
                Modifier2.removeModifier(tg, "H");
                Modifier2.removeModifier(tg, "H1");
                Modifier2.removeModifier(tg, "H2");
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "RemoveModifeirs", new RendererException("Failed inside RemoveModifiers", exc));
        }
    }

    private static void getPixelsMiddleSegment(TGLight tg, double stringWidth, POINT2 segPt0, POINT2 segPt1) {
        try {
            switch (tg.get_LineType()) {
                case 24220000: {
                    break;
                }
                default: {
                    return;
                }
            }
            int totalLength = 0;
            int j = 0;
            double dist = 0.0;
            double mid = 0.0;
            double remainder = 0.0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            POINT2 midPt = null;
            int n = tg.Pixels.size();
            for (j = 0; j < n - 1; ++j) {
                dist = lineutility.CalcDistanceDouble(tg.Pixels.get(j), tg.Pixels.get(j + 1));
                totalLength = (int)((double)totalLength + dist);
            }
            mid = totalLength / 2;
            totalLength = 0;
            for (j = 0; j < n - 1; ++j) {
                dist = lineutility.CalcDistanceDouble(tg.Pixels.get(j), tg.Pixels.get(j + 1));
                if (!((double)(totalLength = (int)((double)totalLength + dist)) >= mid)) continue;
                remainder = (double)totalLength - mid;
                pt0 = tg.Pixels.get(j);
                pt1 = tg.Pixels.get(j + 1);
                midPt = lineutility.ExtendAlongLineDouble2(pt1, pt0, remainder);
                pt2 = lineutility.ExtendAlongLineDouble2(midPt, pt0, stringWidth / 2.0);
                pt3 = lineutility.ExtendAlongLineDouble2(midPt, pt1, stringWidth / 2.0);
                segPt0.x = pt2.x;
                segPt0.y = pt2.y;
                segPt1.x = pt3.x;
                segPt1.y = pt3.y;
                break;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getPixelsMidpoint", new RendererException("Failed inside getPixelsMidpoint", exc));
        }
    }

    private static double getChange1Height(TGLight tg) {
        double height = 0.0;
        try {
            switch (tg.get_LineType()) {
                case 24321200: 
                case 24322200: 
                case 24323200: 
                case 24324200: 
                case 24325200: 
                case 24331200: 
                case 24332200: 
                case 24333200: 
                case 24334200: 
                case 24335200: 
                case 24336200: 
                case 24337200: 
                case 24338200: 
                case 24339200: 
                case 24352000: 
                case 24362000: {
                    break;
                }
                default: {
                    return 0.0;
                }
            }
            double x1 = tg.Pixels.get((int)0).x;
            double y1 = tg.Pixels.get((int)0).y;
            double x2 = tg.Pixels.get((int)1).x;
            double y2 = tg.Pixels.get((int)1).y;
            double deltax = x2 - x1;
            double deltay = y2 - y1;
            height = Math.sqrt(deltax * deltax + deltay * deltay);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getChange1Height", new RendererException("Failed inside getChange1Height", exc));
        }
        return height;
    }

    private static void scaleModifiers(TGLight tg) {
        try {
            if (!RendererSettings.getInstance().getAutoCollapseModifiers()) {
                return;
            }
            if (!tg.get_Client().equalsIgnoreCase("ge")) {
                return;
            }
            if (tg.modifiers == null || tg.modifiers.isEmpty()) {
                return;
            }
            int linetype = tg.get_LineType();
            boolean isClosedPolygon = clsUtility.isClosedPolygon(linetype);
            boolean isChange1Area = clsUtility.IsChange1Area(linetype, null);
            if (!isClosedPolygon && !isChange1Area) {
                return;
            }
            switch (linetype) {
                case 24326100: 
                case 24326101: 
                case 24326200: 
                case 243111000: 
                case 243112000: {
                    return;
                }
            }
            POINT2 ptUl = new POINT2();
            POINT2 ptUr = new POINT2();
            POINT2 ptLr = new POINT2();
            POINT2 ptLl = new POINT2();
            Modifier2.GetMBR(tg, ptUl, ptUr, ptLr, ptLl);
            int sz = tg.get_Font().getSize();
            double heightMBR = 0.0;
            double change1Height = Modifier2.getChange1Height(tg);
            heightMBR = change1Height <= 0.0 ? Math.abs(ptLr.y - ptUr.y) / 2.0 : change1Height;
            double heightModifiers = 0.0;
            ArrayList<Modifier2> modifiers = tg.modifiers;
            Modifier2 modifier = null;
            double minLF = 2.147483647E9;
            int j = 0;
            boolean isValid = false;
            for (j = 0; j < modifiers.size(); ++j) {
                modifier = modifiers.get(j);
                if (modifier.type == 1 || modifier.type == 2 && !isChange1Area) continue;
                if (modifier.lineFactor < minLF) {
                    minLF = modifier.lineFactor;
                }
                isValid = true;
            }
            if (!isValid) {
                return;
            }
            heightModifiers = Math.abs(minLF) * (double)sz;
            boolean expandModifiers = false;
            boolean shrinkModifiers = false;
            if (heightModifiers > heightMBR) {
                shrinkModifiers = true;
            } else if (heightModifiers < 0.5 * heightMBR) {
                expandModifiers = true;
            }
            boolean addEllipsis = false;
            Modifier2 modifierE = new Modifier2();
            if (expandModifiers) {
                double factor = heightMBR / heightModifiers;
                if ((factor = 1.0 + (factor - 1.0) / 4.0) > 2.0) {
                    factor = 2.0;
                }
                for (j = 0; j < modifiers.size(); ++j) {
                    modifier = modifiers.get(j);
                    if (modifier.type == 2 ? !isChange1Area : modifier.type != 3) continue;
                    modifier.lineFactor *= factor;
                }
            } else if (shrinkModifiers) {
                double deltaLF = (heightModifiers - heightMBR) / (double)sz;
                double newLF = 0.0;
                double maxLF = 0.0;
                for (j = 0; j < modifiers.size(); ++j) {
                    modifier = modifiers.get(j);
                    if (modifier.type != 2 ? modifier.type != 3 : !isChange1Area) continue;
                    newLF = modifier.lineFactor + deltaLF;
                    if (Math.abs(newLF * (double)sz) >= heightMBR) {
                        if (modifier.lineFactor > minLF) {
                            modifierE.type = modifier.type;
                            modifier.type = 7;
                            if (!modifier.text.isEmpty()) {
                                addEllipsis = true;
                            }
                        }
                        modifier.lineFactor = newLF;
                        modifierE.textPath = modifier.textPath;
                        continue;
                    }
                    modifier.lineFactor = newLF;
                }
                ArrayList<Modifier2> modifiers2 = new ArrayList<Modifier2>();
                for (j = 0; j < modifiers.size(); ++j) {
                    modifier = modifiers.get(j);
                    if (modifier.type == 7) continue;
                    if (modifier.lineFactor > maxLF) {
                        maxLF = modifier.lineFactor;
                    }
                    modifiers2.add(modifier);
                }
                if (addEllipsis) {
                    String echelonSymbol;
                    Character letter = Character.valueOf('\u25cf');
                    String s = Character.toString(letter.charValue());
                    modifierE.text = echelonSymbol = s + s + s;
                    modifierE.lineFactor = maxLF + 1.0;
                    modifiers2.add(modifierE);
                }
                tg.modifiers = modifiers2;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "scaleModifiers", new RendererException("Failed inside scaleModifiers", exc));
        }
    }

    public static void AddModifiersGeo(TGLight tg, Graphics2D g2d, Object clipBounds, IPointConversion converter) {
        try {
            if (tg.Pixels == null || tg.Pixels.isEmpty()) {
                return;
            }
            ArrayList<POINT2> origPoints = null;
            Font font = tg.get_Font();
            boolean shiftLines = Channels.getShiftLines();
            boolean usas = false;
            boolean foundSegment = false;
            double csFactor = 1.0;
            double dist = 0.0;
            double dist2 = 0.0;
            POINT2 midPt = null;
            boolean isChange1Area = clsUtility.IsChange1Area(tg.get_LineType(), null);
            int northestPtIndex = 0;
            int southestPtIndex = 0;
            POINT2 northestPt = null;
            POINT2 southestPt = null;
            if (isChange1Area) {
                return;
            }
            Rectangle2D.Double clipRect = null;
            ArrayList clipArray = null;
            if (clipBounds != null && ArrayList.class.isAssignableFrom(clipBounds.getClass())) {
                clipArray = (ArrayList)clipBounds;
            }
            if (clipBounds != null && Rectangle2D.Double.class.isAssignableFrom(clipBounds.getClass())) {
                clipRect = (Rectangle2D.Double)clipBounds;
            }
            FontMetrics metrics = g2d.getFontMetrics();
            int stringWidth = 0;
            int stringWidth2 = 0;
            String dash = "";
            if (tg.get_DTG() != null && tg.get_DTG1() != null && !tg.get_DTG().isEmpty() && !tg.get_DTG1().isEmpty()) {
                dash = " - ";
            }
            if (tg.get_Client().equals("cpof3d")) {
                csFactor = 0.9;
            }
            switch (tg.get_LineType()) {
                case 0x222248: 
                case 10000000: 
                case 11000000: 
                case 15000000: 
                case 15000001: 
                case 21700000: 
                case 21710000: 
                case 21800000: 
                case 22121000: 
                case 22122000: 
                case 22123000: 
                case 22124000: 
                case 22125000: 
                case 22131000: 
                case 22131001: 
                case 22132000: 
                case 22133000: 
                case 22134000: 
                case 22135000: 
                case 22136000: 
                case 22137000: 
                case 22138000: 
                case 22221000: 
                case 22222000: 
                case 22222001: 
                case 22223000: 
                case 22224000: 
                case 22224001: 
                case 22225000: 
                case 22231000: 
                case 22232000: 
                case 22233000: 
                case 22234000: 
                case 22234100: 
                case 22234200: 
                case 22235000: 
                case 22320000: 
                case 22330000: 
                case 22340000: 
                case 22350000: 
                case 22421000: 
                case 22422000: 
                case 22431000: 
                case 22431100: 
                case 22432000: 
                case 22522100: 
                case 22523000: 
                case 22524000: 
                case 22525000: 
                case 22526000: 
                case 22527000: 
                case 22528000: 
                case 22531000: 
                case 22532000: 
                case 22535000: 
                case 22613000: 
                case 22621000: 
                case 22622000: 
                case 22624000: 
                case 22625000: 
                case 22626000: 
                case 23111000: 
                case 23111001: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23162000: 
                case 23163000: 
                case 23164000: 
                case 23180000: 
                case 23350000: 
                case 23410000: 
                case 23490000: 
                case 24210000: 
                case 24211000: 
                case 24220000: 
                case 24225000: 
                case 24226000: 
                case 24230000: 
                case 24240000: 
                case 24250000: 
                case 24260000: 
                case 24313000: 
                case 24314000: 
                case 24315000: 
                case 24321100: 
                case 24322100: 
                case 24323100: 
                case 24324100: 
                case 24325100: 
                case 24330000: 
                case 24331100: 
                case 24332100: 
                case 24333100: 
                case 24334100: 
                case 24335100: 
                case 24336100: 
                case 24337100: 
                case 24338100: 
                case 24339100: 
                case 24351000: 
                case 24361000: 
                case 25211000: 
                case 25212000: 
                case 25221000: 
                case 25222000: 
                case 25223000: 
                case 25224000: 
                case 25225000: 
                case 25310000: 
                case 25320000: 
                case 25330000: 
                case 25340000: 
                case 25351000: 
                case 25352000: 
                case 25353000: 
                case 26400000: 
                case 26410000: 
                case 26420000: 
                case 26430000: 
                case 26440000: 
                case 31740000: 
                case 31770000: 
                case 211800000: 
                case 212000000: 
                case 212210000: 
                case 212210001: 
                case 212220000: 
                case 212220001: 
                case 212230000: 
                case 212230001: 
                case 212400000: 
                case 212410000: 
                case 221311000: 
                case 317100000: {
                    origPoints = lineutility.getDeepCopy(tg.Pixels);
                    break;
                }
                default: {
                    return;
                }
            }
            double factor = 1.0;
            int linetype = tg.get_LineType();
            int j = 0;
            int k = 0;
            double x = 0.0;
            double y = 0.0;
            if (tg.get_Font() == null || tg.get_Font().getSize() <= 0) {
                return;
            }
            factor = 10.0 / (double)tg.get_Font().getSize();
            int lastIndex = tg.Pixels.size() - 1;
            int nextToLastIndex = tg.Pixels.size() - 2;
            POINT2 pt0 = new POINT2(tg.Pixels.get(0));
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            POINT2 ptLast = new POINT2(tg.Pixels.get(lastIndex));
            POINT2 ptNextToLast = null;
            if (lastIndex > 0) {
                ptNextToLast = new POINT2(tg.Pixels.get(lastIndex - 1));
            }
            if (tg.Pixels.size() > 1) {
                pt1 = new POINT2(tg.Pixels.get(1));
            }
            Modifier2.shiftModifierPath(tg, pt0, pt1, ptLast, ptNextToLast);
            String label = Modifier2.GetCenterLabel(tg);
            Object[] pts = tg.Pixels.toArray();
            POINT2 ptCenter = mdlGeodesic.geodesic_center(tg.LatLongs);
            if (ptCenter == null) {
                ptCenter = lineutility.CalcCenterPointDouble2(pts, pts.length);
            } else {
                Point2D pt = converter.GeoToPixels(new Point2D.Double(ptCenter.x, ptCenter.y));
                ptCenter.x = pt.getX();
                ptCenter.y = pt.getY();
            }
            int middleSegment = (tg.Pixels.size() + 1) / 2 - 1;
            int middleSegment2 = 0;
            if (clipRect != null) {
                middleSegment = Modifier2.getVisibleMiddleSegment(tg, clipRect);
            } else if (clipArray != null) {
                middleSegment = Modifier2.getVisibleMiddleSegment(tg, clipArray);
            }
            String affiliation = tg.get_Affiliation();
            if (tg.Pixels.size() > 2) {
                pt2 = tg.Pixels.get(2);
            }
            if (tg.Pixels.size() > 3) {
                pt3 = tg.Pixels.get(3);
            }
            double TLineFactor = 0.0;
            double T1LineFactor = 0.0;
            POINT2 lr = new POINT2(tg.Pixels.get(0));
            POINT2 ll = new POINT2(tg.Pixels.get(0));
            POINT2 ul = new POINT2(tg.Pixels.get(0));
            POINT2 ur = new POINT2(tg.Pixels.get(0));
            int index = 0;
            int nextIndex = 0;
            int size = tg.Pixels.size();
            Line2D line = null;
            switch (linetype) {
                case 22131001: {
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, true);
                    break;
                }
                case 0x222248: {
                    if (Modifier2.areasWithTwoLabels(tg, tg.get_H(), tg.get_N(), g2d)) break;
                    if (affiliation != null && affiliation.equals("H")) {
                        Modifier2.AddIntegralModifier(tg, tg.get_N(), 2, 0.0, 0, 1, true);
                        Modifier2.AddIntegralModifier(tg, tg.get_N(), 2, 0.0, lastIndex / 2, lastIndex / 2 + 1, true);
                    }
                    if (lastIndex > 3) {
                        line = clsUtility.getExtendedLine(tg, lastIndex / 2 - 1, font.getSize());
                        pt0 = new POINT2(line.getX1(), line.getY1());
                        pt1 = new POINT2(line.getX2(), line.getY2());
                        Modifier2.AddModifier2(tg, tg.get_H(), 2, 0.0, pt0, pt1, true);
                    }
                    line = clsUtility.getExtendedLine(tg, lastIndex / 2 + 1, font.getSize());
                    pt0 = new POINT2(line.getX1(), line.getY1());
                    pt1 = new POINT2(line.getX2(), line.getY2());
                    Modifier2.AddModifier2(tg, tg.get_H(), 2, 0.0, pt0, pt1, true);
                    break;
                }
                case 24313000: {
                    y = pt0.y;
                    index = 0;
                    for (j = 1; j < size - 1; ++j) {
                        if (tg.Pixels.get((int)j).y < y) {
                            y = tg.Pixels.get((int)j).y;
                            index = j;
                        }
                        if (index > 0) {
                            nextIndex = tg.Pixels.get((int)(index - 1)).y < tg.Pixels.get((int)(index + 1)).y ? index - 1 : index + 1;
                        }
                        if (index != 0) continue;
                        nextIndex = pt1.y < ptNextToLast.y ? 1 : nextToLastIndex;
                    }
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, 0.0, index, nextIndex, true);
                    break;
                }
                case 212210000: 
                case 212220000: 
                case 212230000: {
                    stringWidth = (int)(1.5 * (double)metrics.stringWidth(label));
                    pt0 = new POINT2(tg.Pixels.get(0));
                    pt0.x += (double)(2 * stringWidth);
                    pt1 = new POINT2(tg.Pixels.get(0));
                    pt1.x -= (double)(2 * stringWidth);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt0, pt0, true);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt1, pt1, true);
                    break;
                }
                case 212210001: 
                case 212220001: 
                case 212230001: {
                    stringWidth = (int)(1.5 * (double)metrics.stringWidth(label));
                    pt1 = new POINT2(tg.Pixels.get(1));
                    pt2 = new POINT2(tg.Pixels.get(2));
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt1, pt1, true);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt2, pt2, true);
                    break;
                }
                case 24225000: {
                    pt0 = tg.Pixels.get(middleSegment);
                    pt1 = tg.Pixels.get(middleSegment + 1);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, middleSegment, middleSegment + 1, true);
                    Modifier2.AddIntegralModifier(tg, tg.get_DTG(), 2, 1.0 * factor * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_DTG1(), 2, 2.0 * factor * csFactor, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 25224000: {
                    stringWidth = (int)(1.5 * (double)metrics.stringWidth("ALT"));
                    stringWidth2 = (int)(1.5 * (double)metrics.stringWidth(label + tg.get_Name()));
                    if (stringWidth2 > stringWidth) {
                        stringWidth = stringWidth2;
                    }
                    foundSegment = false;
                    if (!RendererSettings.getInstance().getTwoLabelOnly()) {
                        for (j = 0; j < tg.Pixels.size() - 1; ++j) {
                            pt0 = tg.Pixels.get(j);
                            dist = lineutility.CalcDistanceDouble(pt0, pt1 = tg.Pixels.get(j + 1));
                            if (dist < (double)stringWidth) continue;
                            if (pt0.x < pt1.x || pt0.x == pt1.x && pt0.y > pt1.y) {
                                Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -3.5 * factor * csFactor, j, j + 1, false);
                                Modifier2.AddIntegralModifier(tg, "ALT", 2, -1.5 * factor * csFactor, j, j + 1, true);
                            } else {
                                Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -2.0 * factor * csFactor, j, j + 1, false);
                                Modifier2.AddIntegralModifier(tg, "ALT", 2, 0.7 * csFactor, j, j + 1, true);
                            }
                            foundSegment = true;
                        }
                        if (foundSegment) break;
                        pt0 = tg.Pixels.get(middleSegment);
                        pt1 = tg.Pixels.get(middleSegment + 1);
                        if (pt0.x < pt1.x || pt0.x == pt1.x && pt0.y > pt1.y) {
                            Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -3.5 * factor * csFactor, middleSegment, middleSegment + 1, false);
                            Modifier2.AddIntegralModifier(tg, "ALT", 2, -1.5 * factor * csFactor, middleSegment, middleSegment + 1, true);
                            break;
                        }
                        Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -2.0 * factor * csFactor, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "ALT", 2, 0.7 * csFactor, middleSegment, middleSegment + 1, true);
                        break;
                    }
                    for (j = 0; j < tg.Pixels.size(); ++j) {
                        pt0 = tg.Pixels.get(j);
                        if (northestPt == null) {
                            northestPt = pt0;
                            northestPtIndex = j;
                        }
                        if (southestPt == null) {
                            southestPt = pt0;
                            southestPtIndex = j;
                        }
                        if (pt0.y >= northestPt.y) {
                            northestPt = pt0;
                            northestPtIndex = j;
                        }
                        if (!(pt0.y <= southestPt.y)) continue;
                        southestPt = pt0;
                        southestPtIndex = j;
                    }
                    middleSegment = northestPtIndex;
                    middleSegment2 = southestPtIndex;
                    if (middleSegment == tg.Pixels.size() - 1) {
                        --middleSegment;
                    }
                    if (middleSegment2 == tg.Pixels.size() - 1) {
                        --middleSegment2;
                    }
                    if (middleSegment == middleSegment2) {
                        --middleSegment2;
                    }
                    Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "ALT", 2, -1.5 * factor * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, 0.0, middleSegment2, middleSegment2 + 1, false);
                    Modifier2.AddIntegralModifier(tg, "ALT", 2, -1.5 * factor * csFactor, middleSegment2, middleSegment2 + 1, false);
                    break;
                }
                case 25223000: {
                    stringWidth = (int)(1.5 * (double)metrics.stringWidth(label + tg.get_Name()));
                    foundSegment = false;
                    if (!RendererSettings.getInstance().getTwoLabelOnly()) {
                        for (j = 0; j < tg.Pixels.size() - 1; ++j) {
                            pt0 = tg.Pixels.get(j);
                            dist = lineutility.CalcDistanceDouble(pt0, pt1 = tg.Pixels.get(j + 1));
                            if (dist < (double)stringWidth) continue;
                            if (pt0.x < pt1.x || pt0.x == pt1.x && pt0.y > pt1.y) {
                                Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -3.0 * factor * csFactor, j, j + 1, false);
                            } else {
                                Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -2.0 * factor * csFactor, j, j + 1, false);
                            }
                            foundSegment = true;
                        }
                        if (foundSegment) break;
                        pt0 = tg.Pixels.get(middleSegment);
                        pt1 = tg.Pixels.get(middleSegment + 1);
                        if (pt0.x < pt1.x || pt0.x == pt1.x && pt0.y > pt1.y) {
                            Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -3.0 * factor * csFactor, middleSegment, middleSegment + 1, false);
                            break;
                        }
                        Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -2.0 * factor * csFactor, middleSegment, middleSegment + 1, false);
                        break;
                    }
                    for (j = 0; j < tg.Pixels.size(); ++j) {
                        pt0 = tg.Pixels.get(j);
                        if (northestPt == null) {
                            northestPt = pt0;
                            northestPtIndex = j;
                        }
                        if (southestPt == null) {
                            southestPt = pt0;
                            southestPtIndex = j;
                        }
                        if (pt0.y >= northestPt.y) {
                            northestPt = pt0;
                            northestPtIndex = j;
                        }
                        if (!(pt0.y <= southestPt.y)) continue;
                        southestPt = pt0;
                        southestPtIndex = j;
                    }
                    middleSegment = northestPtIndex;
                    middleSegment2 = southestPtIndex;
                    if (middleSegment == tg.Pixels.size() - 1) {
                        --middleSegment;
                    }
                    if (middleSegment2 == tg.Pixels.size() - 1) {
                        --middleSegment2;
                    }
                    if (middleSegment == middleSegment2) {
                        --middleSegment2;
                    }
                    Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, 0.0, middleSegment2, middleSegment2 + 1, false);
                    break;
                }
                case 25225000: {
                    stringWidth = (int)(1.5 * (double)metrics.stringWidth(label + tg.get_Name()));
                    foundSegment = false;
                    if (!RendererSettings.getInstance().getTwoLabelOnly()) {
                        for (j = 0; j < tg.Pixels.size() - 1; ++j) {
                            pt0 = tg.Pixels.get(j);
                            dist = lineutility.CalcDistanceDouble(pt0, pt1 = tg.Pixels.get(j + 1));
                            if (dist < (double)stringWidth) continue;
                            if (pt0.x < pt1.x || pt0.x == pt1.x && pt0.y > pt1.y) {
                                Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -4.5 * factor * csFactor, j, j + 1, false);
                            } else {
                                Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -2.0 * factor * csFactor, j, j + 1, false);
                            }
                            foundSegment = true;
                        }
                        if (foundSegment) break;
                        pt0 = tg.Pixels.get(middleSegment);
                        pt1 = tg.Pixels.get(middleSegment + 1);
                        if (pt0.x < pt1.x || pt0.x == pt1.x && pt0.y > pt1.y) {
                            Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -4.5 * factor * csFactor, middleSegment, middleSegment + 1, false);
                            break;
                        }
                        Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -2.0 * factor * csFactor, middleSegment, middleSegment + 1, false);
                        break;
                    }
                    for (j = 0; j < tg.Pixels.size(); ++j) {
                        pt0 = tg.Pixels.get(j);
                        if (northestPt == null) {
                            northestPt = pt0;
                            northestPtIndex = j;
                        }
                        if (southestPt == null) {
                            southestPt = pt0;
                            southestPtIndex = j;
                        }
                        if (pt0.y >= northestPt.y) {
                            northestPt = pt0;
                            northestPtIndex = j;
                        }
                        if (!(pt0.y <= southestPt.y)) continue;
                        southestPt = pt0;
                        southestPtIndex = j;
                    }
                    middleSegment = northestPtIndex;
                    middleSegment2 = southestPtIndex;
                    if (middleSegment == tg.Pixels.size() - 1) {
                        --middleSegment;
                    }
                    if (middleSegment2 == tg.Pixels.size() - 1) {
                        --middleSegment2;
                    }
                    if (middleSegment == middleSegment2) {
                        --middleSegment2;
                    }
                    Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, 0.0, middleSegment2, middleSegment2 + 1, false);
                    break;
                }
                case 25310000: {
                    Modifier2.AddIntegralAreaModifier(tg, "DETAINEE", 3, -1.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, "HOLDING", 3, -0.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, "AREA", 3, 0.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 1.5 * csFactor, ptCenter, ptCenter, false);
                    break;
                }
                case 25320000: {
                    Modifier2.AddIntegralAreaModifier(tg, "EPW", 3, -1.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, "HOLDING", 3, -0.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, "AREA", 3, 0.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 1.5 * csFactor, ptCenter, ptCenter, false);
                    break;
                }
                case 23180000: {
                    Modifier2.areasWithENY(tg, g2d);
                    break;
                }
                case 25330000: 
                case 25351000: 
                case 25352000: 
                case 25353000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -0.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.5 * csFactor, ptCenter, ptCenter, false);
                    break;
                }
                case 31740000: 
                case 31770000: 
                case 317100000: {
                    Modifier2.AddAreaModifier(tg, tg.get_H(), 3, -0.5, ptCenter, ptCenter, "H");
                    Modifier2.AddAreaModifier(tg, tg.get_H1(), 3, 0.5, ptCenter, ptCenter, "H1");
                    break;
                }
                case 25340000: {
                    Modifier2.AddIntegralAreaModifier(tg, "REFUGEE", 3, -1.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, "HOLDING", 3, -0.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, "AREA", 3, 0.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 1.5 * csFactor, ptCenter, ptCenter, false);
                    break;
                }
                case 25221000: 
                case 25222000: {
                    foundSegment = false;
                    if (!RendererSettings.getInstance().getTwoLabelOnly()) {
                        for (j = 0; j < tg.Pixels.size() - 1; ++j) {
                            pt0 = tg.Pixels.get(j);
                            pt1 = tg.Pixels.get(j + 1);
                            stringWidth = (int)(1.5 * (double)metrics.stringWidth(label + tg.get_Name()));
                            dist = lineutility.CalcDistanceDouble(pt0, pt1);
                            if (dist < (double)stringWidth) continue;
                            Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -1.0 * csFactor, j, j + 1, false);
                            foundSegment = true;
                        }
                        if (foundSegment) break;
                        Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, -1.0 * csFactor, middleSegment, middleSegment + 1, false);
                        break;
                    }
                    for (j = 0; j < tg.Pixels.size(); ++j) {
                        pt0 = tg.Pixels.get(j);
                        if (northestPt == null) {
                            northestPt = pt0;
                            northestPtIndex = j;
                        }
                        if (southestPt == null) {
                            southestPt = pt0;
                            southestPtIndex = j;
                        }
                        if (pt0.y >= northestPt.y) {
                            northestPt = pt0;
                            northestPtIndex = j;
                        }
                        if (!(pt0.y <= southestPt.y)) continue;
                        southestPt = pt0;
                        southestPtIndex = j;
                    }
                    middleSegment = northestPtIndex;
                    middleSegment2 = southestPtIndex;
                    if (middleSegment == tg.Pixels.size() - 1) {
                        --middleSegment;
                    }
                    if (middleSegment2 == tg.Pixels.size() - 1) {
                        --middleSegment2;
                    }
                    if (middleSegment == middleSegment2) {
                        --middleSegment2;
                    }
                    Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, label + tg.get_Name(), 2, 0.0, middleSegment2, middleSegment2 + 1, false);
                    break;
                }
                case 24250000: {
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, -0.8 * csFactor, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 24211000: {
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, -0.8 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.8 * csFactor, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 24260000: {
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, -1.0 * csFactor, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, label, 2, 1.0 * csFactor, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_T1(), 2, 2.0 * csFactor, 0, 1, false);
                    break;
                }
                case 23163000: {
                    if (tg.Pixels.get((int)1).y > tg.Pixels.get((int)0).y) {
                        pt0 = tg.Pixels.get(1);
                        pt1 = tg.Pixels.get(3);
                        pt2 = tg.Pixels.get(0);
                        pt3 = tg.Pixels.get(2);
                    } else {
                        pt0 = tg.Pixels.get(0);
                        pt1 = tg.Pixels.get(2);
                        pt2 = tg.Pixels.get(1);
                        pt3 = tg.Pixels.get(3);
                    }
                    pt2 = lineutility.ExtendAlongLineDouble2(pt0, pt2, -20.0);
                    pt3 = lineutility.ExtendAlongLineDouble2(pt1, pt3, -20.0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, 0.0, pt2, pt3, false);
                    break;
                }
                case 23162000: {
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_H(), 2, -1.5 * factor * csFactor, ul, ur, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 2, 1.5 * factor * csFactor, ll, lr, false);
                    Modifier2.areasWithENY(tg, g2d);
                    break;
                }
                case 22622000: {
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, 1.35 * factor * csFactor, ll, lr, false);
                    break;
                }
                case 25211000: 
                case 25212000: {
                    String convoyBlankString = Modifier2.blankString(metrics, 35);
                    Modifier2.AddIntegralModifier(tg, tg.get_H() + convoyBlankString + tg.get_H1(), 2, 0.0, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, 1.2 * csFactor, 0, 1, false);
                    break;
                }
                case 22522100: {
                    if (affiliation == null || !affiliation.equals("H")) break;
                    k = tg.Pixels.size();
                    j = lineutility.GetDirAtkAirMiddleSegment(tg.Pixels.toArray(new POINT2[tg.Pixels.size()]), tg.Pixels.size());
                    pt1 = tg.Pixels.get(k - j - 1);
                    pt0 = tg.Pixels.get(k - j);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1);
                    pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, 2.0 * dist / 3.0);
                    Modifier2.AddModifier2(tg, tg.get_N(), 2, 0.0, pt0, pt1, true);
                    break;
                }
                case 22432000: 
                case 22535000: 
                case 22621000: {
                    Modifier2.AddIntegralAreaModifier(tg, label + tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    break;
                }
                case 24322100: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -3.0 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -2.0 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, "MIN ALT: " + tg.get_H(), 3, -1.0 * csFactor, ptCenter, ptCenter, false, "H");
                    Modifier2.AddIntegralAreaModifier(tg, "MAX ALT: " + tg.get_H1(), 3, 0.0, ptCenter, ptCenter, false, "H1");
                    Modifier2.AddIntegralAreaModifier(tg, "Grids: " + tg.get_H2(), 3, 1.0 * csFactor, ptCenter, ptCenter, false, "H2");
                    Modifier2.AddIntegralAreaModifier(tg, "EFF: " + tg.get_DTG(), 3, 2.0 * csFactor, ptCenter, ptCenter, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 3, 3.0 * csFactor, ptCenter, ptCenter, false, "W1");
                    break;
                }
                case 24323100: 
                case 24325100: 
                case 24351000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.0 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 3, 1.0 * csFactor, ptCenter, ptCenter, false, "W+W1");
                    break;
                }
                case 24361000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.0 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 3, 1.0 * csFactor, ptCenter, ptCenter, false, "W+W1");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_H1(), 3, 2.0 * csFactor, ptCenter, ptCenter, false);
                    break;
                }
                case 24324100: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.0 * csFactor, ptCenter, ptCenter, true);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, true);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 3, 1.0 * csFactor, ptCenter, ptCenter, true, "W+W1");
                    break;
                }
                case 24321100: {
                    Modifier2.AddIntegralAreaModifier(tg, label + " " + tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    POINT2 ptLeftFSA = ul;
                    POINT2 ptRightFSA = ur;
                    if (tg.get_Client().equalsIgnoreCase("ge")) {
                        ptLeftFSA.x -= (double)(font.getSize() / 2);
                        ptRightFSA.x -= (double)(font.getSize() / 2);
                    }
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 1, 0.5 * csFactor, ptLeftFSA, ptRightFSA, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 1, 1.5 * csFactor, ptLeftFSA, ptRightFSA, false, "W1");
                    break;
                }
                case 24331100: 
                case 24332100: 
                case 24333100: 
                case 24334100: 
                case 24335100: 
                case 24336100: 
                case 24337100: 
                case 24338100: 
                case 24339100: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 1.0 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    POINT2 ptLeft = ul;
                    POINT2 ptRight = ur;
                    if (tg.get_Client().equalsIgnoreCase("ge")) {
                        ptLeft.x -= (double)(font.getSize() / 2);
                        ptRight.x -= (double)(font.getSize() / 2);
                    }
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 1, 0.5 * csFactor, ptLeft, ptRight, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 1, 1.5 * csFactor, ptLeft, ptRight, false, "W1");
                    break;
                }
                case 24314000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 3, 1.0 * csFactor, ptCenter, ptCenter, false, "W+W1");
                    break;
                }
                case 22431000: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_EchelonSymbol(), 2, -0.2 * csFactor, 0, 1, true);
                    Modifier2.areasWithENY(tg, g2d);
                    break;
                }
                case 22431100: {
                    Modifier2.AddIntegralAreaModifier(tg, label + tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_EchelonSymbol(), 2, -0.2 * csFactor, 0, 1, true);
                    Modifier2.areasWithENY(tg, g2d);
                    break;
                }
                case 22422000: {
                    pt1 = lineutility.ExtendAlongLineDouble(pt1, pt0, -22.0, 0);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt1, pt1, false);
                    break;
                }
                case 22421000: {
                    stringWidth = metrics.stringWidth(label);
                    pt1 = new POINT2(pt0);
                    pt1.x -= (double)(stringWidth + 8);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt1, pt1, false);
                    pt1 = new POINT2(ptLast);
                    pt1.x += 40.0;
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt1, pt1, false);
                    break;
                }
                case 22532000: 
                case 22625000: 
                case 22626000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -0.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.5 * csFactor, ptCenter, ptCenter, false);
                    break;
                }
                case 22531000: {
                    Modifier2.AddIntegralAreaModifier(tg, "ASLT", 3, -1.0 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, "PSN", 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 1.0 * csFactor, ptCenter, ptCenter, false);
                    break;
                }
                case 22235000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.5 * csFactor, ptCenter, ptCenter, true);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -0.5 * csFactor, ptCenter, ptCenter, true);
                    Modifier2.AddIntegralAreaModifier(tg, "TIME FROM: " + tg.get_DTG(), 3, 0.5 * csFactor, ptCenter, ptCenter, true, "W");
                    Modifier2.AddIntegralAreaModifier(tg, "TIME TO: " + tg.get_DTG1(), 3, 1.5 * csFactor, ptCenter, ptCenter, true, "W1");
                    break;
                }
                case 23114000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -0.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 3, 0.5 * csFactor, ptCenter, ptCenter, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 3, 1.5 * csFactor, ptCenter, ptCenter, false, "W1");
                    break;
                }
                case 23115000: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -1.0 * csFactor, ptCenter, ptCenter, true);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 3, 0.0, ptCenter, ptCenter, true, "W");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 3, 1.0 * csFactor, ptCenter, ptCenter, true, "W1");
                    break;
                }
                case 22231000: 
                case 22232000: 
                case 22233000: 
                case 22234000: 
                case 22234100: 
                case 22234200: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -2.5, ptCenter, ptCenter, false, "");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -1.5, ptCenter, ptCenter, false, "T");
                    Modifier2.AddIntegralAreaModifier(tg, "MIN ALT: " + tg.get_H(), 3, -0.5, ptCenter, ptCenter, false, "H");
                    Modifier2.AddIntegralAreaModifier(tg, "MAX ALT: " + tg.get_H1(), 3, 0.5, ptCenter, ptCenter, false, "H1");
                    Modifier2.AddIntegralAreaModifier(tg, "TIME FROM: " + tg.get_DTG(), 3, 1.5, ptCenter, ptCenter, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, "TIME TO: " + tg.get_DTG1(), 3, 2.5, ptCenter, ptCenter, false, "W1");
                    break;
                }
                case 22223000: {
                    pt0 = new POINT2(tg.Pixels.get(middleSegment));
                    dist = pt0.style / tg.get_Font().getSize();
                    dist /= 2.0;
                    if (tg.getSymbologyStandard() == 1) {
                        Modifier2.AddIntegralModifier(tg, "SAAFR " + tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "Max Alt: " + tg.get_H1(), 2, -4.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "Min Alt: " + tg.get_H(), 2, -5.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "Width: " + tg.get_H2(), 2, -6.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "Name: " + tg.get_Name(), 2, -7.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "DTG Start: " + tg.get_DTG(), 2, -3.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "DTG End: " + tg.get_DTG1(), 2, -2.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                        break;
                    }
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Max Alt: " + tg.get_H1(), 2, -2.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Min Alt: " + tg.get_H(), 2, -3.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Width: " + tg.get_H2(), 2, -4.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Name: " + tg.get_Name(), 2, -5.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 22221000: {
                    pt0 = new POINT2(tg.Pixels.get(middleSegment));
                    dist = pt0.style / tg.get_Font().getSize();
                    dist /= 2.0;
                    if (tg.getSymbologyStandard() == 1) {
                        Modifier2.AddIntegralModifier(tg, label + " " + tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "Max Alt: " + tg.get_H1(), 2, -4.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "Min Alt: " + tg.get_H(), 2, -5.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "Width: " + tg.get_H2(), 2, -6.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "Name: " + tg.get_Name(), 2, -7.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "DTG Start: " + tg.get_DTG(), 2, -3.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                        Modifier2.AddIntegralModifier(tg, "DTG End: " + tg.get_DTG1(), 2, -2.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                        break;
                    }
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, -1.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_T1(), 2, 1.0 * csFactor - dist, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 22222000: 
                case 22222001: 
                case 22224000: 
                case 22224001: 
                case 22225000: {
                    if (tg.getSymbologyStandard() == 1) {
                        Modifier2.AddIntegralModifier(tg, label + " " + tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                        pt0 = new POINT2(tg.Pixels.get(middleSegment));
                        pt1 = new POINT2(tg.Pixels.get(middleSegment + 1));
                        if (pt0.y < pt1.y) {
                            pt1.y = pt0.y;
                        } else {
                            pt0.y = pt1.y;
                        }
                        pt0.y -= (double)(pt0.style / 2);
                        pt1.y -= (double)(pt0.style / 2);
                        Modifier2.AddIntegralAreaModifier(tg, "Max Alt: " + tg.get_H1(), 2, -4.0 * csFactor, pt0, pt1, false);
                        Modifier2.AddIntegralAreaModifier(tg, "Min Alt: " + tg.get_H(), 2, -5.0 * csFactor, pt0, pt1, false);
                        Modifier2.AddIntegralAreaModifier(tg, "Width: " + tg.get_H2(), 2, -6.0 * csFactor, pt0, pt1, false);
                        Modifier2.AddIntegralAreaModifier(tg, "Name: " + tg.get_Name(), 2, -7.0 * csFactor, pt0, pt1, false);
                        Modifier2.AddIntegralAreaModifier(tg, "DTG Start: " + tg.get_DTG(), 2, -3.0 * csFactor, pt0, pt1, false);
                        Modifier2.AddIntegralAreaModifier(tg, "DTG End: " + tg.get_DTG1(), 2, -2.0 * csFactor, pt0, pt1, false);
                        break;
                    }
                    Modifier2.AddIntegralModifier(tg, label, 2, -0.5, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, 0.5, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 221311000: {
                    Modifier2.areasWithENY(tg, g2d);
                    break;
                }
                case 22131000: {
                    Modifier2.areasWithENY(tg, g2d);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    break;
                }
                case 22134000: 
                case 22624000: {
                    if (affiliation == null || !affiliation.equals("H")) break;
                    Modifier2.AddIntegralModifier(tg, tg.get_N(), 2, 0.0, 0, 1, true);
                    Modifier2.AddIntegralModifier(tg, tg.get_N(), 2, 0.0, middleSegment, middleSegment + 1, true);
                    break;
                }
                case 22132000: 
                case 22133000: 
                case 22135000: 
                case 22136000: 
                case 22137000: 
                case 22138000: {
                    Modifier2.areasWithENY(tg, g2d);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.0 * csFactor, ptCenter, ptCenter, false);
                    break;
                }
                case 22121000: {
                    if (clipRect != null) {
                        Modifier2.AddBoundaryModifiers(tg, g2d, clipRect);
                        break;
                    }
                    if (clipArray != null) {
                        Modifier2.AddBoundaryModifiers(tg, g2d, clipArray);
                        break;
                    }
                    Modifier2.AddBoundaryModifiers(tg, g2d, (Rectangle2D)null);
                    break;
                }
                case 22340000: 
                case 22350000: {
                    Modifier2.areasWithENY(tg, g2d);
                    if (affiliation == null || !affiliation.equals("H")) break;
                    pt1 = lineutility.MidPointDouble(pt0, pt1, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, pt1, true);
                    if (middleSegment == 0) break;
                    pt0 = tg.Pixels.get(middleSegment);
                    pt1 = tg.Pixels.get(middleSegment + 1);
                    pt1 = lineutility.MidPointDouble(pt0, pt1, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, pt1, true);
                    break;
                }
                case 23164000: {
                    Modifier2.areasWithENY(tg, g2d);
                    if (affiliation == null || !affiliation.equals("H")) break;
                    pt1 = lineutility.MidPointDouble(pt0, pt1, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, pt1, true);
                    if (middleSegment == 0) break;
                    pt0 = tg.Pixels.get(middleSegment);
                    pt1 = tg.Pixels.get(middleSegment + 1);
                    pt1 = lineutility.MidPointDouble(pt0, pt1, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, pt1, true);
                    break;
                }
                case 22124000: {
                    Modifier2.AddIntegralAreaModifier(tg, label + tg.get_Name(), 1, T1LineFactor, pt0, pt1, false);
                    Modifier2.AddIntegralAreaModifier(tg, label + tg.get_Name(), 1, T1LineFactor, ptLast, ptNextToLast, false);
                    break;
                }
                case 10000000: 
                case 15000000: {
                    if (tg.get_T1() == null || tg.get_T1().isEmpty()) {
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 1, T1LineFactor, pt0, pt1, false);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 1, T1LineFactor, ptLast, ptNextToLast, false);
                        break;
                    }
                    if (tg.get_T1().equalsIgnoreCase("1")) {
                        for (j = 0; j < tg.Pixels.size() - 1; ++j) {
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 0.0, tg.Pixels.get(j), tg.Pixels.get(j + 1), false);
                        }
                        break;
                    }
                    if (tg.get_T1().equalsIgnoreCase("2")) {
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 1, T1LineFactor, pt0, pt1, false);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 1, T1LineFactor, ptLast, ptNextToLast, false);
                        break;
                    }
                    if (tg.get_T1().equalsIgnoreCase("3")) {
                        dist = lineutility.CalcDistanceDouble(pt0, pt1);
                        stringWidth = metrics.stringWidth(tg.get_Name());
                        pt2 = lineutility.ExtendAlongLineDouble2(pt1, pt0, dist + (double)(stringWidth /= 2));
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, pt2, pt2, false);
                        dist = lineutility.CalcDistanceDouble(ptNextToLast, ptLast);
                        pt2 = lineutility.ExtendAlongLineDouble2(ptNextToLast, ptLast, dist + (double)stringWidth);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, pt2, pt2, false);
                        for (j = 1; j < tg.Pixels.size() - 1; ++j) {
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, tg.Pixels.get(j), tg.Pixels.get(j), false);
                        }
                        break;
                    }
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 1, T1LineFactor, pt0, pt1, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 1, T1LineFactor, ptLast, ptNextToLast, false);
                    break;
                }
                case 11000000: 
                case 15000001: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    break;
                }
                case 22525000: 
                case 22526000: 
                case 22527000: {
                    if (!tg.get_Name().isEmpty()) {
                        Modifier2.AddIntegralAreaModifier(tg, "(PL " + tg.get_Name() + ")", 1, 1.0 * csFactor, pt0, pt1, false);
                    }
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, pt0, pt1, false);
                    if (!tg.get_Name().isEmpty()) {
                        Modifier2.AddIntegralAreaModifier(tg, "(PL " + tg.get_Name() + ")", 1, 1.0 * csFactor, ptLast, ptNextToLast, false);
                    }
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, ptLast, ptNextToLast, false);
                    break;
                }
                case 22613000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, -csFactor, pt0, pt1, false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, -csFactor, ptLast, ptNextToLast, false);
                    break;
                }
                case 22125000: 
                case 22523000: 
                case 22528000: {
                    usas = true;
                    if (!usas) {
                        Modifier2.AddIntegralAreaModifier(tg, "(PL " + tg.get_Name() + ")", 1, 1.0 * csFactor, pt0, pt1, false);
                        Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, pt0, pt1, false);
                        Modifier2.AddIntegralAreaModifier(tg, "(PL " + tg.get_Name() + ")", 1, 1.0 * csFactor, ptLast, ptNextToLast, false);
                        Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, ptLast, ptNextToLast, false);
                        break;
                    }
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, -csFactor, pt0, pt1, false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, -csFactor, ptLast, ptNextToLast, false);
                    break;
                }
                case 24230000: {
                    usas = true;
                    if (!usas) {
                        Modifier2.AddIntegralAreaModifier(tg, "(PL " + tg.get_Name() + ")", 1, 1.0 * csFactor, pt0, pt1, false);
                        Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, pt0, pt1, false);
                        Modifier2.AddIntegralAreaModifier(tg, "(PL " + tg.get_Name() + ")", 1, 1.0 * csFactor, ptLast, ptNextToLast, false);
                        Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, ptLast, ptNextToLast, false);
                        break;
                    }
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, -csFactor, pt0, pt1, false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, -csFactor, ptLast, ptNextToLast, false);
                    break;
                }
                case 24210000: {
                    pt0 = tg.Pixels.get(0);
                    pt1 = tg.Pixels.get(1);
                    pt2 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt3 = tg.Pixels.get(tg.Pixels.size() - 2);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1);
                    dist2 = lineutility.CalcDistanceDouble(pt2, pt3);
                    stringWidth = (int)((double)metrics.stringWidth(tg.get_Name() + " " + label));
                    stringWidth2 = (int)((double)metrics.stringWidth(tg.get_DTG()));
                    if (stringWidth2 > stringWidth) {
                        stringWidth = stringWidth2;
                    }
                    if (tg.Pixels.size() == 2) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, 1.0 * (double)stringWidth);
                        Modifier2.AddModifier2(tg, tg.get_Name() + " " + label, 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        if (!(dist > 3.5 * (double)stringWidth)) break;
                        pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                        pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, 1.0 * (double)stringWidth);
                        Modifier2.AddModifier2(tg, tg.get_Name() + " " + label, 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        break;
                    }
                    double dist3 = lineutility.CalcDistanceDouble(pt0, pt2);
                    if (dist > (double)(stringWidth + 5) || dist >= dist2 || dist3 > (double)(stringWidth + 5)) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, 1.0 * (double)stringWidth);
                        Modifier2.AddModifier2(tg, tg.get_Name() + " " + label, 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                    }
                    if (!(dist2 > (double)(stringWidth + 5)) && !(dist2 > dist) && !(dist3 > (double)(stringWidth + 5))) break;
                    pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                    pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, 1.0 * (double)stringWidth);
                    Modifier2.AddModifier2(tg, tg.get_Name() + " " + label, 2, -0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                    break;
                }
                case 24220000: {
                    stringWidth = (int)((double)metrics.stringWidth(label + tg.get_Name()));
                    stringWidth2 = (int)((double)metrics.stringWidth(tg.get_DTG() + dash + tg.get_DTG1()));
                    if (stringWidth2 > stringWidth) {
                        stringWidth = stringWidth2;
                    }
                    pt0 = new POINT2(tg.Pixels.get(middleSegment));
                    pt1 = new POINT2(tg.Pixels.get(middleSegment + 1));
                    Modifier2.getPixelsMiddleSegment(tg, stringWidth, pt0, pt1);
                    Modifier2.AddModifier2(tg, label + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, 0.7 * csFactor, pt0, pt1, false);
                    break;
                }
                case 24240000: {
                    pt0 = tg.Pixels.get(0);
                    pt1 = tg.Pixels.get(1);
                    pt2 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt3 = tg.Pixels.get(tg.Pixels.size() - 2);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1);
                    dist2 = lineutility.CalcDistanceDouble(pt2, pt3);
                    stringWidth = (int)((double)metrics.stringWidth(label + " " + tg.get_Name()));
                    stringWidth2 = (int)((double)metrics.stringWidth(tg.get_DTG()));
                    if (stringWidth2 > stringWidth) {
                        stringWidth = stringWidth2;
                    }
                    if (tg.Pixels.size() == 2) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, 1.0 * (double)stringWidth);
                        Modifier2.AddModifier2(tg, label + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        if (!(dist > 3.5 * (double)stringWidth)) break;
                        pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                        pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, 1.0 * (double)stringWidth);
                        Modifier2.AddModifier2(tg, label + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        break;
                    }
                    double dist3 = lineutility.CalcDistanceDouble(pt0, pt2);
                    if (dist > (double)(stringWidth + 5) || dist >= dist2 || dist3 > (double)(stringWidth + 5)) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, 1.0 * (double)stringWidth);
                        Modifier2.AddModifier2(tg, label + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                    }
                    if (!(dist2 > (double)(stringWidth + 5)) && !(dist2 > dist) && !(dist3 > (double)(stringWidth + 5))) break;
                    pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                    pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, 1.0 * (double)stringWidth);
                    Modifier2.AddModifier2(tg, label + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                    Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                    break;
                }
                case 22122000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, pt0, pt1, false);
                    if (affiliation != null && affiliation.equals("H")) {
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 1, -1.0 * csFactor, pt0, pt1, false);
                    }
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, ptLast, ptNextToLast, false);
                    if (affiliation == null || !affiliation.equals("H")) break;
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 1, -1.0 * csFactor, ptLast, ptNextToLast, false);
                    break;
                }
                case 22123000: {
                    double shiftFactor = 1.0;
                    if (shiftLines) {
                        shiftFactor = 0.5;
                    }
                    if (affiliation == null || !affiliation.equals("H")) break;
                    TLineFactor = pt0.x < pt1.x ? -shiftFactor : shiftFactor;
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 1, TLineFactor, pt0, pt1, false);
                    TLineFactor = ptNextToLast.x < ptLast.x ? -shiftFactor : shiftFactor;
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 1, TLineFactor, ptLast, ptNextToLast, false);
                    break;
                }
                case 21700000: {
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, 1, 0, false);
                    break;
                }
                case 21710000: {
                    stringWidth = (int)(1.5 * (double)metrics.stringWidth(label));
                    pt2 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                    Modifier2.AddModifier2(tg, label, 2, 0.0, pt1, pt2, false);
                    break;
                }
                case 22330000: {
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, -0.7 * csFactor, 1, 0, false);
                    break;
                }
                case 22320000: {
                    midPt = lineutility.MidPointDouble(tg.Pixels.get(lastIndex - 1), tg.Pixels.get(nextToLastIndex - 1), 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 0.0, tg.Pixels.get(lastIndex - 1), midPt, false);
                    break;
                }
                case 22524000: {
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, 0.0, 1, 0, false);
                    break;
                }
                case 23490000: {
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, 0.0, 1, 0, true);
                    break;
                }
                case 212000000: 
                case 212400000: 
                case 212410000: {
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, 0, 1, true);
                    break;
                }
                case 26400000: 
                case 26410000: 
                case 26420000: 
                case 26430000: 
                case 26440000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, 0.0, tg.Pixels.get(0), tg.Pixels.get(1), true);
                    break;
                }
                case 24226000: 
                case 24315000: 
                case 211800000: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, ptCenter, ptCenter, true);
                    break;
                }
                case 23111000: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -0.5 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_T1(), 3, 0.5 * csFactor, ptCenter, ptCenter, false);
                    break;
                }
                case 23111001: {
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 23113000: 
                case 24330000: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    break;
                }
                case 23350000: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_EchelonSymbol(), 2, 0.0, 0, 1, true);
                    break;
                }
                case 23410000: {
                    Modifier2.AddIntegralAreaModifier(tg, "1", 3, 0.0, pt1, pt1, true);
                    Modifier2.AddIntegralAreaModifier(tg, "2", 3, 0.0, pt2, pt2, true);
                    Modifier2.AddIntegralAreaModifier(tg, "3", 3, 0.0, pt3, pt3, true);
                    break;
                }
                case 24311000: 
                case 24312000: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, pt0, pt0, false);
                    break;
                }
                case 21800000: {
                    Modifier2.AddIntegralModifier(tg, tg.get_DTG(), 2, -1.0 * csFactor, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, 0, 1, true);
                    break;
                }
            }
            Modifier2.scaleModifiers(tg);
            tg.Pixels = origPoints;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifiersGeo", new RendererException("Failed inside AddModifiersGeo", exc));
        }
    }

    private static int getRFALines(TGLight tg) {
        int lines = 1;
        try {
            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                ++lines;
            }
            if (tg.get_DTG() != null && !tg.get_DTG().isEmpty()) {
                ++lines;
            } else if (tg.get_DTG1() != null && !tg.get_DTG1().isEmpty()) {
                ++lines;
            }
            switch (tg.get_LineType()) {
                case 24352000: 
                case 24362000: {
                    if (tg.get_H1() == null || tg.get_H1().isEmpty()) break;
                    ++lines;
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifiers", new RendererException("Failed inside AddModifiers", exc));
        }
        return lines;
    }

    public static boolean addSectorModifiers(TGLight tg, IPointConversion converter) {
        try {
            int k;
            int k2;
            int linetype = tg.get_LineType();
            if (linetype != 243112000) {
                return false;
            }
            ArrayList<Double> AM = new ArrayList<Double>();
            ArrayList<Double> AN = new ArrayList<Double>();
            String H2 = tg.get_H2();
            String H1 = tg.get_H1();
            String T1 = tg.get_T1();
            String T = tg.get_Name();
            String[] altitudes = null;
            String[] am = T1.split(",");
            String[] az = T.split(",");
            double min = 0.0;
            double max = 0.0;
            double left = 0.0;
            double right = 0.0;
            int numSectors = az.length / 2;
            if (numSectors < 1) {
                return false;
            }
            if (!H1.isEmpty()) {
                altitudes = H1.split(",");
            }
            try {
                for (k2 = 0; k2 < am.length; ++k2) {
                    min = Double.parseDouble(am[k2]);
                    AM.add(min);
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            try {
                for (k2 = 0; k2 < az.length / 2; ++k2) {
                    left = Double.parseDouble(az[2 * k2]);
                    right = Double.parseDouble(az[2 * k2 + 1]);
                    AN.add(left);
                    AN.add(right);
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (numSectors + 1 > AM.size() && Double.parseDouble(am[0]) != 0.0) {
                AM.add(0, 0.0);
            }
            int n = tg.Pixels.size();
            POINT2 pt0 = tg.Pixels.get(n - 5);
            POINT2 pt1 = tg.Pixels.get(n - 4);
            Point2D pt02d = new Point2D.Double(pt0.x, pt0.y);
            Point2D pt12d = new Point2D.Double(pt1.x, pt1.y);
            pt02d = converter.PixelsToGeo(pt02d);
            pt12d = converter.PixelsToGeo(pt12d);
            pt0.x = pt02d.getX();
            pt0.y = pt02d.getY();
            pt1.x = pt12d.getX();
            pt1.y = pt12d.getY();
            double az12 = mdlGeodesic.GetAzimuth(pt0, pt1);
            POINT2 pt2 = null;
            ArrayList<POINT2> locModifier = new ArrayList<POINT2>();
            POINT2 ptLeft = null;
            POINT2 ptRight = null;
            ArrayList<POINT2> locAZModifier = new ArrayList<POINT2>();
            Point2D pt22d = null;
            double radius = 0.0;
            for (k = 0; k < numSectors && AM.size() >= k + 2; ++k) {
                radius = ((Double)AM.get(k) + (Double)AM.get(k + 1)) / 2.0;
                pt2 = mdlGeodesic.geodesic_coordinate(pt0, radius, az12);
                pt22d = new Point2D.Double(pt2.x, pt2.y);
                pt22d = converter.GeoToPixels(pt22d);
                pt2.x = pt22d.getX();
                pt2.y = pt22d.getY();
                locModifier.add(pt2);
                if (tg.get_HideOptionalLabels()) continue;
                ptLeft = mdlGeodesic.geodesic_coordinate(pt0, radius, (Double)AN.get(2 * k));
                pt22d = new Point2D.Double(ptLeft.x, ptLeft.y);
                pt22d = converter.GeoToPixels(pt22d);
                ptLeft.x = pt22d.getX();
                ptLeft.y = pt22d.getY();
                ptRight = mdlGeodesic.geodesic_coordinate(pt0, radius, (Double)AN.get(2 * k + 1));
                pt22d = new Point2D.Double(ptRight.x, ptRight.y);
                pt22d = converter.GeoToPixels(pt22d);
                ptRight.x = pt22d.getX();
                ptRight.y = pt22d.getY();
                locAZModifier.add(ptLeft);
                locAZModifier.add(ptRight);
            }
            if (altitudes != null) {
                for (k = 0; k < altitudes.length && k < locModifier.size(); ++k) {
                    pt0 = (POINT2)locModifier.get(k);
                    Modifier2.AddAreaModifier(tg, "ALT " + altitudes[k], 3, 0.0, pt0, pt0);
                }
            }
            if (tg.get_HideOptionalLabels()) {
                return true;
            }
            for (k = 0; k < numSectors; ++k) {
                pt0 = (POINT2)locModifier.get(k);
                Modifier2.AddAreaModifier(tg, "RG " + AM.get(k + 1), 3, -1.0, pt0, pt0);
                ptLeft = (POINT2)locAZModifier.get(2 * k);
                ptRight = (POINT2)locAZModifier.get(2 * k + 1);
                Modifier2.AddAreaModifier(tg, az[2 * k], 3, 0.0, ptLeft, ptLeft);
                Modifier2.AddAreaModifier(tg, az[2 * k + 1], 3, 0.0, ptRight, ptRight);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "addSectorModifiers", new RendererException("Failed inside addSectorModifiers", exc));
        }
        return true;
    }

    public static void AddModifiers2(TGLight tg) {
        try {
            if (tg.Pixels == null || tg.Pixels.isEmpty()) {
                return;
            }
            switch (tg.get_LineType()) {
                case 14000000: 
                case 15000002: 
                case 15000003: 
                case 21100000: 
                case 21200000: 
                case 21300000: 
                case 21400000: 
                case 21500000: 
                case 21600000: 
                case 22612000: 
                case 22612001: 
                case 22623000: 
                case 22623001: 
                case 24311000: 
                case 24312000: 
                case 24321200: 
                case 24321300: 
                case 24322200: 
                case 24322300: 
                case 24323200: 
                case 24323300: 
                case 24324200: 
                case 24324300: 
                case 24325200: 
                case 24325300: 
                case 24326100: 
                case 24326101: 
                case 24326200: 
                case 24331200: 
                case 24331300: 
                case 24332200: 
                case 24332300: 
                case 24333200: 
                case 24333300: 
                case 24334200: 
                case 24334300: 
                case 24335200: 
                case 24335300: 
                case 24336200: 
                case 24336300: 
                case 24337200: 
                case 24337300: 
                case 24338200: 
                case 24338300: 
                case 24339200: 
                case 24339300: 
                case 24352000: 
                case 24353000: 
                case 24362000: 
                case 24363000: 
                case 211000000: 
                case 211100000: 
                case 211200000: 
                case 211210000: 
                case 211400000: 
                case 211600000: 
                case 211700000: 
                case 211900000: 
                case 212100000: 
                case 212300000: 
                case 212300001: 
                case 212500000: 
                case 212600000: 
                case 243111000: 
                case 243112000: {
                    break;
                }
                default: {
                    return;
                }
            }
            ArrayList<POINT2> origPoints = lineutility.getDeepCopy(tg.Pixels);
            int n = tg.Pixels.size();
            if (tg.modifiers == null) {
                tg.modifiers = new ArrayList();
            }
            Font font = tg.get_Font();
            POINT2 ptCenter = null;
            double csFactor = 1.0;
            int linetype = tg.get_LineType();
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            int j = 0;
            boolean k = false;
            double dist = 0.0;
            String label = Modifier2.GetCenterLabel(tg);
            String[] H1 = null;
            int lastIndex = tg.Pixels.size() - 1;
            int nextToLastIndex = 0;
            if (tg.Pixels.size() > 1) {
                nextToLastIndex = tg.Pixels.size() - 2;
            }
            POINT2 ptLast = new POINT2(tg.Pixels.get(lastIndex));
            POINT2 ptNextToLast = null;
            if (tg.Pixels.size() > 1) {
                ptNextToLast = new POINT2(tg.Pixels.get(nextToLastIndex));
            }
            String dash = "";
            if (tg.get_DTG() != null && tg.get_DTG1() != null && !tg.get_DTG().isEmpty() && !tg.get_DTG1().isEmpty()) {
                dash = " - ";
            }
            POINT2 ptLeft = null;
            POINT2 ptRight = null;
            BufferedImage bi = new BufferedImage(8, 8, 2);
            Graphics2D g2d = bi.createGraphics();
            FontMetrics metrics = g2d.getFontMetrics();
            int stringWidth = 0;
            int rfaLines = 0;
            pt0 = new POINT2(tg.Pixels.get(0));
            if (tg.Pixels.size() > 1) {
                pt1 = new POINT2(tg.Pixels.get(1));
            }
            Object[] pts = null;
            if (tg.get_Client().equals("cpof3d")) {
                csFactor = 0.9;
            }
            Modifier2.shiftModifierPath(tg, pt0, pt1, ptLast, ptNextToLast);
            if (tg.getSymbologyStandard() == 1) {
                switch (linetype) {
                    case 14000000: 
                    case 15000003: {
                        pts = new POINT2[4];
                        for (j = 0; j < 4; ++j) {
                            pts[j] = tg.Pixels.get(j);
                        }
                        ptCenter = lineutility.CalcCenterPointDouble2(pts, 4);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -0.125 * csFactor, ptCenter, ptCenter, false);
                        break;
                    }
                    case 21200000: 
                    case 21300000: 
                    case 21400000: {
                        pt0 = tg.Pixels.get(1);
                        pt1 = tg.Pixels.get(2);
                        Modifier2.AddIntegralAreaModifier(tg, label, 2, -0.125 * csFactor, pt0, pt1, true);
                        break;
                    }
                    case 21500000: 
                    case 211700000: {
                        pt0 = tg.Pixels.get(2);
                        pt1 = tg.Pixels.get(3);
                        Modifier2.AddIntegralAreaModifier(tg, label, 2, -0.125 * csFactor, pt0, pt1, true);
                        break;
                    }
                    case 211000000: {
                        pt0 = tg.Pixels.get(4);
                        pt1 = tg.Pixels.get(5);
                        Modifier2.AddIntegralAreaModifier(tg, label, 2, -0.125 * csFactor, pt0, pt1, true);
                        break;
                    }
                    case 211100000: {
                        pt0 = tg.Pixels.get(0);
                        pt1 = tg.Pixels.get(1);
                        Modifier2.AddIntegralAreaModifier(tg, label, 2, -0.125 * csFactor, pt0, pt1, true);
                        break;
                    }
                    case 211400000: 
                    case 211600000: 
                    case 211900000: 
                    case 212100000: {
                        pt0 = tg.Pixels.get(13);
                        pt1 = tg.Pixels.get(14);
                        Modifier2.AddIntegralAreaModifier(tg, label, 2, -0.125 * csFactor, pt0, pt1, true);
                        break;
                    }
                    case 21600000: {
                        pt0 = tg.Pixels.get(13);
                        pt1 = tg.Pixels.get(14);
                        Modifier2.AddIntegralAreaModifier(tg, "C", 2, -0.125 * csFactor, pt0, pt1, true);
                        break;
                    }
                    case 212300000: 
                    case 212300001: {
                        pt0 = tg.Pixels.get(26);
                        pt1 = tg.Pixels.get(27);
                        Modifier2.AddIntegralAreaModifier(tg, label, 2, -0.125 * csFactor, pt0, pt1, true);
                        break;
                    }
                }
            }
            block14 : switch (linetype) {
                case 212500000: 
                case 212600000: {
                    pt0 = tg.Pixels.get(13);
                    pt1 = tg.Pixels.get(0);
                    stringWidth = metrics.stringWidth(label);
                    if (pt0.x < pt1.x) {
                        stringWidth = -stringWidth;
                    }
                    pt1 = lineutility.ExtendAlongLineDouble2(pt0, pt1, 0.75 * (double)stringWidth);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, 0.0, pt0, pt1, true);
                    break;
                }
                case 211200000: {
                    pt0 = tg.Pixels.get(0);
                    pt1 = lineutility.MidPointDouble(tg.Pixels.get(5), tg.Pixels.get(6), 0);
                    pt1 = lineutility.ExtendAlongLineDouble(pt1, pt0, -10.0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 0.0, pt0, pt1, true);
                    break;
                }
                case 211210000: {
                    pt0 = tg.Pixels.get(3);
                    pt1 = tg.Pixels.get(6);
                    pt1 = lineutility.ExtendAlongLineDouble(pt1, pt0, -10.0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 0.0, pt0, pt1, true);
                    break;
                }
                case 24322200: {
                    ptLeft = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
                    ptRight = lineutility.MidPointDouble(tg.Pixels.get(2), tg.Pixels.get(3), 0);
                    Modifier2.AddModifier2(tg, label, 2, -3.0 * csFactor, ptLeft, ptRight, false);
                    Modifier2.AddModifier2(tg, tg.get_Name(), 2, -2.0 * csFactor, ptLeft, ptRight, false);
                    Modifier2.AddModifier2(tg, "MIN ALT: " + tg.get_H(), 2, -1.0 * csFactor, ptLeft, ptRight, false, "H");
                    Modifier2.AddModifier2(tg, "MAX ALT: " + tg.get_H1(), 2, 0.0, ptLeft, ptRight, false, "H1");
                    Modifier2.AddModifier2(tg, "Grids: " + tg.get_H2(), 2, 1.0 * csFactor, ptLeft, ptRight, false, "H2");
                    Modifier2.AddModifier2(tg, "EFF: " + tg.get_DTG(), 2, 2.0 * csFactor, ptLeft, ptRight, false, "W");
                    Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 3.0 * csFactor, ptLeft, ptRight, false, "W1");
                    break;
                }
                case 24322300: {
                    ptCenter = lineutility.CalcCenterPointDouble2(tg.Pixels.toArray(), tg.Pixels.size());
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -3.0 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -2.0 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, "MIN ALT: " + tg.get_H(), 3, -1.0 * csFactor, ptCenter, ptCenter, false, "H");
                    Modifier2.AddIntegralAreaModifier(tg, "MAX ALT: " + tg.get_H1(), 3, 0.0, ptCenter, ptCenter, false, "H1");
                    Modifier2.AddIntegralAreaModifier(tg, "Grids: " + tg.get_H2(), 3, 1.0 * csFactor, ptCenter, ptCenter, false, "H2");
                    Modifier2.AddIntegralAreaModifier(tg, "EFF: " + tg.get_DTG(), 3, 2.0 * csFactor, ptCenter, ptCenter, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 3, 3.0 * csFactor, ptCenter, ptCenter, false, "W1");
                    break;
                }
                case 15000002: 
                case 24311000: 
                case 24312000: {
                    ptCenter = lineutility.CalcCenterPointDouble2(tg.Pixels.toArray(), tg.Pixels.size());
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    break;
                }
                case 24321300: 
                case 24331300: 
                case 24332300: 
                case 24333300: 
                case 24334300: 
                case 24335300: 
                case 24336300: 
                case 24337300: 
                case 24338300: 
                case 24339300: {
                    ptCenter = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(tg.Pixels.size() / 2), 0);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.0 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddOffsetModifier(tg, tg.get_DTG(), 1, -1.0 * csFactor, tg.Pixels.size() / 2, 0, 4.0, "left");
                    Modifier2.AddOffsetModifier(tg, tg.get_DTG1(), 1, 0.0, tg.Pixels.size() / 2, 0, 4.0, "left");
                    break;
                }
                case 24323300: 
                case 24324300: 
                case 24325300: {
                    rfaLines = Modifier2.getRFALines(tg);
                    ptCenter = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(51), 0);
                    switch (rfaLines) {
                        case 3: {
                            Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.0 * csFactor, ptCenter, ptCenter, true);
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, true);
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 3, 1.0 * csFactor, ptCenter, ptCenter, true, "W+W1");
                            break block14;
                        }
                        case 2: {
                            Modifier2.AddIntegralAreaModifier(tg, label, 3, -0.5 * csFactor, ptCenter, ptCenter, true);
                            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                                Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.5 * csFactor, ptCenter, ptCenter, true);
                                break block14;
                            }
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 3, 0.5 * csFactor, ptCenter, ptCenter, true, "W+W1");
                            break block14;
                        }
                    }
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, ptCenter, ptCenter, true);
                    break;
                }
                case 24353000: 
                case 24363000: {
                    rfaLines = Modifier2.getRFALines(tg);
                    ptCenter = lineutility.CalcCenterPointDouble2(tg.Pixels.toArray(), tg.Pixels.size());
                    switch (rfaLines) {
                        case 4: {
                            Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.0 * csFactor, ptCenter, ptCenter, true);
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, true);
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 3, 1.0 * csFactor, ptCenter, ptCenter, true, "W+W1");
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_H1(), 3, 2.0 * csFactor, ptCenter, ptCenter, true, "H1");
                            break block14;
                        }
                        case 3: {
                            Modifier2.AddIntegralAreaModifier(tg, label, 3, -1.0 * csFactor, ptCenter, ptCenter, true);
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, true);
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 3, 1.0 * csFactor, ptCenter, ptCenter, true, "W+W1");
                            break block14;
                        }
                        case 2: {
                            Modifier2.AddIntegralAreaModifier(tg, label, 3, -0.5 * csFactor, ptCenter, ptCenter, true);
                            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                                Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.5 * csFactor, ptCenter, ptCenter, true);
                                break block14;
                            }
                            Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 3, 0.5 * csFactor, ptCenter, ptCenter, true, "W+W1");
                            break block14;
                        }
                    }
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, ptCenter, ptCenter, true);
                    break;
                }
                case 21100000: {
                    for (j = 0; j < n; ++j) {
                        if (tg.Pixels.get((int)j).style != 14) continue;
                        Modifier2.AddIntegralModifier(tg, label, 2, 0.0, j, j + 1);
                        break block14;
                    }
                    break;
                }
                case 21600000: {
                    for (j = 0; j < n; ++j) {
                        if (tg.Pixels.get((int)j).style != 14) continue;
                        pt0 = tg.Pixels.get(j);
                        pt1 = tg.Pixels.get(j + 1);
                        Modifier2.AddIntegralAreaModifier(tg, label, 2, 0.0, pt0, pt1, true);
                        break block14;
                    }
                    break;
                }
                case 22612000: 
                case 22612001: 
                case 22623000: 
                case 22623001: {
                    if (ptLast.x < pt0.x) {
                        pt1 = new POINT2(ptLast);
                        ptLast = new POINT2(pt0);
                        pt0 = new POINT2(pt1);
                    }
                    stringWidth = metrics.stringWidth(label);
                    pt1 = new POINT2(pt0);
                    pt1.x -= (double)stringWidth / 1.5;
                    pt1.y -= (double)(font.getSize() / 2);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt1, pt1, false);
                    pt1 = new POINT2(ptLast);
                    pt1.x += (double)stringWidth / 1.5;
                    pt1.y -= (double)(font.getSize() / 2);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt1, pt1, false);
                    break;
                }
                case 24323200: 
                case 24324200: 
                case 24325200: {
                    rfaLines = Modifier2.getRFALines(tg);
                    pt0 = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
                    pt1 = lineutility.MidPointDouble(tg.Pixels.get(2), tg.Pixels.get(3), 0);
                    switch (rfaLines) {
                        case 3: {
                            Modifier2.AddModifier2(tg, label, 2, -1.0 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_Name(), 2, 0.0, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, 1.0 * csFactor, pt0, pt1, false, "W+W1");
                            break block14;
                        }
                        case 2: {
                            Modifier2.AddModifier2(tg, label, 2, -0.5 * csFactor, pt0, pt1, false);
                            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                                Modifier2.AddModifier2(tg, tg.get_Name(), 2, 0.5 * csFactor, pt0, pt1, false);
                                break block14;
                            }
                            Modifier2.AddModifier2(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, 0.5 * csFactor, pt0, pt1, false, "W+W1");
                            break block14;
                        }
                    }
                    Modifier2.AddModifier2(tg, label, 2, 0.0, pt0, pt1, false);
                    break;
                }
                case 24352000: 
                case 24362000: {
                    rfaLines = Modifier2.getRFALines(tg);
                    pt0 = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
                    pt1 = lineutility.MidPointDouble(tg.Pixels.get(2), tg.Pixels.get(3), 0);
                    switch (rfaLines) {
                        case 4: {
                            Modifier2.AddModifier2(tg, label, 2, -1.0 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_Name(), 2, 0.0, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, 1.0 * csFactor, pt0, pt1, false, "W+W1");
                            Modifier2.AddModifier2(tg, tg.get_H1(), 2, 2.0 * csFactor, pt0, pt1, false, "H1");
                            break block14;
                        }
                        case 3: {
                            Modifier2.AddModifier2(tg, label, 2, -1.0 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_Name(), 2, 0.0, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, 1.0 * csFactor, pt0, pt1, false, "W+W1");
                            break block14;
                        }
                        case 2: {
                            Modifier2.AddModifier2(tg, label, 2, -0.5 * csFactor, pt0, pt1, false);
                            if (tg.get_Name() != null && !tg.get_Name().isEmpty()) {
                                Modifier2.AddModifier2(tg, tg.get_Name(), 2, 0.5 * csFactor, pt0, pt1, false);
                                break block14;
                            }
                            Modifier2.AddModifier2(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, 0.5 * csFactor, pt0, pt1, false, "W+W1");
                            break block14;
                        }
                    }
                    Modifier2.AddModifier2(tg, label, 2, 0.0, pt0, pt1, false);
                    break;
                }
                case 24321200: 
                case 24331200: 
                case 24332200: 
                case 24333200: 
                case 24334200: 
                case 24335200: 
                case 24336200: 
                case 24337200: 
                case 24338200: 
                case 24339200: {
                    ptLeft = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
                    ptRight = lineutility.MidPointDouble(tg.Pixels.get(2), tg.Pixels.get(3), 0);
                    Modifier2.AddModifier2(tg, label, 2, 0.0, ptLeft, ptRight, false);
                    Modifier2.AddModifier2(tg, tg.get_Name(), 2, 1.0 * csFactor, ptLeft, ptRight, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 1.0 * csFactor, ptCenter, ptCenter, false);
                    pt0 = tg.Pixels.get(0);
                    pt1 = tg.Pixels.get(1);
                    pt2 = tg.Pixels.get(2);
                    pt3 = tg.Pixels.get(3);
                    if (tg.get_Client().equalsIgnoreCase("ge")) {
                        pt0.x -= (double)(font.getSize() / 2);
                        pt2.x -= (double)(font.getSize() / 2);
                    }
                    if (!tg.get_Client().equalsIgnoreCase("ge")) {
                        clsUtility.shiftModifiersLeft(pt0, pt3, 12.5);
                        clsUtility.shiftModifiersLeft(pt1, pt2, 12.5);
                    }
                    if (ptLeft.x == ptRight.x) {
                        ptRight.x += 1.0;
                    }
                    if (ptLeft.x < ptRight.x) {
                        Modifier2.AddModifier(tg, tg.get_DTG(), 1, 0.0, pt0, pt3);
                        Modifier2.AddModifier(tg, tg.get_DTG1(), 1, 1.0 * csFactor, pt0, pt3);
                        break;
                    }
                    Modifier2.AddModifier(tg, tg.get_DTG(), 1, 0.0, pt2, pt1);
                    Modifier2.AddModifier(tg, tg.get_DTG1(), 1, 1.0, pt2, pt1);
                    break;
                }
                case 24326100: 
                case 24326101: {
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, 0, 1, true);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, 1, 2, true);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, 2, 3, true);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, 3, 0, true);
                    break;
                }
                case 24326200: {
                    pt0 = tg.Pixels.get(0);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt0, pt0, true);
                    pt0 = tg.Pixels.get(25);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt0, pt0, true);
                    pt0 = tg.Pixels.get(50);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt0, pt0, true);
                    pt0 = tg.Pixels.get(75);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, pt0, pt0, true);
                    break;
                }
                case 243111000: {
                    if (tg.get_H1() != null && !tg.get_H1().equals("")) {
                        H1 = tg.get_H1().split(",");
                        for (j = 0; j < H1.length; ++j) {
                            if (tg.Pixels.size() <= j * 102 + 25) continue;
                            pt0 = tg.Pixels.get(j * 102 + 25);
                            Modifier2.AddAreaModifier(tg, "ALT " + H1[j], 3, 0.0, pt0, pt0);
                        }
                    }
                    if (tg.get_HideOptionalLabels()) break;
                    String H2 = tg.get_H2();
                    String[] am = H2.split(",");
                    for (j = 0; j < am.length; ++j) {
                        if (tg.Pixels.size() <= j * 102 + 25) continue;
                        pt0 = tg.Pixels.get(j * 102 + 25);
                        if (j == 0) {
                            Modifier2.AddAreaModifier(tg, "MIN RG " + am[j], 3, -1.0, pt0, pt0);
                            continue;
                        }
                        Modifier2.AddAreaModifier(tg, "MAX RG (" + Integer.toString(j) + ") " + am[j], 3, -1.0, pt0, pt0);
                    }
                    break;
                }
                case 243112000: {
                    break;
                }
            }
            Modifier2.scaleModifiers(tg);
            tg.Pixels = origPoints;
            g2d.dispose();
            g2d = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifiers2", new RendererException("Failed inside AddModifiers2", exc));
        }
    }

    public static void DisplayModifiers(TGLight tg, Graphics2D g2d) {
        try {
            Font font = g2d.getFont();
            int j = 0;
            Modifier2 modifier = null;
            g2d.setBackground(Color.white);
            POINT2 pt = null;
            double theta = 0.0;
            int stringWidth = 0;
            int stringHeight = 0;
            FontMetrics metrics = g2d.getFontMetrics();
            String s = "";
            int x = 0;
            int y = 0;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            int quadrant = -1;
            int n = tg.Pixels.size();
            block14: for (j = 0; j < n; ++j) {
                modifier = tg.modifiers.get(j);
                double lineFactor = modifier.lineFactor;
                s = modifier.text;
                double x1 = 0.0;
                double y1 = 0.0;
                double x2 = 0.0;
                double y2 = 0.0;
                pt = modifier.textPath[0];
                x1 = pt.x;
                y1 = pt.y;
                pt = modifier.textPath[1];
                x2 = pt.x;
                y2 = pt.y;
                theta = Math.atan2(y2 - y1, x2 - x1);
                if (x1 > x2) {
                    theta -= Math.PI;
                }
                switch (modifier.type) {
                    case 1: {
                        g2d.rotate(theta, x1, y1);
                        stringWidth = metrics.stringWidth(s);
                        stringHeight = font.getSize();
                        if (x1 < x2 || x1 == x2 && y1 > y2) {
                            x = (int)x1 - stringWidth;
                            y = (int)y1 - stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                            g2d.setColor(tg.get_FontBackColor());
                            g2d.clearRect(x, y, stringWidth, stringHeight);
                            y = (int)y1 + stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                            g2d.setColor(tg.get_TextColor());
                            g2d.drawString(s, x, y);
                            continue block14;
                        }
                        x = (int)x1;
                        y = (int)y1 - stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_FontBackColor());
                        g2d.clearRect(x, y, stringWidth, stringHeight);
                        y = (int)y1 + stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_TextColor());
                        g2d.drawString(s, x, y);
                        continue block14;
                    }
                    case 2: {
                        POINT2 midPt = new POINT2((x1 + x2) / 2.0, (y1 + y2) / 2.0);
                        g2d.rotate(theta, midPt.x, midPt.y);
                        stringWidth = metrics.stringWidth(s);
                        stringHeight = font.getSize();
                        x = (int)midPt.x - stringWidth / 2;
                        y = (int)midPt.y - stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_FontBackColor());
                        g2d.clearRect(x, y, stringWidth, stringHeight);
                        y = (int)midPt.y + stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_TextColor());
                        g2d.drawString(s, x, y);
                        continue block14;
                    }
                    case 3: {
                        g2d.rotate(0.0, x1, y1);
                        stringWidth = metrics.stringWidth(s);
                        stringHeight = font.getSize();
                        x = (int)x1 - stringWidth / 2;
                        y = (int)y1 - stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_FontBackColor());
                        g2d.clearRect(x, y, stringWidth, stringHeight);
                        y = (int)y1 + stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_TextColor());
                        g2d.drawString(s, x, y);
                        continue block14;
                    }
                    case 4: {
                        if (tg.Pixels.size() >= 14) {
                            pt1 = tg.Pixels.get(3);
                            pt2 = tg.Pixels.get(10);
                            quadrant = lineutility.GetQuadrantDouble(pt1, pt2);
                            theta = Math.atan2(pt2.y - pt1.y, pt2.x - pt1.x);
                            switch (quadrant) {
                                case 1: {
                                    theta += 1.5707963267948966;
                                    break;
                                }
                                case 2: {
                                    theta -= 1.5707963267948966;
                                    break;
                                }
                                case 3: {
                                    theta -= 1.5707963267948966;
                                    break;
                                }
                                case 4: {
                                    theta += 1.5707963267948966;
                                    break;
                                }
                            }
                            g2d.rotate(theta, x1, y1);
                            stringWidth = metrics.stringWidth(s);
                            stringHeight = font.getSize();
                            x = (int)x1 - stringWidth / 2;
                            y = (int)y1 - stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                            g2d.setColor(tg.get_FontBackColor());
                            g2d.clearRect(x, y, stringWidth, stringHeight);
                            y = (int)y1 + stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                            g2d.setColor(tg.get_TextColor());
                            g2d.drawString(s, x, y);
                            continue block14;
                        }
                        stringWidth = metrics.stringWidth(s);
                        stringHeight = font.getSize();
                        x = (int)tg.Pixels.get((int)0).x;
                        y = (int)tg.Pixels.get((int)0).y;
                        g2d.setColor(tg.get_FontBackColor());
                        g2d.clearRect(x, y, stringWidth, stringHeight);
                        y = y + stringHeight / 2 + (int)(lineFactor * (double)stringHeight);
                        g2d.setColor(tg.get_TextColor());
                        g2d.drawString(s, x, y);
                        continue block14;
                    }
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DisplayModifiers", new RendererException("Failed inside DisplayModifiers", exc));
        }
    }

    public static Shape2 BuildModifierShape(TGLight tg, POINT2 pt0, POINT2 pt1, int stringWidth, int stringHeight, double lineFactor, boolean isTextFlipped) {
        Shape2 modifierFill = null;
        try {
            POINT2 ptTemp0 = new POINT2(pt0);
            POINT2 ptTemp1 = new POINT2(pt1);
            if (isTextFlipped) {
                lineFactor += 1.0;
            }
            if (lineFactor < 0.0) {
                ptTemp0 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 2, -lineFactor * (double)stringHeight);
                ptTemp1 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 2, -lineFactor * (double)stringHeight);
            }
            if (lineFactor > 0.0) {
                ptTemp0 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 3, lineFactor * (double)stringHeight);
                ptTemp1 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 3, lineFactor * (double)stringHeight);
            }
            if (ptTemp0.y == ptTemp1.y) {
                ptTemp0.y += 1.0;
            }
            POINT2 pt3 = null;
            POINT2 pt4 = null;
            POINT2 pt5 = null;
            POINT2 pt6 = null;
            POINT2 pt7 = null;
            pt3 = lineutility.ExtendAlongLineDouble(ptTemp0, ptTemp1, -stringWidth);
            pt4 = lineutility.ExtendDirectedLine(ptTemp1, ptTemp0, pt3, 0, stringHeight / 2);
            pt5 = lineutility.ExtendDirectedLine(ptTemp1, ptTemp0, pt3, 1, stringHeight / 2);
            pt6 = lineutility.ExtendDirectedLine(ptTemp1, ptTemp0, ptTemp0, 1, stringHeight / 2);
            pt7 = lineutility.ExtendDirectedLine(ptTemp1, ptTemp0, ptTemp0, 0, stringHeight / 2);
            modifierFill = new Shape2(3);
            modifierFill.moveTo(pt4);
            modifierFill.lineTo(pt5);
            modifierFill.lineTo(pt6);
            modifierFill.lineTo(pt7);
            modifierFill.lineTo(pt4);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "BuildModifierShape", new RendererException("Failed inside BuildModifierShape", exc));
        }
        return modifierFill;
    }

    public static void GetIntegralTextShapes(TGLight tg, Graphics2D g2d, ArrayList<Shape2> shapes) {
        try {
            if (tg.Pixels == null || shapes == null) {
                return;
            }
            HashMap<Integer, Color> hmap = clsUtility.getMSRSegmentColors(tg);
            Color color = null;
            Shape2 shape = null;
            Shape2 segShape = null;
            g2d.setFont(tg.get_Font());
            int j = 0;
            String affiliation = null;
            FontMetrics metrics = g2d.getFontMetrics();
            String echelonSymbol = null;
            int stringWidthEchelonSymbol = 0;
            int stringWidthENY = 0;
            POINT2 ptEchelonStart = null;
            POINT2 ptEchelonEnd = null;
            POINT2 ptENY0Start = null;
            POINT2 ptENY0End = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            double dist = 0.0;
            BasicStroke stroke = null;
            switch (tg.get_LineType()) {
                case 22121000: {
                    echelonSymbol = tg.get_EchelonSymbol();
                    shape = new Shape2(0);
                    shape.setLineColor(tg.get_LineColor());
                    shape.set_Style(tg.get_LineStyle());
                    affiliation = tg.get_Affiliation();
                    stroke = clsUtility.getLineStroke(tg.get_LineThickness(), shape.get_Style(), 1, 1);
                    shape.setStroke(stroke);
                    if (tg.get_Affiliation() != null && tg.get_Affiliation().equals("H")) {
                        stringWidthENY = metrics.stringWidth(tg.get_N());
                    }
                    if (echelonSymbol != null && !echelonSymbol.isEmpty()) {
                        stringWidthEchelonSymbol = metrics.stringWidth(echelonSymbol);
                    }
                    if (hmap == null || hmap.isEmpty()) {
                        shape.moveTo(tg.Pixels.get(0));
                        for (j = 1; j < tg.Pixels.size(); ++j) {
                            shape.lineTo(tg.Pixels.get(j));
                        }
                        shapes.add(shape);
                        break;
                    }
                    int n = tg.Pixels.size();
                    for (j = 0; j < n - 1; ++j) {
                        segShape = null;
                        if (hmap != null && hmap.containsKey(j)) {
                            color = hmap.get(j);
                            segShape = new Shape2(0);
                            segShape.setLineColor(color);
                            segShape.set_Style(tg.get_LineStyle());
                            segShape.setStroke(stroke);
                        }
                        pt0 = tg.Pixels.get(j);
                        pt1 = tg.Pixels.get(j + 1);
                        if (segShape != null) {
                            segShape.moveTo(pt0);
                        } else {
                            shape.moveTo(pt0);
                        }
                        if (tg.get_Client().equals("ge") || Modifier2.GetBoundarySegmentTooShort(tg, g2d, j)) {
                            if (segShape != null) {
                                segShape.lineTo(pt1);
                                shapes.add(segShape);
                                continue;
                            }
                            shape.lineTo(pt1);
                            continue;
                        }
                        POINT2 midpt = lineutility.MidPointDouble(pt0, pt1, 0);
                        if (stringWidthENY > 0) {
                            midpt = lineutility.MidPointDouble(pt0, midpt, 0);
                            midpt = lineutility.MidPointDouble(pt0, midpt, 0);
                            dist = lineutility.CalcDistanceDouble(pt0, midpt) - (double)stringWidthENY / 1.5;
                            ptENY0Start = lineutility.ExtendAlongLineDouble(pt0, pt1, dist);
                            dist = lineutility.CalcDistanceDouble(pt0, midpt) + (double)stringWidthENY / 1.5;
                            ptENY0End = lineutility.ExtendAlongLineDouble(pt0, pt1, dist);
                            if (segShape != null) {
                                segShape.moveTo(pt0);
                                segShape.lineTo(ptENY0Start);
                                segShape.moveTo(ptENY0End);
                            } else {
                                shape.moveTo(pt0);
                                shape.lineTo(ptENY0Start);
                                shape.moveTo(ptENY0End);
                            }
                        } else if (segShape != null) {
                            segShape.moveTo(pt0);
                        } else {
                            shape.moveTo(pt0);
                        }
                        if (stringWidthEchelonSymbol > 0) {
                            midpt = lineutility.MidPointDouble(pt0, pt1, 0);
                            dist = lineutility.CalcDistanceDouble(pt0, midpt) - (double)stringWidthEchelonSymbol / 1.5;
                            ptEchelonStart = lineutility.ExtendAlongLineDouble(pt0, pt1, dist);
                            dist = lineutility.CalcDistanceDouble(pt0, midpt) + (double)stringWidthEchelonSymbol / 1.5;
                            ptEchelonEnd = lineutility.ExtendAlongLineDouble(pt0, pt1, dist);
                            if (segShape != null) {
                                segShape.lineTo(ptEchelonStart);
                                segShape.moveTo(ptEchelonEnd);
                            } else {
                                shape.lineTo(ptEchelonStart);
                                shape.moveTo(ptEchelonEnd);
                            }
                        }
                        if (stringWidthENY > 0) {
                            midpt = lineutility.MidPointDouble(pt0, pt1, 0);
                            midpt = lineutility.MidPointDouble(pt1, midpt, 0);
                            midpt = lineutility.MidPointDouble(pt1, midpt, 0);
                            dist = lineutility.CalcDistanceDouble(pt1, midpt) - (double)stringWidthENY / 1.5;
                            POINT2 ptENY1Start = lineutility.ExtendAlongLineDouble(pt1, pt0, dist);
                            dist = lineutility.CalcDistanceDouble(pt1, midpt) + (double)stringWidthENY / 1.5;
                            POINT2 ptENY1End = lineutility.ExtendAlongLineDouble(pt1, pt0, dist);
                            if (segShape != null) {
                                segShape.lineTo(ptENY1End);
                                segShape.moveTo(ptENY1Start);
                                segShape.lineTo(pt1);
                            } else {
                                shape.lineTo(ptENY1End);
                                shape.moveTo(ptENY1Start);
                                shape.lineTo(pt1);
                            }
                        } else if (segShape != null) {
                            segShape.lineTo(pt1);
                        } else {
                            shape.lineTo(pt1);
                        }
                        if (segShape == null) continue;
                        shapes.add(segShape);
                    }
                    shapes.add(shape);
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetIntegralTextShapes", new RendererException("Failed inside GetIntegralTextShapes", exc));
        }
    }

    private static int switchDirection(int direction) {
        int result = -1;
        switch (direction) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return result;
    }

    public static void DisplayModifiers2(TGLight tg, Graphics2D g2d, ArrayList<Shape2> shapes, boolean isTextFlipped, IPointConversion converter) {
        try {
            if (shapes == null) {
                return;
            }
            if (tg.modifiers == null || tg.modifiers.isEmpty()) {
                return;
            }
            Font font = null;
            int j = 0;
            Modifier2 modifier = null;
            Color fontBackColor = tg.get_FontBackColor();
            Color textColor = tg.get_TextColor();
            double theta = 0.0;
            double stringWidth = 0.0;
            double stringHeight = 0.0;
            String s = "";
            int x = 0;
            int y = 0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            int quadrant = -1;
            Shape2 shape2 = null;
            long lineType = tg.get_LineType();
            font = tg.get_Font();
            if (font == null) {
                font = g2d.getFont();
            }
            if (font.getSize() == 0) {
                return;
            }
            g2d.setFont(font);
            FontMetrics metrics = g2d.getFontMetrics();
            if (fontBackColor != null) {
                g2d.setBackground(fontBackColor);
            } else {
                g2d.setBackground(Color.white);
            }
            if (textColor == null) {
                textColor = tg.get_LineColor();
            }
            int direction = -1;
            Point glyphPosition = null;
            for (j = 0; j < tg.modifiers.size(); ++j) {
                modifier = tg.modifiers.get(j);
                double lineFactor = modifier.lineFactor;
                if (isTextFlipped) {
                    lineFactor = -lineFactor;
                }
                if ((s = modifier.text) == null || s.equals("")) continue;
                stringWidth = (double)metrics.stringWidth(s) + 1.0;
                stringHeight = font.getSize();
                double x1 = 0.0;
                double y1 = 0.0;
                double x2 = 0.0;
                double y2 = 0.0;
                double dist = 0.0;
                pt0 = modifier.textPath[0];
                x1 = Math.round(pt0.x);
                y1 = Math.round(pt0.y);
                pt1 = modifier.textPath[1];
                x2 = Math.round(pt1.x);
                y2 = Math.round(pt1.y);
                theta = Math.atan2(y2 - y1, x2 - x1);
                if (x1 > x2) {
                    theta -= Math.PI;
                }
                pt0 = new POINT2(x1, y1);
                pt1 = new POINT2(x2, y2);
                POINT2 midPt = new POINT2((x1 + x2) / 2.0, (y1 + y2) / 2.0);
                Point2D.Double modifierPosition = null;
                int justify = 0;
                switch (modifier.type) {
                    case 5: {
                        if (x1 == x2) {
                            x2 += 1.0;
                        }
                        if (x1 < x2) {
                            x = (int)x1;
                            y = (int)y1 + (int)stringHeight / 2 + (int)(lineFactor * stringHeight);
                        } else {
                            x = (int)x1 - (int)stringWidth;
                            y = (int)y1 + (int)stringHeight / 2 + (int)(lineFactor * stringHeight);
                        }
                        direction = lineFactor >= 0.0 ? 2 : 3;
                        if (lineType == 22123000L || tg.get_Client().equalsIgnoreCase("ge")) {
                            direction = Modifier2.switchDirection(direction);
                        }
                        justify = x1 < x2 ? 2 : 0;
                        pt3 = lineutility.ExtendDirectedLine(pt1, pt0, pt0, direction, lineFactor * stringHeight);
                        glyphPosition = new Point((int)pt3.x, (int)pt3.y);
                        modifierPosition = new Point2D.Double(pt3.x, pt3.y);
                        break;
                    }
                    case 1: {
                        if (x1 == x2) {
                            x2 += 1.0;
                        }
                        direction = lineFactor >= 0.0 ? 2 : 3;
                        if (lineType == 22123000L || tg.get_Client().equalsIgnoreCase("ge")) {
                            direction = Modifier2.switchDirection(direction);
                        }
                        dist = lineutility.CalcDistanceDouble(pt0, pt1) + stringWidth / 2.0;
                        pt0 = lineutility.ExtendAlongLineDouble(pt1, pt0, dist);
                        pt2 = lineutility.ExtendDirectedLine(pt1, pt0, pt1, direction, lineFactor * stringHeight);
                        pt3 = lineutility.ExtendDirectedLine(pt1, pt0, pt0, direction, lineFactor * stringHeight);
                        glyphPosition = new Point((int)pt3.x, (int)pt3.y);
                        justify = x1 < x2 ? 2 : 0;
                        modifierPosition = new Point2D.Double(pt3.x, pt3.y);
                        break;
                    }
                    case 2: {
                        pt2 = midPt;
                        if (tg.get_Client().equals("2D")) {
                            lineFactor += 0.5;
                        }
                        if (lineFactor >= 0.0) {
                            pt3 = lineutility.ExtendDirectedLine(pt0, pt2, pt2, 3, Math.abs(lineFactor * stringHeight));
                            midPt = lineutility.ExtendDirectedLine(pt0, midPt, midPt, 3, Math.abs(lineFactor * stringHeight));
                        } else {
                            pt3 = lineutility.ExtendDirectedLine(pt0, pt2, pt2, 2, Math.abs(lineFactor * stringHeight));
                            midPt = lineutility.ExtendDirectedLine(pt0, midPt, midPt, 2, Math.abs(lineFactor * stringHeight));
                        }
                        if (x1 == x2 && y1 > y2) {
                            pt3 = lineutility.ExtendDirectedLine(pt0, pt2, pt2, 1, Math.abs(lineFactor * stringHeight));
                            midPt = lineutility.ExtendDirectedLine(pt0, midPt, midPt, 1, Math.abs(lineFactor * stringHeight));
                        }
                        if (x1 == x2 && y1 < y2) {
                            pt3 = lineutility.ExtendDirectedLine(pt0, pt2, pt2, 0, Math.abs(lineFactor * stringHeight));
                            midPt = lineutility.ExtendDirectedLine(pt0, midPt, midPt, 0, Math.abs(lineFactor * stringHeight));
                        }
                        glyphPosition = new Point((int)pt3.x, (int)pt3.y);
                        justify = 1;
                        modifierPosition = new Point2D.Double(midPt.x, midPt.y);
                        break;
                    }
                    case 3: {
                        theta = 0.0;
                        y = (int)y1 + (int)(stringHeight / 2.0) + (int)(lineFactor * stringHeight);
                        x = (int)x1;
                        glyphPosition = new Point(x, y);
                        justify = 1;
                        modifierPosition = new Point2D.Double(x1, y);
                        break;
                    }
                    case 4: {
                        if (tg.Pixels.size() >= 14) {
                            pt1 = tg.Pixels.get(3);
                            pt2 = tg.Pixels.get(10);
                            quadrant = lineutility.GetQuadrantDouble(pt1, pt2);
                            theta = Math.atan2(pt2.y - pt1.y, pt2.x - pt1.x);
                            if (Math.abs(theta) < 0.39269908169872414) {
                                theta = theta < 0.0 ? (theta -= 1.5707963267948966) : (theta += 1.5707963267948966);
                            }
                            switch (quadrant) {
                                case 1: {
                                    theta += 1.5707963267948966;
                                    break;
                                }
                                case 2: {
                                    theta -= 1.5707963267948966;
                                    break;
                                }
                                case 3: {
                                    theta -= 1.5707963267948966;
                                    break;
                                }
                                case 4: {
                                    theta += 1.5707963267948966;
                                    break;
                                }
                            }
                            x = (int)x1 - (int)stringWidth / 2;
                            y = (int)y1 - (int)stringHeight / 2 + (int)(lineFactor * stringHeight);
                            y = (int)y1 + (int)(stringHeight / 2.0) + (int)(lineFactor * stringHeight);
                        } else {
                            theta = 0.0;
                            x = (int)tg.Pixels.get((int)0).x;
                            y = (int)tg.Pixels.get((int)0).y;
                            x -= (int)stringWidth / 2;
                            y = y - (int)stringHeight / 2 + (int)(lineFactor * stringHeight);
                            y = y + (int)(stringHeight / 2.0) + (int)(lineFactor * stringHeight);
                        }
                        glyphPosition = new Point(x, y);
                        break;
                    }
                }
                shape2 = new Shape2(3);
                shape2.setStroke(new BasicStroke(0.0f, 1, 1, 3.0f));
                if (tg.get_TextColor() != null) {
                    shape2.setFillColor(tg.get_TextColor());
                } else if (tg.get_LineColor() != null) {
                    shape2.setFillColor(tg.get_LineColor());
                }
                if (tg.get_LineColor() != null) {
                    shape2.setLineColor(tg.get_LineColor());
                }
                TextLayout tl = new TextLayout(s, font, g2d.getFontMetrics().getFontRenderContext());
                shape2.setTextLayout(tl);
                if (converter != null) {
                    shape2.setGlyphPosition(glyphPosition);
                } else {
                    shape2.setGlyphPosition(new Point2D.Double(0.0, 0.0));
                }
                shape2.setModifierString(s);
                shape2.setModifierStringAngle(theta * 180.0 / Math.PI);
                shape2.setModifierStringPosition(modifierPosition);
                shape2.setTextJustify(justify);
                if (shape2 == null) continue;
                shapes.add(shape2);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DisplayModifiers2", new RendererException("Failed inside DisplayModifiers2", exc));
        }
    }

    public static Shape getTextShape(Graphics2D g2d, String str, Font font, AffineTransform tx) {
        TextLayout tl = null;
        FontRenderContext frc = null;
        try {
            frc = g2d.getFontRenderContext();
            tl = new TextLayout(str, font, frc);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getTextShape", new RendererException("Failed inside getTextShape", exc));
        }
        return tl.getOutline(tx);
    }

    public static Shape2 createTextOutline(Shape2 originalText) {
        Shape2 siOutline = null;
        try {
            Shape outline = originalText.getShape();
            siOutline = new Shape2(3);
            siOutline.setShape(outline);
            if (originalText.getFillColor().getRed() == 255 && originalText.getFillColor().getGreen() == 255 && originalText.getFillColor().getBlue() == 255) {
                siOutline.setLineColor(Color.BLACK);
            } else {
                siOutline.setLineColor(Color.WHITE);
            }
            int width = RendererSettings.getInstance().getTextOutlineWidth();
            siOutline.setStroke(new BasicStroke(width, 1, 1, 3.0f));
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "createTextOutline", new RendererException("Failed inside createTextOutline", exc));
        }
        return siOutline;
    }

    private static ArrayList<POINT2> getShapePoints(Shape shape) {
        try {
            int type;
            ArrayList<Point2D.Double> ptsPoly = new ArrayList<Point2D.Double>();
            Point2D.Double ptPoly = null;
            float[] coords = new float[6];
            int zeros = 0;
            PathIterator i = shape.getPathIterator(null);
            while (!(i.isDone() || (type = i.currentSegment(coords)) == 0 && zeros == 2)) {
                switch (type) {
                    case 0: {
                        ptPoly = new Point2D.Double(coords[0], coords[1]);
                        ptsPoly.add(ptPoly);
                        ++zeros;
                        break;
                    }
                    case 1: {
                        ptPoly = new Point2D.Double(coords[0], coords[1]);
                        ptsPoly.add(ptPoly);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                i.next();
            }
            if (ptsPoly.size() > 0) {
                ArrayList<POINT2> pts = null;
                pts = new ArrayList<POINT2>();
                for (int j = 0; j < ptsPoly.size(); ++j) {
                    Point2D pt2d = (Point2D)ptsPoly.get(j);
                    POINT2 pt = new POINT2(pt2d.getX(), pt2d.getY());
                    pts.add(pt);
                }
                return pts;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getshapePoints", new RendererException("Failed inside getShapePoints", exc));
        }
        return null;
    }

    private static String getRevDLabel(int code) {
        switch (code) {
            case 200401: 
            case 200402: {
                return "AOI";
            }
            case 200300: {
                return "N";
            }
            case 200101: {
                return "LA";
            }
            case 200201: 
            case 200202: {
                return "DA";
            }
            case 170800: {
                return "BDZ";
            }
            case 150501: {
                return "JTAA";
            }
            case 150502: {
                return "SAA";
            }
            case 150503: {
                return "SGSA";
            }
            case 140700: {
                return "FCL";
            }
            case 151500: {
                return "ASLT";
            }
            case 170400: {
                return "SL";
            }
            case 170600: {
                return "TC";
            }
            case 171100: {
                return "AARROZ";
            }
            case 171200: {
                return "UAROZ";
            }
            case 171300: {
                return "WEZ";
            }
            case 171400: {
                return "FEZ";
            }
            case 171500: {
                return "JEZ";
            }
            case 171900: {
                return "SHORADEZ";
            }
            case 190100: {
                return "IFF OFF";
            }
            case 190200: {
                return "IFF ON";
            }
            case 220102: {
                return "EW";
            }
            case 220107: {
                return "J";
            }
            case 220108: {
                return "RDF";
            }
            case 260300: {
                return "NFL";
            }
            case 260400: {
                return "BCL";
            }
            case 300100: {
                return "ICL";
            }
            case 140400: 
            case 140401: {
                return "FEBA";
            }
            case 140900: {
                return "LOA";
            }
        }
        return "";
    }

    public static void AddModifiers2RevD(TGLight tg, ArrayList<Shape2> shapes) {
        if (tg.get_SymbolId().length() < 20) {
            Modifier2.AddModifiers2(tg);
            return;
        }
        try {
            String symbolId = tg.get_SymbolId();
            String setA = symbolId.substring(0, 10);
            String setB = symbolId.substring(10);
            String code = setB.substring(0, 6);
            int nCode = Integer.parseInt(code);
            String symbolSet = setA.substring(4, 6);
            int nSymbol = Integer.parseInt(symbolSet);
            String country = "US";
            String v = "MORTAR";
            String ap = "QC 1968";
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            double csFactor = 1.0;
            int n = tg.Pixels.size();
            POINT2 ptLeft = null;
            POINT2 ptRight = null;
            Object ptCenter = null;
            String label = Modifier2.getRevDLabel(nCode);
            String dash = " - ";
            switch (nCode) {
                case 200202: {
                    ptLeft = lineutility.MidPointDouble(tg.Pixels.get(0), tg.Pixels.get(1), 0);
                    ptRight = lineutility.MidPointDouble(tg.Pixels.get(2), tg.Pixels.get(3), 0);
                    Modifier2.AddIntegralAreaModifier(tg, label + " - " + tg.get_Name(), 2, -csFactor / 2.0, ptLeft, ptRight, false);
                    break;
                }
                case 290600: {
                    pt0 = tg.Pixels.get(4);
                    pt1 = tg.Pixels.get(2);
                    if (tg.Pixels.get((int)0).y < tg.Pixels.get((int)1).y) {
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + " - " + tg.get_DTG1(), 2, csFactor / 2.0, pt0, pt1, false);
                        break;
                    }
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + " - " + tg.get_DTG1(), 2, -csFactor / 2.0, pt0, pt1, false);
                    break;
                }
                case 200402: {
                    if (tg.Pixels.get((int)0).x > tg.Pixels.get((int)3).x) {
                        Modifier2.AddIntegralAreaModifier(tg, label, 2, csFactor, tg.Pixels.get(0), tg.Pixels.get(3), false);
                        break;
                    }
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, csFactor, tg.Pixels.get(1), tg.Pixels.get(2), false);
                    break;
                }
                case 141400: 
                case 141500: 
                case 200300: 
                case 240804: {
                    break;
                }
                case 151407: 
                case 151408: {
                    Shape2 shape = shapes.get(shapes.size() - 1);
                    ArrayList<POINT2> pts = Modifier2.getShapePoints(shape.getShape());
                    n = pts.size();
                    if (n == 4) {
                        pt0 = pts.get(0);
                        pt1 = pts.get(1);
                        pt1 = lineutility.MidPointDouble(pt0, pt1, 0);
                    } else if (n == 6) {
                        pt0 = pts.get(3);
                        pt1 = pts.get(4);
                    } else {
                        pt0 = pts.get(1);
                        pt1 = pts.get(2);
                    }
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, pt1, false);
                    if (n == 4) {
                        pt0 = pts.get(2);
                        pt1 = pts.get(3);
                        pt1 = lineutility.MidPointDouble(pt0, pt1, 0);
                    } else if (n == 6) {
                        pt0 = pts.get(0);
                        pt1 = pts.get(1);
                    } else {
                        pt0 = pts.get(n / 2 + 1);
                        pt1 = pts.get(n / 2 + 2);
                    }
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt0, pt1, false);
                    break;
                }
                default: {
                    int saveStd = tg.getSymbologyStandard();
                    tg.setSymbologyStandard(1);
                    Modifier2.AddModifiers2(tg);
                    tg.setSymbologyStandard(saveStd);
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifiers2RevD", new RendererException("Failed inside AddModifiers2RevD", exc));
        }
    }

    public static void AddModifiersGeo2(TGLight tg, Graphics2D g2d, Object clipBounds, IPointConversion converter) {
        if (tg.get_SymbolId().length() < 20) {
            Modifier2.AddModifiersGeo(tg, g2d, clipBounds, converter);
            return;
        }
        try {
            String symbolId = tg.get_SymbolId();
            String setA = symbolId.substring(0, 10);
            String setB = symbolId.substring(10);
            String code = setB.substring(0, 6);
            int nCode = Integer.parseInt(code);
            String symbolSet = setA.substring(4, 6);
            int nSymbol = Integer.parseInt(symbolSet);
            String country = "US";
            String v = "MORTAR";
            String ap = "QC 1968";
            String t = tg.get_Name();
            String label = Modifier2.GetCenterLabel(tg);
            double csFactor = 1.0;
            if (nSymbol == 45 || nSymbol == 46) {
                Modifier2.AddModifiersGeo(tg, g2d, clipBounds, converter);
                return;
            }
            if (nSymbol != 25) {
                Modifier2.AddModifiersGeo(tg, g2d, clipBounds, converter);
                return;
            }
            double factor = 1.0;
            boolean j = false;
            boolean k = false;
            double x = 0.0;
            double y = 0.0;
            if (tg.get_Font() == null || tg.get_Font().getSize() <= 0) {
                return;
            }
            factor = 10.0 / (double)tg.get_Font().getSize();
            FontMetrics metrics = g2d.getFontMetrics();
            int stringWidth = 0;
            int stringWidth2 = 0;
            String dash = "";
            if (tg.get_DTG() != null && tg.get_DTG1() != null && !tg.get_DTG().isEmpty() && !tg.get_DTG1().isEmpty()) {
                dash = " - ";
            }
            int lastIndex = tg.Pixels.size() - 1;
            int nextToLastIndex = tg.Pixels.size() - 2;
            POINT2 pt0 = new POINT2(tg.Pixels.get(0));
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            POINT2 ptLast = new POINT2(tg.Pixels.get(lastIndex));
            POINT2 ptNextToLast = null;
            POINT2 midPt = null;
            if (lastIndex > 0) {
                ptNextToLast = new POINT2(tg.Pixels.get(lastIndex - 1));
            }
            if (tg.Pixels.size() > 1) {
                pt1 = new POINT2(tg.Pixels.get(1));
            }
            if (tg.Pixels.size() > 2) {
                pt2 = new POINT2(tg.Pixels.get(2));
            }
            if (tg.Pixels.size() > 3) {
                pt3 = new POINT2(tg.Pixels.get(3));
            }
            Object[] pts = tg.Pixels.toArray();
            POINT2 ptCenter = null;
            if (converter != null) {
                ptCenter = mdlGeodesic.geodesic_center(tg.LatLongs);
                if (ptCenter != null) {
                    Point2D pt22 = converter.GeoToPixels(new Point2D.Double(ptCenter.x, ptCenter.y));
                    ptCenter.x = pt22.getX();
                    ptCenter.y = pt22.getY();
                } else {
                    ptCenter = lineutility.CalcCenterPointDouble2(pts, pts.length);
                }
            } else {
                ptCenter = lineutility.CalcCenterPointDouble2(pts, pts.length);
            }
            POINT2 lr = new POINT2(tg.Pixels.get(0));
            POINT2 ll = new POINT2(tg.Pixels.get(0));
            POINT2 ul = new POINT2(tg.Pixels.get(0));
            POINT2 ur = new POINT2(tg.Pixels.get(0));
            Rectangle2D.Double clipRect = null;
            ArrayList clipArray = null;
            if (clipBounds != null && ArrayList.class.isAssignableFrom(clipBounds.getClass())) {
                clipArray = (ArrayList)clipBounds;
            }
            if (clipBounds != null && Rectangle2D.Double.class.isAssignableFrom(clipBounds.getClass())) {
                clipRect = (Rectangle2D.Double)clipBounds;
            }
            int middleSegment = (tg.Pixels.size() + 1) / 2 - 1;
            if (clipRect != null) {
                middleSegment = Modifier2.getVisibleMiddleSegment(tg, clipRect);
            } else if (clipArray != null) {
                middleSegment = Modifier2.getVisibleMiddleSegment(tg, clipArray);
            }
            double dist = 0.0;
            double dist2 = 0.0;
            Font font = null;
            font = tg.get_Font();
            if (font == null) {
                font = g2d.getFont();
            }
            g2d.setFont(font);
            POINT2 ptUl = null;
            POINT2 ptUr = null;
            POINT2 ptLl = null;
            POINT2 ptLr = null;
            switch (nCode) {
                case 200401: {
                    ptUr = new POINT2();
                    ptUl = new POINT2();
                    ptLl = new POINT2();
                    ptLr = new POINT2();
                    Modifier2.GetMBR(tg, ptUl, ptUr, ptLr, ptLl);
                    label = Modifier2.getRevDLabel(nCode);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, csFactor, ptLl, ptLr, false);
                    break;
                }
                case 110101: 
                case 110102: 
                case 110103: {
                    t = t + " (" + country + ")";
                    tg.set_Name(t);
                    tg.set_T1(t);
                    Modifier2.AddModifiersGeo(tg, g2d, clipBounds, converter);
                    break;
                }
                case 110200: 
                case 141000: 
                case 141100: 
                case 141200: 
                case 141400: 
                case 141500: 
                case 141600: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 5, -csFactor, pt0, pt1, false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 5, -csFactor, ptLast, ptNextToLast, false);
                    break;
                }
                case 120400: {
                    ptUr = new POINT2();
                    ptUl = new POINT2();
                    ptLl = new POINT2();
                    ptLr = new POINT2();
                    Modifier2.GetMBR(tg, ptUl, ptUr, ptLr, ptLl);
                    stringWidth = metrics.stringWidth(tg.get_H());
                    pt0.x = ptUr.x + (double)(stringWidth / 2) + 1.0;
                    pt0.y = (ptUr.y + ptLr.y) / 2.0 - (double)font.getSize();
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_H(), 3, csFactor, pt0, pt0, false);
                    break;
                }
                case 200101: 
                case 200201: {
                    label = Modifier2.getRevDLabel(nCode);
                    Modifier2.AddIntegralAreaModifier(tg, label + " - " + tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    break;
                }
                case 140700: 
                case 140900: 
                case 190100: 
                case 190200: {
                    label = Modifier2.getRevDLabel(nCode);
                    Modifier2.AddIntegralAreaModifier(tg, label, 5, -csFactor, pt0, pt1, false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 5, -csFactor, ptLast, ptNextToLast, false);
                    break;
                }
                case 140103: 
                case 140104: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 1, -1.0 * csFactor, pt0, pt1, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 1, -1.0 * csFactor, ptLast, ptNextToLast, false);
                    break;
                }
                case 140101: 
                case 140102: 
                case 141700: 
                case 150101: 
                case 150102: 
                case 151900: 
                case 152000: 
                case 152100: 
                case 152200: 
                case 200402: {
                    break;
                }
                case 140400: 
                case 140401: {
                    label = Modifier2.getRevDLabel(nCode);
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, pt0, pt1, false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 1, 0.0, ptLast, ptNextToLast, false);
                    break;
                }
                case 150103: 
                case 150104: {
                    Modifier2.areasWithENY(tg, g2d);
                    break;
                }
                case 150501: 
                case 150502: 
                case 150503: {
                    Modifier2.areasWithENY(tg, g2d);
                    label = Modifier2.getRevDLabel(nCode);
                    Modifier2.AddIntegralAreaModifier(tg, label + " " + tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, csFactor, ptCenter, ptCenter, false);
                    break;
                }
                case 151000: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    break;
                }
                case 151401: 
                case 151402: {
                    if (tg.Pixels.size() == 3) {
                        midPt = lineutility.MidPointDouble(pt0, pt1, 0);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 2, 0.0, midPt, midPt, false);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 2, csFactor, midPt, midPt, false);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 2.0 * csFactor, midPt, midPt, false);
                        break;
                    }
                    if (tg.Pixels.size() == 4) {
                        midPt = lineutility.MidPointDouble(pt1, pt2, 0);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 2, 0.0, midPt, midPt, false);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 2, csFactor, midPt, midPt, false);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 2.0 * csFactor, midPt, midPt, false);
                        break;
                    }
                    midPt = lineutility.MidPointDouble(pt1, pt2, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 2, -csFactor / 2.0, midPt, midPt, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 2, csFactor / 2.0, midPt, midPt, false);
                    midPt = lineutility.MidPointDouble(pt2, pt3, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, -csFactor / 2.0, midPt, midPt, false);
                    break;
                }
                case 151403: 
                case 151404: 
                case 151405: 
                case 151406: 
                case 151407: 
                case 151408: {
                    if (tg.Pixels.size() == 3) {
                        midPt = lineutility.MidPointDouble(pt0, pt1, 0);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 2, 0.0, midPt, midPt, false);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 2, csFactor, midPt, midPt, false);
                        Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 2.0 * csFactor, midPt, midPt, false);
                        break;
                    }
                    midPt = lineutility.MidPointDouble(pt0, pt1, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 2, -csFactor / 2.0, midPt, midPt, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 2, csFactor / 2.0, midPt, midPt, false);
                    midPt = lineutility.MidPointDouble(pt1, pt2, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, -csFactor / 2.0, midPt, midPt, false);
                    break;
                }
                case 140601: 
                case 140602: 
                case 140603: 
                case 140604: 
                case 140605: {
                    midPt = lineutility.MidPointDouble(pt0, pt1, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 2, 0.0, pt0, midPt, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, csFactor, pt0, pt1, false);
                    break;
                }
                case 140606: 
                case 140607: {
                    midPt = lineutility.MidPointDouble(pt0, pt1, 0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_N(), 2, 0.0, pt1, midPt, false);
                    break;
                }
                case 170800: {
                    label = Modifier2.getRevDLabel(nCode);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, 0.0, ptCenter, ptCenter, false);
                    break;
                }
                case 151500: {
                    label = Modifier2.getRevDLabel(nCode);
                    Modifier2.AddIntegralAreaModifier(tg, label + " " + tg.get_Name(), 2, 0.0, ptCenter, ptCenter, false);
                    break;
                }
                case 151600: 
                case 151700: {
                    Modifier2.AddIntegralAreaModifier(tg, label + " " + tg.get_Name(), 2, 0.0, ptCenter, ptCenter, false);
                    break;
                }
                case 141300: {
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, 1.35 * factor * csFactor, ll, lr, false);
                    break;
                }
                case 170100: 
                case 170101: 
                case 170200: 
                case 170300: 
                case 170500: 
                case 170700: {
                    Modifier2.AddIntegralModifier(tg, label + " " + tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Max Alt: " + tg.get_H1(), 2, -4.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Min Alt: " + tg.get_H(), 2, -5.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Width: " + tg.get_H2(), 2, -6.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Name: " + tg.get_Name(), 2, -7.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "DTG Start: " + tg.get_DTG(), 2, -3.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "DTG End: " + tg.get_DTG1(), 2, -2.0 * csFactor, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 170400: 
                case 170600: {
                    label = Modifier2.getRevDLabel(nCode);
                    Modifier2.AddIntegralModifier(tg, label + " " + tg.get_Name(), 2, 0.0, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Max Alt: " + tg.get_H1(), 2, -4.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Min Alt: " + tg.get_H(), 2, -5.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Width: " + tg.get_H2(), 2, -6.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "Name: " + tg.get_Name(), 2, -7.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "DTG Start: " + tg.get_DTG(), 2, -3.0 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, "DTG End: " + tg.get_DTG1(), 2, -2.0 * csFactor, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 171100: 
                case 171200: 
                case 171300: 
                case 171400: 
                case 171500: 
                case 171900: {
                    label = Modifier2.getRevDLabel(nCode);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -2.5, ptCenter, ptCenter, false, "");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -1.5, ptCenter, ptCenter, false, "T");
                    Modifier2.AddIntegralAreaModifier(tg, "MIN ALT: " + tg.get_H(), 3, -0.5, ptCenter, ptCenter, false, "H");
                    Modifier2.AddIntegralAreaModifier(tg, "MAX ALT: " + tg.get_H1(), 3, 0.5, ptCenter, ptCenter, false, "H1");
                    Modifier2.AddIntegralAreaModifier(tg, "TIME FROM: " + tg.get_DTG(), 3, 1.5, ptCenter, ptCenter, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, "TIME TO: " + tg.get_DTG1(), 3, 2.5, ptCenter, ptCenter, false, "W1");
                    break;
                }
                case 200300: {
                    label = Modifier2.getRevDLabel(nCode);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, -1.0, pt0, pt0, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, csFactor, pt0, pt0, false);
                    break;
                }
                case 220107: 
                case 220108: {
                    label = Modifier2.getRevDLabel(nCode);
                    Modifier2.AddIntegralAreaModifier(tg, label, 2, 0.0, pt0, pt1, false);
                    break;
                }
                case 240101: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, -3.0 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, -2.0 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, "MIN ALT: " + tg.get_H(), 3, -1.0 * csFactor, ptCenter, ptCenter, false, "H");
                    Modifier2.AddIntegralAreaModifier(tg, "MAX ALT: " + tg.get_H1(), 3, 0.0, ptCenter, ptCenter, false, "H1");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Location(), 3, 1.0 * csFactor, ptCenter, ptCenter, false, "H2");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 3, 2.0 * csFactor, ptCenter, ptCenter, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 3, 3.0 * csFactor, ptCenter, ptCenter, false, "W1");
                    break;
                }
                case 300100: {
                    label = Modifier2.getRevDLabel(nCode);
                    pt0 = tg.Pixels.get(0);
                    pt1 = tg.Pixels.get(1);
                    pt2 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt3 = tg.Pixels.get(tg.Pixels.size() - 2);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1);
                    dist2 = lineutility.CalcDistanceDouble(pt2, pt3);
                    stringWidth = (int)((double)metrics.stringWidth(tg.get_Name() + " " + label));
                    stringWidth2 = (int)((double)metrics.stringWidth(tg.get_DTG()));
                    if (stringWidth2 > stringWidth) {
                        stringWidth = stringWidth2;
                    }
                    if (tg.Pixels.size() == 2) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, label + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        if (dist > 3.5 * (double)stringWidth) {
                            pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                            pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                            pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                            Modifier2.AddModifier2(tg, label + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        }
                    } else {
                        double dist3 = lineutility.CalcDistanceDouble(pt0, pt2);
                        if (dist > (double)(stringWidth + 5) || dist >= dist2 || dist3 > (double)(stringWidth + 5)) {
                            pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                            Modifier2.AddModifier2(tg, label + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        }
                        if (dist2 > (double)(stringWidth + 5) || dist2 > dist || dist3 > (double)(stringWidth + 5)) {
                            pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                            pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                            pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                            Modifier2.AddModifier2(tg, label + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        }
                    }
                    break;
                }
                case 260300: 
                case 260400: {
                    label = Modifier2.getRevDLabel(nCode);
                    pt0 = tg.Pixels.get(0);
                    pt1 = tg.Pixels.get(1);
                    pt2 = tg.Pixels.get(tg.Pixels.size() - 1);
                    pt3 = tg.Pixels.get(tg.Pixels.size() - 2);
                    dist = lineutility.CalcDistanceDouble(pt0, pt1);
                    dist2 = lineutility.CalcDistanceDouble(pt2, pt3);
                    stringWidth = (int)((double)metrics.stringWidth(tg.get_Name() + " " + label));
                    stringWidth2 = (int)((double)metrics.stringWidth(tg.get_DTG()));
                    if (stringWidth2 > stringWidth) {
                        stringWidth = stringWidth2;
                    }
                    if (tg.Pixels.size() == 2) {
                        pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                        Modifier2.AddModifier2(tg, label + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                        Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        if (dist > 3.5 * (double)stringWidth) {
                            pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                            pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                            pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                            Modifier2.AddModifier2(tg, label + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        }
                    } else {
                        double dist3 = lineutility.CalcDistanceDouble(pt0, pt2);
                        if (dist > (double)(stringWidth + 5) || dist >= dist2 || dist3 > (double)(stringWidth + 5)) {
                            pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                            Modifier2.AddModifier2(tg, label + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        }
                        if (dist2 > (double)(stringWidth + 5) || dist2 > dist || dist3 > (double)(stringWidth + 5)) {
                            pt0 = tg.Pixels.get(tg.Pixels.size() - 1);
                            pt1 = tg.Pixels.get(tg.Pixels.size() - 2);
                            pt1 = lineutility.ExtendAlongLineDouble(pt0, pt1, stringWidth);
                            Modifier2.AddModifier2(tg, label + " " + tg.get_Name(), 2, -0.7 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG(), 2, 0.7 * csFactor, pt0, pt1, false);
                            Modifier2.AddModifier2(tg, tg.get_DTG1(), 2, 1.7 * csFactor, pt0, pt1, false);
                        }
                    }
                    break;
                }
                case 260600: {
                    pt0 = tg.Pixels.get(middleSegment);
                    pt1 = tg.Pixels.get(middleSegment + 1);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.0, middleSegment, middleSegment + 1, true);
                    Modifier2.AddIntegralModifier(tg, tg.get_DTG(), 5, 1.0 * csFactor, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_DTG1(), 5, 2.0 * csFactor, 0, 1, false);
                    break;
                }
                case 240701: {
                    Modifier2.AddIntegralModifier(tg, ap, 2, -0.8 * csFactor, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 240702: {
                    Modifier2.AddIntegralModifier(tg, ap, 2, -0.8 * csFactor, middleSegment, middleSegment + 1, false);
                    Modifier2.AddIntegralModifier(tg, label, 2, 0.8 * csFactor, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 240703: {
                    Modifier2.AddIntegralModifier(tg, ap, 2, -1.0 * csFactor, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, label, 2, 1.0 * csFactor, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_T1(), 2, 2.0 * csFactor, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, v, 2, 3.0 * csFactor, 0, 1, false);
                    break;
                }
                case 240801: {
                    Modifier2.AddIntegralAreaModifier(tg, ap, 3, 0.0, ptCenter, ptCenter, false);
                    break;
                }
                case 240802: 
                case 240803: {
                    Modifier2.AddIntegralAreaModifier(tg, ap, 3, 0.0, pt0, pt0, false);
                    break;
                }
                case 240804: {
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 0.0, ptCenter, ptCenter, false);
                    break;
                }
                case 240806: 
                case 240807: {
                    Modifier2.AddIntegralAreaModifier(tg, ap, 3, -csFactor, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 3, 1.0 * csFactor, ptCenter, ptCenter, false, "W+W1");
                    break;
                }
                case 242301: 
                case 242304: {
                    Modifier2.AddIntegralAreaModifier(tg, label, 3, 0.0, ptCenter, ptCenter, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_Name(), 3, 1.0 * csFactor, ptCenter, ptCenter, false);
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    POINT2 ptLeft = ul;
                    POINT2 ptRight = ur;
                    if (tg.get_Client().equalsIgnoreCase("ge")) {
                        ptLeft.x -= (double)(font.getSize() / 2);
                        ptRight.x -= (double)(font.getSize() / 2);
                    }
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 1, 0.5 * csFactor, ptLeft, ptRight, false, "W");
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG1(), 1, 1.5 * csFactor, ptLeft, ptRight, false, "W1");
                    break;
                }
                case 140500: 
                case 242302: 
                case 242303: 
                case 242305: 
                case 242306: {
                    break;
                }
                case 290100: {
                    Modifier2.AddIntegralModifier(tg, tg.get_Name(), 2, csFactor, middleSegment, middleSegment + 1, false);
                    break;
                }
                case 290600: {
                    break;
                }
                case 270800: {
                    Modifier2.GetMBR(tg, ul, ur, lr, ll);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_H(), 2, -1.5 * factor * csFactor, ul, ur, false);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG(), 2, 1.5 * factor * csFactor, ll, lr, false);
                    Modifier2.areasWithENY(tg, g2d);
                    break;
                }
                case 271300: {
                    if (tg.Pixels.get((int)1).y > tg.Pixels.get((int)0).y) {
                        pt0 = tg.Pixels.get(1);
                        pt1 = tg.Pixels.get(3);
                        pt2 = tg.Pixels.get(0);
                        pt3 = tg.Pixels.get(2);
                    } else {
                        pt0 = tg.Pixels.get(0);
                        pt1 = tg.Pixels.get(2);
                        pt2 = tg.Pixels.get(1);
                        pt3 = tg.Pixels.get(3);
                    }
                    pt2 = lineutility.ExtendAlongLineDouble2(pt0, pt2, -20.0);
                    pt3 = lineutility.ExtendAlongLineDouble2(pt1, pt3, -20.0);
                    Modifier2.AddIntegralAreaModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, 0.0, pt2, pt3, false);
                    break;
                }
                case 330100: 
                case 330200: {
                    String convoyBlankString = Modifier2.blankString(metrics, 35);
                    Modifier2.AddIntegralModifier(tg, v + convoyBlankString + tg.get_H(), 2, 0.0, 0, 1, false);
                    Modifier2.AddIntegralModifier(tg, tg.get_DTG() + dash + tg.get_DTG1(), 2, 1.2 * csFactor, 0, 1, false);
                    break;
                }
                default: {
                    Modifier2.AddModifiersGeo(tg, g2d, clipBounds, converter);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AddModifiersGeo2", new RendererException("Failed inside AddModifiersGeo2", exc));
        }
    }
}

