/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.JavaLineArray;

import armyc2.c2sd.JavaLineArray.CELineArray;
import armyc2.c2sd.JavaLineArray.Channels;
import armyc2.c2sd.JavaLineArray.DISMSupport;
import armyc2.c2sd.JavaLineArray.POINT2;
import armyc2.c2sd.JavaLineArray.Shape2;
import armyc2.c2sd.JavaLineArray.countsupport;
import armyc2.c2sd.JavaLineArray.flot;
import armyc2.c2sd.JavaLineArray.lineutility;
import armyc2.c2sd.JavaLineArray.ref;
import armyc2.c2sd.graphics2d.Area;
import armyc2.c2sd.graphics2d.BasicStroke;
import armyc2.c2sd.graphics2d.Polygon;
import armyc2.c2sd.graphics2d.Rectangle2D;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.IPointConversion;
import armyc2.c2sd.renderer.utilities.RendererException;
import java.util.ArrayList;

public final class arraysupport {
    private static final double maxLength = 100.0;
    private static double minLength = 2.5;
    private static double dACP = 0.0;
    private static final String _className = "arraysupport";

    private static void FillPoints(POINT2[] pLinePoints, int counter, ArrayList<POINT2> points) {
        points.clear();
        for (int j = 0; j < counter; ++j) {
            points.add(pLinePoints[j]);
        }
    }

    public static ArrayList<POINT2> GetLineArray2(int lineType, ArrayList<POINT2> pts, ArrayList<Shape2> shapes, Rectangle2D clipBounds, int rev, IPointConversion converter) {
        ArrayList<POINT2> points = null;
        try {
            int vblCounter;
            POINT2 pt = null;
            Object pLinePoints2 = null;
            POINT2[] pLinePoints = null;
            int vblSaveCounter = pts.size();
            int j = 0;
            if (pLinePoints2 == null || (pLinePoints2).length == 0) {
                pLinePoints = new POINT2[vblSaveCounter];
                for (j = 0; j < vblSaveCounter; ++j) {
                    pt = pts.get(j);
                    pLinePoints[j] = new POINT2(pt.x, pt.y, pt.style);
                }
            }
            if ((vblCounter = countsupport.GetCountersDouble(lineType, vblSaveCounter, pLinePoints, clipBounds, rev)) <= 0) {
                shapes = null;
                return null;
            }
            pLinePoints = new POINT2[vblCounter];
            lineutility.InitializePOINT2Array(pLinePoints);
            if (vblSaveCounter > pts.size()) {
                vblSaveCounter = pts.size();
            }
            if (vblSaveCounter > pLinePoints.length) {
                vblSaveCounter = pLinePoints.length;
            }
            for (j = 0; j < vblSaveCounter; ++j) {
                pt = pts.get(j);
                pLinePoints[j] = new POINT2(pt.x, pt.y, pt.style);
            }
            points = arraysupport.GetLineArray2Double(lineType, pLinePoints, vblCounter, vblSaveCounter, shapes, clipBounds, rev, converter);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetLineArray2", new RendererException("GetLineArray2 " + Integer.toString(lineType), exc));
        }
        return points;
    }

    private static int GetFORTLPointsDouble(POINT2[] pLinePoints, int lineType, int vblSaveCounter) {
        int nCounter = 0;
        try {
            int j = 0;
            int k = 0;
            int bolVertical = 0;
            int lCount = 0;
            double dLengthSegment = 0.0;
            double dIncrement = 20.0;
            ref<double[]> m = new ref<double[]>();
            POINT2[] pSpikePoints = null;
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            lCount = countsupport.GetFORTLCountDouble(pLinePoints, lineType, vblSaveCounter);
            int numGlyphs = 0;
            double dGlyphSize = 0.0;
            pSpikePoints = new POINT2[lCount];
            lineutility.InitializePOINT2Array(pSpikePoints);
            switch (lineType) {
                default: 
            }
            dIncrement = 20.0;
            for (j = 0; j < vblSaveCounter - 1; ++j) {
                bolVertical = lineutility.CalcTrueSlopeDouble(pLinePoints[j], pLinePoints[j + 1], m);
                dLengthSegment = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                if (dLengthSegment / 20.0 < 1.0) {
                    pSpikePoints[nCounter] = new POINT2(pLinePoints[j]);
                    pSpikePoints[++nCounter] = new POINT2(pLinePoints[j + 1]);
                    ++nCounter;
                    continue;
                }
                numGlyphs = (int)(dLengthSegment / dIncrement);
                dGlyphSize = 10.0;
                dIncrement = dLengthSegment / (double)numGlyphs;
                if (dIncrement > 25.0) {
                    dIncrement = 25.0;
                    numGlyphs = (int)(dLengthSegment / dIncrement);
                }
                for (k = 0; k < numGlyphs; ++k) {
                    pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement, 0);
                    pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - dIncrement / 2.0, 0);
                    pt0 = new POINT2(pSpikePoints[++nCounter - 1]);
                    pt1 = lineutility.ExtendLineDouble(pLinePoints[j], pSpikePoints[nCounter - 1], dIncrement / 2.0);
                    if (pLinePoints[j].x > pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 3, dGlyphSize);
                        pSpikePoints[++nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt1, 3, dGlyphSize);
                        ++nCounter;
                    }
                    if (pLinePoints[j].x < pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 2, dGlyphSize);
                        pSpikePoints[++nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt1, 2, dGlyphSize);
                        ++nCounter;
                    }
                    if (pLinePoints[j].x == pLinePoints[j + 1].x) {
                        if (pLinePoints[j].y < pLinePoints[j + 1].y) {
                            pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 1, dGlyphSize);
                            pSpikePoints[++nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt1, 1, dGlyphSize);
                            ++nCounter;
                        }
                        if (pLinePoints[j].y > pLinePoints[j + 1].y) {
                            pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 0, dGlyphSize);
                            pSpikePoints[++nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt1, 0, dGlyphSize);
                            ++nCounter;
                        }
                    }
                    pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nCounter - 3], dIncrement / 2.0, 0);
                    ++nCounter;
                }
                pSpikePoints[nCounter] = new POINT2(pLinePoints[j + 1]);
                ++nCounter;
            }
            for (j = 0; j < nCounter; ++j) {
                pLinePoints[j] = new POINT2(pSpikePoints[j]);
            }
            return nCounter;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetFORTLPointsDouble", new RendererException("GetFORTLPointsDouble " + Integer.toString(lineType), exc));
            return nCounter;
        }
    }

    private static void CoordFEBADouble(POINT2[] pLinePoints, int vblCounter) {
        try {
            int j = 0;
            POINT2[] pXLinePoints = new POINT2[4 * vblCounter / 32];
            POINT2[] pNewLinePoints = new POINT2[vblCounter / 32];
            POINT2[] pShortLinePoints = new POINT2[2 * vblCounter / 32];
            POINT2[] pArcLinePoints = new POINT2[26 * vblCounter / 32];
            double dPrinter = 1.0;
            for (j = vblCounter / 32; j < vblCounter; ++j) {
                pLinePoints[j] = new POINT2(pLinePoints[0]);
                pLinePoints[j].style = 0;
            }
            for (j = 0; j < 4 * vblCounter / 32; ++j) {
                pXLinePoints[j] = new POINT2(pLinePoints[0]);
                pXLinePoints[j].style = 0;
            }
            for (j = 0; j < vblCounter / 32; ++j) {
                pNewLinePoints[j] = new POINT2(pLinePoints[j]);
                pNewLinePoints[j].style = 0;
            }
            for (j = 0; j < 2 * vblCounter / 32; ++j) {
                pShortLinePoints[j] = new POINT2(pLinePoints[0]);
                pShortLinePoints[j].style = 0;
            }
            for (j = 0; j < 26 * vblCounter / 32; ++j) {
                pArcLinePoints[j] = new POINT2(pLinePoints[0]);
                pArcLinePoints[j].style = 0;
            }
            lineutility.GetXFEBADouble(pNewLinePoints, 10.0 * dPrinter, vblCounter / 32, pXLinePoints);
            for (j = 0; j < 4 * vblCounter / 32; ++j) {
                pLinePoints[j] = new POINT2(pXLinePoints[j]);
            }
            pLinePoints[4 * vblCounter / 32 - 1].style = 5;
            for (j = 4 * vblCounter / 32; j < 6 * vblCounter / 32; ++j) {
                pLinePoints[j] = new POINT2(pShortLinePoints[j - 4 * vblCounter / 32]);
                pLinePoints[j].style = 5;
            }
            pLinePoints[6 * vblCounter / 32 - 1].style = 5;
            lineutility.GetArcFEBADouble(14.0 * dPrinter, pNewLinePoints, vblCounter / 32, pArcLinePoints);
            for (j = 6 * vblCounter / 32; j < vblCounter; ++j) {
                pLinePoints[j] = new POINT2(pArcLinePoints[j - 6 * vblCounter / 32]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CoordFEBADouble", new RendererException("CoordFEBADouble", exc));
        }
    }

    private static int GetATWallPointsDouble2(POINT2[] pLinePoints, int lineType, int vblSaveCounter) {
        int nCounter = 0;
        try {
            int j = 0;
            int k = 0;
            int lCount = 0;
            double dLengthSegment = 0.0;
            double dIncrement = 0.0;
            POINT2[] pSpikePoints = null;
            double dSpikeSize = 0.0;
            int limit = 0;
            int numSpikes = 0;
            lCount = countsupport.GetFORTLCountDouble(pLinePoints, lineType, vblSaveCounter);
            pSpikePoints = new POINT2[lCount];
            lineutility.InitializePOINT2Array(pSpikePoints);
            pSpikePoints[nCounter++] = new POINT2(pLinePoints[0]);
            for (j = 0; j < vblSaveCounter - 1; ++j) {
                dLengthSegment = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                dIncrement = 20.0;
                dSpikeSize = 10.0;
                numSpikes = (int)Math.round((dLengthSegment - 10.0) / dIncrement);
                if ((dIncrement = dLengthSegment / (double)numSpikes) > 25.0) {
                    dIncrement = 25.0;
                }
                limit = numSpikes - 1;
                for (k = -1; k < limit; ++k) {
                    pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - 30.0, 0);
                    POINT2 pt0 = lineutility.ExtendLineDouble(pLinePoints[j], pSpikePoints[++nCounter - 1], dSpikeSize / 2.0);
                    if (pLinePoints[j].x > pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pSpikePoints[nCounter - 1], pt0, 2, dSpikeSize);
                    }
                    if (pLinePoints[j].x < pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pSpikePoints[nCounter - 1], pt0, 3, dSpikeSize);
                    }
                    if (pLinePoints[j].x == pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = new POINT2(pt0);
                        pSpikePoints[nCounter].x = pLinePoints[j].y < pLinePoints[j + 1].y ? pt0.x - dSpikeSize : pt0.x + dSpikeSize;
                    }
                    pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nCounter - 2], dSpikeSize, 0);
                    ++nCounter;
                }
                pSpikePoints[nCounter] = new POINT2(pLinePoints[j + 1]);
                pSpikePoints[nCounter].style = 0;
                ++nCounter;
            }
            for (j = 0; j < nCounter; ++j) {
                pLinePoints[j] = new POINT2(pSpikePoints[j]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetATWallPointsDouble", new RendererException("GetATWallPointsDouble", exc));
        }
        return nCounter;
    }

    public static int GetInsideOutsideDouble2(POINT2 pt0, POINT2 pt1, POINT2[] pLinePoints, int vblCounter, int index, int lineType) {
        int nDirection = 0;
        try {
            ref<double[]> m = new ref<double[]>();
            ref<double[]> m0 = new ref<double[]>();
            double b0 = 0.0;
            double b2 = 0.0;
            double b = 0.0;
            double X0 = 0.0;
            double Y0 = 0.0;
            double X = 0.0;
            double Y = 0.0;
            int nInOutCounter = 0;
            int j = 0;
            int bolVertical = 0;
            int bolVertical2 = 0;
            boolean nOrientation = false;
            int extendLeft = 0;
            int extendRight = 1;
            int extendAbove = 2;
            int extendBelow = 3;
            int oppSegment = vblCounter - index - 3;
            POINT2 pt2 = new POINT2();
            bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m0);
            if (m0.value == null) {
                return 0;
            }
            X0 = (pt0.x + pt1.x) / 2.0;
            Y0 = (pt0.y + pt1.y) / 2.0;
            if (lineType == 23111001 && oppSegment >= 0 && oppSegment < vblCounter - 1) {
                X0 = (pLinePoints[oppSegment].x + pLinePoints[oppSegment + 1].x) / 2.0;
                Y0 = (pLinePoints[oppSegment].y + pLinePoints[oppSegment + 1].y) / 2.0;
                b0 = Y0 + 1.0 / ((double[])m0.value)[0] * X0;
                b2 = pt0.y - ((double[])m0.value)[0] * pt0.x;
                if (((double[])m0.value)[0] != 0.0 && bolVertical != 0) {
                    pt2 = lineutility.CalcTrueIntersectDouble2(-1.0 / ((double[])m0.value)[0], b0, ((double[])m0.value)[0], b2, 1, 1, 0.0, 0.0);
                    X0 = pt2.x;
                    Y0 = pt2.y;
                }
                if (((double[])m0.value)[0] == 0.0 && bolVertical != 0) {
                    X0 = (pLinePoints[oppSegment].x + pLinePoints[oppSegment + 1].x) / 2.0;
                    Y0 = (pt0.y + pt1.y) / 2.0;
                }
                if (bolVertical == 0) {
                    Y0 = (pLinePoints[oppSegment].y + pLinePoints[oppSegment + 1].y) / 2.0;
                    X0 = (pt0.x + pt1.x) / 2.0;
                }
            }
            if (Math.abs(((double[])m0.value)[0]) >= 1.0 || bolVertical == 0) {
                nOrientation = false;
                for (j = 0; j < vblCounter - 1; ++j) {
                    if (index == j || lineType == 23111001 && oppSegment != j || !(pLinePoints[j].y < Y0 && pLinePoints[j + 1].y > Y0 || pLinePoints[j].y > Y0 && pLinePoints[j + 1].y < Y0 || pLinePoints[j].y < Y0 && pLinePoints[j + 1].y == Y0) && (pLinePoints[j].y != Y0 || !(pLinePoints[j + 1].y < Y0))) continue;
                    bolVertical2 = lineutility.CalcTrueSlopeDouble(pLinePoints[j], pLinePoints[j + 1], m);
                    if (bolVertical2 == 1 && ((double[])m.value)[0] == 0.0) {
                        ++nInOutCounter;
                        --nInOutCounter;
                    }
                    if (bolVertical2 == 0 && pLinePoints[j].x < X0) {
                        ++nInOutCounter;
                    }
                    if (((double[])m.value)[0] == 0.0 || bolVertical2 != 1 || !((X = (Y0 - (b = pLinePoints[j].y - ((double[])m.value)[0] * pLinePoints[j].x)) / ((double[])m.value)[0]) < X0)) continue;
                    ++nInOutCounter;
                }
            } else {
                nOrientation = true;
                for (j = 0; j < vblCounter - 1; ++j) {
                    if (index == j || lineType == 23111001 && oppSegment != j || !(pLinePoints[j].x < X0 && pLinePoints[j + 1].x > X0 || pLinePoints[j].x > X0 && pLinePoints[j + 1].x < X0 || pLinePoints[j].x < X0 && pLinePoints[j + 1].x == X0) && (pLinePoints[j].x != X0 || !(pLinePoints[j + 1].x < X0))) continue;
                    bolVertical2 = lineutility.CalcTrueSlopeDouble(pLinePoints[j], pLinePoints[j + 1], m);
                    if (bolVertical2 == 0) {
                        ++nInOutCounter;
                        --nInOutCounter;
                    }
                    if (bolVertical2 == 1 && ((double[])m.value)[0] == 0.0 && pLinePoints[j].y < Y0) {
                        ++nInOutCounter;
                    }
                    if (((double[])m.value)[0] == 0.0 || bolVertical2 != 1 || !((Y = ((double[])m.value)[0] * X0 + (b = pLinePoints[j].y - ((double[])m.value)[0] * pLinePoints[j].x)) < Y0)) continue;
                    ++nInOutCounter;
                }
            }
            switch (nInOutCounter % 2) {
                case 0: {
                    if (!nOrientation) {
                        nDirection = extendLeft;
                        break;
                    }
                    nDirection = extendAbove;
                    break;
                }
                case 1: {
                    if (!nOrientation) {
                        nDirection = extendRight;
                        break;
                    }
                    nDirection = extendBelow;
                    break;
                }
            }
            switch (lineType) {
                case 31740000: {
                    if (nDirection == extendLeft) {
                        nDirection = extendRight;
                        break;
                    }
                    if (nDirection == extendRight) {
                        nDirection = extendLeft;
                        break;
                    }
                    if (nDirection == extendAbove) {
                        nDirection = extendBelow;
                        break;
                    }
                    if (nDirection != extendBelow) break;
                    nDirection = extendAbove;
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetInsideOutsideDouble2", new RendererException("GetInsideOutsideDouble2", exc));
        }
        return nDirection;
    }

    protected static int GetZONEPointsDouble2(POINT2[] pLinePoints, int lineType, int vblSaveCounter) {
        int nCounter = 0;
        try {
            int j = 0;
            int k = 0;
            int n = 0;
            int lCount = 0;
            double dLengthSegment = 0.0;
            POINT2 pt0 = new POINT2(pLinePoints[0]);
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            POINT2[] pSpikePoints = null;
            int nDirection = 0;
            lCount = countsupport.GetFORTLCountDouble(pLinePoints, lineType, vblSaveCounter);
            pSpikePoints = new POINT2[lCount];
            lineutility.InitializePOINT2Array(pSpikePoints);
            double remainder = 0.0;
            for (j = 0; j < vblSaveCounter - 1; ++j) {
                pt1 = new POINT2(pLinePoints[j]);
                pt2 = new POINT2(pLinePoints[j + 1]);
                nDirection = arraysupport.GetInsideOutsideDouble2(pt1, pt2, pLinePoints, vblSaveCounter, j, lineType);
                dLengthSegment = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                if (lineType != 23111000 && lineType != 23111001 && dLengthSegment < 20.0) {
                    pSpikePoints[nCounter] = new POINT2(pLinePoints[j]);
                    pSpikePoints[++nCounter] = new POINT2(pLinePoints[j + 1]);
                    ++nCounter;
                    continue;
                }
                block1 : switch (lineType) {
                    case 23114000: 
                    case 23115000: {
                        switch (nDirection) {
                            case 0: {
                                nDirection = 1;
                                break block1;
                            }
                            case 1: {
                                nDirection = 0;
                                break block1;
                            }
                            case 2: {
                                nDirection = 3;
                                break block1;
                            }
                            case 3: {
                                nDirection = 2;
                                break block1;
                            }
                        }
                        break;
                    }
                }
                n = (int)(dLengthSegment / 20.0);
                remainder = dLengthSegment - (double)(n * 20);
                for (k = 0; k < n; ++k) {
                    if (k > 0) {
                        pSpikePoints[nCounter++] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k * 20) - remainder / 2.0, 0);
                        pSpikePoints[nCounter++] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k * 20 - 10) - remainder / 2.0, 0);
                    } else {
                        pSpikePoints[nCounter++] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], -k * 20, 0);
                        pSpikePoints[nCounter++] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], -k * 20 - 10, 0);
                    }
                    switch (lineType) {
                        case 22624000: 
                        case 23111000: 
                        case 23111001: 
                        case 23113000: 
                        case 23114000: 
                        case 23115000: {
                            pt0 = lineutility.ExtendLineDouble(pLinePoints[j], pSpikePoints[nCounter - 1], 5.0);
                            break;
                        }
                        case 22134000: 
                        case 23350000: {
                            pt0 = new POINT2(pSpikePoints[nCounter - 1]);
                            break;
                        }
                    }
                    pSpikePoints[nCounter++] = lineutility.ExtendDirectedLine(pt1, pt2, pt0, nDirection, 10.0);
                    switch (lineType) {
                        case 22624000: 
                        case 23111000: 
                        case 23111001: 
                        case 23113000: 
                        case 23114000: 
                        case 23115000: {
                            pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nCounter - 2], 10.0, 0);
                            break;
                        }
                        case 23350000: {
                            pSpikePoints[nCounter] = new POINT2(pSpikePoints[nCounter - 2]);
                            break;
                        }
                        case 22134000: {
                            pt3 = lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nCounter - 2], 10.0, 0);
                            pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pt1, pt2, pt3, nDirection, 10.0);
                            pSpikePoints[++nCounter] = new POINT2(pt3);
                            break;
                        }
                    }
                    ++nCounter;
                    if (lineType != 22624000) continue;
                    pSpikePoints[nCounter++] = new POINT2(pSpikePoints[nCounter - 4]);
                }
                pSpikePoints[nCounter++] = new POINT2(pLinePoints[j + 1]);
            }
            for (j = 0; j < nCounter; ++j) {
                if ((long)lineType != 23115000L) continue;
                pSpikePoints[j].style = 11;
            }
            if ((long)lineType == 23115000L) {
                pSpikePoints[nCounter - 1].style = 12;
            } else if (nCounter > 0) {
                pSpikePoints[nCounter - 1].style = 5;
            }
            for (j = 0; j < nCounter; ++j) {
                pLinePoints[j] = new POINT2(pSpikePoints[j]);
                if (j != nCounter - 1 || (long)lineType == 23115000L) continue;
                pLinePoints[j].style = 5;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetZONEPointsDouble2", new RendererException("GetZONEPointsDouble2", exc));
        }
        return nCounter;
    }

    private static boolean IsTurnArcReversed(POINT2[] pPoints) {
        try {
            if (pPoints.length < 3) {
                return false;
            }
            POINT2[] ptsSeize = new POINT2[]{new POINT2(pPoints[0]), new POINT2(pPoints[1])};
            lineutility.CalcClockwiseCenterDouble(ptsSeize);
            double d = lineutility.CalcDistanceDouble(ptsSeize[0], pPoints[2]);
            ptsSeize[0] = new POINT2(pPoints[1]);
            ptsSeize[1] = new POINT2(pPoints[0]);
            lineutility.CalcClockwiseCenterDouble(ptsSeize);
            double dArcReversed = lineutility.CalcDistanceDouble(ptsSeize[0], pPoints[2]);
            ptsSeize = null;
            return dArcReversed > d;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "IsTurnArcReversed", new RendererException("IsTurnArcReversed", exc));
            return false;
        }
    }

    private static void GetIsolatePointsDouble(POINT2[] pLinePoints, int lineType, IPointConversion converter) {
        try {
            boolean reverseTurn = false;
            POINT2 pt0 = new POINT2(pLinePoints[0]);
            POINT2 pt1 = new POINT2(pLinePoints[1]);
            POINT2 pt2 = new POINT2(pLinePoints[0]);
            if (pt0.x == pt1.x && pt0.y == pt1.y) {
                pt1.x += 1.0;
            }
            POINT2 C = new POINT2();
            POINT2 E = new POINT2();
            POINT2 midPt = new POINT2();
            int j = 0;
            int k = 0;
            int l = 0;
            POINT2[] ptsArc = new POINT2[26];
            POINT2[] midPts = new POINT2[7];
            POINT2[] trianglePts = new POINT2[21];
            POINT2[] pArrowPoints = new POINT2[3];
            POINT2[] reversepArrowPoints = new POINT2[3];
            double dRadius = lineutility.CalcDistanceDouble(pt0, pt1);
            double dLength = Math.abs(dRadius - 20.0);
            if (dRadius < 40.0) {
                dLength = dRadius / 1.5;
            }
            double d = lineutility.MBRDistance(pLinePoints, 2);
            POINT2[] ptsSeize = new POINT2[2];
            POINT2[] savepoints = new POINT2[3];
            for (j = 0; j < 2; ++j) {
                savepoints[j] = new POINT2(pLinePoints[j]);
            }
            if (pLinePoints.length >= 3) {
                savepoints[2] = new POINT2(pLinePoints[2]);
            }
            lineutility.InitializePOINT2Array(ptsArc);
            lineutility.InitializePOINT2Array(midPts);
            lineutility.InitializePOINT2Array(trianglePts);
            lineutility.InitializePOINT2Array(pArrowPoints);
            lineutility.InitializePOINT2Array(reversepArrowPoints);
            lineutility.InitializePOINT2Array(ptsSeize);
            if (d / 7.0 > 100.0) {
                d = 700.0;
            }
            if (d / 7.0 < minLength) {
                d = 7.0 * minLength;
            }
            if (d > 140.0) {
                d = 140.0;
            }
            POINT2[] ptsArc2 = new POINT2[26];
            lineutility.InitializePOINT2Array(ptsArc2);
            E.x = 2.0 * pt1.x - pt0.x;
            E.y = 2.0 * pt1.y - pt0.y;
            ptsArc[0] = new POINT2(pLinePoints[1]);
            ptsArc[1] = new POINT2(E);
            if (converter != null) {
                ptsArc[0] = new POINT2(pLinePoints[0]);
                ptsArc[1] = new POINT2(pLinePoints[1]);
            }
            lineutility.ArcArrayDouble(ptsArc, 0, dRadius, lineType, converter);
            for (j = 0; j < 26; ++j) {
                ptsArc[j].style = 0;
                pLinePoints[j] = new POINT2(ptsArc[j]);
                pLinePoints[j].style = 0;
            }
            if (lineType != 211600000) {
                lineutility.GetArrowHead4Double(ptsArc[24], ptsArc[25], (int)d / 7, (int)d / 7, pArrowPoints, 0);
            } else {
                lineutility.GetArrowHead4Double(ptsArc[24], ptsArc[25], (int)d / 7, (int)(1.75 * d) / 7, pArrowPoints, 0);
            }
            pLinePoints[25].style = 5;
            switch (lineType) {
                case 211400000: 
                case 212500000: 
                case 212600000: {
                    if (dRadius > 100.0) {
                        dLength = 0.8 * dRadius;
                    }
                    for (j = 1; j <= 23; ++j) {
                        if (j % 3 != 0) continue;
                        midPts[k].x = pt0.x - (double)((long)(dLength / dRadius * (pt0.x - ptsArc[j].x)));
                        midPts[k].y = pt0.y - (double)((long)(dLength / dRadius * (pt0.y - ptsArc[j].y)));
                        midPts[k].style = 0;
                        trianglePts[l] = new POINT2(ptsArc[j - 1]);
                        trianglePts[++l] = new POINT2(midPts[k]);
                        trianglePts[++l] = new POINT2(ptsArc[j + 1]);
                        trianglePts[l].style = 5;
                        ++l;
                        ++k;
                    }
                    for (j = 26; j < 47; ++j) {
                        pLinePoints[j] = new POINT2(trianglePts[j - 26]);
                    }
                    pLinePoints[46].style = 5;
                    for (j = 47; j < 50; ++j) {
                        pLinePoints[j] = new POINT2(pArrowPoints[j - 47]);
                        pLinePoints[j].style = 0;
                    }
                    break;
                }
                case 211600000: {
                    midPt.x = (pt1.x + ptsArc[25].x) / 2.0;
                    midPt.y = (pt1.y + ptsArc[25].y) / 2.0;
                    lineutility.GetArrowHead4Double(midPt, ptsArc[25], (int)d / 7, (int)(1.75 * d) / 7, reversepArrowPoints, 0);
                    for (j = 26; j < 29; ++j) {
                        pLinePoints[j] = new POINT2(pArrowPoints[j - 26]);
                    }
                    for (j = 29; j < 32; ++j) {
                        pLinePoints[j] = new POINT2(reversepArrowPoints[j - 29]);
                        pLinePoints[j].style = 0;
                    }
                    break;
                }
                case 212100000: {
                    for (j = 26; j < 29; ++j) {
                        pLinePoints[j] = new POINT2(pArrowPoints[j - 26]);
                        pLinePoints[j].style = 0;
                    }
                    pLinePoints[28].style = 5;
                    break;
                }
                case 23173000: {
                    boolean changeArc = arraysupport.IsTurnArcReversed(savepoints);
                    if (reverseTurn || changeArc) {
                        pt0.x = pt1.x;
                        pt0.y = pt1.y;
                        pt1.x = pt2.x;
                        pt1.y = pt2.y;
                    }
                    ptsSeize[0] = new POINT2(pt0);
                    ptsSeize[1] = new POINT2(pt1);
                    dRadius = lineutility.CalcClockwiseCenterDouble(ptsSeize);
                    C = new POINT2(ptsSeize[0]);
                    E = new POINT2(ptsSeize[1]);
                    ptsArc[0] = new POINT2(pt0);
                    ptsArc[1] = new POINT2(E);
                    lineutility.ArcArrayDouble(ptsArc, 0, dRadius, lineType, null);
                    for (j = 0; j < 26; ++j) {
                        ptsArc[j].style = 0;
                        pLinePoints[j] = new POINT2(ptsArc[j]);
                        pLinePoints[j].style = 0;
                    }
                    if (changeArc) {
                        lineutility.GetArrowHead4Double(ptsArc[1], pt0, (int)d / 7, (int)d / 7, pArrowPoints, 5);
                    } else {
                        lineutility.GetArrowHead4Double(ptsArc[24], pt1, (int)d / 7, (int)d / 7, pArrowPoints, 5);
                    }
                    pLinePoints[25].style = 5;
                    for (j = 26; j < 29; ++j) {
                        pLinePoints[j] = new POINT2(pArrowPoints[j - 26]);
                        pLinePoints[j].style = 9;
                    }
                    pLinePoints[28].style = 10;
                    break;
                }
                case 211900000: {
                    for (j = 26; j < 29; ++j) {
                        pLinePoints[j] = new POINT2(pArrowPoints[j - 26]);
                        pLinePoints[j].style = 0;
                    }
                    pLinePoints[28].style = 5;
                    k = 29;
                    for (j = 1; j < 24; ++j) {
                        pLinePoints[k] = new POINT2(ptsArc[j]);
                        pLinePoints[k].style = 0;
                        pLinePoints[++k] = lineutility.ExtendLineDouble(pt0, ptsArc[j], (long)d / 7L);
                        pLinePoints[k].style = 5;
                        ++k;
                    }
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetIsolatePointsDouble", new RendererException("GetIsolatePointsDouble " + Integer.toString(lineType), exc));
        }
    }

    private static POINT2 getDummyHat(POINT2[] pLinePoints) {
        POINT2 pt = null;
        try {
            int j = 0;
            double minY = Double.MAX_VALUE;
            double minX = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            int index = -1;
            for (j = 0; j < pLinePoints.length - 3; ++j) {
                if (pLinePoints[j].y < minY) {
                    minY = pLinePoints[j].y;
                    index = j;
                }
                if (pLinePoints[j].x < minX) {
                    minX = pLinePoints[j].x;
                }
                if (!(pLinePoints[j].x > maxX)) continue;
                maxX = pLinePoints[j].x;
            }
            pt = new POINT2(pLinePoints[index]);
            double deltaMaxX = 0.0;
            double deltaMinX = 0.0;
            if (pt.x + 25.0 > maxX) {
                deltaMaxX = pt.x + 25.0 - maxX;
                pt.x -= deltaMaxX;
            }
            if (pt.x - 25.0 < minX) {
                deltaMinX = minX - (pt.x - 25.0);
                pt.x += deltaMinX;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getDummyHat", new RendererException("getDummyHat", exc));
        }
        return pt;
    }

    private static void AreaWithCenterFeatureDouble(POINT2[] pLinePoints, int vblCounter, int lineType) {
        try {
            double d;
            int k = 0;
            POINT2 ptCenter = new POINT2();
            int fLength = 4;
            if (lineType == 221311000) {
                fLength = 5;
            }
            if ((d = lineutility.MBRDistance(pLinePoints, vblCounter - fLength)) > 350.0) {
                d = 350.0;
            }
            for (k = 0; k < vblCounter; ++k) {
                pLinePoints[k].style = 0;
            }
            switch (lineType) {
                case 0x222248: {
                    if (d < 20.0) {
                        d = 20.0;
                    }
                    if (d > 60.0) {
                        d = 60.0;
                    }
                    POINT2 ul = new POINT2();
                    POINT2 lr = new POINT2();
                    lineutility.CalcMBRPoints(pLinePoints, vblCounter - 4, ul, lr);
                    POINT2 ur = new POINT2(lr);
                    ur.y = ul.y;
                    pLinePoints[vblCounter - 3] = lineutility.MidPointDouble(ur, ul, 0);
                    pLinePoints[vblCounter - 3].x -= d / 2.0;
                    pLinePoints[vblCounter - 3].y -= d / 5.0;
                    pLinePoints[vblCounter - 2] = lineutility.MidPointDouble(ur, ul, 0);
                    pLinePoints[vblCounter - 2].y -= d * 0.7;
                    pLinePoints[vblCounter - 1] = lineutility.MidPointDouble(ur, ul, 0);
                    pLinePoints[vblCounter - 1].x += d / 2.0;
                    pLinePoints[vblCounter - 1].y -= d / 5.0;
                    pLinePoints[vblCounter - 4].style = 5;
                    break;
                }
                case 221311000: {
                    if (d < 100.0) {
                        d = 100.0;
                    }
                    pLinePoints[vblCounter - 5] = new POINT2(pLinePoints[0]);
                    pLinePoints[vblCounter - 5].style = 5;
                    pLinePoints[vblCounter - 4] = lineutility.CalcCenterPointDouble(pLinePoints, vblCounter - 6);
                    pLinePoints[vblCounter - 4].x -= d / 10.0;
                    pLinePoints[vblCounter - 4].style = 0;
                    pLinePoints[vblCounter - 3] = new POINT2(pLinePoints[vblCounter - 4]);
                    pLinePoints[vblCounter - 3].x = pLinePoints[vblCounter - 4].x + d / 5.0;
                    pLinePoints[vblCounter - 3].style = 5;
                    pLinePoints[vblCounter - 2] = new POINT2(pLinePoints[vblCounter - 4]);
                    pLinePoints[vblCounter - 2].y += d / 20.0;
                    pLinePoints[vblCounter - 2].style = 0;
                    pLinePoints[vblCounter - 1] = new POINT2(pLinePoints[vblCounter - 3]);
                    pLinePoints[vblCounter - 1].y -= d / 20.0;
                    pLinePoints[vblCounter - 1].style = 0;
                    break;
                }
                case 22340000: {
                    if (d < 50.0) {
                        d = 50.0;
                    }
                    if ((long)lineType == 22340000L) {
                        for (k = 0; k < vblCounter - 4; ++k) {
                            pLinePoints[k].style = 14;
                        }
                    }
                    pLinePoints[vblCounter - 4] = new POINT2(pLinePoints[0]);
                    pLinePoints[vblCounter - 4].style = 5;
                    ptCenter = lineutility.CalcCenterPointDouble(pLinePoints, vblCounter - 4);
                    pLinePoints[vblCounter - 3].x = ptCenter.x - d / 10.0;
                    pLinePoints[vblCounter - 3].y = ptCenter.y;
                    pLinePoints[vblCounter - 3].style = 18;
                    pLinePoints[vblCounter - 2].x = ptCenter.x;
                    pLinePoints[vblCounter - 2].y = ptCenter.y - d / 10.0;
                    pLinePoints[vblCounter - 2].style = 18;
                    pLinePoints[vblCounter - 1].x = ptCenter.x + d / 10.0;
                    pLinePoints[vblCounter - 1].y = ptCenter.y;
                    break;
                }
                case 22350000: {
                    if (d < 50.0) {
                        d = 50.0;
                    }
                    pLinePoints[vblCounter - 4].style = 5;
                    ptCenter = lineutility.CalcCenterPointDouble(pLinePoints, vblCounter - 4);
                    pLinePoints[vblCounter - 3].x = ptCenter.x - d / 10.0;
                    pLinePoints[vblCounter - 3].y = ptCenter.y;
                    pLinePoints[vblCounter - 3].style = 18;
                    pLinePoints[vblCounter - 2].x = ptCenter.x;
                    pLinePoints[vblCounter - 2].y = ptCenter.y - d / 10.0;
                    pLinePoints[vblCounter - 2].style = 18;
                    pLinePoints[vblCounter - 1].x = ptCenter.x + d / 10.0;
                    pLinePoints[vblCounter - 1].y = ptCenter.y;
                    pLinePoints[vblCounter - 1].style = 5;
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AreaWithCenterFeatureDouble", new RendererException("AreaWithCenterFeatureDouble " + Integer.toString(lineType), exc));
        }
    }

    private static int GetATWallPointsDouble(POINT2[] pLinePoints, int lineType, int vblSaveCounter) {
        int nCounter = 0;
        try {
            int j = 0;
            int k = 0;
            int lCount = 0;
            double dLengthSegment = 0.0;
            double dIncrement = 0.0;
            POINT2[] pSpikePoints = null;
            double dRemainder = 0.0;
            double dSpikeSize = 0.0;
            int limit = 0;
            lCount = countsupport.GetFORTLCountDouble(pLinePoints, lineType, vblSaveCounter);
            pSpikePoints = new POINT2[lCount];
            switch (lineType) {
                case 31131200: 
                case 31131300: {
                    pSpikePoints[nCounter] = pLinePoints[0];
                    pSpikePoints[nCounter].style = 0;
                    ++nCounter;
                    break;
                }
            }
            for (j = 0; j < vblSaveCounter - 1; ++j) {
                dLengthSegment = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                switch (lineType) {
                    case 31131000: 
                    case 31131100: 
                    case 31131200: 
                    case 31131300: {
                        dIncrement = 60.0;
                        dSpikeSize = 20.0;
                        dRemainder = dLengthSegment / dIncrement - (double)((int)(dLengthSegment / dIncrement));
                        if (dRemainder < 0.75) {
                            limit = (int)(dLengthSegment / dIncrement);
                            break;
                        }
                        limit = (int)(dLengthSegment / dIncrement) + 1;
                        break;
                    }
                    default: {
                        dIncrement = 20.0;
                        dSpikeSize = 10.0;
                        limit = (int)(dLengthSegment / dIncrement) - 1;
                    }
                }
                if (limit < 1) {
                    pSpikePoints[nCounter] = pLinePoints[j];
                    pSpikePoints[++nCounter] = pLinePoints[j + 1];
                    ++nCounter;
                    continue;
                }
                for (k = 0; k < limit; ++k) {
                    switch (lineType) {
                        case 31131200: {
                            if (k > 0) {
                                pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement + 45.0, 0);
                                pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement + 4.0, 5);
                                pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - 1.0, 20);
                                pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - 7.0, 0);
                                break;
                            }
                            pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - 45.0, 0);
                            break;
                        }
                        case 31131300: {
                            if (k > 0) {
                                pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement + 45.0, 0);
                                pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement + 10.0, 5);
                                pSpikePoints[++nCounter] = lineutility.ExtendAlongLineDouble(pSpikePoints[nCounter - 1], pLinePoints[j + 1], 5.0, 0);
                                pSpikePoints[++nCounter] = lineutility.ExtendAlongLineDouble(pSpikePoints[nCounter - 1], pLinePoints[j + 1], 10.0, 5);
                                POINT2 crossPt1 = lineutility.ExtendDirectedLine(pSpikePoints[++nCounter - 2], pSpikePoints[nCounter - 1], pSpikePoints[nCounter - 1], 2, 5.0, 0);
                                POINT2 crossPt2 = lineutility.ExtendDirectedLine(pSpikePoints[nCounter - 1], pSpikePoints[nCounter - 2], pSpikePoints[nCounter - 2], 3, 5.0, 5);
                                pSpikePoints[nCounter] = crossPt1;
                                pSpikePoints[++nCounter] = crossPt2;
                                pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - 13.0, 0);
                                break;
                            }
                            pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - 45.0, 0);
                            break;
                        }
                        default: {
                            pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - 30.0, 0);
                        }
                    }
                    if (lineType == 31131000) {
                        pSpikePoints[nCounter].style = 0;
                    }
                    pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement - dSpikeSize, 0);
                    if (lineType == 31131000 || lineType == 31131200 || lineType == 31131300) {
                        pSpikePoints[nCounter].style = 9;
                    }
                    POINT2 pt0 = lineutility.ExtendLineDouble(pLinePoints[j], pSpikePoints[++nCounter - 1], dSpikeSize / 2.0);
                    if (pLinePoints[j].x > pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pSpikePoints[nCounter - 1], pt0, 2, dSpikeSize);
                    }
                    if (pLinePoints[j].x < pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = lineutility.ExtendDirectedLine(pLinePoints[j], pSpikePoints[nCounter - 1], pt0, 3, dSpikeSize);
                    }
                    if (pLinePoints[j].x == pLinePoints[j + 1].x) {
                        pSpikePoints[nCounter] = pt0;
                        pSpikePoints[nCounter].x = pLinePoints[j].y < pLinePoints[j + 1].y ? pt0.x - dSpikeSize : pt0.x + dSpikeSize;
                    }
                    ++nCounter;
                    if (lineType == 31131000 || lineType == 31131200 || lineType == 31131300) {
                        pSpikePoints[nCounter - 1].style = 9;
                    }
                    pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nCounter - 2], dSpikeSize, 0);
                    switch (lineType) {
                        case 31131000: {
                            pSpikePoints[nCounter].style = 10;
                            break;
                        }
                        case 31131200: 
                        case 31131300: {
                            pSpikePoints[nCounter].style = 10;
                            pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j], pSpikePoints[nCounter - 3], dSpikeSize, 0);
                            break;
                        }
                    }
                    ++nCounter;
                }
                pSpikePoints[nCounter] = pLinePoints[j + 1];
                pSpikePoints[nCounter].style = 0;
                ++nCounter;
            }
            for (j = 0; j < nCounter; ++j) {
                pLinePoints[j] = pSpikePoints[j];
            }
            pLinePoints[nCounter - 1].style = 5;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetATWallPointsDouble", new RendererException("GetATWallPointsDouble " + Integer.toString(lineType), exc));
        }
        return nCounter;
    }

    private static int GetRidgePointsDouble(POINT2[] pLinePoints, int lineType, int vblSaveCounter) {
        int nCounter = 0;
        try {
            int j = 0;
            int k = 0;
            int lCount = 0;
            double dLengthSegment = 0.0;
            double dIncrement = 20.0;
            ref<double[]> m = new ref<double[]>();
            POINT2[] pSpikePoints = null;
            double dSpikeSize = 20.0;
            int limit = 0;
            double d = 0.0;
            int bolVertical = 0;
            m.value = new double[1];
            lCount = countsupport.GetFORTLCountDouble(pLinePoints, lineType, vblSaveCounter);
            pSpikePoints = new POINT2[lCount];
            lineutility.InitializePOINT2Array(pSpikePoints);
            for (j = 0; j < vblSaveCounter - 1; ++j) {
                bolVertical = lineutility.CalcTrueSlopeDouble(pLinePoints[j], pLinePoints[j + 1], m);
                dLengthSegment = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                limit = (int)(dLengthSegment / dIncrement);
                if (limit < 1) {
                    pSpikePoints[nCounter] = new POINT2(pLinePoints[j]);
                    pSpikePoints[++nCounter] = new POINT2(pLinePoints[j + 1]);
                    ++nCounter;
                    continue;
                }
                for (k = 0; k < limit; ++k) {
                    pSpikePoints[nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], (double)(-k) * dIncrement, 0);
                    d = lineutility.CalcDistanceDouble(pLinePoints[j], pSpikePoints[++nCounter - 1]);
                    POINT2 pt0 = lineutility.ExtendLineDouble(pLinePoints[j + 1], pLinePoints[j], -d - dSpikeSize / 2.0);
                    pSpikePoints[nCounter] = bolVertical != 0 ? (pLinePoints[j].x < pLinePoints[j + 1].x ? lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 2, dSpikeSize) : lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 3, dSpikeSize)) : (pLinePoints[j + 1].y < pLinePoints[j].y ? lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 0, dSpikeSize) : lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], pt0, 1, dSpikeSize));
                    pSpikePoints[++nCounter] = lineutility.ExtendLine2Double(pLinePoints[j + 1], pLinePoints[j], -d - dSpikeSize, 0);
                    ++nCounter;
                }
                pSpikePoints[nCounter] = new POINT2(pLinePoints[j + 1]);
                ++nCounter;
            }
            for (j = 0; j < nCounter; ++j) {
                pLinePoints[j] = new POINT2(pSpikePoints[j]);
            }
            for (j = nCounter; j < lCount; ++j) {
                pLinePoints[j] = new POINT2(pSpikePoints[nCounter - 1]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetRidgePointsDouble", new RendererException("GetRidgePointsDouble " + Integer.toString(lineType), exc));
        }
        return nCounter;
    }

    protected static int GetSquallDouble(POINT2[] pLinePoints, int amplitude, int quantity, int length, int numPoints) {
        int counter = 0;
        try {
            int j = 0;
            int k = 0;
            POINT2 savePoint1 = new POINT2(pLinePoints[0]);
            POINT2 savePoint2 = new POINT2(pLinePoints[numPoints - 1]);
            ref<int[]> sign = new ref<int[]>();
            int segQty = 0;
            int totalQty = countsupport.GetSquallQty(pLinePoints, quantity, length, numPoints);
            POINT2[] pSquallPts = new POINT2[totalQty];
            POINT2[] pSquallSegPts = null;
            lineutility.InitializePOINT2Array(pSquallPts);
            sign.value = new int[1];
            ((int[])sign.value)[0] = -1;
            if (totalQty == 0) {
                return 0;
            }
            for (j = 0; j < numPoints - 1; ++j) {
                POINT2 StartSegPt = new POINT2(pLinePoints[j]);
                POINT2 EndSegPt = new POINT2(pLinePoints[j + 1]);
                segQty = countsupport.GetSquallSegQty(StartSegPt, EndSegPt, quantity, length);
                if (segQty <= 0) {
                    pSquallPts[counter].x = StartSegPt.x;
                    pSquallPts[counter++].y = StartSegPt.y;
                    pSquallPts[counter].x = EndSegPt.x;
                    pSquallPts[counter++].y = EndSegPt.y;
                    continue;
                }
                pSquallSegPts = new POINT2[segQty];
                lineutility.InitializePOINT2Array(pSquallSegPts);
                ((int[])sign.value)[0] = -1;
                lineutility.GetSquallSegment(StartSegPt, EndSegPt, pSquallSegPts, sign, amplitude, quantity, length);
                for (k = 0; k < segQty; ++k) {
                    pSquallPts[counter].x = pSquallSegPts[k].x;
                    pSquallPts[counter].y = pSquallSegPts[k].y;
                    if (k == 0) {
                        pSquallPts[counter] = new POINT2(pLinePoints[j]);
                    }
                    if (k == segQty - 1) {
                        pSquallPts[counter] = new POINT2(pLinePoints[j + 1]);
                    }
                    pSquallPts[counter].style = 0;
                    ++counter;
                }
            }
            for (j = 0; j < counter; ++j) {
                if (j >= totalQty) continue;
                pLinePoints[j].x = pSquallPts[j].x;
                pLinePoints[j].y = pSquallPts[j].y;
                if (j == 0) {
                    pLinePoints[j] = new POINT2(savePoint1);
                }
                if (j == counter - 1) {
                    pLinePoints[j] = new POINT2(savePoint2);
                }
                pLinePoints[j].style = pSquallPts[j].style;
            }
            if (counter == 0) {
                for (j = 0; j < pLinePoints.length; ++j) {
                    pLinePoints[j] = j == 0 ? new POINT2(savePoint1) : new POINT2(savePoint2);
                }
                counter = pLinePoints.length;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSquallDouble", new RendererException("GetSquallDouble", exc));
        }
        return counter;
    }

    protected static int GetSevereSquall(POINT2[] pLinePoints, int numPoints) {
        int l = 0;
        try {
            int quantity = 5;
            int length = 30;
            int j = 0;
            int k = 0;
            int totalQty = countsupport.GetSquallQty(pLinePoints, quantity, length, numPoints) + 2 * numPoints;
            POINT2[] squallPts = new POINT2[totalQty];
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            POINT2 pt3 = new POINT2();
            POINT2 pt4 = new POINT2();
            POINT2 pt5 = new POINT2();
            POINT2 pt6 = new POINT2();
            POINT2 pt7 = new POINT2();
            POINT2 pt8 = new POINT2();
            int segQty = 0;
            double dist = 0.0;
            lineutility.InitializePOINT2Array(squallPts);
            for (j = 0; j < numPoints - 1; ++j) {
                dist = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                segQty = (int)(dist / 30.0);
                for (k = 0; k < segQty; ++k) {
                    pt0 = lineutility.ExtendAlongLineDouble(pLinePoints[j], pLinePoints[j + 1], k * 30);
                    pt1 = lineutility.ExtendAlongLineDouble(pLinePoints[j], pLinePoints[j + 1], k * 30 + 20);
                    pt5 = lineutility.ExtendAlongLineDouble(pLinePoints[j], pLinePoints[j + 1], k * 30 + 25);
                    pt6 = lineutility.ExtendAlongLineDouble(pLinePoints[j], pLinePoints[j + 1], k * 30 + 30);
                    pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 2, 5.0, 0);
                    pt3 = lineutility.ExtendDirectedLine(pt0, pt5, pt5, 3, 5.0, 0);
                    pt4 = lineutility.ExtendDirectedLine(pt0, pt6, pt6, 2, 5.0, 5);
                    pt4.style = 5;
                    squallPts[l++] = new POINT2(pt2);
                    squallPts[l++] = new POINT2(pt3);
                    squallPts[l++] = new POINT2(pt4);
                    pt7 = lineutility.ExtendAlongLineDouble(pLinePoints[j], pLinePoints[j + 1], k * 30 + 5);
                    pt8 = lineutility.ExtendAlongLineDouble(pLinePoints[j], pLinePoints[j + 1], k * 30 + 10);
                    pt8.style = 5;
                    squallPts[l++] = new POINT2(pt7);
                    squallPts[l++] = new POINT2(pt8);
                }
                squallPts[l++] = new POINT2(pLinePoints[j + 1]);
                pt0 = lineutility.ExtendAlongLineDouble(pLinePoints[j + 1], pLinePoints[j], 5.0);
                pt0.style = 5;
                squallPts[l++] = new POINT2(pt0);
            }
            if (l > pLinePoints.length) {
                l = pLinePoints.length;
            }
            for (j = 0; j < l && j < totalQty; ++j) {
                pLinePoints[j] = new POINT2(squallPts[j]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSevereSquall", new RendererException("GetSevereSquall", exc));
        }
        return l;
    }

    private static int GetConvergancePointsDouble(POINT2[] pLinePoints, int vblCounter) {
        int counter = vblCounter;
        try {
            int j = 0;
            int k = 0;
            double d = 0.0;
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2[] tempPts = new POINT2[vblCounter];
            POINT2 tempPt = new POINT2();
            int numJags = 0;
            for (j = 0; j < vblCounter; ++j) {
                tempPts[j] = new POINT2(pLinePoints[j]);
            }
            pLinePoints[vblCounter - 1].style = 5;
            for (j = 0; j < vblCounter - 1; ++j) {
                pt0 = new POINT2(tempPts[j]);
                pt1 = new POINT2(tempPts[j + 1]);
                d = lineutility.CalcDistanceDouble(pt0, pt1);
                if (d - (double)((numJags = (int)(d / 10.0)) * 10) < 5.0) {
                    --numJags;
                }
                for (k = 0; k < numJags; ++k) {
                    tempPt = lineutility.ExtendAlongLineDouble(pt0, pt1, k * 10 + 5, 0);
                    pLinePoints[counter++] = new POINT2(tempPt);
                    tempPt = lineutility.ExtendAlongLineDouble(tempPt, pt1, 5.0);
                    tempPt = lineutility.ExtendDirectedLine(pt0, tempPt, tempPt, 2, 5.0, 5);
                    pLinePoints[counter++] = new POINT2(tempPt);
                    tempPt = lineutility.ExtendAlongLineDouble(pt0, pt1, (k + 1) * 10, 0);
                    pLinePoints[counter++] = new POINT2(tempPt);
                    tempPt = lineutility.ExtendAlongLineDouble(tempPt, pt1, 5.0);
                    tempPt = lineutility.ExtendDirectedLine(pt0, tempPt, tempPt, 3, 5.0, 5);
                    pLinePoints[counter++] = new POINT2(tempPt);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetConvergancePointsDouble", new RendererException("GetConvergancePointsDouble", exc));
        }
        return counter;
    }

    private static int GetITDPointsDouble(POINT2[] pLinePoints, int vblCounter) {
        int counter = 0;
        try {
            int j = 0;
            int k = 0;
            double d = 0.0;
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2[] tempPts = new POINT2[vblCounter];
            POINT2 tempPt = new POINT2();
            int numJags = 0;
            int lineStyle = 19;
            for (j = 0; j < vblCounter; ++j) {
                tempPts[j] = new POINT2(pLinePoints[j]);
            }
            for (j = 0; j < vblCounter - 1; ++j) {
                pt0 = new POINT2(tempPts[j]);
                pt1 = new POINT2(tempPts[j + 1]);
                d = lineutility.CalcDistanceDouble(pt0, pt1);
                if (d - (double)((numJags = (int)(d / 15.0)) * 10) < 5.0) {
                    --numJags;
                }
                if (numJags == 0) {
                    pt0.style = 19;
                    pLinePoints[counter++] = new POINT2(pt0);
                    pt1.style = 5;
                    pLinePoints[counter++] = new POINT2(pt1);
                }
                for (k = 0; k < numJags; ++k) {
                    tempPt = lineutility.ExtendAlongLineDouble(pt0, pt1, k * 15 + 5, lineStyle);
                    pLinePoints[counter++] = new POINT2(tempPt);
                    if (k < numJags - 1) {
                        tempPt = lineutility.ExtendAlongLineDouble(tempPt, pt1, 10.0, 5);
                    } else {
                        tempPt = new POINT2(tempPts[j + 1]);
                        tempPt.style = 5;
                    }
                    pLinePoints[counter++] = new POINT2(tempPt);
                    lineStyle = lineStyle == 19 ? 25 : 19;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetITDPointsDouble", new RendererException("GetITDPointsDouble", exc));
        }
        return counter;
    }

    private static int GetXPoints(int linetype, POINT2[] pOriginalLinePoints, POINT2[] XPoints, int vblCounter) {
        int xCounter = 0;
        try {
            int j = 0;
            int k = 0;
            double d = 0.0;
            POINT2 pt3 = new POINT2();
            POINT2 pt4 = new POINT2();
            POINT2 pt5 = new POINT2();
            POINT2 pt6 = new POINT2();
            int numThisSegment = 0;
            double distInterval = 0.0;
            for (j = 0; j < vblCounter - 1; ++j) {
                d = lineutility.CalcDistanceDouble(pOriginalLinePoints[j], pOriginalLinePoints[j + 1]);
                numThisSegment = (int)((d - 20.0) / 20.0);
                if (linetype == 32153000) {
                    numThisSegment = (int)((d - 30.0) / 30.0);
                }
                distInterval = d / (double)numThisSegment;
                for (k = 0; k < numThisSegment; ++k) {
                    POINT2 pt0 = lineutility.ExtendAlongLineDouble2(pOriginalLinePoints[j], pOriginalLinePoints[j + 1], distInterval / 2.0 + distInterval * (double)k);
                    POINT2 pt1 = lineutility.ExtendAlongLineDouble2(pt0, pOriginalLinePoints[j + 1], 5.0);
                    POINT2 pt2 = lineutility.ExtendAlongLineDouble2(pt0, pOriginalLinePoints[j + 1], -5.0);
                    pt3 = lineutility.ExtendDirectedLine(pOriginalLinePoints[j], pt1, pt1, 2, 5.0);
                    pt4 = lineutility.ExtendDirectedLine(pOriginalLinePoints[j], pt1, pt1, 3, 5.0);
                    pt4.style = 5;
                    pt5 = lineutility.ExtendDirectedLine(pOriginalLinePoints[j], pt2, pt2, 2, 5.0);
                    pt6 = lineutility.ExtendDirectedLine(pOriginalLinePoints[j], pt2, pt2, 3, 5.0);
                    pt6.style = 5;
                    XPoints[xCounter++] = new POINT2(pt3);
                    XPoints[xCounter++] = new POINT2(pt6);
                    XPoints[xCounter++] = new POINT2(pt5);
                    XPoints[xCounter++] = new POINT2(pt4);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetXPointsDouble", new RendererException("GetXPointsDouble", exc));
        }
        return xCounter;
    }

    private static POINT2[] getEllipsePoints(POINT2 ptCenter, POINT2 ptWidth, POINT2 ptHeight) {
        POINT2[] pEllipsePoints = null;
        try {
            pEllipsePoints = new POINT2[37];
            int l = 0;
            double dFactor = 0.0;
            double a = lineutility.CalcDistanceDouble(ptCenter, ptWidth);
            double b = lineutility.CalcDistanceDouble(ptCenter, ptHeight);
            lineutility.InitializePOINT2Array(pEllipsePoints);
            for (l = 1; l < 37; ++l) {
                dFactor = 10.0 * (double)l * Math.PI / 180.0;
                pEllipsePoints[l - 1].x = ptCenter.x + (double)((int)(a * Math.cos(dFactor)));
                pEllipsePoints[l - 1].y = ptCenter.y + (double)((int)(b * Math.sin(dFactor)));
                pEllipsePoints[l - 1].style = 0;
            }
            pEllipsePoints[36] = new POINT2(pEllipsePoints[0]);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetEllipsePoints", new RendererException("GetEllipsePoints", exc));
        }
        return pEllipsePoints;
    }

    private static POINT2[] getRotatedEllipsePoints(POINT2 ptCenter, POINT2 ptWidth, POINT2 ptHeight, double azimuth, int lineType) {
        POINT2[] pResultPoints = null;
        try {
            POINT2[] pEllipsePoints = new POINT2[36];
            int l = 0;
            int j = 0;
            double dFactor = 0.0;
            double a = lineutility.CalcDistanceDouble(ptCenter, ptWidth);
            double b = lineutility.CalcDistanceDouble(ptCenter, ptHeight);
            lineutility.InitializePOINT2Array(pEllipsePoints);
            for (l = 1; l < 37; ++l) {
                dFactor = 10.0 * (double)l * Math.PI / 180.0;
                pEllipsePoints[l - 1].x = ptCenter.x + a * Math.cos(dFactor);
                pEllipsePoints[l - 1].y = ptCenter.y + b * Math.sin(dFactor);
                pEllipsePoints[l - 1].style = 0;
            }
            if (lineType != 13000002) {
                lineutility.RotateGeometryDouble(pEllipsePoints, 36, azimuth - 90.0);
            }
            pResultPoints = new POINT2[37];
            for (j = 0; j < 36; ++j) {
                pResultPoints[j] = pEllipsePoints[j];
            }
            pResultPoints[36] = pEllipsePoints[0];
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetRotatedEllipsePoints", new RendererException("GetRotatedEllipsePoints", exc));
        }
        return pResultPoints;
    }

    private static int GetLVOPoints(int linetype, POINT2[] pOriginalLinePoints, POINT2[] pLinePoints, int vblCounter) {
        int lEllipseCounter = 0;
        try {
            double dAngle = 0.0;
            double d = 0.0;
            double a = 4.0;
            double b = 8.0;
            double dFactor = 0.0;
            int lHowManyThisSegment = 0;
            int j = 0;
            int k = 0;
            int l = 0;
            boolean t = false;
            POINT2 ptCenter = new POINT2();
            POINT2[] pEllipsePoints2 = new POINT2[37];
            double distInterval = 0.0;
            for (j = 0; j < vblCounter - 1; ++j) {
                lineutility.InitializePOINT2Array(pEllipsePoints2);
                d = lineutility.CalcDistanceDouble(pOriginalLinePoints[j], pOriginalLinePoints[j + 1]);
                lHowManyThisSegment = (int)((d - 20.0) / 20.0);
                if (linetype == 32153000) {
                    lHowManyThisSegment = (int)((d - 30.0) / 30.0);
                }
                distInterval = d / (double)lHowManyThisSegment;
                dAngle = lineutility.CalcSegmentAngleDouble(pOriginalLinePoints[j], pOriginalLinePoints[j + 1]);
                dAngle += 1.5707963267948966;
                for (k = 0; k < lHowManyThisSegment; ++k) {
                    ptCenter = lineutility.ExtendAlongLineDouble2(pOriginalLinePoints[j], pOriginalLinePoints[j + 1], (double)k * distInterval);
                    for (l = 1; l < 37; ++l) {
                        dFactor = 20.0 * (double)l * Math.PI / 180.0;
                        pEllipsePoints2[l - 1].x = ptCenter.x + (double)((int)(a * Math.cos(dFactor)));
                        pEllipsePoints2[l - 1].y = ptCenter.y + (double)((int)(b * Math.sin(dFactor)));
                        pEllipsePoints2[l - 1].style = 0;
                    }
                    lineutility.RotateGeometryDouble(pEllipsePoints2, 36, (int)(dAngle * 180.0 / Math.PI));
                    pEllipsePoints2[36] = new POINT2(pEllipsePoints2[35]);
                    pEllipsePoints2[36].style = 5;
                    for (l = 0; l < 37; ++l) {
                        pLinePoints[lEllipseCounter] = new POINT2(pEllipsePoints2[l]);
                        ++lEllipseCounter;
                    }
                }
                if (j != vblCounter - 2) continue;
                ptCenter = pOriginalLinePoints[j + 1];
                for (l = 1; l < 37; ++l) {
                    dFactor = 20.0 * (double)l * Math.PI / 180.0;
                    pEllipsePoints2[l - 1].x = ptCenter.x + (double)((int)(a * Math.cos(dFactor)));
                    pEllipsePoints2[l - 1].y = ptCenter.y + (double)((int)(b * Math.sin(dFactor)));
                    pEllipsePoints2[l - 1].style = 0;
                }
                lineutility.RotateGeometryDouble(pEllipsePoints2, 36, (int)(dAngle * 180.0 / Math.PI));
                pEllipsePoints2[36] = new POINT2(pEllipsePoints2[35]);
                pEllipsePoints2[36].style = 5;
                for (l = 0; l < 37; ++l) {
                    pLinePoints[lEllipseCounter] = new POINT2(pEllipsePoints2[l]);
                    ++lEllipseCounter;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetLVOPointsDouble", new RendererException("GetLVOPointsDouble", exc));
        }
        return lEllipseCounter;
    }

    private static int GetIcingPointsDouble(POINT2[] pLinePoints, int vblCounter) {
        int counter = 0;
        try {
            int j = 0;
            POINT2[] origPoints = new POINT2[vblCounter];
            int nDirection = -1;
            int k = 0;
            int numSegments = 0;
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 midPt = new POINT2();
            POINT2 pt2 = new POINT2();
            for (j = 0; j < vblCounter; ++j) {
                origPoints[j] = new POINT2(pLinePoints[j]);
            }
            double distInterval = 0.0;
            for (j = 0; j < vblCounter - 1; ++j) {
                numSegments = (int)lineutility.CalcDistanceDouble(origPoints[j], origPoints[j + 1]);
                distInterval = lineutility.CalcDistanceDouble(origPoints[j], origPoints[j + 1]) / (double)(numSegments /= 15);
                nDirection = arraysupport.GetInsideOutsideDouble2(origPoints[j], origPoints[j + 1], origPoints, vblCounter, j, 31740000);
                for (k = 0; k < numSegments; ++k) {
                    pt0 = k == 0 ? new POINT2(origPoints[j]) : lineutility.ExtendAlongLineDouble(origPoints[j], origPoints[j + 1], (double)k * distInterval, 0);
                    pt1 = lineutility.ExtendAlongLineDouble(origPoints[j], origPoints[j + 1], (double)k * distInterval + 10.0, 5);
                    midPt = lineutility.ExtendAlongLineDouble(origPoints[j], origPoints[j + 1], (double)k * distInterval + 5.0, 0);
                    pt2 = lineutility.ExtendDirectedLine(origPoints[j], origPoints[j + 1], midPt, nDirection, 5.0, 5);
                    pLinePoints[counter] = new POINT2(pt0);
                    pLinePoints[counter + 1] = new POINT2(pt1);
                    pLinePoints[counter + 2] = new POINT2(midPt);
                    pLinePoints[counter + 3] = new POINT2(pt2);
                    counter += 4;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetIcingPointsDouble", new RendererException("GetIcingPointsDouble", exc));
        }
        return counter;
    }

    protected static int GetAnchorageDouble(POINT2[] vbPoints2, int numPts) {
        int lFlotCounter = 0;
        try {
            int j = 0;
            int k = 0;
            int l = 0;
            int x1 = 0;
            int y1 = 0;
            int numSegPts = -1;
            int lFlotCount = 0;
            int lNumSegs = 0;
            double dDistance = 0.0;
            int[] vbPoints = null;
            int[] points = null;
            int[] points2 = null;
            POINT2 pt = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            lFlotCount = flot.GetAnchorageCountDouble(vbPoints2, numPts);
            vbPoints = new int[2 * numPts];
            for (j = 0; j < numPts; ++j) {
                vbPoints[k] = (int)vbPoints2[j].x;
                vbPoints[++k] = (int)vbPoints2[j].y;
                ++k;
            }
            k = 0;
            ref<int[]> bFlip = new ref<int[]>();
            bFlip.value = new int[1];
            ref<int[]> lDirection = new ref<int[]>();
            lDirection.value = new int[1];
            ref<int[]> lLastDirection = new ref<int[]>();
            lLastDirection.value = new int[1];
            for (l = 0; l < numPts - 1; ++l) {
                pt1.x = vbPoints[2 * l];
                pt1.y = vbPoints[2 * l + 1];
                pt2.x = vbPoints[2 * l + 2];
                pt2.y = vbPoints[2 * l + 3];
                if (l > 0) {
                    pt1 = lineutility.ExtendAlongLineDouble(pt1, pt2, 20.0);
                }
                if ((lNumSegs = (int)((dDistance = lineutility.CalcDistanceDouble(pt1, pt2)) / 20.0)) > 0) {
                    points2 = new int[lNumSegs * 32];
                    numSegPts = flot.GetAnchorageFlotSegment(vbPoints, (int)pt1.x, (int)pt1.y, (int)pt2.x, (int)pt2.y, l, points2, bFlip, lDirection, lLastDirection);
                    points = new int[numSegPts];
                    for (j = 0; j < numSegPts; ++j) {
                        points[j] = points2[j];
                    }
                    for (j = 0; j < numSegPts / 3; ++j) {
                        x1 = points[k];
                        y1 = points[k + 1];
                        k += 3;
                        if (j % 10 == 0) {
                            pt.x = x1;
                            pt.y = y1;
                            pt.style = 5;
                        } else if ((j + 1) % 10 == 0) {
                            if (lFlotCounter >= lFlotCount) break;
                            vbPoints2[lFlotCounter].x = x1;
                            vbPoints2[lFlotCounter++].y = y1;
                            vbPoints2[lFlotCounter++] = new POINT2(pt);
                            continue;
                        }
                        if (lFlotCounter >= lFlotCount) break;
                        vbPoints2[lFlotCounter].x = x1;
                        vbPoints2[lFlotCounter].y = y1;
                        ++lFlotCounter;
                    }
                    k = 0;
                    points = null;
                    continue;
                }
                if (lFlotCounter >= lFlotCount) continue;
                vbPoints2[lFlotCounter].x = vbPoints[2 * l];
                vbPoints2[lFlotCounter].y = vbPoints[2 * l + 1];
                ++lFlotCounter;
            }
            for (j = lFlotCounter - 1; j < lFlotCount; ++j) {
                vbPoints2[j].style = 5;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetAnchorageDouble", new RendererException("GetAnchorageDouble", exc));
        }
        return lFlotCounter;
    }

    private static int GetPipePoints(POINT2[] pLinePoints, int vblCounter) {
        int counter = 0;
        try {
            POINT2[] pOriginalPoints = new POINT2[vblCounter];
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            POINT2[] xPoints = new POINT2[pLinePoints.length];
            int xCounter = 0;
            int j = 0;
            int k = 0;
            for (j = 0; j < vblCounter; ++j) {
                pOriginalPoints[j] = new POINT2(pLinePoints[j]);
            }
            int numSegs = 0;
            double d = 0.0;
            lineutility.InitializePOINT2Array(xPoints);
            for (j = 0; j < vblCounter - 1; ++j) {
                d = lineutility.CalcDistanceDouble(pOriginalPoints[j], pOriginalPoints[j + 1]);
                numSegs = (int)(d / 20.0);
                for (k = 0; k < numSegs; ++k) {
                    pt0 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], 20 * k);
                    pt0.style = 0;
                    pt1 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], 20 * k + 10);
                    pt1.style = 5;
                    pt2 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], 20 * k + 10);
                    pt2.style = 20;
                    pLinePoints[counter++] = new POINT2(pt0);
                    pLinePoints[counter++] = new POINT2(pt1);
                    xPoints[xCounter++] = new POINT2(pt2);
                }
                if (numSegs == 0) {
                    pLinePoints[counter] = new POINT2(pOriginalPoints[j]);
                    pLinePoints[counter++].style = 0;
                    pLinePoints[counter] = new POINT2(pOriginalPoints[j + 1]);
                    pLinePoints[counter++].style = 5;
                    continue;
                }
                pLinePoints[counter] = new POINT2(pLinePoints[counter - 1]);
                pLinePoints[counter++].style = 0;
                pLinePoints[counter] = new POINT2(pOriginalPoints[j + 1]);
                pLinePoints[counter++].style = 5;
            }
            for (k = 0; k < xCounter; ++k) {
                pLinePoints[counter++] = new POINT2(xPoints[k]);
            }
            pLinePoints[counter++] = new POINT2(pLinePoints[counter]);
            pOriginalPoints = null;
            xPoints = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetPipePoints", new RendererException("GetPipePoints", exc));
        }
        return counter;
    }

    private static int GetReefPoints(POINT2[] pLinePoints, int vblCounter) {
        int counter = 0;
        try {
            POINT2[] pOriginalPoints = new POINT2[vblCounter];
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            POINT2 pt3 = new POINT2();
            POINT2 pt4 = new POINT2();
            for (int j = 0; j < vblCounter; ++j) {
                pOriginalPoints[j] = new POINT2(pLinePoints[j]);
            }
            int numSegs = 0;
            int direction = 0;
            double d = 0.0;
            for (int j = 0; j < vblCounter - 1; ++j) {
                direction = pOriginalPoints[j].x < pOriginalPoints[j + 1].x ? 2 : 3;
                d = lineutility.CalcDistanceDouble(pOriginalPoints[j], pOriginalPoints[j + 1]);
                numSegs = (int)(d / 40.0);
                for (int k = 0; k < numSegs; ++k) {
                    pt0 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], 40 * k);
                    pt1 = lineutility.ExtendAlongLineDouble2(pt0, pOriginalPoints[j + 1], 10.0);
                    pt1 = lineutility.ExtendDirectedLine(pOriginalPoints[j], pOriginalPoints[j + 1], pt1, direction, 15.0);
                    pt2 = lineutility.ExtendAlongLineDouble2(pt0, pOriginalPoints[j + 1], 20.0);
                    pt2 = lineutility.ExtendDirectedLine(pOriginalPoints[j], pOriginalPoints[j + 1], pt2, direction, 5.0);
                    pt3 = lineutility.ExtendAlongLineDouble2(pt0, pOriginalPoints[j + 1], 30.0);
                    pt3 = lineutility.ExtendDirectedLine(pOriginalPoints[j], pOriginalPoints[j + 1], pt3, direction, 20.0);
                    pt4 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], 40 * (k + 1));
                    pLinePoints[counter++] = new POINT2(pt0);
                    pLinePoints[counter++] = new POINT2(pt1);
                    pLinePoints[counter++] = new POINT2(pt2);
                    pLinePoints[counter++] = new POINT2(pt3);
                    pLinePoints[counter++] = new POINT2(pt4);
                }
                if (numSegs != 0) continue;
                pLinePoints[counter++] = new POINT2(pOriginalPoints[j]);
                pLinePoints[counter++] = new POINT2(pOriginalPoints[j + 1]);
            }
            pLinePoints[counter++] = new POINT2(pOriginalPoints[vblCounter - 1]);
            pOriginalPoints = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetReefPoints", new RendererException("GetReefPoints", exc));
        }
        return counter;
    }

    private static int GetRestrictedAreaPoints(POINT2[] pLinePoints, int vblCounter) {
        int counter = 0;
        try {
            POINT2[] pOriginalPoints = new POINT2[vblCounter];
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            POINT2 pt3 = new POINT2();
            for (int j = 0; j < vblCounter; ++j) {
                pOriginalPoints[j] = new POINT2(pLinePoints[j]);
            }
            int direction = 0;
            int numSegs = 0;
            double d = 0.0;
            for (int j = 0; j < vblCounter - 1; ++j) {
                d = lineutility.CalcDistanceDouble(pOriginalPoints[j], pOriginalPoints[j + 1]);
                numSegs = (int)(d / 15.0);
                direction = pOriginalPoints[j].x < pOriginalPoints[j + 1].x ? 3 : 2;
                for (int k = 0; k < numSegs; ++k) {
                    pt0 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], 15 * k);
                    pt0.style = 0;
                    pt1 = lineutility.ExtendAlongLineDouble2(pOriginalPoints[j], pOriginalPoints[j + 1], 15 * k + 10);
                    pt1.style = 5;
                    pt2 = lineutility.MidPointDouble(pt0, pt1, 0);
                    pt3 = lineutility.ExtendDirectedLine(pOriginalPoints[j], pOriginalPoints[j + 1], pt2, direction, 10.0);
                    pt3.style = 5;
                    pLinePoints[counter++] = new POINT2(pt2);
                    pLinePoints[counter++] = new POINT2(pt3);
                    pLinePoints[counter++] = new POINT2(pt0);
                    pLinePoints[counter++] = new POINT2(pt1);
                }
                if (numSegs != 0) continue;
                pLinePoints[counter++] = new POINT2(pOriginalPoints[j]);
                pLinePoints[counter++] = new POINT2(pOriginalPoints[j + 1]);
            }
            pLinePoints[counter - 1].style = 0;
            pLinePoints[counter++] = new POINT2(pOriginalPoints[vblCounter - 1]);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetRestrictedAreaPoints", new RendererException("GetRestrictedAreaPoints", exc));
        }
        return counter;
    }

    private static int getOverheadWire(POINT2[] pLinePoints, int vblCounter) {
        int counter = 0;
        try {
            int j = 0;
            POINT2 pt = null;
            POINT2 pt2 = null;
            double x = 0.0;
            double y = 0.0;
            ArrayList<POINT2> pts = new ArrayList<POINT2>();
            for (j = 0; j < vblCounter; ++j) {
                pt = new POINT2(pLinePoints[j]);
                x = pt.x;
                y = pt.y;
                pt2 = new POINT2(pt);
                pt2.y -= 5.0;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x -= 5.0;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.y -= 20.0;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x += 5.0;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.y -= 5.0;
                pt2.style = 5;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x -= 2.0;
                pt2.y -= 10.0;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x += 2.0;
                pt2.y -= 10.0;
                pt2.style = 5;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x -= 7.0;
                pt2.y -= 17.0;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x -= 5.0;
                pt2.y -= 20.0;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x += 5.0;
                pt2.y -= 20.0;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x += 7.0;
                pt2.y -= 17.0;
                pt2.style = 5;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.y -= 20.0;
                pts.add(pt2);
                pt2 = new POINT2(pt);
                pt2.x += 8.0;
                pt2.y -= 12.0;
                pt2.style = 5;
                pts.add(pt2);
            }
            for (j = 0; j < vblCounter - 1; ++j) {
                pt = new POINT2(pLinePoints[j]);
                pt2 = new POINT2(pLinePoints[j + 1]);
                if (pt.x < pt2.x) {
                    pt.x += 5.0;
                    pt.y -= 10.0;
                    pt2.x -= 5.0;
                    pt2.y -= 10.0;
                    pt2.style = 5;
                } else {
                    pt.x -= 5.0;
                    pt.y -= 10.0;
                    pt2.x += 5.0;
                    pt2.y -= 10.0;
                    pt2.style = 5;
                }
                pts.add(pt);
                pts.add(pt2);
            }
            for (j = 0; j < pts.size(); ++j) {
                pLinePoints[j] = (POINT2)pts.get(j);
                ++counter;
            }
            for (j = counter; j < pLinePoints.length; ++j) {
                pLinePoints[j] = new POINT2(pLinePoints[counter - 1]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetOverheadWire", new RendererException("GetOverheadWire", exc));
        }
        return counter;
    }

    private static ArrayList<POINT2> GetLineArray2Double(int lineType, POINT2[] pLinePoints, int vblCounter, int vblSaveCounter, ArrayList<Shape2> shapes, Rectangle2D clipBounds, int rev, IPointConversion converter) {
        ArrayList<POINT2> points = new ArrayList<POINT2>();
        try {
            String client = CELineArray.getClient();
            if (pLinePoints == null || pLinePoints.length < 2) {
                return null;
            }
            Object segments = null;
            double dMRR = 0.0;
            int n = 0;
            int bolVertical = 0;
            double dExtendLength = 0.0;
            double dWidth = 0.0;
            int nQuadrant = 0;
            int lLinestyle = 0;
            int pointCounter = 0;
            ref<double[]> offsetX = new ref<double[]>();
            ref<double[]> offsetY = new ref<double[]>();
            double b = 0.0;
            double b1 = 0.0;
            double dRadius = 0.0;
            double d1 = 0.0;
            double d = 0.0;
            double d2 = 0.0;
            ref<double[]> m = new ref<double[]>();
            int direction = 0;
            int nCounter = 0;
            int j = 0;
            int k = 0;
            int middleSegment = -1;
            double dMBR = lineutility.MBRDistance(pLinePoints, vblSaveCounter);
            POINT2 pt0 = new POINT2(pLinePoints[0]);
            POINT2 pt1 = new POINT2(pLinePoints[1]);
            POINT2 pt2 = new POINT2(pLinePoints[1]);
            POINT2 pt3 = new POINT2(pLinePoints[0]);
            POINT2 pt4 = new POINT2(pLinePoints[0]);
            POINT2 pt5 = new POINT2(pLinePoints[0]);
            POINT2 pt6 = new POINT2(pLinePoints[0]);
            POINT2 pt7 = new POINT2(pLinePoints[0]);
            POINT2 pt8 = new POINT2(pLinePoints[0]);
            POINT2 ptYIntercept = new POINT2(pLinePoints[0]);
            POINT2 ptYIntercept1 = new POINT2(pLinePoints[0]);
            POINT2 ptCenter = new POINT2(pLinePoints[0]);
            POINT2[] pArrowPoints = new POINT2[3];
            POINT2[] arcPts = new POINT2[26];
            POINT2[] circlePoints = new POINT2[100];
            POINT2[] pts = null;
            POINT2[] pts2 = null;
            POINT2 midpt = new POINT2(pLinePoints[0]);
            POINT2 midpt1 = new POINT2(pLinePoints[0]);
            POINT2[] pOriginalLinePoints = null;
            POINT2[] pUpperLinePoints = null;
            POINT2[] pLowerLinePoints = null;
            POINT2[] pUpperLowerLinePoints = null;
            POINT2 calcPoint0 = new POINT2();
            POINT2 calcPoint1 = new POINT2();
            POINT2 calcPoint2 = new POINT2();
            POINT2 calcPoint3 = new POINT2();
            POINT2 calcPoint4 = new POINT2();
            POINT2 ptTemp = new POINT2(pLinePoints[0]);
            int acCounter = 0;
            POINT2[] acPoints = new POINT2[6];
            int lFlotCount = 0;
            if (vblCounter > 2) {
                pt2 = new POINT2(pLinePoints[2]);
            }
            pt0.style = 0;
            pt1.style = 0;
            pt2.style = 0;
            ArrayList xPoints = null;
            pOriginalLinePoints = new POINT2[vblSaveCounter];
            for (j = 0; j < vblSaveCounter; ++j) {
                pOriginalLinePoints[j] = new POINT2(pLinePoints[j]);
            }
            switch (lineType) {
                case 15000001: {
                    lineutility.getExteriorPoints(pLinePoints, vblSaveCounter, lineType, false);
                    acCounter = vblSaveCounter;
                    break;
                }
                case 12000000: {
                    pt0 = new POINT2(pLinePoints[0]);
                    pLinePoints[0] = new POINT2(pt0);
                    pLinePoints[0].x -= 10.0;
                    pLinePoints[1] = new POINT2(pt0);
                    pLinePoints[1].x += 10.0;
                    pLinePoints[1].style = 10;
                    pLinePoints[2] = new POINT2(pt0);
                    pLinePoints[2].y += 10.0;
                    pLinePoints[3] = new POINT2(pt0);
                    pLinePoints[3].y -= 10.0;
                    acCounter = 4;
                    break;
                }
                case 14000000: {
                    lineutility.CalcMBRPoints(pLinePoints, pLinePoints.length, pt0, pt2);
                    pt1 = new POINT2(pt0);
                    pt1.x = pt2.x;
                    pt3 = new POINT2(pt0);
                    pt3.y = pt2.y;
                    pLinePoints = new POINT2[]{new POINT2(pt0), new POINT2(pt1), new POINT2(pt2), new POINT2(pt3), new POINT2(pt0)};
                    acCounter = 5;
                    break;
                }
                case 15000003: {
                    double buffer = pLinePoints[0].style;
                    pOriginalLinePoints = new POINT2[]{new POINT2(pLinePoints[0]), new POINT2(pLinePoints[1]), new POINT2(pLinePoints[2]), new POINT2(pLinePoints[3]), new POINT2(pLinePoints[0])};
                    pt0 = pLinePoints[0];
                    pt0.x -= buffer;
                    pt0.y -= buffer;
                    pt1 = pLinePoints[1];
                    pt1.x += buffer;
                    pt1.y -= buffer;
                    pt2 = pLinePoints[2];
                    pt2.x += buffer;
                    pt2.y += buffer;
                    pt3 = pLinePoints[3];
                    pt3.x -= buffer;
                    pt3.y += buffer;
                    pLinePoints = new POINT2[]{new POINT2(pt0), new POINT2(pt1), new POINT2(pt2), new POINT2(pt3), new POINT2(pt0)};
                    vblSaveCounter = 5;
                    acCounter = 5;
                    break;
                }
                case 13000000: {
                    pt0 = pLinePoints[0];
                    pt1 = pLinePoints[1];
                    pt2 = pLinePoints[2];
                    double azimuth = pLinePoints[3].x;
                    pLinePoints = arraysupport.getRotatedEllipsePoints(pt0, pt1, pt2, azimuth, lineType);
                    acCounter = 37;
                    break;
                }
                case 13000001: 
                case 13000002: {
                    pt0 = pLinePoints[0];
                    pt1 = pLinePoints[1];
                    pt2 = pLinePoints[2];
                    double azimuth = pLinePoints[3].x;
                    pOriginalLinePoints = arraysupport.getRotatedEllipsePoints(pt0, pt1, pt2, azimuth, lineType);
                    double dist = pt0.style;
                    pt1.x += dist;
                    pt2.y -= dist;
                    pLinePoints = arraysupport.getRotatedEllipsePoints(pt0, pt1, pt2, azimuth, lineType);
                    acCounter = 37;
                    vblSaveCounter = 37;
                    break;
                }
                case 23200000: {
                    acCounter = arraysupport.getOverheadWire(pLinePoints, vblSaveCounter);
                    break;
                }
                case 23200001: {
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pLinePoints[j].style = 1;
                    }
                    for (j = vblSaveCounter; j < 2 * vblSaveCounter; ++j) {
                        pLinePoints[j] = new POINT2(pOriginalLinePoints[j - vblSaveCounter]);
                        pLinePoints[j].style = 20;
                    }
                    acCounter = pLinePoints.length;
                    break;
                }
                case 22121000: {
                    acCounter = pLinePoints.length;
                    break;
                }
                case 322510000: {
                    acCounter = vblCounter = arraysupport.GetReefPoints(pLinePoints, vblSaveCounter);
                    break;
                }
                case 32134000: {
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 5], pLinePoints[vblCounter - 4], 10, 10, pArrowPoints, 0);
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[vblCounter - 3 + j] = new POINT2(pArrowPoints[j]);
                    }
                    pLinePoints[vblCounter - 4].style = 5;
                    pLinePoints[vblCounter - 1].style = 5;
                    acCounter = vblCounter;
                    break;
                }
                case 32530000: {
                    acCounter = vblCounter = arraysupport.GetRestrictedAreaPoints(pLinePoints, vblSaveCounter);
                    break;
                }
                case 32550000: {
                    dMBR = lineutility.MBRDistance(pLinePoints, vblSaveCounter);
                    d = 20.0;
                    if (dMBR < 60.0) {
                        d = dMBR / 4.0;
                    }
                    if (d < 5.0) {
                        d = 5.0;
                    }
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pLinePoints[j].style = 1;
                    }
                    pLinePoints[vblSaveCounter - 1].style = 5;
                    pt0 = lineutility.CalcCenterPointDouble(pLinePoints, vblSaveCounter - 1);
                    lineutility.CalcCircleDouble(pt0, d, 26, arcPts, 0);
                    for (j = vblSaveCounter; j < vblSaveCounter + 26; ++j) {
                        pLinePoints[j] = new POINT2(arcPts[j - vblSaveCounter]);
                    }
                    pLinePoints[j - 1].style = 5;
                    d = dMBR < 50.0 ? (d *= 0.6) : 12.0;
                    pt1 = new POINT2(pt0);
                    pt1.y -= d;
                    pt1.style = 0;
                    pt2 = new POINT2(pt1);
                    pt2.y += d;
                    pt2.style = 5;
                    pt3 = new POINT2(pt2);
                    pt3.y += d / 4.0;
                    pt3.style = 0;
                    pt4 = new POINT2(pt3);
                    pt4.y += d / 4.0;
                    pLinePoints[j++] = new POINT2(pt1);
                    pLinePoints[j++] = new POINT2(pt2);
                    pLinePoints[j++] = new POINT2(pt3);
                    pt4.style = 5;
                    pLinePoints[j++] = new POINT2(pt4);
                    acCounter = vblCounter = j;
                    break;
                }
                case 32680000: {
                    acCounter = vblCounter = arraysupport.GetPipePoints(pLinePoints, vblSaveCounter);
                    break;
                }
                case 32231500: {
                    n = arraysupport.GetInsideOutsideDouble2(pLinePoints[0], pLinePoints[1], pLinePoints, vblSaveCounter, 0, lineType);
                    nQuadrant = lineutility.GetQuadrantDouble(pLinePoints[0], pLinePoints[1]);
                    block113 : switch (nQuadrant) {
                        case 4: {
                            switch (n) {
                                case 1: 
                                case 2: {
                                    break block113;
                                }
                                case 0: 
                                case 3: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block113;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (n) {
                                case 1: 
                                case 3: {
                                    break block113;
                                }
                                case 0: 
                                case 2: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block113;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (n) {
                                case 1: 
                                case 2: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block113;
                                }
                                case 0: 
                                case 3: {
                                    break block113;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (n) {
                                case 1: 
                                case 3: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block113;
                                }
                                case 0: 
                                case 2: {
                                    break block113;
                                }
                            }
                            break;
                        }
                    }
                    acCounter = lFlotCount = arraysupport.GetAnchorageDouble(pLinePoints, vblSaveCounter);
                    break;
                }
                case 32231400: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    acCounter = arraysupport.GetAnchorageDouble(pLinePoints, vblSaveCounter);
                    break;
                }
                case 32153000: {
                    int xCount = countsupport.GetXPointsCount(lineType, pOriginalLinePoints, vblSaveCounter);
                    POINT2[] xPoints2 = new POINT2[xCount];
                    int lvoCount = countsupport.GetLVOCount(lineType, pOriginalLinePoints, vblSaveCounter);
                    POINT2[] lvoPoints = new POINT2[lvoCount];
                    xCount = arraysupport.GetXPoints(lineType, pOriginalLinePoints, xPoints2, vblSaveCounter);
                    lvoCount = arraysupport.GetLVOPoints(lineType, pOriginalLinePoints, lvoPoints, vblSaveCounter);
                    for (k = 0; k < xCount; ++k) {
                        pLinePoints[k] = new POINT2(xPoints2[k]);
                    }
                    if (xCount > 0) {
                        pLinePoints[xCount - 1].style = 5;
                    }
                    for (k = 0; k < lvoCount; ++k) {
                        pLinePoints[xCount + k] = new POINT2(lvoPoints[k]);
                    }
                    acCounter = xCount + lvoCount;
                    break;
                }
                case 32152000: {
                    if (pLinePoints[0].x < pLinePoints[1].x) {
                        lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    }
                    acCounter = lFlotCount = flot.GetFlotDouble(pLinePoints, vblSaveCounter);
                    break;
                }
                case 32151000: {
                    acCounter = arraysupport.GetLVOPoints(lineType, pOriginalLinePoints, pLinePoints, vblSaveCounter);
                    break;
                }
                case 31740000: {
                    acCounter = vblCounter = arraysupport.GetIcingPointsDouble(pLinePoints, vblSaveCounter);
                    break;
                }
                case 31720000: {
                    n = arraysupport.GetInsideOutsideDouble2(pLinePoints[0], pLinePoints[1], pLinePoints, vblSaveCounter, 0, lineType);
                    nQuadrant = lineutility.GetQuadrantDouble(pLinePoints[0], pLinePoints[1]);
                    block135 : switch (nQuadrant) {
                        case 4: {
                            switch (n) {
                                case 0: 
                                case 3: {
                                    break block135;
                                }
                                case 1: 
                                case 2: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block135;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (n) {
                                case 0: 
                                case 2: {
                                    break block135;
                                }
                                case 1: 
                                case 3: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block135;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (n) {
                                case 0: 
                                case 3: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block135;
                                }
                                case 1: 
                                case 2: {
                                    break block135;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (n) {
                                case 0: 
                                case 2: {
                                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                                    break block135;
                                }
                                case 1: 
                                case 3: {
                                    break block135;
                                }
                            }
                            break;
                        }
                    }
                    acCounter = lFlotCount = flot.GetFlotDouble(pLinePoints, vblSaveCounter);
                    break;
                }
                case 31148000: {
                    acCounter = arraysupport.GetITDPointsDouble(pLinePoints, vblSaveCounter);
                    break;
                }
                case 31147000: {
                    acCounter = arraysupport.GetConvergancePointsDouble(pLinePoints, vblSaveCounter);
                    break;
                }
                case 31142000: {
                    acCounter = vblCounter = arraysupport.GetRidgePointsDouble(pLinePoints, lineType, vblSaveCounter);
                    break;
                }
                case 31141000: 
                case 31144000: 
                case 31145000: {
                    acCounter = vblCounter = arraysupport.GetSquallDouble(pLinePoints, 10, 6, 30, vblSaveCounter);
                    break;
                }
                case 31143000: {
                    acCounter = vblCounter = arraysupport.GetSevereSquall(pLinePoints, vblSaveCounter);
                    break;
                }
                case 31134100: 
                case 31134200: 
                case 31134300: {
                    acCounter = vblCounter = flot.GetSFPointsDouble(pLinePoints, vblSaveCounter, lineType);
                    break;
                }
                case 31134000: {
                    vblCounter = flot.GetOccludedPointsDouble(pLinePoints, vblSaveCounter, lineType);
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pLinePoints[vblCounter + j] = pOriginalLinePoints[j];
                    }
                    acCounter = vblCounter += vblSaveCounter;
                    break;
                }
                case 31133200: {
                    acCounter = vblCounter = flot.GetOFYPointsDouble(pLinePoints, vblSaveCounter, lineType);
                    break;
                }
                case 31133000: 
                case 31133100: {
                    vblCounter = flot.GetOccludedPointsDouble(pLinePoints, vblSaveCounter, lineType);
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pLinePoints[vblCounter + j] = pOriginalLinePoints[j];
                    }
                    acCounter = vblCounter += vblSaveCounter;
                    break;
                }
                case 31132000: 
                case 31132100: {
                    lFlotCount = flot.GetFlot2Double(pLinePoints, vblSaveCounter, lineType);
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pLinePoints[vblCounter - vblSaveCounter + j] = pOriginalLinePoints[j];
                    }
                    acCounter = lFlotCount + vblSaveCounter;
                    break;
                }
                case 31132200: 
                case 31132300: {
                    acCounter = lFlotCount = flot.GetFlot2Double(pLinePoints, vblSaveCounter, lineType);
                    break;
                }
                case 31131200: 
                case 31131300: {
                    acCounter = vblCounter = arraysupport.GetATWallPointsDouble(pLinePoints, lineType, vblSaveCounter);
                    break;
                }
                case 31131000: 
                case 31131100: {
                    vblCounter = arraysupport.GetATWallPointsDouble(pLinePoints, lineType, vblSaveCounter);
                    pLinePoints[vblCounter - 1].style = 5;
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pLinePoints[vblCounter + j] = pOriginalLinePoints[j];
                    }
                    pLinePoints[(vblCounter += vblSaveCounter) - 1].style = 5;
                    acCounter = vblCounter;
                    break;
                }
                case 22524000: 
                case 23191000: 
                case 23192000: 
                case 23193000: {
                    lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pLinePoints[2], pt0, pt1);
                    d = lineutility.CalcDistanceDouble(pLinePoints[0], pt0);
                    pt4 = lineutility.ExtendLineDouble(pt0, pLinePoints[0], d);
                    lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pt4, pt2, pt3);
                    pLinePoints[0] = new POINT2(pt0);
                    pLinePoints[1] = new POINT2(pt1);
                    pLinePoints[2] = new POINT2(pt3);
                    pLinePoints[3] = new POINT2(pt2);
                    switch (lineType) {
                        case 22524000: 
                        case 23193000: {
                            pLinePoints[0].style = 0;
                            pLinePoints[1].style = 5;
                            pLinePoints[2].style = 0;
                            break;
                        }
                        case 23191000: {
                            pLinePoints[0].style = 1;
                            pLinePoints[1].style = 5;
                            pLinePoints[2].style = 1;
                            break;
                        }
                        case 23192000: {
                            pLinePoints[1].style = 5;
                            if (pt0.x <= pt1.x) {
                                if (pLinePoints[1].y <= pLinePoints[2].y) {
                                    pLinePoints[0].style = 0;
                                    pLinePoints[2].style = 1;
                                    break;
                                }
                                pLinePoints[0].style = 1;
                                pLinePoints[2].style = 0;
                                break;
                            }
                            if (pLinePoints[1].y >= pLinePoints[2].y) {
                                pLinePoints[0].style = 0;
                                pLinePoints[2].style = 1;
                                break;
                            }
                            pLinePoints[0].style = 1;
                            pLinePoints[2].style = 0;
                            break;
                        }
                    }
                    acCounter = 4;
                    break;
                }
                case 23224000: {
                    lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pLinePoints[2], pt0, pt1);
                    pLinePoints[0].style = 1;
                    pLinePoints[1].style = 5;
                    pLinePoints[2] = new POINT2(pt0);
                    pLinePoints[2].style = 1;
                    pLinePoints[3] = new POINT2(pt1);
                    pLinePoints[3].style = 5;
                    acCounter = 4;
                    break;
                }
                case 23194000: {
                    pts = new POINT2[4];
                    for (j = 0; j < 4; ++j) {
                        pts[j] = new POINT2(pLinePoints[j]);
                    }
                    dRadius = lineutility.CalcDistanceDouble(pLinePoints[0], pLinePoints[1]);
                    d = lineutility.CalcDistanceToLineDouble(pLinePoints[0], pLinePoints[1], pLinePoints[2]);
                    pLinePoints[0] = lineutility.ExtendTrueLinePerpDouble(pts[0], pts[1], pts[1], d, 0);
                    pLinePoints[1] = lineutility.ExtendTrueLinePerpDouble(pts[0], pts[1], pts[0], d, 5);
                    pLinePoints[2] = lineutility.ExtendTrueLinePerpDouble(pts[0], pts[1], pts[1], -d, 0);
                    pLinePoints[3] = lineutility.ExtendTrueLinePerpDouble(pts[0], pts[1], pts[0], -d, 5);
                    midpt = lineutility.MidPointDouble(pts[0], pts[1], 0);
                    midpt = lineutility.ExtendLineDouble(pts[0], midpt, d);
                    pLinePoints[4] = lineutility.ExtendAngledLine(pts[0], pts[1], midpt, 105.0, dRadius / 2.0);
                    pLinePoints[5] = lineutility.ExtendAngledLine(pts[0], pts[1], midpt, -75.0, dRadius / 2.0);
                    pLinePoints[5].style = 5;
                    midpt = lineutility.MidPointDouble(pts[0], pts[1], 0);
                    midpt = lineutility.ExtendLineDouble(pts[1], midpt, d);
                    pLinePoints[6] = lineutility.ExtendAngledLine(pts[0], pts[1], midpt, 105.0, dRadius / 2.0);
                    pLinePoints[7] = lineutility.ExtendAngledLine(pts[0], pts[1], midpt, -75.0, dRadius / 2.0);
                    pLinePoints[7].style = 5;
                    acCounter = 8;
                    break;
                }
                case 0x222248: 
                case 22340000: 
                case 221311000: {
                    arraysupport.AreaWithCenterFeatureDouble(pLinePoints, vblCounter, lineType);
                    acCounter = vblCounter;
                    break;
                }
                case 22431100: {
                    for (j = 0; j < vblCounter; ++j) {
                        pLinePoints[j].style = 1;
                    }
                    acCounter = vblCounter;
                    break;
                }
                case 22350000: {
                    arraysupport.AreaWithCenterFeatureDouble(pLinePoints, vblCounter, lineType);
                    pLinePoints[vblCounter - 1].style = 5;
                    arraysupport.FillPoints(pLinePoints, vblCounter, points);
                    xPoints = lineutility.LineOfXPoints(pOriginalLinePoints);
                    for (j = 0; j < xPoints.size(); ++j) {
                        points.add((POINT2)xPoints.get(j));
                    }
                    acCounter = points.size();
                    break;
                }
                case 23340000: {
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
                    if (bolVertical == 0) {
                        direction = pt0.y > pt1.y ? 0 : 1;
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] <= 1.0) {
                        direction = pt0.x < pt1.x ? 3 : 2;
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] > 1.0) {
                        if (pt0.x < pt1.x && pt0.y > pt1.y) {
                            direction = 1;
                        }
                        if (pt0.x < pt1.x && pt0.y < pt1.y) {
                            direction = 0;
                        }
                        if (pt0.x > pt1.x && pt0.y > pt1.y) {
                            direction = 1;
                        }
                        if (pt0.x > pt1.x && pt0.y < pt1.y) {
                            direction = 0;
                        }
                    }
                    if (dMBR / 20.0 > 100.0) {
                        dMBR = 2000.0;
                    }
                    if (dMBR / 20.0 < minLength) {
                        dMBR = 20.0 * minLength;
                    }
                    if (dMBR < 250.0) {
                        dMBR = 250.0;
                    }
                    if (dMBR > 500.0) {
                        dMBR = 500.0;
                    }
                    pLinePoints[0] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, direction, dMBR / 20.0);
                    pLinePoints[1] = new POINT2(pt0);
                    pLinePoints[2] = new POINT2(pt1);
                    pLinePoints[3] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, direction, dMBR / 20.0);
                    acCounter = 4;
                    break;
                }
                case 211400000: {
                    arraysupport.GetIsolatePointsDouble(pLinePoints, lineType, converter);
                    acCounter = 50;
                    break;
                }
                case 212500000: 
                case 212600000: {
                    arraysupport.GetIsolatePointsDouble(pLinePoints, lineType, converter);
                    acCounter = 50;
                    break;
                }
                case 211600000: {
                    arraysupport.GetIsolatePointsDouble(pLinePoints, lineType, converter);
                    acCounter = 32;
                    break;
                }
                case 211900000: {
                    arraysupport.GetIsolatePointsDouble(pLinePoints, lineType, converter);
                    acCounter = 75;
                    break;
                }
                case 212100000: {
                    arraysupport.GetIsolatePointsDouble(pLinePoints, lineType, converter);
                    acCounter = 29;
                    break;
                }
                case 23173000: {
                    arraysupport.GetIsolatePointsDouble(pLinePoints, lineType, null);
                    acCounter = 29;
                    break;
                }
                case 22624000: {
                    acCounter = arraysupport.GetZONEPointsDouble2(pLinePoints, lineType, vblSaveCounter);
                    break;
                }
                case 23111001: {
                    pUpperLinePoints = new POINT2[vblSaveCounter];
                    pLowerLinePoints = new POINT2[vblSaveCounter];
                    pUpperLowerLinePoints = new POINT2[2 * vblCounter];
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pLowerLinePoints[j] = new POINT2(pLinePoints[j]);
                    }
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pUpperLinePoints[j] = new POINT2(pLinePoints[j]);
                    }
                    pUpperLinePoints = Channels.CoordIL2Double(1, pUpperLinePoints, 1, vblSaveCounter, lineType, 30);
                    pLowerLinePoints = Channels.CoordIL2Double(1, pLowerLinePoints, 0, vblSaveCounter, lineType, 30);
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pUpperLowerLinePoints[j] = new POINT2(pUpperLinePoints[j]);
                    }
                    for (j = 0; j < vblSaveCounter; ++j) {
                        pUpperLowerLinePoints[j + vblSaveCounter] = new POINT2(pLowerLinePoints[vblSaveCounter - j - 1]);
                    }
                    pUpperLowerLinePoints[2 * vblSaveCounter] = new POINT2(pUpperLowerLinePoints[0]);
                    vblCounter = arraysupport.GetZONEPointsDouble2(pUpperLowerLinePoints, lineType, 2 * vblSaveCounter + 1);
                    for (j = 0; j < vblCounter; ++j) {
                        pLinePoints[j] = new POINT2(pUpperLowerLinePoints[j]);
                    }
                    acCounter = vblCounter;
                    break;
                }
                case 22134000: 
                case 23111000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23350000: {
                    acCounter = arraysupport.GetZONEPointsDouble2(pLinePoints, lineType, vblSaveCounter);
                    break;
                }
                case 23112000: 
                case 23134000: {
                    acCounter = arraysupport.GetATWallPointsDouble2(pLinePoints, lineType, vblSaveCounter);
                    break;
                }
                case 22528000: {
                    for (j = 0; j < vblCounter; ++j) {
                        pLinePoints[j].style = 1;
                    }
                    acCounter = vblCounter;
                    break;
                }
                case 22421000: {
                    arraysupport.CoordFEBADouble(pLinePoints, vblCounter);
                    acCounter = pLinePoints.length;
                    break;
                }
                case 22222000: 
                case 22224000: {
                    if (rev == 0) {
                        dMRR = pOriginalLinePoints[0].style;
                        if (dMRR <= 0.0) {
                            dMRR = 1.0;
                        }
                        lineutility.GetSAAFRSegment(pLinePoints, lineType, dMRR, rev);
                        acCounter = 6;
                    }
                    if (rev != 1) break;
                    return arraysupport.GetLineArray2Double(22223000, pLinePoints, vblCounter, vblSaveCounter, shapes, clipBounds, rev, converter);
                }
                case 22221000: 
                case 22222001: 
                case 22223000: 
                case 22224001: 
                case 22225000: {
                    boolean bolSegmentAC = false;
                    bolSegmentAC = true;
                    dMRR = dACP;
                    lineutility.InitializePOINT2Array(acPoints);
                    lineutility.InitializePOINT2Array(arcPts);
                    acCounter = 0;
                    if (!bolSegmentAC) {
                        for (j = 0; j < vblSaveCounter; ++j) {
                            if (pOriginalLinePoints[j].style > 0) continue;
                            pOriginalLinePoints[j].style = 1;
                        }
                    }
                    for (j = 0; j < vblSaveCounter - 1; ++j) {
                        dMBR = pOriginalLinePoints[j].style;
                        acPoints[0] = new POINT2(pOriginalLinePoints[j]);
                        acPoints[1] = new POINT2(pOriginalLinePoints[j + 1]);
                        lineutility.GetSAAFRSegment(acPoints, lineType, dMBR, rev);
                        for (k = 0; k < 6; ++k) {
                            pLinePoints[acCounter] = new POINT2(acPoints[k]);
                            ++acCounter;
                        }
                    }
                    int currentCircleSize = 0;
                    if (!bolSegmentAC) {
                        for (j = 0; j < vblSaveCounter - 1; ++j) {
                            currentCircleSize = pOriginalLinePoints[j].style;
                            arcPts[0] = new POINT2(pOriginalLinePoints[j]);
                            dMBR = currentCircleSize;
                            lineutility.CalcCircleDouble(arcPts[0], dMBR, 26, arcPts, 0);
                            arcPts[25].style = 5;
                            for (k = 0; k < 26; ++k) {
                                pLinePoints[acCounter] = new POINT2(arcPts[k]);
                                ++acCounter;
                            }
                            arcPts[0] = new POINT2(pOriginalLinePoints[j + 1]);
                            dMBR = currentCircleSize;
                            lineutility.CalcCircleDouble(arcPts[0], dMBR, 26, arcPts, 0);
                            arcPts[25].style = 5;
                            for (k = 0; k < 26; ++k) {
                                pLinePoints[acCounter] = new POINT2(arcPts[k]);
                                ++acCounter;
                            }
                        }
                    } else {
                        int lastCircleSize = 0;
                        POINT2 lastCirclePoint = null;
                        for (j = 0; j < vblSaveCounter; ++j) {
                            currentCircleSize = pOriginalLinePoints[j].style;
                            if (j == 0) {
                                lastCircleSize = currentCircleSize;
                                lastCirclePoint = pOriginalLinePoints[j];
                                continue;
                            }
                            if (currentCircleSize < 0) continue;
                            arcPts[0] = new POINT2(pOriginalLinePoints[j]);
                            dMBR = lastCircleSize;
                            lineutility.CalcCircleDouble(arcPts[0], dMBR, 26, arcPts, 0);
                            arcPts[25].style = 5;
                            for (k = 0; k < 26; ++k) {
                                pLinePoints[acCounter] = new POINT2(arcPts[k]);
                                ++acCounter;
                            }
                            arcPts[0] = new POINT2(lastCirclePoint);
                            lineutility.CalcCircleDouble(arcPts[0], dMBR, 26, arcPts, 0);
                            arcPts[25].style = 5;
                            for (k = 0; k < 26; ++k) {
                                pLinePoints[acCounter] = new POINT2(arcPts[k]);
                                ++acCounter;
                            }
                            lastCircleSize = currentCircleSize;
                            lastCirclePoint = pOriginalLinePoints[j];
                        }
                        if (rev != 0 || lineType == 22223000) break;
                        pts = lineutility.GetSAAFRMiddleLine(pOriginalLinePoints);
                        for (j = 0; j < pts.length; ++j) {
                            pLinePoints[acCounter++] = new POINT2(pts[j]);
                        }
                    }
                    break;
                }
                case 23164000: 
                case 23180000: {
                    acCounter = vblCounter;
                    break;
                }
                case 26400000: 
                case 26410000: 
                case 26420000: 
                case 26430000: 
                case 26440000: {
                    acCounter = vblCounter;
                    break;
                }
                case 23410000: {
                    lineutility.InitializePOINT2Array(circlePoints);
                    pt3 = new POINT2(pLinePoints[3]);
                    if (converter == null) {
                        dRadius = lineutility.CalcDistanceDouble(pt0, pt1);
                        lineutility.CalcCircleDouble(pt0, dRadius, 100, circlePoints, 0);
                    } else {
                        lineutility.CalcCircleDouble2(pt0, pt1, 100, circlePoints, converter);
                    }
                    for (j = 0; j < 100; ++j) {
                        pLinePoints[j] = new POINT2(circlePoints[j]);
                    }
                    pLinePoints[99].style = 5;
                    if (converter == null) {
                        dRadius = lineutility.CalcDistanceDouble(pt0, pt2);
                        lineutility.CalcCircleDouble(pt0, dRadius, 100, circlePoints, 0);
                    } else {
                        lineutility.CalcCircleDouble2(pt0, pt2, 100, circlePoints, converter);
                    }
                    for (j = 0; j < 100; ++j) {
                        pLinePoints[100 + j] = new POINT2(circlePoints[j]);
                    }
                    pLinePoints[199].style = 5;
                    if (converter == null) {
                        dRadius = lineutility.CalcDistanceDouble(pt0, pt3);
                        lineutility.CalcCircleDouble(pt0, dRadius, 100, circlePoints, 0);
                    } else {
                        lineutility.CalcCircleDouble2(pt0, pt3, 100, circlePoints, converter);
                    }
                    for (j = 0; j < 100; ++j) {
                        pLinePoints[200 + j] = new POINT2(circlePoints[j]);
                    }
                    acCounter = vblCounter;
                    break;
                }
                case 25211000: {
                    d = lineutility.CalcDistanceDouble(pt0, pt1);
                    if (d <= 30.0) {
                        arraysupport.GetLineArray2Double(22522220, pLinePoints, 5, 2, shapes, clipBounds, rev, converter);
                        break;
                    }
                    pt0 = new POINT2(pLinePoints[0]);
                    pt1 = new POINT2(pLinePoints[1]);
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt1, pt0, m);
                    pt0 = lineutility.ExtendLine2Double(pt1, pt0, -30.0, 0);
                    if (((double[])m.value)[0] < 1.0) {
                        pLinePoints[0] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 2, 10.0);
                        pLinePoints[1] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 2, 10.0);
                        pLinePoints[2] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 3, 10.0);
                        pLinePoints[3] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 3, 10.0);
                    } else {
                        pLinePoints[0] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 0, 10.0);
                        pLinePoints[1] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 0, 10.0);
                        pLinePoints[2] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 1, 10.0);
                        pLinePoints[3] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 1, 10.0);
                    }
                    pt2 = lineutility.ExtendLineDouble(pt1, pt0, 30.0);
                    lineutility.GetArrowHead4Double(pt0, pt2, 30, 30, pArrowPoints, 0);
                    d = lineutility.CalcDistanceDouble(pLinePoints[0], pArrowPoints[0]);
                    d1 = lineutility.CalcDistanceDouble(pLinePoints[3], pArrowPoints[0]);
                    pLinePoints[3].style = 5;
                    if (d < d1) {
                        pLinePoints[4] = new POINT2(pLinePoints[0]);
                        pLinePoints[4].style = 0;
                        pLinePoints[5] = new POINT2(pArrowPoints[0]);
                        pLinePoints[5].style = 0;
                        pLinePoints[6] = new POINT2(pArrowPoints[1]);
                        pLinePoints[6].style = 0;
                        pLinePoints[7] = new POINT2(pArrowPoints[2]);
                        pLinePoints[7].style = 0;
                        pLinePoints[8] = new POINT2(pLinePoints[3]);
                    } else {
                        pLinePoints[4] = pLinePoints[3];
                        pLinePoints[4].style = 0;
                        pLinePoints[5] = pArrowPoints[0];
                        pLinePoints[5].style = 0;
                        pLinePoints[6] = pArrowPoints[1];
                        pLinePoints[6].style = 0;
                        pLinePoints[7] = pArrowPoints[2];
                        pLinePoints[7].style = 0;
                        pLinePoints[8] = pLinePoints[0];
                    }
                    acCounter = 9;
                    break;
                }
                case 25212000: {
                    pt0 = new POINT2(pLinePoints[0]);
                    pt1 = new POINT2(pLinePoints[1]);
                    pt2.x = (pt0.x + pt1.x) / 2.0;
                    pt2.y = (pt0.y + pt1.y) / 2.0;
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt1, pt0, m);
                    if (((double[])m.value)[0] < 1.0) {
                        pLinePoints[0] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 2, 10.0);
                        pLinePoints[1] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 2, 10.0);
                        pLinePoints[2] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 3, 10.0);
                        pLinePoints[3] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 3, 10.0);
                    } else {
                        pLinePoints[0] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 0, 10.0);
                        pLinePoints[1] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 0, 10.0);
                        pLinePoints[2] = lineutility.ExtendDirectedLine(pt0, pt1, pt1, 1, 10.0);
                        pLinePoints[3] = lineutility.ExtendDirectedLine(pt0, pt1, pt0, 1, 10.0);
                    }
                    pLinePoints[4] = new POINT2(pLinePoints[0]);
                    pLinePoints[5] = new POINT2(pt0);
                    pLinePoints[5].style = 0;
                    pt2 = lineutility.ExtendLineDouble(pt1, pt0, 50.0);
                    lineutility.GetArrowHead4Double(pt2, pt0, 20, 20, pArrowPoints, 0);
                    pLinePoints[6] = new POINT2(pArrowPoints[1]);
                    pLinePoints[7] = new POINT2(pArrowPoints[0]);
                    pLinePoints[8] = new POINT2(pArrowPoints[2]);
                    pLinePoints[8].style = 0;
                    pLinePoints[9] = new POINT2(pArrowPoints[1]);
                    acCounter = 10;
                    break;
                }
                case 25223000: 
                case 25224000: 
                case 25225000: {
                    nCounter = vblSaveCounter;
                    pLinePoints[vblSaveCounter - 1].style = 5;
                    for (j = 0; j < vblSaveCounter - 1; ++j) {
                        d = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                        if (d < 20.0) continue;
                        pt0 = new POINT2(pLinePoints[j]);
                        pt1 = new POINT2(pLinePoints[j + 1]);
                        bolVertical = lineutility.CalcTrueSlopeDouble(pLinePoints[j], pLinePoints[j + 1], m);
                        d = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                        pt2 = lineutility.ExtendLine2Double(pLinePoints[j], pLinePoints[j + 1], -3.0 * d / 4.0, 0);
                        pt3 = lineutility.ExtendLine2Double(pLinePoints[j], pLinePoints[j + 1], -1.0 * d / 4.0, 5);
                        if (pLinePoints[j].x < pLinePoints[j + 1].x) {
                            if (((double[])m.value)[0] < 1.0) {
                                pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, 2, 10.0);
                                pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, 2, 10.0);
                            }
                            if (((double[])m.value)[0] >= 1.0) {
                                pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, 1, 10.0);
                                pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, 1, 10.0);
                            }
                        }
                        if (pLinePoints[j].x > pLinePoints[j + 1].x) {
                            if (((double[])m.value)[0] < 1.0) {
                                pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, 3, 10.0);
                                pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, 3, 10.0);
                            }
                            if (((double[])m.value)[0] >= 1.0) {
                                pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, 0, 10.0);
                                pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, 0, 10.0);
                            }
                        }
                        if (bolVertical == 0) {
                            if (pLinePoints[j].y > pLinePoints[j + 1].y) {
                                pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, 0, 10.0);
                                pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, 0, 10.0);
                            } else {
                                pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, 1, 10.0);
                                pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, 1, 10.0);
                            }
                        }
                        pLinePoints[nCounter] = new POINT2(pt2);
                        pLinePoints[++nCounter] = new POINT2(pt3);
                        ++nCounter;
                        d = 10.0;
                        if (dMBR / 20.0 < minLength) {
                            d = 5.0;
                        }
                        lineutility.GetArrowHead4Double(pt2, pt3, (int)d, (int)d, pArrowPoints, 0);
                        for (k = 0; k < 3; ++k) {
                            pLinePoints[nCounter] = new POINT2(pArrowPoints[k]);
                            ++nCounter;
                        }
                        if ((long)lineType == 25224000L) {
                            lineutility.GetArrowHead4Double(pt3, pt2, (int)d, (int)d, pArrowPoints, 0);
                            for (k = 0; k < 3; ++k) {
                                pLinePoints[nCounter] = new POINT2(pArrowPoints[k]);
                                ++nCounter;
                            }
                        }
                        if ((long)lineType != 25225000L) continue;
                        if (pLinePoints[j].x < pLinePoints[j + 1].x) {
                            if (((double[])m.value)[0] < 1.0) {
                                pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, 2, 15.0);
                                pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, 2, 15.0);
                            }
                            if (((double[])m.value)[0] >= 1.0) {
                                pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, 1, 15.0);
                                pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, 1, 15.0);
                            }
                        }
                        if (pLinePoints[j].x > pLinePoints[j + 1].x) {
                            if (((double[])m.value)[0] < 1.0) {
                                pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, 3, 15.0);
                                pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, 3, 15.0);
                            }
                            if (((double[])m.value)[0] >= 1.0) {
                                pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, 0, 15.0);
                                pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, 0, 15.0);
                            }
                        }
                        if (bolVertical == 0) {
                            if (pLinePoints[j].y > pLinePoints[j + 1].y) {
                                pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, 0, 15.0);
                                pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, 0, 15.0);
                            } else {
                                pt2 = lineutility.ExtendDirectedLine(pt0, pt1, pt2, 1, 15.0);
                                pt3 = lineutility.ExtendDirectedLine(pt0, pt1, pt3, 1, 15.0);
                            }
                        }
                        pLinePoints[nCounter] = new POINT2(pt2);
                        pLinePoints[++nCounter] = new POINT2(pt3);
                        ++nCounter;
                        lineutility.GetArrowHead4Double(pt3, pt2, (int)d, (int)d, pArrowPoints, 0);
                        for (k = 0; k < 3; ++k) {
                            pLinePoints[nCounter] = new POINT2(pArrowPoints[k]);
                            ++nCounter;
                        }
                    }
                    acCounter = nCounter;
                    break;
                }
                case 24220000: {
                    for (j = 0; j < vblCounter; ++j) {
                        pLinePoints[j].style = 1;
                    }
                    acCounter = vblCounter;
                    break;
                }
                case 22330000: {
                    d = lineutility.CalcDistanceDouble(pLinePoints[0], pLinePoints[1]);
                    if (d < 20.0) {
                        pLinePoints[1] = lineutility.ExtendLineDouble(pLinePoints[0], pLinePoints[1], 21.0);
                    }
                    pLinePoints[0] = lineutility.ExtendAlongLineDouble(pLinePoints[0], pLinePoints[1], 20.0);
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    d = dMBR;
                    pt0 = lineutility.ExtendLineDouble(pLinePoints[vblCounter - 8], pLinePoints[vblCounter - 7], 20.0);
                    pt1 = new POINT2(pLinePoints[vblCounter - 8]);
                    pt2 = new POINT2(pLinePoints[vblCounter - 7]);
                    if (d / 10.0 > 100.0) {
                        d = 1000.0;
                    }
                    if (d / 10.0 < minLength) {
                        d = 10.0 * minLength;
                    }
                    if (d < 250.0) {
                        d = 250.0;
                    }
                    if (d > 500.0) {
                        d = 250.0;
                    }
                    lineutility.GetArrowHead4Double(pt1, pt2, (int)d / 10, (int)d / 10, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 6 + k] = pArrowPoints[k];
                    }
                    lineutility.GetArrowHead4Double(pt1, pt0, (int)d / 10, (int)d / 10, pArrowPoints, 18);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 3 + k] = pArrowPoints[k];
                    }
                    acCounter = vblCounter;
                    break;
                }
                case 23225000: {
                    lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pLinePoints[2], pt4, pt5);
                    pLinePoints[2] = new POINT2(pt5);
                    pLinePoints[3] = new POINT2(pt4);
                    for (j = 0; j < vblCounter; ++j) {
                        pLinePoints[j].style = 1;
                    }
                    pt0 = lineutility.MidPointDouble(pLinePoints[0], pLinePoints[1], 0);
                    pt1 = lineutility.MidPointDouble(pLinePoints[2], pLinePoints[3], 0);
                    POINT2[] savepoints = null;
                    Boolean drawJaggies = true;
                    if (clipBounds != null) {
                        POINT2 lr;
                        POINT2 ul = new POINT2(clipBounds.getMinX(), clipBounds.getMinY());
                        savepoints = lineutility.BoundOneSegment(pt0, pt1, ul, lr = new POINT2(clipBounds.getMaxX(), clipBounds.getMaxY()));
                        if (savepoints != null && savepoints.length > 1) {
                            pt0 = savepoints[0];
                            pt1 = savepoints[1];
                        } else {
                            savepoints = new POINT2[]{new POINT2(pt0), new POINT2(pt1)};
                            drawJaggies = false;
                        }
                        midpt = lineutility.MidPointDouble(pt0, pt1, 0);
                        double dist0 = lineutility.CalcDistanceDouble(midpt, pt0);
                        double dist1 = lineutility.CalcDistanceDouble(midpt, pt1);
                        if (dist0 > dist1) {
                            lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pt0, pt4, pt5);
                        } else {
                            lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pt1, pt4, pt5);
                        }
                        pLinePoints[2] = new POINT2(pt5);
                        pLinePoints[3] = new POINT2(pt4);
                    } else {
                        double dist1;
                        midpt = lineutility.MidPointDouble(pLinePoints[0], pLinePoints[1], 0);
                        double dist0 = lineutility.CalcDistanceDouble(midpt, pt0);
                        if (dist0 > (dist1 = lineutility.CalcDistanceDouble(midpt, pt1))) {
                            lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pt0, pt4, pt5);
                        } else {
                            lineutility.LineRelativeToLine(pLinePoints[0], pLinePoints[1], pt1, pt4, pt5);
                        }
                        pLinePoints[2] = new POINT2(pt5);
                        pLinePoints[3] = new POINT2(pt4);
                    }
                    pt2 = lineutility.ExtendLine2Double(pLinePoints[0], pt0, -10.0, 0);
                    pt3 = lineutility.ExtendLine2Double(pLinePoints[3], pt1, -10.0, 0);
                    pt4 = lineutility.ExtendLine2Double(pLinePoints[0], pt0, 10.0, 0);
                    pt5 = lineutility.ExtendLine2Double(pLinePoints[3], pt1, 10.0, 0);
                    dWidth = lineutility.CalcDistanceDouble(pt0, pt1);
                    pointCounter = 4;
                    n = 1;
                    pLinePoints[pointCounter] = new POINT2(pt0);
                    pLinePoints[pointCounter].style = 0;
                    ++pointCounter;
                    if (drawJaggies.booleanValue()) {
                        while (dExtendLength < dWidth - 10.0) {
                            dExtendLength = (double)n * 5.0;
                            pLinePoints[pointCounter] = lineutility.ExtendLine2Double(pt2, pt3, dExtendLength - dWidth, 0);
                            dExtendLength = (double)(++n) * 5.0;
                            pLinePoints[++pointCounter] = lineutility.ExtendLine2Double(pt4, pt5, dExtendLength - dWidth, 0);
                            if (++pointCounter >= pLinePoints.length - 1) break;
                            ++n;
                        }
                    }
                    pLinePoints[pointCounter] = new POINT2(pt1);
                    pLinePoints[pointCounter].style = 5;
                    acCounter = ++pointCounter;
                    break;
                }
                case 23131100: {
                    acCounter = lineutility.GetDitchSpikeDouble(pLinePoints, vblSaveCounter, 0, lineType);
                    break;
                }
                case 23131200: {
                    pLinePoints[0].style = 9;
                    acCounter = lineutility.GetDitchSpikeDouble(pLinePoints, vblSaveCounter, 0, lineType);
                    break;
                }
                case 23132000: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    pLinePoints[0].style = 9;
                    acCounter = lineutility.GetDitchSpikeDouble(pLinePoints, vblSaveCounter, 0, lineType);
                    break;
                }
                case 22522210: {
                    if (dMBR / 30.0 > 100.0) {
                        dMBR = 3000.0;
                    }
                    if (dMBR / 30.0 < minLength) {
                        dMBR = 30.0 * minLength;
                    }
                    if (dMBR < 500.0) {
                        dMBR = 500.0;
                    }
                    if (dMBR > 750.0) {
                        dMBR = 500.0;
                    }
                    if ((d = lineutility.CalcDistanceDouble(pLinePoints[0], pLinePoints[1])) < dMBR / 40.0) {
                        pLinePoints[1] = lineutility.ExtendLineDouble(pLinePoints[0], pLinePoints[1], dMBR / 40.0 + 1.0);
                    }
                    pLinePoints[0] = lineutility.ExtendAlongLineDouble(pLinePoints[0], pLinePoints[1], dMBR / 40.0);
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    pt0 = new POINT2(pLinePoints[vblCounter - 12]);
                    pt1 = new POINT2(pLinePoints[vblCounter - 11]);
                    pt2 = lineutility.ExtendLineDouble(pt0, pt1, dMBR / 40.0);
                    lineutility.GetArrowHead4Double(pt0, pt1, (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[vblCounter - 10 + j] = new POINT2(pArrowPoints[j]);
                    }
                    lineutility.GetArrowHead4Double(pt0, pt2, (int)(dMBR / 13.33), (int)(dMBR / 13.33), pArrowPoints, 0);
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[vblCounter - 7 + j] = new POINT2(pArrowPoints[j]);
                    }
                    pLinePoints[vblCounter - 4] = new POINT2(pLinePoints[vblCounter - 10]);
                    pLinePoints[vblCounter - 4].style = 0;
                    pLinePoints[vblCounter - 3] = new POINT2(pLinePoints[vblCounter - 7]);
                    pLinePoints[vblCounter - 3].style = 5;
                    pLinePoints[vblCounter - 2] = new POINT2(pLinePoints[vblCounter - 8]);
                    pLinePoints[vblCounter - 2].style = 0;
                    pLinePoints[vblCounter - 1] = new POINT2(pLinePoints[vblCounter - 5]);
                    pLinePoints[vblCounter - 1].style = 5;
                    acCounter = vblCounter;
                    break;
                }
                case 23226000: {
                    pt2 = lineutility.ExtendLineDouble(pLinePoints[vblCounter - 8], pLinePoints[vblCounter - 7], dMBR / 2.0);
                    pt3 = new POINT2(pLinePoints[vblCounter - 7]);
                    pt1 = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], dMBR / 2.0);
                    if (dMBR / 10.0 > 100.0) {
                        dMBR = 1000.0;
                    }
                    if (dMBR / 10.0 < minLength) {
                        dMBR = 10.0 * minLength;
                    }
                    if (dMBR > 250.0) {
                        dMBR = 250.0;
                    }
                    lineutility.GetArrowHead4Double(pt2, pt3, (int)dMBR / 10, (int)dMBR / 10, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 6 + k] = new POINT2(pArrowPoints[k]);
                    }
                    lineutility.GetArrowHead4Double(pt1, pt0, (int)dMBR / 10, (int)dMBR / 10, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 3 + k] = new POINT2(pArrowPoints[k]);
                    }
                    pLinePoints[vblSaveCounter - 1].style = 5;
                    acCounter = vblCounter;
                    break;
                }
                case 23227000: {
                    pt2 = lineutility.ExtendLineDouble(pLinePoints[vblCounter - 8], pLinePoints[vblCounter - 7], dMBR / 2.0);
                    pt3 = new POINT2(pLinePoints[vblCounter - 7]);
                    pt1 = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], dMBR / 2.0);
                    if (dMBR / 10.0 > 100.0) {
                        dMBR = 1000.0;
                    }
                    if (dMBR / 10.0 < minLength) {
                        dMBR = 10.0 * minLength;
                    }
                    if (dMBR > 200.0) {
                        dMBR = 200.0;
                    }
                    lineutility.GetArrowHead4Double(pt2, pt3, (int)dMBR / 10, (int)dMBR / 5, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 6 + k] = new POINT2(pArrowPoints[k]);
                    }
                    lineutility.GetArrowHead4Double(pt1, pt0, (int)dMBR / 10, (int)dMBR / 5, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 3 + k] = new POINT2(pArrowPoints[k]);
                    }
                    pLinePoints[vblSaveCounter - 1].style = 5;
                    acCounter = vblCounter;
                    break;
                }
                case 22522100: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    for (k = vblSaveCounter - 1; k > 0 && !((d += lineutility.CalcDistanceDouble(pLinePoints[k], pLinePoints[k - 1])) > 60.0); --k) {
                    }
                    if (d > 60.0) {
                        middleSegment = k;
                        pt2 = pLinePoints[middleSegment];
                        if (middleSegment >= 1) {
                            pt3 = pLinePoints[middleSegment - 1];
                        }
                    } else {
                        middleSegment = vblSaveCounter <= 3 ? 1 : 2;
                        pt2 = pLinePoints[middleSegment];
                        if (middleSegment >= 1) {
                            pt3 = pLinePoints[middleSegment - 1];
                        }
                    }
                    pt0 = new POINT2(pLinePoints[0]);
                    if (dMBR / 20.0 > 100.0) {
                        dMBR = 2000.0;
                    }
                    if (dMBR / 20.0 < minLength) {
                        dMBR = 20.0 * minLength;
                    }
                    if (dMBR < 150.0) {
                        dMBR = 150.0;
                    }
                    if (dMBR > 250.0) {
                        dMBR = 250.0;
                    }
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 11], pLinePoints[vblCounter - 10], (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[vblCounter - 9 + j] = new POINT2(pArrowPoints[j]);
                    }
                    pLinePoints[vblCounter - 6].x = (pLinePoints[vblCounter - 11].x + pLinePoints[vblCounter - 10].x) / 2.0;
                    pLinePoints[vblCounter - 6].y = (pLinePoints[vblCounter - 11].y + pLinePoints[vblCounter - 10].y) / 2.0;
                    pt0 = new POINT2(pLinePoints[vblCounter - 6]);
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 11], pt0, (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 9);
                    if (middleSegment >= 1) {
                        pt0 = lineutility.MidPointDouble(pt2, pt3, 0);
                        lineutility.GetArrowHead4Double(pt3, pt0, (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 9);
                    }
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[vblCounter - 6 + j] = new POINT2(pArrowPoints[j]);
                    }
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 10], pt0, (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 9);
                    if (middleSegment >= 1) {
                        pt0 = lineutility.MidPointDouble(pt2, pt3, 0);
                        lineutility.GetArrowHead4Double(pt2, pt0, (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 9);
                    }
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[vblCounter - 3 + j] = new POINT2(pArrowPoints[j]);
                    }
                    ArrayList<POINT2> airPts = new ArrayList<POINT2>();
                    pLinePoints[middleSegment - 1].style = 5;
                    if (vblSaveCounter == 2) {
                        pLinePoints[1].style = 5;
                    }
                    for (j = 0; j < vblCounter; ++j) {
                        airPts.add(new POINT2(pLinePoints[j]));
                    }
                    midpt = lineutility.MidPointDouble(pLinePoints[middleSegment - 1], pLinePoints[middleSegment], 0);
                    pt0 = lineutility.ExtendAlongLineDouble(midpt, pLinePoints[middleSegment], dMBR / 20.0, 0);
                    airPts.add(pt0);
                    pt1 = new POINT2(pLinePoints[middleSegment]);
                    pt1.style = 5;
                    airPts.add(pt1);
                    pt0 = lineutility.ExtendAlongLineDouble(midpt, pLinePoints[middleSegment - 1], dMBR / 20.0, 0);
                    airPts.add(pt0);
                    pt1 = new POINT2(pLinePoints[middleSegment - 1]);
                    pt1.style = 5;
                    airPts.add(pt1);
                    vblCounter = airPts.size();
                    pLinePoints = new POINT2[airPts.size()];
                    for (j = 0; j < airPts.size(); ++j) {
                        pLinePoints[j] = new POINT2((POINT2)airPts.get(j));
                    }
                    acCounter = vblCounter;
                    break;
                }
                case 22422000: {
                    pt0 = new POINT2(pLinePoints[1]);
                    pt1 = new POINT2(pLinePoints[0]);
                    pLinePoints[0] = new POINT2(pt0);
                    pLinePoints[1] = new POINT2(pt1);
                    pts2 = new POINT2[]{new POINT2(pt0), new POINT2(pt1), new POINT2(pt2)};
                    lineutility.GetPixelsMin(pts2, 3, offsetX, offsetY);
                    ((double[])offsetX.value)[0] = ((double[])offsetX.value)[0] < 0.0 ? ((double[])offsetX.value)[0] - 100.0 : 0.0;
                    pLinePoints[2].style = 5;
                    if (dMBR / 20.0 > 100.0) {
                        dMBR = 2000.0;
                    }
                    if (dMBR < minLength) {
                        dMBR = 20.0 * minLength;
                    }
                    if (dMBR > 250.0) {
                        dMBR = 250.0;
                    }
                    pt2 = lineutility.ExtendLineDouble(pt0, pt1, -dMBR / 10.0);
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
                    if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                        b = pt2.y + 1.0 / ((double[])m.value)[0] * pt2.x;
                        b1 = -1.0 / ((double[])m.value)[0] * ((double[])offsetX.value)[0] + b;
                        ptYIntercept.x = ((double[])offsetX.value)[0];
                        ptYIntercept.y = b1;
                        pLinePoints[3] = lineutility.ExtendLineDouble(ptYIntercept, pt2, -2.0);
                        pLinePoints[3].style = 0;
                        pLinePoints[4] = lineutility.ExtendLineDouble(ptYIntercept, pt2, 2.0);
                        pLinePoints[4].style = 0;
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                        pLinePoints[3] = new POINT2(pt2);
                        pLinePoints[3].y = pt2.y - 2.0;
                        pLinePoints[3].style = 0;
                        pLinePoints[4] = new POINT2(pt2);
                        pLinePoints[4].y = pt2.y + 2.0;
                        pLinePoints[4].style = 0;
                    }
                    if (bolVertical == 0) {
                        pLinePoints[3] = new POINT2(pt2);
                        pLinePoints[3].x = pt2.x - 2.0;
                        pLinePoints[3].style = 0;
                        pLinePoints[4] = new POINT2(pt2);
                        pLinePoints[4].x = pt2.x + 2.0;
                        pLinePoints[4].style = 0;
                    }
                    pt2 = lineutility.ExtendLineDouble(pt1, pt0, -dMBR / 10.0);
                    if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                        b = pt2.y + 1.0 / ((double[])m.value)[0] * pt2.x;
                        b1 = -1.0 / ((double[])m.value)[0] * ((double[])offsetX.value)[0] + b;
                        ptYIntercept.x = ((double[])offsetX.value)[0];
                        ptYIntercept.y = b1;
                        pLinePoints[5] = lineutility.ExtendLineDouble(ptYIntercept, pt2, 2.0);
                        pLinePoints[5].style = 0;
                        pLinePoints[6] = lineutility.ExtendLineDouble(ptYIntercept, pt2, -2.0);
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                        pLinePoints[5] = new POINT2(pt2);
                        pLinePoints[5].y = pt2.y + 2.0;
                        pLinePoints[5].style = 0;
                        pLinePoints[6] = new POINT2(pt2);
                        pLinePoints[6].y = pt2.y - 2.0;
                    }
                    if (bolVertical == 0) {
                        pLinePoints[5] = new POINT2(pt2);
                        pLinePoints[5].x = pt2.x + 2.0;
                        pLinePoints[5].style = 0;
                        pLinePoints[6] = new POINT2(pt2);
                        pLinePoints[6].x = pt2.x - 2.0;
                    }
                    pLinePoints[6].style = 0;
                    pLinePoints[7] = new POINT2(pLinePoints[3]);
                    pLinePoints[7].style = 5;
                    lineutility.GetArrowHead4Double(pLinePoints[1], pLinePoints[0], (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[8 + j] = new POINT2(pArrowPoints[j]);
                    }
                    lineutility.GetArrowHead4Double(pLinePoints[1], pLinePoints[2], (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (j = 0; j < 3; ++j) {
                        pLinePoints[11 + j] = new POINT2(pArrowPoints[j]);
                        pLinePoints[11 + j].style = 0;
                    }
                    acCounter = 14;
                    break;
                }
                case 22522220: {
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    if (dMBR / 20.0 > 100.0) {
                        dMBR = 2000.0;
                    }
                    if (dMBR / 20.0 < minLength) {
                        dMBR = 20.0 * minLength;
                    }
                    if (client.startsWith("cpof")) {
                        if (dMBR < 250.0) {
                            dMBR = 250.0;
                        }
                    } else if (dMBR < 150.0) {
                        dMBR = 150.0;
                    }
                    if (dMBR > 500.0) {
                        dMBR = 500.0;
                    }
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 5], pLinePoints[vblCounter - 4], (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - k - 1] = new POINT2(pArrowPoints[k]);
                    }
                    acCounter = vblCounter;
                    break;
                }
                case 23120000: {
                    pts2 = new POINT2[]{new POINT2(pt0), new POINT2(pt1)};
                    lineutility.GetPixelsMin(pts2, 2, offsetX, offsetY);
                    ((double[])offsetX.value)[0] = ((double[])offsetX.value)[0] <= 0.0 ? ((double[])offsetX.value)[0] - 100.0 : 0.0;
                    if (dMBR > 300.0) {
                        dMBR = 300.0;
                    }
                    pLinePoints[0] = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], -dMBR / 10.0);
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
                    midpt.x = (pt0.x + pLinePoints[0].x) / 2.0;
                    midpt.y = (pt0.y + pLinePoints[0].y) / 2.0;
                    pLinePoints[vblCounter - 3] = new POINT2(pt0);
                    pLinePoints[vblCounter - 4].style = 5;
                    pLinePoints[vblCounter - 3].style = 0;
                    if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                        b = midpt.y + 1.0 / ((double[])m.value)[0] * midpt.x;
                        b1 = -1.0 / ((double[])m.value)[0] * ((double[])offsetX.value)[0] + b;
                        ptYIntercept.x = ((double[])offsetX.value)[0];
                        ptYIntercept.y = b1;
                        pLinePoints[vblCounter - 2] = lineutility.ExtendLineDouble(ptYIntercept, midpt, dMBR / 20.0);
                        if (pLinePoints[vblCounter - 2].y >= midpt.y) {
                            pLinePoints[vblCounter - 2] = lineutility.ExtendLineDouble(ptYIntercept, midpt, -dMBR / 20.0);
                        }
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                        pLinePoints[vblCounter - 2] = new POINT2(midpt);
                        pLinePoints[vblCounter - 2].y = midpt.y - dMBR / 20.0;
                    }
                    if (bolVertical == 0) {
                        pLinePoints[vblCounter - 2] = new POINT2(midpt);
                        pLinePoints[vblCounter - 2].x = midpt.x - dMBR / 20.0;
                    }
                    pLinePoints[vblCounter - 2].style = 0;
                    pLinePoints[vblCounter - 1] = new POINT2(pLinePoints[0]);
                    acCounter = vblCounter;
                    break;
                }
                case 23157000: {
                    pts2 = new POINT2[2];
                    if (Math.abs(pt0.y - pt1.y) < 1.0) {
                        pt1.y = pt0.y + 1.0;
                    }
                    pts2[0] = new POINT2(pt0);
                    pts2[1] = new POINT2(pt1);
                    pts = new POINT2[26];
                    dRadius = lineutility.CalcDistanceDouble(pt0, pt1) / 2.0;
                    midpt.x = (pt1.x + pt0.x) / 2.0;
                    midpt.y = (pt1.y + pt0.y) / 2.0;
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
                    if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                        b = midpt.y + 1.0 / ((double[])m.value)[0] * midpt.x;
                        ptYIntercept.x = 0.0;
                        ptYIntercept.y = b;
                        pt2 = lineutility.ExtendLineDouble(ptYIntercept, midpt, dRadius);
                        if (pLinePoints[0].x <= pLinePoints[1].x) {
                            if (pt2.y >= midpt.y) {
                                pt2 = lineutility.ExtendLineDouble(ptYIntercept, midpt, -dRadius);
                            }
                        } else if (pt2.y <= midpt.y) {
                            pt2 = lineutility.ExtendLineDouble(ptYIntercept, midpt, -dRadius);
                        }
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                        pt2 = midpt;
                        pt2.y = pLinePoints[0].x <= pLinePoints[1].x ? midpt.y - dRadius : midpt.y + dRadius;
                    }
                    if (bolVertical == 0) {
                        pt2 = midpt;
                        pt2.x = pLinePoints[0].y <= pLinePoints[1].y ? midpt.x + dRadius : midpt.x - dRadius;
                    }
                    pt1 = lineutility.ExtendLineDouble(midpt, pt2, 100.0);
                    pts[0] = new POINT2(pt2);
                    pts[1] = new POINT2(pt1);
                    lineutility.ArcArrayDouble(pts, 0, dRadius, lineType, null);
                    pLinePoints[0].style = 1;
                    pLinePoints[1].style = 5;
                    for (j = 0; j < 26; ++j) {
                        pLinePoints[2 + j] = new POINT2(pts[j]);
                        pLinePoints[2 + j].style = 1;
                    }
                    acCounter = 28;
                    break;
                }
                case 231100000: {
                    dRadius = lineutility.CalcDistanceToLineDouble(pt0, pt1, pt2);
                    bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
                    if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                        b = pt1.y + 1.0 / ((double[])m.value)[0] * pt1.x;
                        b1 = pt2.y - ((double[])m.value)[0] * pt2.x;
                        calcPoint0 = lineutility.CalcTrueIntersectDouble2(-1.0 / ((double[])m.value)[0], b, ((double[])m.value)[0], b1, 1, 1, pt0.x, pt0.y);
                        calcPoint1 = lineutility.ExtendLineDouble(pt0, pt1, dRadius / 2.0);
                        calcPoint2 = lineutility.ExtendLineDouble(pt0, pt1, dRadius);
                        b = calcPoint1.y + 1.0 / ((double[])m.value)[0] * calcPoint1.x;
                        calcPoint3 = lineutility.CalcTrueIntersectDouble2(-1.0 / ((double[])m.value)[0], b, ((double[])m.value)[0], b1, 1, 1, pt0.x, pt0.y);
                        b = calcPoint2.y + 1.0 / ((double[])m.value)[0] * calcPoint2.x;
                        calcPoint4 = lineutility.CalcTrueIntersectDouble2(-1.0 / ((double[])m.value)[0], b, ((double[])m.value)[0], b1, 1, 1, pt0.x, pt0.y);
                        midpt = lineutility.MidPointDouble(calcPoint1, calcPoint3, 0);
                        midpt1 = lineutility.MidPointDouble(calcPoint2, calcPoint4, 0);
                        b = pt1.y + 1.0 / ((double[])m.value)[0] * pt1.x;
                        calcPoint0 = lineutility.CalcTrueIntersectDouble2(-1.0 / ((double[])m.value)[0], b, ((double[])m.value)[0], b1, 1, 1, pt0.x, pt0.y);
                        calcPoint3 = lineutility.ExtendLineDouble(pt0, pt1, dRadius);
                        d = lineutility.CalcDistanceDouble(calcPoint0, calcPoint3);
                        calcPoint1 = lineutility.ExtendLineDouble(calcPoint0, calcPoint3, -(d - dRadius));
                    }
                    if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                        calcPoint0.x = pt1.x;
                        calcPoint0.y = pt2.y;
                        calcPoint1 = lineutility.ExtendLineDouble(pt0, pt1, dRadius / 2.0);
                        calcPoint2 = pt2;
                        calcPoint3.x = calcPoint0.x + dRadius / 2.0;
                        calcPoint3.y = calcPoint0.y;
                        calcPoint4.x = pt1.x + dRadius;
                        calcPoint4.y = pt2.y;
                        midpt = lineutility.MidPointDouble(calcPoint1, calcPoint3, 0);
                        midpt1 = lineutility.MidPointDouble(calcPoint2, calcPoint4, 0);
                        calcPoint3 = lineutility.ExtendLineDouble(pt0, pt1, dRadius);
                        d = lineutility.CalcDistanceDouble(calcPoint0, calcPoint3);
                        calcPoint1 = lineutility.ExtendLineDouble(calcPoint0, calcPoint3, -(d - dRadius));
                    }
                    if (bolVertical == 0) {
                        calcPoint0.x = pt2.x;
                        calcPoint0.y = pt1.y;
                        calcPoint1 = lineutility.ExtendLineDouble(pt0, pt1, dRadius / 2.0);
                        calcPoint2 = pt2;
                        calcPoint3.y = calcPoint0.y + dRadius / 2.0;
                        calcPoint3.x = calcPoint0.x;
                        calcPoint4.y = pt1.y + dRadius;
                        calcPoint4.x = pt2.x;
                        midpt = lineutility.MidPointDouble(calcPoint1, calcPoint3, 0);
                        midpt1 = lineutility.MidPointDouble(calcPoint2, calcPoint4, 0);
                        calcPoint3 = lineutility.ExtendLineDouble(pt0, pt1, dRadius);
                        d = lineutility.CalcDistanceDouble(calcPoint0, calcPoint3);
                        calcPoint1 = lineutility.ExtendLineDouble(calcPoint0, calcPoint3, -(d - dRadius));
                    }
                    arcPts[0] = new POINT2(calcPoint1);
                    arcPts[1] = new POINT2(calcPoint3);
                    lineutility.ArcArrayDouble(arcPts, 0, dRadius, lineType, null);
                    pLinePoints[0].style = 5;
                    pLinePoints[1].style = 5;
                    for (k = 0; k < 26; ++k) {
                        pLinePoints[k] = new POINT2(arcPts[k]);
                    }
                    for (k = 25; k < vblCounter; ++k) {
                        pLinePoints[k].style = 5;
                    }
                    pLinePoints[26] = new POINT2(pt1);
                    dRadius = lineutility.CalcDistanceDouble(pt1, pt0);
                    midpt = lineutility.ExtendLine2Double(pt1, pt0, -dRadius / 2.0 - 7.0, 0);
                    pLinePoints[27] = new POINT2(midpt);
                    pLinePoints[27].style = 0;
                    midpt = lineutility.ExtendLine2Double(pt1, pt0, -dRadius / 2.0 + 7.0, 0);
                    pLinePoints[28] = new POINT2(midpt);
                    pLinePoints[29] = new POINT2(pt0);
                    pLinePoints[29].style = 5;
                    lineutility.GetArrowHead4Double(pt1, pt0, 15, 15, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[30 + k] = new POINT2(pArrowPoints[k]);
                    }
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[30 + k].style = 5;
                    }
                    midpt = lineutility.MidPointDouble(pt0, pt1, 0);
                    d = lineutility.CalcDistanceDouble(pt1, calcPoint0);
                    pLinePoints[33] = pt2;
                    pt3 = lineutility.PointRelativeToLine(pt0, pt1, pt0, pt2);
                    d = lineutility.CalcDistanceDouble(pt3, pt2);
                    pt4 = lineutility.ExtendAlongLineDouble(pt0, pt1, d);
                    d = lineutility.CalcDistanceDouble(pt2, pt4);
                    pLinePoints[34] = lineutility.ExtendLineDouble(pt2, pt4, d);
                    acCounter = 35;
                    break;
                }
                case 211200000: {
                    d = lineutility.CalcDistanceDouble(pLinePoints[0], pLinePoints[1]);
                    d2 = client.startsWith("cpof") ? 20.0 : 30.0;
                    if (d < d2) {
                        lineType = 22522220;
                        arraysupport.GetLineArray2Double(22522220, pLinePoints, 5, 2, shapes, clipBounds, rev, converter);
                        break;
                    }
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    if (dMBR / 10.0 > 100.0) {
                        dMBR = 1000.0;
                    }
                    if (dMBR / 10.0 < minLength) {
                        dMBR = 10.0 * minLength;
                    }
                    if (dMBR > 150.0) {
                        dMBR = 150.0;
                    }
                    pLinePoints[0] = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], -2.0 * dMBR / 10.0);
                    for (k = 0; k < vblCounter - 14; ++k) {
                        pLinePoints[k].style = 18;
                    }
                    pLinePoints[vblCounter - 15].style = 5;
                    pt0 = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], 5.0 * dMBR / 10.0);
                    lineutility.GetArrowHead4Double(pt0, pLinePoints[0], (int)dMBR / 10, (int)dMBR / 10, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 14 + k] = new POINT2(pArrowPoints[k]);
                    }
                    pt3 = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], dMBR / 10.0);
                    lineutility.GetArrowHead4Double(pt0, pt3, (int)dMBR / 10, (int)dMBR / 10, pArrowPoints, 0);
                    pLinePoints[vblCounter - 12].style = 0;
                    pLinePoints[vblCounter - 11] = new POINT2(pArrowPoints[2]);
                    pLinePoints[vblCounter - 11].style = 0;
                    pLinePoints[vblCounter - 10] = new POINT2(pArrowPoints[0]);
                    pLinePoints[vblCounter - 10].style = 0;
                    pLinePoints[vblCounter - 9] = new POINT2(pLinePoints[vblCounter - 14]);
                    pLinePoints[vblCounter - 9].style = 5;
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 16], pLinePoints[vblCounter - 15], (int)dMBR / 10, (int)dMBR / 10, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 8 + k] = new POINT2(pArrowPoints[k]);
                    }
                    pLinePoints[vblCounter - 6].style = 0;
                    pLinePoints[1] = pt3 = lineutility.ExtendLineDouble(pLinePoints[vblCounter - 16], pLinePoints[vblCounter - 15], -0.75 * dMBR / 10.0);
                    pLinePoints[1].style = 5;
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 16], pt3, (int)(dMBR / 10.0), (int)(dMBR / 10.0), pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 5 + k] = new POINT2(pArrowPoints[2 - k]);
                    }
                    pLinePoints[vblCounter - 5].style = 0;
                    pLinePoints[vblCounter - 2] = new POINT2(pLinePoints[vblCounter - 8]);
                    pLinePoints[vblCounter - 2].style = 5;
                    pLinePoints[vblCounter - 1] = new POINT2(pLinePoints[vblCounter - 7]);
                    acCounter = 16;
                    break;
                }
                case 211210000: {
                    d2 = client.startsWith("cpof") ? 25.0 : 25.0;
                    double folspDist = 0.0;
                    folspDist = lineutility.CalcDistanceDouble(pLinePoints[0], pLinePoints[1]);
                    if (folspDist < d2) {
                        lineType = 22522220;
                        arraysupport.GetLineArray2Double(lineType, pLinePoints, 5, 2, shapes, clipBounds, rev, converter);
                        break;
                    }
                    lineutility.ReversePointsDouble2(pLinePoints, vblSaveCounter);
                    if (dMBR / 10.0 > 100.0) {
                        dMBR = 1000.0;
                    }
                    if (dMBR / 10.0 < minLength) {
                        dMBR = 10.0 * minLength;
                    }
                    if (dMBR > 250.0) {
                        dMBR = 250.0;
                    }
                    if (client.startsWith("cpof")) {
                        if (folspDist < 25.0) {
                            dMBR = 125.0;
                        }
                        if (folspDist < 75.0) {
                            dMBR = 150.0;
                        }
                        if (folspDist < 100.0) {
                            dMBR = 175.0;
                        }
                        if (folspDist < 125.0) {
                            dMBR = 200.0;
                        }
                    } else {
                        dMBR *= 1.5;
                    }
                    pLinePoints[0] = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], -dMBR / 8.75);
                    pLinePoints[vblCounter - 15].style = 5;
                    pt0 = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], dMBR / 4.0);
                    lineutility.GetArrowHead4Double(pt0, pLinePoints[0], (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 14 + k] = new POINT2(pArrowPoints[k]);
                    }
                    pLinePoints[vblCounter - 12].style = 0;
                    pt3 = lineutility.ExtendLineDouble(pLinePoints[1], pLinePoints[0], dMBR / 15.0);
                    lineutility.GetArrowHead4Double(pt0, pt3, (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 0);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 11 + k] = new POINT2(pArrowPoints[2 - k]);
                        pLinePoints[vblCounter - 11 + k].style = 0;
                    }
                    pLinePoints[vblCounter - 8] = new POINT2(pLinePoints[vblCounter - 14]);
                    pLinePoints[vblCounter - 8].style = 5;
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 16], pLinePoints[vblCounter - 15], (int)dMBR / 20, (int)dMBR / 20, pArrowPoints, 9);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 7 + k] = new POINT2(pArrowPoints[k]);
                    }
                    for (k = 4; k > 0; --k) {
                        pLinePoints[vblCounter - k].style = 5;
                    }
                    acCounter = 12;
                    break;
                }
                case 23223000: {
                    lLinestyle = 9;
                    if (dMBR / 10.0 > 100.0) {
                        dMBR = 1000.0;
                    }
                    if (dMBR / 10.0 < minLength) {
                        dMBR = 10.0 * minLength;
                    }
                    if (dMBR > 250.0) {
                        dMBR = 250.0;
                    }
                    lineutility.GetArrowHead4Double(pLinePoints[vblCounter - 8], pLinePoints[vblCounter - 7], (int)dMBR / 10, (int)dMBR / 10, pArrowPoints, lLinestyle);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 6 + k] = new POINT2(pArrowPoints[k]);
                    }
                    lineutility.GetArrowHead4Double(pLinePoints[1], pLinePoints[0], (int)dMBR / 10, (int)dMBR / 10, pArrowPoints, lLinestyle);
                    for (k = 0; k < 3; ++k) {
                        pLinePoints[vblCounter - 3 + k] = new POINT2(pArrowPoints[k]);
                    }
                    acCounter = 8;
                    break;
                }
                case 26220000: {
                    pt3 = lineutility.ExtendLine2Double(pt1, pt0, -10.0, 0);
                    pt4 = lineutility.ExtendLine2Double(pt0, pt1, -10.0, 0);
                    pt5 = lineutility.ExtendTrueLinePerpDouble(pt0, pt1, pt3, 10.0, 0);
                    pt6 = lineutility.ExtendTrueLinePerpDouble(pt0, pt1, pt3, -10.0, 0);
                    pt7 = lineutility.ExtendTrueLinePerpDouble(pt0, pt1, pt4, 10.0, 0);
                    pt8 = lineutility.ExtendTrueLinePerpDouble(pt0, pt1, pt4, -10.0, 0);
                    pLinePoints[0] = pt5.y < pt6.y ? new POINT2(pt5) : new POINT2(pt6);
                    pLinePoints[3] = pt7.y > pt8.y ? new POINT2(pt7) : new POINT2(pt8);
                    pLinePoints[1] = new POINT2(pt0);
                    pLinePoints[2] = new POINT2(pt1);
                    acCounter = 4;
                    break;
                }
                case 23330000: {
                    acCounter = arraysupport.GetFORTLPointsDouble(pLinePoints, lineType, vblSaveCounter);
                    break;
                }
                case 21400000: {
                    acCounter = DISMSupport.GetDISMCanalizeDouble(pLinePoints, lineType);
                    break;
                }
                case 21200000: {
                    acCounter = DISMSupport.GetDISMBreachDouble(pLinePoints, lineType);
                    break;
                }
                case 212210000: 
                case 212220000: 
                case 212230000: {
                    acCounter = DISMSupport.GetDISMCoverDouble(pLinePoints, lineType);
                    break;
                }
                case 212210001: 
                case 212220001: 
                case 212230001: {
                    acCounter = DISMSupport.GetDISMCoverDoubleRevC(pLinePoints, lineType, vblSaveCounter);
                    break;
                }
                case 22139000: {
                    acCounter = DISMSupport.GetDISMCoverDouble(pLinePoints, lineType);
                    POINT2[] saraPts = new POINT2[16];
                    for (j = 0; j < 4; ++j) {
                        saraPts[j] = pLinePoints[j];
                    }
                    for (j = 4; j < 8; ++j) {
                        saraPts[j] = pLinePoints[j + 4];
                    }
                    for (j = 8; j < 12; ++j) {
                        saraPts[j] = pLinePoints[j - 4];
                    }
                    for (j = 12; j < 16; ++j) {
                        saraPts[j] = pLinePoints[j];
                    }
                    pLinePoints = saraPts;
                    break;
                }
                case 211000000: {
                    acCounter = DISMSupport.GetDISMDisruptDouble(pLinePoints, lineType);
                    break;
                }
                case 21600000: {
                    acCounter = DISMSupport.GetDISMContainDouble(pLinePoints, lineType);
                    break;
                }
                case 211700000: {
                    DISMSupport.GetDISMPenetrateDouble(pLinePoints, lineType);
                    acCounter = 7;
                    break;
                }
                case 23171000: {
                    DISMSupport.GetDISMBlockDouble2(pLinePoints, lineType);
                    acCounter = 4;
                    break;
                }
                case 21100000: {
                    DISMSupport.GetDISMBlockDouble2(pLinePoints, lineType);
                    acCounter = 4;
                    break;
                }
                case 24211000: 
                case 24250000: 
                case 24260000: {
                    acCounter = DISMSupport.GetDISMLinearTargetDouble(pLinePoints, lineType, vblCounter);
                    break;
                }
                case 23163000: 
                case 23221000: 
                case 23222000: {
                    DISMSupport.GetDISMGapDouble(pLinePoints, lineType);
                    acCounter = 12;
                    break;
                }
                case 23174000: {
                    acCounter = DISMSupport.GetDISMMinefieldDisruptDouble(pLinePoints, lineType);
                    break;
                }
                case 22534000: {
                    acCounter = DISMSupport.GetDISMSupportByFireDouble(pLinePoints, lineType);
                    break;
                }
                case 22533000: {
                    acCounter = DISMSupport.GetDISMATKBYFIREDouble(pLinePoints, lineType);
                    break;
                }
                case 23213000: {
                    acCounter = DISMSupport.GetDISMByImpDouble(pLinePoints, lineType);
                    break;
                }
                case 21500000: {
                    acCounter = DISMSupport.GetDISMClearDouble(pLinePoints, lineType);
                    break;
                }
                case 23212000: {
                    acCounter = DISMSupport.GetDISMByDifDouble(pLinePoints, lineType, clipBounds);
                    break;
                }
                case 212300000: {
                    acCounter = DISMSupport.GetDISMSeizeDouble(pLinePoints, lineType, 0.0);
                    break;
                }
                case 212300001: {
                    double radius = 0.0;
                    if (rev == 1) {
                        radius = lineutility.CalcDistanceDouble(pLinePoints[0], pLinePoints[1]);
                        pLinePoints[1] = new POINT2(pLinePoints[3]);
                        pLinePoints[2] = new POINT2(pLinePoints[2]);
                    }
                    acCounter = DISMSupport.GetDISMSeizeDouble(pLinePoints, lineType, radius);
                    break;
                }
                case 23172000: 
                case 211100000: {
                    acCounter = DISMSupport.GetDISMFixDouble(pLinePoints, lineType, clipBounds);
                    break;
                }
                case 211800000: {
                    acCounter = DISMSupport.GetDISMRIPDouble(pLinePoints, lineType);
                    break;
                }
                case 21800000: 
                case 212000000: 
                case 212400000: 
                case 212410000: {
                    acCounter = DISMSupport.GetDelayGraphicEtcDouble(pLinePoints);
                    break;
                }
                case 23211000: {
                    acCounter = DISMSupport.GetDISMEasyDouble(pLinePoints, lineType);
                    break;
                }
                case 22310000: {
                    DISMSupport.GetDISMDeceiveDouble(pLinePoints);
                    acCounter = 4;
                    break;
                }
                case 21300000: {
                    acCounter = DISMSupport.GetDISMBypassDouble(pLinePoints, lineType);
                    break;
                }
                case 24326100: {
                    DISMSupport.GetDISMPAADouble(pLinePoints, lineType);
                    acCounter = 5;
                    break;
                }
                case 22611000: {
                    acCounter = DISMSupport.AmbushPointsDouble(pLinePoints);
                    break;
                }
                case 22122000: {
                    acCounter = flot.GetFlotDouble(pLinePoints, vblSaveCounter);
                    break;
                }
                default: {
                    acCounter = vblSaveCounter;
                }
            }
            switch (lineType) {
                case 22121000: {
                    arraysupport.FillPoints(pLinePoints, acCounter, points);
                    return points;
                }
                case 0x222248: 
                case 14000000: 
                case 15000003: 
                case 21100000: 
                case 21200000: 
                case 21300000: 
                case 21400000: 
                case 21500000: 
                case 21600000: 
                case 22340000: 
                case 22522100: 
                case 23120000: 
                case 23226000: 
                case 23410000: 
                case 24326100: 
                case 25211000: 
                case 25212000: 
                case 211000000: 
                case 211100000: 
                case 211200000: 
                case 211210000: 
                case 211400000: 
                case 211600000: 
                case 211700000: 
                case 211900000: 
                case 212100000: 
                case 212210000: 
                case 212210001: 
                case 212220000: 
                case 212220001: 
                case 212230000: 
                case 212230001: 
                case 212300000: 
                case 212300001: 
                case 212500000: 
                case 212600000: 
                case 221311000: {
                    arraysupport.FillPoints(pLinePoints, acCounter, points);
                    break;
                }
                default: {
                    if (shapes != null) break;
                    arraysupport.FillPoints(pLinePoints, acCounter, points);
                    return points;
                }
            }
            if (shapes == null) {
                return points;
            }
            Shape2 shape = null;
            Object gp = null;
            Shape2 redShape = null;
            Shape2 blueShape = null;
            Shape2 paleBlueShape = null;
            Shape2 whiteShape = null;
            Shape2 redFillShape = null;
            Shape2 blueFillShape = null;
            Shape2 blackShape = null;
            Area blueArea = null;
            Area paleBlueArea = null;
            Area whiteArea = null;
            boolean beginLine = true;
            Polygon poly = null;
            block166 : switch (lineType) {
                case 13000001: 
                case 13000002: 
                case 15000001: 
                case 15000003: {
                    shape = new Shape2(1);
                    shape.moveTo(pLinePoints[0]);
                    for (j = 0; j < vblSaveCounter; ++j) {
                        shape.lineTo(pLinePoints[j]);
                    }
                    shapes.add(shape);
                    shape = new Shape2(0);
                    shape.moveTo(pOriginalLinePoints[0]);
                    for (j = 1; j < vblSaveCounter; ++j) {
                        shape.lineTo(pOriginalLinePoints[j]);
                    }
                    shapes.add(shape);
                    break;
                }
                case 22522210: {
                    shape = new Shape2(0);
                    shape.moveTo(pLinePoints[0]);
                    for (j = 0; j < acCounter - 10; ++j) {
                        shape.lineTo(pLinePoints[j]);
                    }
                    shapes.add(shape);
                    shape = new Shape2(0);
                    shape.moveTo(pLinePoints[acCounter - 10]);
                    for (j = 9; j > 0; --j) {
                        if (pLinePoints[acCounter - j - 1].style == 5) {
                            shape.moveTo(pLinePoints[acCounter - j]);
                            continue;
                        }
                        shape.lineTo(pLinePoints[acCounter - j]);
                    }
                    shapes.add(shape);
                    break;
                }
                case 32214000: {
                    whiteShape = new Shape2(1);
                    whiteShape.setFillColor(Color.WHITE);
                    BasicStroke whiteStroke = new BasicStroke(28.0f);
                    blueShape = new Shape2(1);
                    blueShape.setFillColor(new Color(30, 144, 255));
                    BasicStroke paleBlueStroke = new BasicStroke(14.0f);
                    paleBlueShape = new Shape2(1);
                    paleBlueShape.setFillColor(new Color(153, 204, 255));
                    poly = new Polygon();
                    for (k = 0; k < vblSaveCounter; ++k) {
                        poly.addPoint((int)pLinePoints[k].x, (int)pLinePoints[k].y);
                        if (k == 0) {
                            whiteShape.moveTo(pLinePoints[k]);
                            continue;
                        }
                        whiteShape.lineTo(pLinePoints[k]);
                    }
                    blueArea = new Area(poly);
                    blueShape.setShape(blueArea);
                    whiteArea = new Area(whiteStroke.createStrokedShape(poly));
                    whiteShape.setShape(lineutility.createStrokedShape(whiteArea));
                    paleBlueArea = new Area(paleBlueStroke.createStrokedShape(poly));
                    paleBlueShape.setShape(lineutility.createStrokedShape(paleBlueArea));
                    shapes.add(blueShape);
                    shapes.add(paleBlueShape);
                    shapes.add(whiteShape);
                    break;
                }
                case 32550000: {
                    redShape = new Shape2(0);
                    redShape.set_Style(1);
                    blueShape = new Shape2(0);
                    blueShape.set_Style(0);
                    redShape.moveTo(pLinePoints[0]);
                    for (k = 1; k < vblSaveCounter; ++k) {
                        redShape.lineTo(pLinePoints[k]);
                    }
                    beginLine = true;
                    for (k = vblSaveCounter; k < acCounter; ++k) {
                        if (pLinePoints[k].style == 0) {
                            if (beginLine) {
                                blueShape.moveTo(pLinePoints[k]);
                                beginLine = false;
                            } else {
                                blueShape.lineTo(pLinePoints[k]);
                            }
                        }
                        if (pLinePoints[k].style != 5) continue;
                        blueShape.lineTo(pLinePoints[k]);
                        beginLine = true;
                    }
                    shapes.add(redShape);
                    shapes.add(blueShape);
                    break;
                }
                case 31148000: {
                    redShape = new Shape2(0);
                    redShape.setLineColor(Color.RED);
                    blueShape = new Shape2(0);
                    blueShape.setLineColor(Color.GREEN);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style == 19 && pLinePoints[k + 1].style == 5) {
                            redShape.moveTo(pLinePoints[k]);
                            redShape.lineTo(pLinePoints[k + 1]);
                            continue;
                        }
                        if (pLinePoints[k].style != 25 || pLinePoints[k + 1].style != 5) continue;
                        blueShape.moveTo(pLinePoints[k]);
                        blueShape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(redShape);
                    shapes.add(blueShape);
                    break;
                }
                case 31134300: {
                    redShape = new Shape2(0);
                    redShape.setLineColor(Color.RED);
                    blueShape = new Shape2(0);
                    blueShape.setLineColor(Color.BLUE);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style == 23) {
                            redFillShape = new Shape2(1);
                            redFillShape.setFillColor(Color.RED);
                            redFillShape.moveTo(pLinePoints[k - 9]);
                            for (int l = k - 8; l <= k; ++l) {
                                redFillShape.lineTo(pLinePoints[l]);
                            }
                            shapes.add(redFillShape);
                        }
                        if (pLinePoints[k].style != 24) continue;
                        blueFillShape = new Shape2(1);
                        blueFillShape.setFillColor(Color.BLUE);
                        blueFillShape.moveTo(pLinePoints[k - 2]);
                        blueFillShape.lineTo(pLinePoints[k - 1]);
                        blueFillShape.lineTo(pLinePoints[k]);
                        shapes.add(blueFillShape);
                        redShape.moveTo(pLinePoints[k - 2]);
                        redShape.lineTo(pLinePoints[k - 1]);
                        redShape.lineTo(pLinePoints[k]);
                    }
                    for (k = 0; k < vblSaveCounter; ++k) {
                        if (k == 0) {
                            d = 50.0;
                            redShape.moveTo(pOriginalLinePoints[0]);
                            d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[0], pOriginalLinePoints[1]);
                            if (d1 < d) {
                                d = d1;
                            }
                            pt0 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[0], pOriginalLinePoints[1], d);
                            redShape.lineTo(pt0);
                            continue;
                        }
                        if (k > 0 && k < vblSaveCounter - 1) {
                            d = 50.0;
                            d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[k], pOriginalLinePoints[k - 1]);
                            if (d1 < d) {
                                d = d1;
                            }
                            pt0 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[k], pOriginalLinePoints[k - 1], d);
                            pt1 = pOriginalLinePoints[k];
                            d = 50.0;
                            d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[k], pOriginalLinePoints[k + 1]);
                            if (d1 < d) {
                                d = d1;
                            }
                            pt2 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[k], pOriginalLinePoints[k + 1], d);
                            redShape.moveTo(pt0);
                            redShape.lineTo(pt1);
                            redShape.lineTo(pt2);
                            continue;
                        }
                        d = 50.0;
                        d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[vblSaveCounter - 1], pOriginalLinePoints[vblSaveCounter - 2]);
                        if (d1 < d) {
                            d = d1;
                        }
                        redShape.moveTo(pOriginalLinePoints[vblSaveCounter - 1]);
                        pt0 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[vblSaveCounter - 1], pOriginalLinePoints[vblSaveCounter - 2], d);
                        redShape.lineTo(pt0);
                    }
                    for (k = 0; k < vblCounter - 1; ++k) {
                        if (pLinePoints[k].style == 19 && pLinePoints[k + 1].style == 5) {
                            redShape.moveTo(pLinePoints[k]);
                            redShape.lineTo(pLinePoints[k + 1]);
                            continue;
                        }
                        if (pLinePoints[k].style != 25 || pLinePoints[k + 1].style != 5) continue;
                        blueShape.moveTo(pLinePoints[k]);
                        blueShape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(redShape);
                    shapes.add(blueShape);
                    break;
                }
                case 31134200: {
                    POINT2[] CirclePoints;
                    redShape = new Shape2(0);
                    redShape.setLineColor(Color.RED);
                    blueShape = new Shape2(0);
                    blueShape.setLineColor(Color.BLUE);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style == 23) {
                            redFillShape = new Shape2(1);
                            redFillShape.setFillColor(Color.RED);
                            redFillShape.moveTo(pLinePoints[k - 9]);
                            for (int l = k - 8; l <= k; ++l) {
                                redFillShape.lineTo(pLinePoints[l]);
                            }
                            shapes.add(redFillShape);
                        }
                        if (pLinePoints[k].style != 24) continue;
                        blueFillShape = new Shape2(1);
                        blueFillShape.setFillColor(Color.BLUE);
                        blueFillShape.moveTo(pLinePoints[k - 2]);
                        blueFillShape.lineTo(pLinePoints[k - 1]);
                        blueFillShape.lineTo(pLinePoints[k]);
                        shapes.add(blueFillShape);
                        redShape.moveTo(pLinePoints[k - 2]);
                        redShape.lineTo(pLinePoints[k - 1]);
                        redShape.lineTo(pLinePoints[k]);
                    }
                    for (k = 0; k < vblSaveCounter; ++k) {
                        if (k == 0) {
                            d = 50.0;
                            redShape.moveTo(pOriginalLinePoints[0]);
                            d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[0], pOriginalLinePoints[1]);
                            if (d1 < d) {
                                d = d1;
                            }
                            pt0 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[0], pOriginalLinePoints[1], d);
                            redShape.lineTo(pt0);
                            continue;
                        }
                        if (k > 0 && k < vblSaveCounter - 1) {
                            d = 50.0;
                            d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[k], pOriginalLinePoints[k - 1]);
                            if (d1 < d) {
                                d = d1;
                            }
                            pt0 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[k], pOriginalLinePoints[k - 1], d);
                            pt1 = pOriginalLinePoints[k];
                            d = 50.0;
                            d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[k], pOriginalLinePoints[k + 1]);
                            if (d1 < d) {
                                d = d1;
                            }
                            pt2 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[k], pOriginalLinePoints[k + 1], d);
                            redShape.moveTo(pt0);
                            redShape.lineTo(pt1);
                            redShape.lineTo(pt2);
                            continue;
                        }
                        d = 50.0;
                        d1 = lineutility.CalcDistanceDouble(pOriginalLinePoints[vblSaveCounter - 1], pOriginalLinePoints[vblSaveCounter - 2]);
                        if (d1 < d) {
                            d = d1;
                        }
                        redShape.moveTo(pOriginalLinePoints[vblSaveCounter - 1]);
                        pt0 = lineutility.ExtendAlongLineDouble(pOriginalLinePoints[vblSaveCounter - 1], pOriginalLinePoints[vblSaveCounter - 2], d);
                        redShape.lineTo(pt0);
                    }
                    shapes.add(redShape);
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style == 22) {
                            CirclePoints = new POINT2[8];
                            redShape = lineutility.CalcCircleShape(pLinePoints[k], 3.0, 8, CirclePoints, 9);
                            redShape.setFillColor(Color.RED);
                            if (redShape != null && redShape.getShape() != null) {
                                shapes.add(redShape);
                            }
                        }
                        if (pLinePoints[k].style != 20) continue;
                        CirclePoints = new POINT2[8];
                        blueShape = lineutility.CalcCircleShape(pLinePoints[k], 3.0, 8, CirclePoints, 9);
                        blueShape.setFillColor(Color.BLUE);
                        if (blueShape == null || blueShape.getShape() == null) continue;
                        shapes.add(blueShape);
                    }
                    break;
                }
                case 31134100: {
                    redShape = new Shape2(0);
                    redShape.setLineColor(Color.RED);
                    blueShape = new Shape2(0);
                    blueShape.setLineColor(Color.BLUE);
                    beginLine = true;
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style == 19 && pLinePoints[k + 1].style == 5) {
                            redShape.moveTo(pLinePoints[k]);
                            redShape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style == 19 && pLinePoints[k + 1].style == 19) {
                            redShape.moveTo(pLinePoints[k]);
                            redShape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style == 25 && pLinePoints[k + 1].style == 5) {
                            blueShape.moveTo(pLinePoints[k]);
                            blueShape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style == 25 && pLinePoints[k + 1].style == 25) {
                            blueShape.moveTo(pLinePoints[k]);
                            blueShape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style != 0 || pLinePoints[k + 1].style != 5) continue;
                        redShape.moveTo(pLinePoints[k]);
                        redShape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(redShape);
                    shapes.add(blueShape);
                    break;
                }
                case 31134000: {
                    blackShape = new Shape2(0);
                    blackShape.setLineColor(Color.BLACK);
                    redShape = new Shape2(0);
                    redShape.setLineColor(Color.RED);
                    blueShape = new Shape2(0);
                    blueShape.setLineColor(Color.BLUE);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style == 23) {
                            redFillShape = new Shape2(1);
                            redFillShape.setFillColor(Color.RED);
                            redFillShape.moveTo(pLinePoints[k - 9]);
                            blackShape.moveTo(pLinePoints[k - 9]);
                            for (int l = k - 8; l <= k; ++l) {
                                redFillShape.lineTo(pLinePoints[l]);
                                blackShape.lineTo(pLinePoints[l]);
                            }
                            redFillShape.lineTo(pLinePoints[k - 9]);
                            shapes.add(redFillShape);
                        }
                        if (pLinePoints[k].style != 24) continue;
                        blueFillShape = new Shape2(1);
                        blueFillShape.setFillColor(Color.BLUE);
                        blueFillShape.moveTo(pLinePoints[k - 2]);
                        blueFillShape.lineTo(pLinePoints[k - 1]);
                        blueFillShape.lineTo(pLinePoints[k]);
                        blueFillShape.lineTo(pLinePoints[k - 2]);
                        shapes.add(blueFillShape);
                        blackShape.moveTo(pLinePoints[k - 2]);
                        blackShape.lineTo(pLinePoints[k - 1]);
                        blackShape.lineTo(pLinePoints[k]);
                    }
                    blackShape.moveTo(pOriginalLinePoints[0]);
                    for (k = 1; k < vblSaveCounter; ++k) {
                        blackShape.lineTo(pOriginalLinePoints[k]);
                    }
                    shapes.add(redShape);
                    shapes.add(blueShape);
                    shapes.add(blackShape);
                    break;
                }
                case 31132200: {
                    POINT2[] CirclePoints;
                    shape = new Shape2(0);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style != 0 || pLinePoints[k + 1].style != 5) continue;
                        shape.moveTo(pLinePoints[k]);
                        shape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(shape);
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style != 20 || (shape = lineutility.CalcCircleShape(pLinePoints[k], 3.0, 8, CirclePoints = new POINT2[8], 9)) == null || shape.getShape() == null) continue;
                        shapes.add(shape);
                    }
                    break;
                }
                case 211200000: {
                    shape = new Shape2(0);
                    shape.set_Style(1);
                    shape.moveTo(pLinePoints[0]);
                    shape.lineTo(pLinePoints[1]);
                    shapes.add(shape);
                    shape = new Shape2(0);
                    shape.set_Style(0);
                    for (j = 2; j < vblCounter; ++j) {
                        if (pLinePoints[j - 1].style != 5) {
                            shape.lineTo(pLinePoints[j]);
                            continue;
                        }
                        shape.moveTo(pLinePoints[j]);
                    }
                    shapes.add(shape);
                    break;
                }
                case 31131200: {
                    POINT2[] CirclePoints;
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style != 20 || (shape = lineutility.CalcCircleShape(pLinePoints[k], 3.0, 8, CirclePoints = new POINT2[8], 9)) == null || shape.getShape() == null) continue;
                        shapes.add(shape);
                    }
                    shape = new Shape2(0);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style == 0 && pLinePoints[k + 1].style == 0) {
                            shape.moveTo(pLinePoints[k]);
                            shape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style == 0 && pLinePoints[k + 1].style == 9) {
                            shape.moveTo(pLinePoints[k]);
                            shape.lineTo(pLinePoints[k + 1]);
                        }
                        if (pLinePoints[k].style == 0 && pLinePoints[k + 1].style == 5) {
                            d = lineutility.CalcDistanceDouble(pLinePoints[k], pLinePoints[k + 1]);
                            pt0 = lineutility.ExtendAlongLineDouble(pLinePoints[k], pLinePoints[k + 1], d - 5.0);
                            shape.moveTo(pLinePoints[k]);
                            shape.lineTo(pt0);
                        }
                        if (pLinePoints[k].style != 0 || k != acCounter - 2) continue;
                        shape.moveTo(pLinePoints[k]);
                        shape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(shape);
                    break;
                }
                case 32680000: {
                    POINT2[] CirclePoints;
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style != 20 || (shape = lineutility.CalcCircleShape(pLinePoints[k], 5.0, 8, CirclePoints = new POINT2[8], 9)) == null || shape.getShape() == null) continue;
                        shapes.add(shape);
                    }
                    shape = new Shape2(0);
                    for (k = 0; k < acCounter - 1; ++k) {
                        if (pLinePoints[k].style != 0 || pLinePoints[k + 1].style != 5) continue;
                        shape.moveTo(pLinePoints[k]);
                        shape.lineTo(pLinePoints[k + 1]);
                    }
                    shapes.add(shape);
                    break;
                }
                case 23200001: {
                    POINT2[] CirclePoints;
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style != 20 || (shape = lineutility.CalcCircleShape(pLinePoints[k], 5.0, 8, CirclePoints = new POINT2[8], 9)) == null || shape.getShape() == null) continue;
                        shapes.add(shape);
                    }
                    shape = new Shape2(0);
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style != 1) continue;
                        if (k == 0) {
                            shape.moveTo(pLinePoints[k]);
                            continue;
                        }
                        shape.lineTo(pLinePoints[k]);
                    }
                    shapes.add(shape);
                    break;
                }
                case 23132000: {
                    POINT2[] CirclePoints;
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style == 20) {
                            CirclePoints = new POINT2[8];
                            shape = lineutility.CalcCircleShape(pLinePoints[k], 4.0, 8, CirclePoints, 9);
                            if (shape == null || shape.getShape() == null) continue;
                            shapes.add(shape);
                            continue;
                        }
                        if (k < acCounter - 2) {
                            if (pLinePoints[k].style != 0 && pLinePoints[k + 1].style == 0) {
                                shape = new Shape2(0);
                                shape.set_Style(pLinePoints[k].style);
                                shape.moveTo(pLinePoints[k]);
                                shape.lineTo(pLinePoints[k]);
                            } else if (pLinePoints[k].style == 0 && pLinePoints[k + 1].style == 0) {
                                shape.moveTo(pLinePoints[k]);
                                shape.lineTo(pLinePoints[k + 1]);
                            } else if (pLinePoints[k].style == 0 && pLinePoints[k + 1].style == 10) {
                                shape.moveTo(pLinePoints[k]);
                                shape.lineTo(pLinePoints[k + 1]);
                                shapes.add(shape);
                            }
                        }
                        if (k >= acCounter - 2) continue;
                        if (pLinePoints[k].style == 5 && pLinePoints[k + 1].style == 0) {
                            shape = new Shape2(0);
                            shape.set_Style(pLinePoints[k].style);
                            shape.moveTo(pLinePoints[k]);
                            continue;
                        }
                        if (pLinePoints[k].style == 0 && pLinePoints[k + 1].style == 0) {
                            shape.lineTo(pLinePoints[k + 1]);
                            continue;
                        }
                        if (pLinePoints[k].style != 0 || pLinePoints[k + 1].style != 5) continue;
                        shape.lineTo(pLinePoints[k + 1]);
                        shapes.add(shape);
                    }
                    break;
                }
                case 22330000: {
                    for (k = 0; k < vblCounter; ++k) {
                        if (pLinePoints[k].style == 18) continue;
                        if (shape == null) {
                            shape = new Shape2(0);
                        }
                        if (beginLine) {
                            if (k > 0 && pLinePoints[k].style == 5 && pLinePoints[k - 1].style == 5) continue;
                            if (k == 0) {
                                shape.set_Style(pLinePoints[k].style);
                            }
                            shape.moveTo(pLinePoints[k]);
                            beginLine = false;
                        } else {
                            shape.lineTo(pLinePoints[k]);
                            if (pLinePoints[k].style == 5) {
                                beginLine = true;
                            }
                        }
                        if (k != vblCounter - 1 || shape == null || shape.getShape() == null) continue;
                        shapes.add(shape);
                    }
                    for (k = 0; k < vblCounter; ++k) {
                        if (pLinePoints[k].style == 18 && pLinePoints[k - 1].style == 5) {
                            shape = new Shape2(0);
                            shape.set_Style(1);
                            shape.moveTo(pLinePoints[k]);
                            continue;
                        }
                        if (pLinePoints[k].style == 18 && pLinePoints[k - 1].style == 18) {
                            shape.lineTo(pLinePoints[k]);
                            continue;
                        }
                        if (pLinePoints[k].style != 5 || pLinePoints[k - 1].style != 18) continue;
                        shape.lineTo(pLinePoints[k]);
                        if (shape == null || shape.getShape() == null) break block166;
                        shapes.add(shape);
                        break block166;
                    }
                    break;
                }
                case 23192000: {
                    shape = new Shape2(0);
                    shape.set_Style(pLinePoints[0].style);
                    shape.moveTo(pLinePoints[0]);
                    shape.lineTo(pLinePoints[1]);
                    shapes.add(shape);
                    shape = new Shape2(0);
                    shape.set_Style(pLinePoints[2].style);
                    shape.moveTo(pLinePoints[2]);
                    shape.lineTo(pLinePoints[3]);
                    shapes.add(shape);
                    break;
                }
                case 0x222248: {
                    shape = new Shape2(0);
                    beginLine = true;
                    for (k = 0; k < acCounter - 3; ++k) {
                        if (shape == null) {
                            shape = new Shape2(0);
                        }
                        if (beginLine) {
                            if (k == 0) {
                                shape.set_Style(pLinePoints[k].style);
                            }
                            shape.moveTo(pLinePoints[k]);
                            beginLine = false;
                        } else {
                            shape.lineTo(pLinePoints[k]);
                            if (pLinePoints[k].style == 5 || pLinePoints[k].style == 10) {
                                beginLine = true;
                            }
                        }
                        if (k != acCounter - 4 || shape == null || shape.getShape() == null) continue;
                        shapes.add(shape);
                    }
                    shape = new Shape2(0);
                    shape.set_Style(1);
                    shape.moveTo(pLinePoints[acCounter - 1]);
                    shape.lineTo(pLinePoints[acCounter - 2]);
                    shape.lineTo(pLinePoints[acCounter - 3]);
                    if (shape == null || shape.getShape() == null) break;
                    shapes.add(shape);
                    break;
                }
                case 22340000: {
                    shape = new Shape2(0);
                    shape.set_Style(pLinePoints[0].style);
                    shape.moveTo(pLinePoints[0]);
                    for (k = 1; k < vblCounter - 3; ++k) {
                        shape.lineTo(pLinePoints[k]);
                    }
                    if (shape != null && shape.getShape() != null) {
                        shapes.add(shape);
                    }
                    shape = new Shape2(0);
                    shape.moveTo(pLinePoints[vblCounter - 3]);
                    shape.set_Style(1);
                    shape.lineTo(pLinePoints[vblCounter - 2]);
                    shape.lineTo(pLinePoints[vblCounter - 1]);
                    if (shape == null || shape.getShape() == null) break;
                    shapes.add(shape);
                    break;
                }
                case 23225000: {
                    shape = new Shape2(0);
                    shape.set_Style(pLinePoints[0].style);
                    shape.moveTo(pLinePoints[0]);
                    shape.lineTo(pLinePoints[1]);
                    shape.moveTo(pLinePoints[2]);
                    shape.lineTo(pLinePoints[3]);
                    shapes.add(shape);
                    shape = new Shape2(0);
                    shape.set_Style(pLinePoints[4].style);
                    shape.moveTo(pLinePoints[4]);
                    for (k = 5; k < acCounter; ++k) {
                        if (pLinePoints[k - 1].style == 5) continue;
                        shape.lineTo(pLinePoints[k]);
                    }
                    if (shape == null || shape.getShape() == null) break;
                    shapes.add(shape);
                    break;
                }
                case 22350000: {
                    shape = new Shape2(0);
                    shape.set_Style(points.get((int)0).style);
                    shape.moveTo(points.get(0));
                    for (k = 1; k < vblCounter - 3; ++k) {
                        shape.lineTo(points.get(k));
                    }
                    if (shape != null && shape.getShape() != null) {
                        shapes.add(shape);
                    }
                    shape = new Shape2(0);
                    shape.moveTo(points.get(vblCounter - 3));
                    shape.set_Style(1);
                    shape.lineTo(points.get(vblCounter - 2));
                    shape.lineTo(points.get(vblCounter - 1));
                    if (shape != null && shape.getShape() != null) {
                        shapes.add(shape);
                    }
                    shape = new Shape2(0);
                    beginLine = true;
                    for (k = vblCounter; k < points.size(); ++k) {
                        if (beginLine) {
                            if (k == 0) {
                                shape.set_Style(points.get((int)k).style);
                            }
                            if (k > 0 && points.get((int)k).style == 5 && points.get((int)(k - 1)).style == 5) {
                                shape.lineTo(points.get(k));
                            }
                            shape.moveTo(points.get(k));
                            beginLine = false;
                        } else {
                            shape.lineTo(points.get(k));
                            if (points.get((int)k).style == 5 || points.get((int)k).style == 10) {
                                beginLine = true;
                            }
                        }
                        if (k != points.size() - 1 || shape == null || shape.getShape() == null) continue;
                        shapes.add(shape);
                    }
                    break;
                }
                case 221311000: {
                    shape = new Shape2(0);
                    shape.moveTo(pLinePoints[0]);
                    for (k = 1; k < acCounter - 5; ++k) {
                        shape.lineTo(pLinePoints[k]);
                    }
                    shapes.add(shape);
                    shape = new Shape2(0);
                    shape.moveTo(pLinePoints[acCounter - 4]);
                    shape.lineTo(pLinePoints[acCounter - 3]);
                    shape.moveTo(pLinePoints[acCounter - 2]);
                    shape.lineTo(pLinePoints[acCounter - 1]);
                    shapes.add(shape);
                    break;
                }
                case -1: {
                    shape = new Shape2(0);
                    shape.moveTo(pLinePoints[0]);
                    for (k = 1; k < pLinePoints.length; ++k) {
                        shape.lineTo(pLinePoints[k]);
                    }
                    shapes.add(shape);
                    break;
                }
                default: {
                    for (k = 0; k < acCounter; ++k) {
                        if (shape == null) {
                            shape = new Shape2(0);
                        }
                        if (beginLine) {
                            if (k == 0) {
                                shape.set_Style(pLinePoints[k].style);
                            }
                            if (k > 0 && (pLinePoints[k].style == 5 && pLinePoints[k - 1].style == 5 && k < acCounter - 1 || pLinePoints[k].style == 5 && pLinePoints[k - 1].style == 10) || k == 0 && pLinePoints.length > 1 && pLinePoints[k].style == 5 && pLinePoints[k + 1].style == 5) continue;
                            shape.moveTo(pLinePoints[k]);
                            beginLine = false;
                        } else {
                            shape.lineTo(pLinePoints[k]);
                            if (pLinePoints[k].style == 5 || pLinePoints[k].style == 10) {
                                beginLine = true;
                            }
                        }
                        if (k != acCounter - 1 || shape == null || shape.getShape() == null) continue;
                        shapes.add(shape);
                    }
                }
            }
            switch (lineType) {
                case 22221000: 
                case 22222000: 
                case 22222001: 
                case 22223000: 
                case 22224000: 
                case 22224001: 
                case 22225000: {
                    for (j = 0; j < vblSaveCounter - 1; ++j) {
                        dMBR = pOriginalLinePoints[j].style;
                        acPoints[0] = new POINT2(pOriginalLinePoints[j]);
                        acPoints[1] = new POINT2(pOriginalLinePoints[j + 1]);
                        lineutility.GetSAAFRFillSegment(acPoints, dMBR);
                        shape = new Shape2(1);
                        shape.moveTo(acPoints[0]);
                        shape.lineTo(acPoints[1]);
                        shape.lineTo(acPoints[2]);
                        shape.lineTo(acPoints[3]);
                        shapes.add(0, shape);
                    }
                    break;
                }
                case 23111001: {
                    shape = new Shape2(1);
                    shape.moveTo(pUpperLinePoints[0]);
                    for (j = 1; j < pUpperLinePoints.length; ++j) {
                        shape.lineTo(pUpperLinePoints[j]);
                    }
                    shape.lineTo(pLowerLinePoints[pLowerLinePoints.length - 1]);
                    for (j = pLowerLinePoints.length - 1; j >= 0; --j) {
                        shape.lineTo(pLowerLinePoints[j]);
                    }
                    shape.lineTo(pUpperLinePoints[0]);
                    shapes.add(0, shape);
                    break;
                }
                case 22522100: {
                    int outLineCounter = 0;
                    POINT2[] ptOutline = new POINT2[4];
                    for (k = 0; k < acCounter; ++k) {
                        if (pLinePoints[k].style != 10) continue;
                        shape = new Shape2(0);
                        shape.moveTo(pLinePoints[k - 2]);
                        shape.lineTo(pLinePoints[k]);
                        if (shape != null && shape.getShape() != null) {
                            shapes.add(1, shape);
                        }
                        ptOutline[outLineCounter++] = pLinePoints[k - 2];
                        ptOutline[outLineCounter++] = pLinePoints[k];
                    }
                    break;
                }
                case 22139000: 
                case 23131200: 
                case 23132000: 
                case 23172000: 
                case 23173000: 
                case 23174000: 
                case 23211000: 
                case 23212000: 
                case 23213000: 
                case 23223000: 
                case 31131000: 
                case 31131200: 
                case 31131300: 
                case 31132000: 
                case 31132200: 
                case 31132300: 
                case 31133000: 
                case 31133200: 
                case 211210000: {
                    for (k = 0; k < acCounter; ++k) {
                        if (k == 0) {
                            if (pLinePoints[k].style == 9) {
                                shape = new Shape2(1);
                                shape.set_Style(pLinePoints[k].style);
                                shape.moveTo(pLinePoints[k]);
                            }
                        } else {
                            if (pLinePoints[k].style == 9 && pLinePoints[k - 1].style != 9) {
                                shape = new Shape2(1);
                                shape.set_Style(pLinePoints[k].style);
                                shape.moveTo(pLinePoints[k]);
                            }
                            if (pLinePoints[k].style == 9 && pLinePoints[k - 1].style == 9) {
                                shape.lineTo(pLinePoints[k]);
                            }
                        }
                        if (pLinePoints[k].style != 10) continue;
                        shape.lineTo(pLinePoints[k]);
                        if (shape == null || shape.getShape() == null) continue;
                        shapes.add(0, shape);
                    }
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetLineArray2Double", new RendererException("GetLineArray2Dboule " + Integer.toString(lineType), exc));
        }
        return points;
    }
}

