/*
 * Decompiled with CFR 0.152.
 */
package me.yokeyword.eventbusactivityscope;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.greenrobot.eventbus.EventBus;

public class EventBusActivityScope {
    private static final String TAG = EventBusActivityScope.class.getSimpleName();
    private static AtomicBoolean sInitialized = new AtomicBoolean(false);
    private static volatile EventBus sInvalidEventBus;
    private static final ArrayList<Activity> sActivityList;
    private static final Map<Activity, EventBus> sActivityEventBusScopePool;

    static void init(Context context) {
        if (sInitialized.getAndSet(true)) {
            return;
        }
        ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onActivityCreated(Activity activity, Bundle bundle) {
                ArrayList arrayList = sActivityList;
                synchronized (arrayList) {
                    sActivityList.add(activity);
                }
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onActivityDestroyed(Activity activity) {
                Object object = sActivityList;
                synchronized (object) {
                    sActivityList.remove(activity);
                }
                object = sActivityEventBusScopePool;
                synchronized (object) {
                    sActivityEventBusScopePool.remove(activity);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventBus getDefault(Activity activity) {
        if (activity == null) {
            Log.e((String)TAG, (String)"Can't find the Activity, the Activity is null!");
            return EventBusActivityScope.invalidEventBus();
        }
        ArrayList<Activity> arrayList = sActivityList;
        synchronized (arrayList) {
            if (!sActivityList.contains(activity)) {
                Log.e((String)TAG, (String)"Can't find the Activity, it has been removed!");
                return EventBusActivityScope.invalidEventBus();
            }
        }
        EventBus eventBus = sActivityEventBusScopePool.get(activity);
        if (eventBus == null) {
            Map<Activity, EventBus> map = sActivityEventBusScopePool;
            synchronized (map) {
                if (sActivityEventBusScopePool.get(activity) == null) {
                    eventBus = new EventBus();
                    sActivityEventBusScopePool.put(activity, eventBus);
                }
            }
        }
        return eventBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EventBus invalidEventBus() {
        if (sInvalidEventBus != null) return sInvalidEventBus;
        Class<EventBusActivityScope> clazz = EventBusActivityScope.class;
        synchronized (EventBusActivityScope.class) {
            if (sInvalidEventBus != null) return sInvalidEventBus;
            sInvalidEventBus = new EventBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInvalidEventBus;
        }
    }

    static {
        sActivityList = new ArrayList();
        sActivityEventBusScopePool = new ConcurrentHashMap<Activity, EventBus>();
    }
}

