/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning.commons;

import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

public class TagComparator
implements Comparator<Ref> {
    private final RevWalk revWalk;

    public TagComparator(Repository repository) {
        this.revWalk = new RevWalk(repository);
    }

    @Override
    public int compare(Ref ref1, Ref ref2) {
        RevObject rev1 = TagComparator.tryUnchecked(() -> this.revWalk.parseAny((AnyObjectId)ref1.getObjectId()));
        RevObject rev2 = TagComparator.tryUnchecked(() -> this.revWalk.parseAny((AnyObjectId)ref2.getObjectId()));
        if (rev1 instanceof RevTag && rev2 instanceof RevTag) {
            return TagComparator.compareTaggerDate((RevTag)rev1, (RevTag)rev2);
        }
        if (rev1 instanceof RevTag) {
            return -1;
        }
        if (rev2 instanceof RevTag) {
            return 1;
        }
        return TagComparator.compareTagVersion(ref1, ref2);
    }

    private static <R> R tryUnchecked(Callable<R> block) {
        try {
            return block.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int compareTagVersion(Ref ref1, Ref ref2) {
        DefaultArtifactVersion version1 = new DefaultArtifactVersion(ref1.getName());
        DefaultArtifactVersion version2 = new DefaultArtifactVersion(ref2.getName());
        return -version1.compareTo((ArtifactVersion)version2);
    }

    private static int compareTaggerDate(RevTag rev1, RevTag rev2) {
        Date revTag1Date = rev1.getTaggerIdent().getWhen();
        Date revTag2Date = rev2.getTaggerIdent().getWhen();
        return -revTag1Date.compareTo(revTag2Date);
    }
}

