/*
 * Decompiled with CFR 0.152.
 */
package me.littlecheesecake.croplayout.util;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageHelper {
    private static final String IMAGE_HELPER = "image helper";

    public static Bitmap rotateImage(Bitmap bitmap, int degree) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degree);
        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return bitmap;
    }

    public static Bitmap getBitmapFromPath(String filePath) {
        BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
        bitmapOptions.inScaled = false;
        bitmapOptions.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)bitmapOptions);
    }

    public static Bitmap getBitmapFromResource(Resources resource, int id) {
        BitmapFactory.Options bitmapOptions = new BitmapFactory.Options();
        bitmapOptions.inScaled = false;
        bitmapOptions.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)resource, (int)id, (BitmapFactory.Options)bitmapOptions);
    }

    public static void saveImageToPath(Bitmap bitmap, String imagePath) {
        try {
            File imageFile = new File(imagePath);
            FileOutputStream fos = new FileOutputStream(imageFile);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            Log.d((String)IMAGE_HELPER, (String)e.toString());
        }
    }

    public static String saveImageCropToPath(Bitmap bitmap, int x1, int y1, int x2, int y2, String directoryPath, String imageName) {
        if (y2 - y1 > bitmap.getHeight()) {
            y2 = bitmap.getHeight() + y1;
        }
        if (x2 - x1 > bitmap.getWidth()) {
            x2 = bitmap.getWidth() + x1;
        }
        Bitmap cropBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
        String fullPath = null;
        try {
            File fileDir = new File(directoryPath);
            if (!fileDir.exists()) {
                fileDir.mkdir();
            }
            File imageFile = new File(directoryPath, imageName);
            FileOutputStream fos = new FileOutputStream(imageFile);
            cropBitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)fos);
            fos.flush();
            fos.close();
            fullPath = imageFile.getPath();
        }
        catch (IOException e) {
            Log.d((String)IMAGE_HELPER, (String)e.toString());
        }
        cropBitmap.recycle();
        return fullPath;
    }
}

