/*
 * Decompiled with CFR 0.152.
 */
package me.littlecheesecake.croplayout.model;

public class ScalableBox
implements Cloneable {
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private int _x1;
    private int _x2;
    private int _y1;
    private int _y2;

    public void setX1(int x1) {
        this.x1 = x1;
    }

    public void setX2(int x2) {
        this.x2 = x2;
    }

    public void setY1(int y1) {
        this.y1 = y1;
    }

    public void setY2(int y2) {
        this.y2 = y2;
    }

    public int getX1() {
        return this.x1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY1() {
        return this.y1;
    }

    public int getY2() {
        return this.y2;
    }

    public ScalableBox() {
    }

    public ScalableBox(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void resizeBox(int x, int y, int dx, int dy, int limitX1, int limitY1, int limitX2, int limitY2, int cornerBoundary) {
        this._x1 = limitX1;
        this._x2 = limitX2;
        this._y1 = limitY1;
        this._y2 = limitY2;
        if (Math.abs(x - this.x1) < cornerBoundary && Math.abs(y - this.y1) < cornerBoundary) {
            if (this.checkLimit(cornerBoundary) && dx > 0) {
                dx = 0;
            }
            if (this.checkLimit(cornerBoundary) && dy > 0) {
                dy = 0;
            }
            this.moveCorner(AREA.TL, dx, dy);
        } else if (Math.abs(x - this.x2) < cornerBoundary && Math.abs(y - this.y1) < cornerBoundary) {
            if (this.checkLimit(cornerBoundary) && dx < 0) {
                dx = 0;
            }
            if (this.checkLimit(cornerBoundary) && dy > 0) {
                dy = 0;
            }
            this.moveCorner(AREA.TR, dx, dy);
        } else if (Math.abs(x - this.x1) < cornerBoundary && Math.abs(y - this.y2) < cornerBoundary) {
            if (this.checkLimit(cornerBoundary) && dx > 0) {
                dx = 0;
            }
            if (this.checkLimit(cornerBoundary) && dy < 0) {
                dy = 0;
            }
            this.moveCorner(AREA.BL, dx, dy);
        } else if (Math.abs(x - this.x2) < cornerBoundary && Math.abs(y - this.y2) < cornerBoundary) {
            if (this.checkLimit(cornerBoundary) && dx < 0) {
                dx = 0;
            }
            if (this.checkLimit(cornerBoundary) && dy < 0) {
                dy = 0;
            }
            this.moveCorner(AREA.BR, dx, dy);
        } else if (x > this.x1 && x < this.x2 && y > this.y1 && y < this.y2) {
            if (this.x1 <= limitX1 && dx < 0 || this.x2 >= limitX2 && dx > 0) {
                dx = 0;
            }
            if (this.y1 <= limitY1 && dy < 0 || this.y2 >= limitY2 && dy > 0) {
                dy = 0;
            }
            this.moveBox(dx, dy);
        }
    }

    private void moveBox(int dx, int dy) {
        this.setX1(this.checkBoundaryX(this.x1 + dx));
        this.setY1(this.checkBoundaryY(this.y1 + dy));
        this.setX2(this.checkBoundaryX(this.x2 + dx));
        this.setY2(this.checkBoundaryY(this.y2 + dy));
    }

    private int checkBoundaryX(int p) {
        if (p <= this._x1) {
            return this._x1;
        }
        if (p >= this._x2) {
            return this._x2;
        }
        return p;
    }

    private int checkBoundaryY(int p) {
        if (p <= this._y1) {
            return this._y1;
        }
        if (p >= this._y2) {
            return this._y2;
        }
        return p;
    }

    private void moveCorner(AREA corner, int dx, int dy) {
        switch (corner) {
            case TL: {
                this.setX1(this.checkBoundaryX(this.x1 + dx));
                this.setY1(this.checkBoundaryY(this.y1 + dy));
                break;
            }
            case TR: {
                this.setX2(this.checkBoundaryX(this.x2 + dx));
                this.setY1(this.checkBoundaryY(this.y1 + dy));
                break;
            }
            case BL: {
                this.setX1(this.checkBoundaryX(this.x1 + dx));
                this.setY2(this.checkBoundaryY(this.y2 + dy));
                break;
            }
            case BR: {
                this.setX2(this.checkBoundaryX(this.x2 + dx));
                this.setY2(this.checkBoundaryY(this.y2 + dy));
            }
        }
    }

    private boolean checkLimit(int cornerBoundary) {
        return this.x2 - this.x1 <= cornerBoundary * 2 || this.y2 - this.y1 <= cornerBoundary * 2;
    }

    public Object clone() throws CloneNotSupportedException {
        return (ScalableBox)super.clone();
    }

    private static enum AREA {
        TL,
        TR,
        BL,
        BR;

    }
}

