/*
 * Decompiled with CFR 0.152.
 */
package me.littlecheesecake.croplayout;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import me.littlecheesecake.croplayout.EditableImage;
import me.littlecheesecake.croplayout.handler.OnBoxChangedListener;
import me.littlecheesecake.croplayout.model.ScalableBox;

public class SelectionView
extends View
implements View.OnTouchListener {
    private static final String SELECTION_VIEW = "BOX SELECTION VIEW";
    private OnBoxChangedListener onBoxChangedListener;
    private EditableImage editableImage;
    private int bitmapWidth;
    private int bitmapHeight;
    private int originX;
    private int originY;
    private List<ScalableBox> displayBoxes;
    private int prevX;
    private int prevY;
    private int prevBoxX1;
    private int prevBoxX2;
    private int prevBoxY1;
    private int prevBoxY2;
    private final Paint mPaint = new Paint(1);
    private float lineWidth;
    private float cornerWidth;
    private float cornerLength;
    private float offset;
    private float offset_2;
    private int lineColor;
    private int cornerColor;
    private int dotColor;
    private int shadowColor;
    private boolean animatingExpanding = false;
    private int[] startingCenter = new int[4];
    private int[] targetingBoxes = new int[4];

    public SelectionView(Context context, float lineWidth, float cornerWidth, float cornerLength, int lineColor, int cornerColor, int dotColor, int shadowColor, EditableImage editableImage) {
        super(context);
        this.setOnTouchListener(this);
        this.editableImage = editableImage;
        this.lineWidth = lineWidth;
        this.cornerWidth = cornerWidth;
        this.cornerLength = cornerLength;
        this.lineColor = lineColor;
        this.cornerColor = cornerColor;
        this.dotColor = dotColor;
        this.shadowColor = shadowColor;
        this.displayBoxes = new ArrayList<ScalableBox>();
        this.offset = lineWidth / 4.0f;
        this.offset_2 = lineWidth;
    }

    public void resetBoxSize(int bitmapWidth, int bitmapHeight) {
        this.bitmapWidth = bitmapWidth;
        this.bitmapHeight = bitmapHeight;
        int size = bitmapWidth < bitmapHeight ? bitmapWidth : bitmapHeight;
        for (ScalableBox displayBox : this.displayBoxes) {
            displayBox.setX1((this.getWidth() - size) / 2);
            displayBox.setX2((this.getWidth() + size) / 2);
            displayBox.setY1((this.getHeight() - size) / 2);
            displayBox.setY2((this.getHeight() + size) / 2);
        }
        this.invalidate();
    }

    public void setBoxSize(EditableImage editableImage, List<ScalableBox> originalBoxes, int widthX, int heightY) {
        this.bitmapWidth = editableImage.getFitSize()[0];
        this.bitmapHeight = editableImage.getFitSize()[1];
        int originX = (widthX - this.bitmapWidth) / 2;
        int originY = (heightY - this.bitmapHeight) / 2;
        this.originX = originX;
        this.originY = originY;
        this.setDisplayBoxes(originalBoxes);
        this.invalidate();
    }

    public void setOnBoxChangedListener(OnBoxChangedListener listener) {
        this.onBoxChangedListener = listener;
    }

    protected void onSizeChanged(int x, int y, int oldx, int oldy) {
        super.onSizeChanged(x, y, oldx, oldy);
    }

    public void onDraw(Canvas canvas) {
        if (this.animatingExpanding) {
            this.expandBox(canvas);
        } else {
            this.drawShadow(canvas);
            this.drawLines(canvas);
            this.drawCorner(canvas);
            this.drawDot(canvas);
        }
    }

    private void drawShadow(Canvas canvas) {
        this.mPaint.setStrokeWidth(0.0f);
        this.mPaint.setColor(this.shadowColor);
        if (this.displayBoxes != null && this.displayBoxes.size() > 0) {
            ScalableBox displayBox = this.displayBoxes.get(this.editableImage.getActiveBoxIdx());
            canvas.drawRect((float)this.originX, (float)this.originY, (float)(this.originX + this.bitmapWidth), (float)displayBox.getY1(), this.mPaint);
            canvas.drawRect((float)this.originX, (float)displayBox.getY1(), (float)displayBox.getX1(), (float)displayBox.getY2(), this.mPaint);
            canvas.drawRect((float)displayBox.getX2(), (float)displayBox.getY1(), (float)(this.originX + this.bitmapWidth), (float)displayBox.getY2(), this.mPaint);
            canvas.drawRect((float)this.originX, (float)displayBox.getY2(), (float)(this.originX + this.bitmapWidth), (float)(this.originY + this.bitmapHeight), this.mPaint);
        }
    }

    private void drawLines(Canvas canvas) {
        this.mPaint.setStrokeWidth(this.lineWidth);
        this.mPaint.setColor(this.lineColor);
        if (this.displayBoxes != null && this.displayBoxes.size() > 0) {
            ScalableBox displayBox = this.displayBoxes.get(this.editableImage.getActiveBoxIdx());
            canvas.drawLine((float)displayBox.getX1(), (float)displayBox.getY1(), (float)displayBox.getX2(), (float)displayBox.getY1(), this.mPaint);
            canvas.drawLine((float)displayBox.getX2(), (float)displayBox.getY1(), (float)displayBox.getX2(), (float)displayBox.getY2(), this.mPaint);
            canvas.drawLine((float)displayBox.getX2(), (float)displayBox.getY2(), (float)displayBox.getX1(), (float)displayBox.getY2(), this.mPaint);
            canvas.drawLine((float)displayBox.getX1(), (float)displayBox.getY2(), (float)displayBox.getX1(), (float)displayBox.getY1(), this.mPaint);
        }
    }

    private void drawCorner(Canvas canvas) {
        this.mPaint.setStrokeWidth(this.cornerWidth);
        this.mPaint.setColor(this.cornerColor);
        if (this.displayBoxes != null && this.displayBoxes.size() > 0) {
            ScalableBox displayBox = this.displayBoxes.get(this.editableImage.getActiveBoxIdx());
            int x1 = displayBox.getX1();
            int x2 = displayBox.getX2();
            int y1 = displayBox.getY1();
            int y2 = displayBox.getY2();
            int minSize = (int)this.cornerLength;
            canvas.drawLine((float)x1 - this.offset_2, (float)y1 - this.offset, (float)x1 - this.offset + (float)minSize, (float)y1 - this.offset, this.mPaint);
            canvas.drawLine((float)x1 - this.offset, (float)y1 - this.offset_2, (float)x1 - this.offset, (float)y1 - this.offset + (float)minSize, this.mPaint);
            canvas.drawLine((float)x2 + this.offset_2, (float)y1 - this.offset, (float)x2 + this.offset - (float)minSize, (float)y1 - this.offset, this.mPaint);
            canvas.drawLine((float)x2 + this.offset, (float)y1 - this.offset_2, (float)x2 + this.offset, (float)y1 - this.offset + (float)minSize, this.mPaint);
            canvas.drawLine((float)x1 - this.offset_2, (float)y2 + this.offset, (float)x1 - this.offset + (float)minSize, (float)y2 + this.offset, this.mPaint);
            canvas.drawLine((float)x1 - this.offset, (float)y2 + this.offset_2, (float)x1 - this.offset, (float)y2 + this.offset - (float)minSize, this.mPaint);
            canvas.drawLine((float)x2 + this.offset_2, (float)y2 + this.offset, (float)x2 + this.offset - (float)minSize, (float)y2 + this.offset, this.mPaint);
            canvas.drawLine((float)x2 + this.offset, (float)y2 + this.offset_2, (float)x2 + this.offset, (float)y2 + this.offset - (float)minSize, this.mPaint);
        }
    }

    private void expandBox(Canvas canvas) {
        int step = 10;
        float aspectRation = (float)(this.targetingBoxes[3] - this.targetingBoxes[2]) * 1.0f / (float)(this.targetingBoxes[1] - this.targetingBoxes[0]);
        this.startingCenter[0] = this.startingCenter[0] - step;
        this.startingCenter[1] = this.startingCenter[1] + step;
        this.startingCenter[2] = (int)((float)this.startingCenter[2] - (float)step * aspectRation);
        this.startingCenter[3] = (int)((float)this.startingCenter[3] + (float)step * aspectRation);
        if (this.startingCenter[0] <= this.targetingBoxes[0] || this.startingCenter[1] >= this.targetingBoxes[1] || this.startingCenter[2] <= this.targetingBoxes[2] || this.startingCenter[3] >= this.targetingBoxes[3]) {
            this.startingCenter[0] = this.targetingBoxes[0];
            this.startingCenter[1] = this.targetingBoxes[1];
            this.startingCenter[2] = this.targetingBoxes[2];
            this.startingCenter[3] = this.targetingBoxes[3];
            this.animatingExpanding = false;
        }
        this.mPaint.setStrokeWidth(0.0f);
        this.mPaint.setColor(this.shadowColor);
        canvas.drawRect((float)this.originX, (float)this.originY, (float)(this.originX + this.bitmapWidth), (float)(this.originY + this.bitmapHeight), this.mPaint);
        this.mPaint.setStrokeWidth(this.lineWidth);
        this.mPaint.setColor(this.lineColor);
        int x1 = this.startingCenter[0];
        int x2 = this.startingCenter[1];
        int y1 = this.startingCenter[2];
        int y2 = this.startingCenter[3];
        int minSize = (int)this.cornerLength;
        canvas.drawLine((float)x1, (float)y1, (float)x2, (float)y1, this.mPaint);
        canvas.drawLine((float)x2, (float)y1, (float)x2, (float)y2, this.mPaint);
        canvas.drawLine((float)x2, (float)y2, (float)x1, (float)y2, this.mPaint);
        canvas.drawLine((float)x1, (float)y2, (float)x1, (float)y1, this.mPaint);
        this.mPaint.setColor(this.cornerColor);
        canvas.drawLine((float)x1 - this.offset_2, (float)y1 - this.offset, (float)x1 - this.offset + (float)minSize, (float)y1 - this.offset, this.mPaint);
        canvas.drawLine((float)x1 - this.offset, (float)y1 - this.offset_2, (float)x1 - this.offset, (float)y1 - this.offset + (float)minSize, this.mPaint);
        canvas.drawLine((float)x2 + this.offset_2, (float)y1 - this.offset, (float)x2 + this.offset - (float)minSize, (float)y1 - this.offset, this.mPaint);
        canvas.drawLine((float)x2 + this.offset, (float)y1 - this.offset_2, (float)x2 + this.offset, (float)y1 - this.offset + (float)minSize, this.mPaint);
        canvas.drawLine((float)x1 - this.offset_2, (float)y2 + this.offset, (float)x1 - this.offset + (float)minSize, (float)y2 + this.offset, this.mPaint);
        canvas.drawLine((float)x1 - this.offset, (float)y2 + this.offset_2, (float)x1 - this.offset, (float)y2 + this.offset - (float)minSize, this.mPaint);
        canvas.drawLine((float)x2 + this.offset_2, (float)y2 + this.offset, (float)x2 + this.offset - (float)minSize, (float)y2 + this.offset, this.mPaint);
        canvas.drawLine((float)x2 + this.offset, (float)y2 + this.offset_2, (float)x2 + this.offset, (float)y2 + this.offset - (float)minSize, this.mPaint);
        this.invalidate();
    }

    private void setUpExpanding(int centerX, int centerY, ScalableBox dot) {
        this.animatingExpanding = true;
        int step = 1;
        float aspectRation = (float)(this.targetingBoxes[3] - this.targetingBoxes[2]) * 1.0f / (float)(this.targetingBoxes[1] - this.targetingBoxes[0]);
        this.startingCenter[0] = centerX - step;
        this.startingCenter[1] = centerX + step;
        this.startingCenter[2] = (int)((float)centerY - (float)step * aspectRation);
        this.startingCenter[3] = (int)((float)centerY + (float)step * aspectRation);
        this.targetingBoxes[0] = dot.getX1();
        this.targetingBoxes[1] = dot.getX2();
        this.targetingBoxes[2] = dot.getY1();
        this.targetingBoxes[3] = dot.getY2();
    }

    private void setDisplayBoxes(List<ScalableBox> originalBoxes) {
        this.displayBoxes.clear();
        for (ScalableBox originalBox : originalBoxes) {
            ScalableBox displayBox = new ScalableBox(originalBox.getX1(), originalBox.getY1(), originalBox.getX2(), originalBox.getY2());
            if (originalBox.getX1() >= 0 && originalBox.getX2() > 0 && originalBox.getY1() >= 0 && originalBox.getY2() > 0) {
                Log.d((String)SELECTION_VIEW, (String)("original box: + (" + originalBox.getX1() + " " + originalBox.getY1() + ") (" + originalBox.getX2() + " " + originalBox.getY2() + ")"));
                float scale = (float)this.editableImage.getFitSize()[0] / (float)this.editableImage.getActualSize()[0];
                int scaleX1 = (int)Math.ceil((float)originalBox.getX1() * scale + (float)this.originX);
                int scaleX2 = (int)Math.ceil((float)originalBox.getX2() * scale + (float)this.originX);
                int scaleY1 = (int)Math.ceil((float)originalBox.getY1() * scale + (float)this.originY);
                int scaleY2 = (int)Math.ceil((float)originalBox.getY2() * scale + (float)this.originY);
                displayBox.setX1(scaleX1);
                displayBox.setX2(scaleX2);
                displayBox.setY1(scaleY1);
                displayBox.setY2(scaleY2);
            } else {
                displayBox.setX1(this.originX);
                displayBox.setX2(this.originX + this.bitmapWidth);
                displayBox.setY1(this.originY);
                displayBox.setY2(this.originY + this.bitmapHeight);
            }
            this.displayBoxes.add(displayBox);
        }
    }

    @TargetApi(value=21)
    private void drawDot(Canvas canvas) {
        this.mPaint.setStrokeWidth(this.cornerWidth);
        int dotSize = 20;
        float dotSizeOuterRatio = 1.5f;
        for (ScalableBox dot : this.displayBoxes) {
            if (this.displayBoxes.indexOf(dot) == this.editableImage.getActiveBoxIdx()) continue;
            int centerX = (dot.getX1() + dot.getX2()) / 2;
            int centerY = (dot.getY1() + dot.getY2()) / 2;
            this.mPaint.setColor(this.dotColor);
            canvas.drawOval((float)centerX - (float)dotSize * dotSizeOuterRatio, (float)centerY - (float)dotSize * dotSizeOuterRatio, (float)centerX + (float)dotSize * dotSizeOuterRatio, (float)centerY + (float)dotSize * dotSizeOuterRatio, this.mPaint);
            this.mPaint.setColor(Color.parseColor((String)"#ffffff"));
            canvas.drawOval((float)(centerX - dotSize), (float)(centerY - dotSize), (float)(centerX + dotSize), (float)(centerY + dotSize), this.mPaint);
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        int[] loc = new int[2];
        this.getLocationOnScreen(loc);
        int curX = (int)motionEvent.getRawX();
        int curY = (int)motionEvent.getRawY();
        if (this.animatingExpanding) {
            return false;
        }
        int activeIdx = this.editableImage.getActiveBoxIdx();
        if (activeIdx < 0) {
            return false;
        }
        switch (motionEvent.getAction()) {
            case 0: {
                this.prevX = curX;
                this.prevY = curY;
                this.prevBoxX1 = this.editableImage.getActiveBox().getX1();
                this.prevBoxX2 = this.editableImage.getActiveBox().getX2();
                this.prevBoxY1 = this.editableImage.getActiveBox().getY1();
                this.prevBoxY2 = this.editableImage.getActiveBox().getY2();
                return true;
            }
            case 2: {
                int diffX = curX - this.prevX;
                int diffY = curY - this.prevY;
                this.displayBoxes.get(activeIdx).resizeBox(curX - loc[0], curY - loc[1], diffX, diffY, (this.getWidth() - this.bitmapWidth) / 2, (this.getHeight() - this.bitmapHeight) / 2, (this.getWidth() + this.bitmapWidth) / 2, (this.getHeight() + this.bitmapHeight) / 2, (int)this.cornerLength);
                this.updateOriginalBox();
                this.invalidate();
                this.prevX = curX;
                this.prevY = curY;
                return true;
            }
            case 1: {
                for (ScalableBox dot : this.displayBoxes) {
                    if (this.displayBoxes.indexOf(dot) == this.editableImage.getActiveBoxIdx()) continue;
                    int buffer = 25;
                    int x1 = dot.getX1();
                    int x2 = dot.getX2();
                    int y1 = dot.getY1();
                    int y2 = dot.getY2();
                    int dotX = (x1 + x2) / 2;
                    int dotY = (y1 + y2) / 2;
                    int pointX = curX - loc[0];
                    int pointY = curY - loc[1];
                    if (dotX - buffer > pointX || pointX > dotX + buffer || dotY - buffer > pointY || pointY > dotY + buffer) continue;
                    this.setUpExpanding(dotX, dotY, dot);
                    this.editableImage.setActiveBoxIdx(this.displayBoxes.indexOf(dot));
                    this.invalidate();
                    if (this.onBoxChangedListener != null) {
                        this.onBoxChangedListener.onChanged(this.editableImage.getActiveBox().getX1(), this.editableImage.getActiveBox().getY1(), this.editableImage.getActiveBox().getX2(), this.editableImage.getActiveBox().getY2());
                    }
                    this.setDisplayBoxes(this.editableImage.getBoxes());
                    return false;
                }
                ScalableBox originalBox = this.editableImage.getActiveBox();
                if (this.onBoxChangedListener != null && (this.prevBoxX1 != originalBox.getX1() || this.prevBoxX2 != originalBox.getX2() || this.prevBoxY1 != originalBox.getY1() || this.prevBoxY2 != originalBox.getY2())) {
                    this.onBoxChangedListener.onChanged(originalBox.getX1(), originalBox.getY1(), originalBox.getX2(), originalBox.getY2());
                }
                this.prevBoxX1 = originalBox.getX1();
                this.prevBoxX2 = originalBox.getX2();
                this.prevBoxY1 = originalBox.getY1();
                this.prevBoxY2 = originalBox.getY2();
            }
        }
        return false;
    }

    public void updateOriginalBox() {
        int viewWidth = this.editableImage.getViewWidth();
        int viewHeight = this.editableImage.getViewHeight();
        int width = this.editableImage.getOriginalImage().getWidth();
        int height = this.editableImage.getOriginalImage().getHeight();
        ScalableBox displayBox = this.displayBoxes.get(this.editableImage.getActiveBoxIdx());
        float ratio = (float)width / (float)height;
        float viewRatio = (float)viewWidth / (float)viewHeight;
        float factor = ratio > viewRatio ? (float)viewWidth / (float)width : (float)viewHeight / (float)height;
        float coorX = ((float)viewWidth - (float)width * factor) / 2.0f;
        float coorY = ((float)viewHeight - (float)height * factor) / 2.0f;
        int originX1 = ((float)displayBox.getX1() - coorX) / factor <= (float)width ? (int)(((float)displayBox.getX1() - coorX) / factor) : width;
        int originY1 = ((float)displayBox.getY1() - coorY) / factor <= (float)height ? (int)(((float)displayBox.getY1() - coorY) / factor) : height;
        int originX2 = ((float)displayBox.getX2() - coorX) / factor <= (float)width ? (int)(((float)displayBox.getX2() - coorX) / factor) : width;
        int originY2 = ((float)displayBox.getY2() - coorY) / factor <= (float)height ? (int)(((float)displayBox.getY2() - coorY) / factor) : height;
        this.editableImage.getActiveBox().setX1(originX1);
        this.editableImage.getActiveBox().setY1(originY1);
        this.editableImage.getActiveBox().setX2(originX2);
        this.editableImage.getActiveBox().setY2(originY2);
    }
}

