/*
 * Decompiled with CFR 0.152.
 */
package me.littlecheesecake.croplayout;

import android.content.Context;
import android.graphics.Bitmap;
import java.util.ArrayList;
import java.util.List;
import me.littlecheesecake.croplayout.model.ScalableBox;
import me.littlecheesecake.croplayout.util.ImageHelper;

public class EditableImage {
    private Bitmap originalImage;
    private List<ScalableBox> originalBoxes;
    private int activeBoxIdx = -1;
    private ScalableBox copyOfActiveBox;
    private int viewWidth;
    private int viewHeight;

    public EditableImage(Bitmap image) {
        this.originalImage = image;
        this.originalBoxes = new ArrayList<ScalableBox>();
    }

    public EditableImage(String localPath) {
        this.originalImage = ImageHelper.getBitmapFromPath(localPath);
        this.originalBoxes = new ArrayList<ScalableBox>();
    }

    public EditableImage(Context context, int id) {
        this.originalImage = ImageHelper.getBitmapFromResource(context.getResources(), id);
        this.originalBoxes = new ArrayList<ScalableBox>();
    }

    public void setViewSize(int viewWidth, int viewHeight) {
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
    }

    public Bitmap getOriginalImage() {
        return this.originalImage;
    }

    public void setBoxes(List<ScalableBox> boxes) {
        if (boxes != null && boxes.size() > 0) {
            this.activeBoxIdx = 0;
            this.setBoxes(boxes, this.activeBoxIdx);
        }
    }

    public void setBoxes(List<ScalableBox> boxes, int activeBoxIdx) {
        if (boxes != null && boxes.size() > 0) {
            this.originalBoxes = boxes;
            try {
                this.copyOfActiveBox = (ScalableBox)this.originalBoxes.get(activeBoxIdx).clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                this.copyOfActiveBox = new ScalableBox();
                this.copyOfActiveBox.setX1(this.originalBoxes.get(activeBoxIdx).getX1());
                this.copyOfActiveBox.setX2(this.originalBoxes.get(activeBoxIdx).getX2());
                this.copyOfActiveBox.setY1(this.originalBoxes.get(activeBoxIdx).getY1());
                this.copyOfActiveBox.setY2(this.originalBoxes.get(activeBoxIdx).getY2());
            }
        }
    }

    public List<ScalableBox> getBoxes() {
        return this.originalBoxes;
    }

    public int getActiveBoxIdx() {
        return this.activeBoxIdx;
    }

    public void setActiveBoxIdx(int activeBoxIdx) {
        this.activeBoxIdx = activeBoxIdx;
        try {
            this.copyOfActiveBox = (ScalableBox)this.originalBoxes.get(activeBoxIdx).clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            this.copyOfActiveBox = new ScalableBox();
            this.copyOfActiveBox.setX1(this.originalBoxes.get(activeBoxIdx).getX1());
            this.copyOfActiveBox.setX2(this.originalBoxes.get(activeBoxIdx).getX2());
            this.copyOfActiveBox.setY1(this.originalBoxes.get(activeBoxIdx).getY1());
            this.copyOfActiveBox.setY2(this.originalBoxes.get(activeBoxIdx).getY2());
        }
    }

    public ScalableBox getActiveBox() {
        return this.copyOfActiveBox;
    }

    public void rotateOriginalImage(int degree) {
        this.originalImage = ImageHelper.rotateImage(this.originalImage, degree);
    }

    public int getViewWidth() {
        return this.viewWidth;
    }

    public void setViewWidth(int viewWidth) {
        this.viewWidth = viewWidth;
    }

    public int getViewHeight() {
        return this.viewHeight;
    }

    public void setViewHeight(int viewHeight) {
        this.viewHeight = viewHeight;
    }

    public int[] getFitSize() {
        float viewRatio;
        int[] fitSize = new int[2];
        float ratio = (float)this.originalImage.getWidth() / (float)this.originalImage.getHeight();
        if (ratio > (viewRatio = (float)this.viewWidth / (float)this.viewHeight)) {
            float factor = (float)this.viewWidth / (float)this.originalImage.getWidth();
            fitSize[0] = this.viewWidth;
            fitSize[1] = (int)((float)this.originalImage.getHeight() * factor);
        } else {
            float factor = (float)this.viewHeight / (float)this.originalImage.getHeight();
            fitSize[0] = (int)((float)this.originalImage.getWidth() * factor);
            fitSize[1] = this.viewHeight;
        }
        return fitSize;
    }

    public int[] getActualSize() {
        int[] actualSize = new int[]{this.originalImage.getWidth(), this.originalImage.getHeight()};
        return actualSize;
    }

    public String cropOriginalImage(String path, String imageName) {
        ScalableBox relativeBox = this.getActiveBox();
        return ImageHelper.saveImageCropToPath(this.originalImage, relativeBox.getX1(), relativeBox.getY1(), relativeBox.getX2(), relativeBox.getY2(), path, imageName);
    }

    public void saveEditedImage(String path) {
        ImageHelper.saveImageToPath(this.originalImage, path);
    }
}

