/*
 * Decompiled with CFR 0.152.
 */
package me.littlecheesecake.croplayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import me.littlecheesecake.croplayout.EditableImage;
import me.littlecheesecake.croplayout.R;
import me.littlecheesecake.croplayout.SelectionView;
import me.littlecheesecake.croplayout.handler.OnBoxChangedListener;

public class EditPhotoView
extends FrameLayout {
    private static final int LINE_WIDTH = 2;
    private static final int CORNER_LENGTH = 30;
    private Context context;
    private ImageView imageView;
    private SelectionView selectionView;
    private EditableImage editableImage;
    private float lineWidth;
    private float cornerWidth;
    private float cornerLength;
    private int lineColor;
    private int cornerColor;
    private int dotColor;
    private int shadowColor;

    public EditPhotoView(Context context) {
        super(context);
        this.context = context;
    }

    public EditPhotoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.obtainAttributes(context, attrs);
    }

    public EditPhotoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.obtainAttributes(context, attrs);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.editableImage != null) {
            this.editableImage.setViewSize(w, h);
            this.imageView.setImageBitmap(this.editableImage.getOriginalImage());
            this.selectionView.setBoxSize(this.editableImage, this.editableImage.getBoxes(), w, h);
        }
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public void initView(Context context, EditableImage editableImage) {
        this.editableImage = editableImage;
        this.selectionView = new SelectionView(context, this.lineWidth, this.cornerWidth, this.cornerLength, this.lineColor, this.cornerColor, this.dotColor, this.shadowColor, editableImage);
        this.imageView = new ImageView(context);
        this.imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.selectionView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.imageView, 0);
        this.addView(this.selectionView, 1);
    }

    public void setOnBoxChangedListener(OnBoxChangedListener onBoxChangedListener) {
        this.selectionView.setOnBoxChangedListener(onBoxChangedListener);
    }

    public void rotateImageView() {
        if (this.editableImage.getActiveBoxIdx() >= 0) {
            this.editableImage.rotateOriginalImage(90);
            this.editableImage.getActiveBox().setX1(0);
            this.editableImage.getActiveBox().setY1(0);
            this.editableImage.getActiveBox().setX2(this.editableImage.getActualSize()[0]);
            this.editableImage.getActiveBox().setY2(this.editableImage.getActualSize()[1]);
            this.selectionView.setBoxSize(this.editableImage, this.editableImage.getBoxes(), this.editableImage.getViewWidth(), this.editableImage.getViewHeight());
            this.imageView.setImageBitmap(this.editableImage.getOriginalImage());
        }
    }

    private void obtainAttributes(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CropLayout);
        this.lineWidth = ta.getDimension(R.styleable.CropLayout_crop_line_width, (float)this.dp2px(2.0f));
        this.lineColor = ta.getColor(R.styleable.CropLayout_crop_line_color, Color.parseColor((String)"#ffffff"));
        this.dotColor = ta.getColor(R.styleable.CropLayout_crop_dot_color, Color.parseColor((String)"#ffffff"));
        this.cornerWidth = ta.getDimension(R.styleable.CropLayout_crop_corner_width, (float)this.dp2px(4.0f));
        this.cornerLength = ta.getDimension(R.styleable.CropLayout_crop_corner_length, (float)this.dp2px(30.0f));
        this.cornerColor = ta.getColor(R.styleable.CropLayout_crop_corner_color, Color.parseColor((String)"#ffffff"));
        this.shadowColor = ta.getColor(R.styleable.CropLayout_crop_shadow_color, Color.parseColor((String)"#aa111111"));
    }

    protected int dp2px(float dp) {
        float scale = this.context.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }
}

