/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.srl.util;

import android.content.Context;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import me.dkzwm.widget.srl.ILifecycleObserver;
import me.dkzwm.widget.srl.SmoothRefreshLayout;
import me.dkzwm.widget.srl.util.HorizontalScrollCompat;
import me.dkzwm.widget.srl.util.ScrollCompat;
import me.dkzwm.widget.srl.util.ViewCatcherUtil;

public class AutoRefreshUtil
implements ILifecycleObserver,
SmoothRefreshLayout.OnStatusChangedListener,
Runnable {
    private SmoothRefreshLayout mRefreshLayout;
    private View mTargetView;
    private int mStatus;
    private boolean mNeedToTriggerRefresh = false;
    private boolean mNeedToTriggerLoadMore = false;
    private boolean mCachedActionAtOnce = false;
    private boolean mCachedAutoRefreshUseSmoothScroll = false;
    private int mMaximumFlingVelocity;

    public AutoRefreshUtil(@NonNull View targetScrollableView) {
        this.mTargetView = targetScrollableView;
        ViewConfiguration configuration = ViewConfiguration.get((Context)targetScrollableView.getContext());
        this.mMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    public void onAttached(SmoothRefreshLayout layout) {
        this.mRefreshLayout = layout;
        this.mRefreshLayout.addOnStatusChangedListener((SmoothRefreshLayout.OnStatusChangedListener)this);
    }

    public void onDetached(SmoothRefreshLayout layout) {
        this.mRefreshLayout.removeCallbacks((Runnable)this);
        this.mRefreshLayout.removeOnStatusChangedListener((SmoothRefreshLayout.OnStatusChangedListener)this);
        this.mRefreshLayout = null;
    }

    public void autoRefresh(boolean atOnce, boolean autoRefreshUseSmoothScroll) {
        if (this.mRefreshLayout != null) {
            if (this.mStatus != 1) {
                return;
            }
            if (this.mRefreshLayout.isNotYetInEdgeCannotMoveHeader()) {
                if (this.mRefreshLayout.isVerticalOrientation()) {
                    ScrollCompat.flingCompat((View)this.mTargetView, (int)(-this.mMaximumFlingVelocity));
                } else if (ViewCatcherUtil.isViewPager((View)this.mTargetView)) {
                    ViewPager pager = (ViewPager)this.mTargetView;
                    PagerAdapter adapter = pager.getAdapter();
                    if (adapter == null) {
                        return;
                    }
                    if (adapter.getCount() <= 0) {
                        return;
                    }
                    pager.setCurrentItem(0, true);
                } else {
                    HorizontalScrollCompat.flingCompat((View)this.mTargetView, (int)(-this.mMaximumFlingVelocity));
                }
                this.mNeedToTriggerRefresh = true;
                this.mCachedActionAtOnce = atOnce;
                this.mCachedAutoRefreshUseSmoothScroll = autoRefreshUseSmoothScroll;
            } else {
                this.mRefreshLayout.autoRefresh(atOnce, autoRefreshUseSmoothScroll);
                this.mNeedToTriggerRefresh = false;
                this.mCachedActionAtOnce = false;
                this.mCachedAutoRefreshUseSmoothScroll = false;
            }
            ViewCompat.postOnAnimation((View)this.mRefreshLayout, (Runnable)this);
        }
    }

    public void autoLoadMore(boolean atOnce, boolean autoRefreshUseSmoothScroll) {
        if (this.mRefreshLayout != null) {
            if (this.mStatus != 1) {
                return;
            }
            if (this.mRefreshLayout.isNotYetInEdgeCannotMoveFooter()) {
                if (this.mRefreshLayout.isVerticalOrientation()) {
                    ScrollCompat.flingCompat((View)this.mTargetView, (int)this.mMaximumFlingVelocity);
                } else if (this.mTargetView instanceof ViewPager) {
                    ViewPager pager = (ViewPager)this.mTargetView;
                    PagerAdapter adapter = pager.getAdapter();
                    if (adapter == null) {
                        return;
                    }
                    if (adapter.getCount() <= 0) {
                        return;
                    }
                    pager.setCurrentItem(adapter.getCount() - 1, true);
                } else {
                    HorizontalScrollCompat.flingCompat((View)this.mTargetView, (int)this.mMaximumFlingVelocity);
                }
                this.mNeedToTriggerLoadMore = true;
                this.mCachedActionAtOnce = atOnce;
                this.mCachedAutoRefreshUseSmoothScroll = autoRefreshUseSmoothScroll;
            } else {
                this.mRefreshLayout.autoLoadMore(atOnce, autoRefreshUseSmoothScroll);
                this.mNeedToTriggerLoadMore = false;
                this.mCachedActionAtOnce = false;
                this.mCachedAutoRefreshUseSmoothScroll = false;
            }
            ViewCompat.postOnAnimation((View)this.mRefreshLayout, (Runnable)this);
        }
    }

    @Override
    public void run() {
        if (this.mRefreshLayout != null) {
            if (this.mNeedToTriggerRefresh && !this.mRefreshLayout.isNotYetInEdgeCannotMoveHeader()) {
                if (this.mRefreshLayout.autoRefresh(this.mCachedActionAtOnce, this.mCachedAutoRefreshUseSmoothScroll)) {
                    ScrollCompat.stopFling((View)this.mTargetView);
                    this.mNeedToTriggerRefresh = false;
                    this.mCachedActionAtOnce = false;
                    this.mCachedAutoRefreshUseSmoothScroll = false;
                    this.mRefreshLayout.removeCallbacks((Runnable)this);
                    return;
                }
            } else if (this.mNeedToTriggerLoadMore && !this.mRefreshLayout.isNotYetInEdgeCannotMoveFooter() && this.mRefreshLayout.autoLoadMore(this.mCachedActionAtOnce, this.mCachedAutoRefreshUseSmoothScroll)) {
                ScrollCompat.stopFling((View)this.mTargetView);
                this.mNeedToTriggerLoadMore = false;
                this.mCachedActionAtOnce = false;
                this.mCachedAutoRefreshUseSmoothScroll = false;
                this.mRefreshLayout.removeCallbacks((Runnable)this);
                return;
            }
            ViewCompat.postOnAnimation((View)this.mRefreshLayout, (Runnable)this);
        }
    }

    public void onStatusChanged(byte old, byte now) {
        this.mStatus = now;
    }
}

