/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.srl.extra.header;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.animation.Animation;
import androidx.annotation.StringRes;
import me.dkzwm.widget.srl.SmoothRefreshLayout;
import me.dkzwm.widget.srl.ext.classic.R;
import me.dkzwm.widget.srl.extra.AbsClassicRefreshView;
import me.dkzwm.widget.srl.extra.ClassicConfig;
import me.dkzwm.widget.srl.indicator.IIndicator;

public class ClassicHeader<T extends IIndicator>
extends AbsClassicRefreshView<T> {
    @StringRes
    private int mPullDownToRefreshRes = R.string.sr_pull_down_to_refresh;
    @StringRes
    private int mPullDownRes = R.string.sr_pull_down;
    @StringRes
    private int mRefreshingRes = R.string.sr_refreshing;
    @StringRes
    private int mRefreshSuccessfulRes = R.string.sr_refresh_complete;
    @StringRes
    private int mRefreshFailRes = R.string.sr_refresh_failed;
    @StringRes
    private int mReleaseToRefreshRes = R.string.sr_release_to_refresh;

    public ClassicHeader(Context context) {
        this(context, null);
    }

    public ClassicHeader(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClassicHeader(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mArrowImageView.setImageResource(R.drawable.sr_classic_arrow_icon);
    }

    public void setPullDownToRefreshRes(@StringRes int pullDownToRefreshRes) {
        this.mPullDownToRefreshRes = pullDownToRefreshRes;
    }

    public void setPullDownRes(@StringRes int pullDownRes) {
        this.mPullDownRes = pullDownRes;
    }

    public void setRefreshingRes(@StringRes int refreshingRes) {
        this.mRefreshingRes = refreshingRes;
    }

    public void setRefreshSuccessfulRes(@StringRes int refreshSuccessfulRes) {
        this.mRefreshSuccessfulRes = refreshSuccessfulRes;
    }

    public void setRefreshFailRes(@StringRes int refreshFailRes) {
        this.mRefreshFailRes = refreshFailRes;
    }

    public void setReleaseToRefreshRes(@StringRes int releaseToRefreshRes) {
        this.mReleaseToRefreshRes = releaseToRefreshRes;
    }

    public int getType() {
        return 0;
    }

    public void onRefreshPrepare(SmoothRefreshLayout frame) {
        this.mShouldShowLastUpdate = true;
        this.tryUpdateLastUpdateTime();
        if (!TextUtils.isEmpty((CharSequence)this.mLastUpdateTimeKey)) {
            this.mLastUpdateTimeUpdater.start();
        }
        this.mProgressBar.setVisibility(4);
        this.mArrowImageView.setVisibility(0);
        this.mTitleTextView.setVisibility(0);
        if (frame.isEnabledPullToRefresh()) {
            this.mTitleTextView.setText(this.mPullDownToRefreshRes);
        } else {
            this.mTitleTextView.setText(this.mPullDownRes);
        }
    }

    public void onRefreshBegin(SmoothRefreshLayout frame, T indicator) {
        this.mArrowImageView.clearAnimation();
        this.mArrowImageView.setVisibility(4);
        this.mProgressBar.setVisibility(0);
        this.mTitleTextView.setVisibility(0);
        this.mTitleTextView.setText(this.mRefreshingRes);
        this.tryUpdateLastUpdateTime();
    }

    public void onRefreshComplete(SmoothRefreshLayout frame, boolean isSuccessful) {
        this.mArrowImageView.clearAnimation();
        this.mArrowImageView.setVisibility(4);
        this.mProgressBar.setVisibility(4);
        this.mTitleTextView.setVisibility(0);
        if (frame.isRefreshSuccessful()) {
            this.mTitleTextView.setText(this.mRefreshSuccessfulRes);
            this.mLastUpdateTime = System.currentTimeMillis();
            ClassicConfig.updateTime(this.getContext(), this.mLastUpdateTimeKey, this.mLastUpdateTime);
        } else {
            this.mTitleTextView.setText(this.mRefreshFailRes);
        }
    }

    public void onRefreshPositionChanged(SmoothRefreshLayout frame, byte status, T indicator) {
        int offsetToRefresh = indicator.getOffsetToRefresh();
        int currentPos = indicator.getCurrentPos();
        int lastPos = indicator.getLastPos();
        if (currentPos < offsetToRefresh && lastPos >= offsetToRefresh) {
            if (indicator.hasTouched() && status == 2) {
                this.mTitleTextView.setVisibility(0);
                if (frame.isEnabledPullToRefresh()) {
                    this.mTitleTextView.setText(this.mPullDownToRefreshRes);
                } else {
                    this.mTitleTextView.setText(this.mPullDownRes);
                }
                this.mArrowImageView.setVisibility(0);
                this.mArrowImageView.clearAnimation();
                this.mArrowImageView.startAnimation((Animation)this.mReverseFlipAnimation);
            }
        } else if (currentPos > offsetToRefresh && lastPos <= offsetToRefresh && indicator.hasTouched() && status == 2) {
            this.mTitleTextView.setVisibility(0);
            if (!frame.isEnabledPullToRefresh()) {
                this.mTitleTextView.setText(this.mReleaseToRefreshRes);
            }
            this.mArrowImageView.setVisibility(0);
            this.mArrowImageView.clearAnimation();
            this.mArrowImageView.startAnimation((Animation)this.mFlipAnimation);
        }
    }
}

