/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.japicmp.report;

import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiCompatibilityChangeType;
import japicmp.model.JApiConstructor;
import japicmp.model.JApiField;
import japicmp.model.JApiHasChangeStatus;
import japicmp.model.JApiImplementedInterface;
import japicmp.model.JApiMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import me.champeau.gradle.japicmp.report.AbstractContextAwareViolationRule;
import me.champeau.gradle.japicmp.report.PostProcessViolationsRule;
import me.champeau.gradle.japicmp.report.SetupRule;
import me.champeau.gradle.japicmp.report.Severity;
import me.champeau.gradle.japicmp.report.Violation;
import me.champeau.gradle.japicmp.report.ViolationCheckContext;
import me.champeau.gradle.japicmp.report.ViolationCheckContextWithViolations;
import me.champeau.gradle.japicmp.report.ViolationRule;
import me.champeau.gradle.japicmp.report.ViolationTransformer;
import me.champeau.gradle.japicmp.report.stdrules.BinaryIncompatibleRule;
import me.champeau.gradle.japicmp.report.stdrules.RecordSeenMembersSetup;
import me.champeau.gradle.japicmp.report.stdrules.SourceCompatibleRule;
import me.champeau.gradle.japicmp.report.stdrules.UnchangedMemberRule;

public class ViolationsGenerator {
    private final List<Pattern> includePatterns;
    private final List<Pattern> excludePatterns;
    private final Map<JApiCompatibilityChangeType, List<ViolationRule>> apiCompatibilityRules = new HashMap<JApiCompatibilityChangeType, List<ViolationRule>>();
    private final Map<JApiChangeStatus, List<ViolationRule>> statusRules = new HashMap<JApiChangeStatus, List<ViolationRule>>();
    private final List<ViolationRule> genericRules = new ArrayList<ViolationRule>();
    private final List<SetupRule> setupRules = new ArrayList<SetupRule>();
    private final List<PostProcessViolationsRule> postProcessRules = new ArrayList<PostProcessViolationsRule>();
    private final List<ViolationTransformer> violationTransformers = new ArrayList<ViolationTransformer>();

    public ViolationsGenerator(List<String> includePatterns, List<String> excludePatterns) {
        this.includePatterns = ViolationsGenerator.toPatterns(includePatterns);
        this.excludePatterns = ViolationsGenerator.toPatterns(excludePatterns);
    }

    private static List<Pattern> toPatterns(List<String> regexps) {
        if (regexps == null || regexps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(regexps.size());
        for (String regexp : regexps) {
            patterns.add(Pattern.compile(regexp));
        }
        return patterns;
    }

    private static boolean anyMatches(List<Pattern> patterns, String className) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(className).find()) continue;
            return true;
        }
        return false;
    }

    public void addRule(SetupRule rule) {
        this.setupRules.add(rule);
    }

    public void addRule(PostProcessViolationsRule rule) {
        this.postProcessRules.add(rule);
    }

    public void addRule(ViolationRule rule) {
        this.genericRules.add(rule);
    }

    public void addRule(JApiCompatibilityChangeType change, ViolationRule rule) {
        List<ViolationRule> violationRules = this.apiCompatibilityRules.get(change);
        if (violationRules == null) {
            violationRules = new ArrayList<ViolationRule>();
            this.apiCompatibilityRules.put(change, violationRules);
        }
        violationRules.add(rule);
    }

    public void addRule(JApiChangeStatus status, ViolationRule rule) {
        List<ViolationRule> violationRules = this.statusRules.get(status);
        if (violationRules == null) {
            violationRules = new ArrayList<ViolationRule>();
            this.statusRules.put(status, violationRules);
        }
        violationRules.add(rule);
    }

    public void addViolationTransformer(ViolationTransformer violationTransformer) {
        this.violationTransformers.add(violationTransformer);
    }

    public Map<String, List<Violation>> toViolations(List<JApiClass> classes) {
        this.addDefaultRuleIfNotConfigured();
        Context ctx = new Context(this.violationTransformers);
        for (SetupRule setupRule : this.setupRules) {
            setupRule.execute(ctx);
        }
        this.injectContextIntoRules(ctx);
        for (JApiClass aClass : classes) {
            this.maybeProcess(aClass, ctx);
        }
        for (PostProcessViolationsRule postProcessViolationsRule : this.postProcessRules) {
            postProcessViolationsRule.execute(ctx);
        }
        return ctx.violations;
    }

    private void addDefaultRuleIfNotConfigured() {
        if (this.setupRules.isEmpty() && this.postProcessRules.isEmpty() && this.apiCompatibilityRules.isEmpty() && this.statusRules.isEmpty() && this.genericRules.isEmpty()) {
            this.addDefaultRules();
        }
    }

    public void addDefaultRules() {
        this.setupRules.add(new RecordSeenMembersSetup());
        this.addRule(JApiChangeStatus.NEW, (ViolationRule)new SourceCompatibleRule(Severity.info, "has been added in source compatible way"));
        this.addRule(JApiChangeStatus.MODIFIED, (ViolationRule)new SourceCompatibleRule(Severity.info, "has been modified in source compatible way"));
        this.addRule(JApiChangeStatus.UNCHANGED, (ViolationRule)new UnchangedMemberRule());
        this.genericRules.add(new BinaryIncompatibleRule());
        this.genericRules.add(new SourceCompatibleRule());
    }

    private void injectContextIntoRules(ViolationCheckContext context) {
        for (List<ViolationRule> rules : this.apiCompatibilityRules.values()) {
            this.injectContextIntoRules(context, rules);
        }
        for (List<ViolationRule> rules : this.statusRules.values()) {
            this.injectContextIntoRules(context, rules);
        }
        this.injectContextIntoRules(context, this.genericRules);
    }

    private void injectContextIntoRules(ViolationCheckContext context, List<ViolationRule> rules) {
        for (ViolationRule rule : rules) {
            if (!(rule instanceof AbstractContextAwareViolationRule)) continue;
            ((AbstractContextAwareViolationRule)rule).setContext(context);
        }
    }

    private void maybeProcess(JApiClass clazz, Context context) {
        String fullyQualifiedName = clazz.getFullyQualifiedName();
        if (!this.includePatterns.isEmpty()) {
            if (ViolationsGenerator.anyMatches(this.includePatterns, fullyQualifiedName)) {
                if (!this.excludePatterns.isEmpty() && ViolationsGenerator.anyMatches(this.excludePatterns, fullyQualifiedName)) {
                    return;
                }
                this.processClass(clazz, context);
                return;
            }
            return;
        }
        if (!this.excludePatterns.isEmpty() && ViolationsGenerator.anyMatches(this.excludePatterns, fullyQualifiedName)) {
            return;
        }
        this.processClass(clazz, context);
    }

    private void processCompatibilityChange(JApiCompatibilityChangeType kind, JApiCompatibility member, Context context) {
        List<ViolationRule> violationRules = this.apiCompatibilityRules.get(kind);
        if (violationRules != null) {
            for (ViolationRule violationRule : violationRules) {
                context.maybeAddViolation(violationRule.maybeViolation(member));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClass(JApiClass clazz, Context context) {
        String oldClass = context.currentClass;
        try {
            context.currentClass = clazz.getFullyQualifiedName();
            this.processAllChanges((JApiCompatibility)clazz, context);
            for (JApiField field : clazz.getFields()) {
                this.processAllChanges((JApiCompatibility)field, context);
            }
            for (JApiMethod method : clazz.getMethods()) {
                this.processAllChanges((JApiCompatibility)method, context);
            }
            for (JApiConstructor constructor : clazz.getConstructors()) {
                this.processAllChanges((JApiCompatibility)constructor, context);
            }
            for (JApiImplementedInterface anInterface : clazz.getInterfaces()) {
                this.processAllChanges((JApiCompatibility)anInterface, context);
            }
        }
        finally {
            context.currentClass = oldClass;
        }
    }

    private void processAllChanges(JApiCompatibility elt, Context context) {
        this.processStatusChanges(elt, context);
        this.processCompatibilityChanges(elt, context);
        this.processGenericRules(elt, context);
    }

    private void processCompatibilityChanges(JApiCompatibility elt, Context context) {
        for (JApiCompatibilityChange compatibilityChange : elt.getCompatibilityChanges()) {
            this.processCompatibilityChange(compatibilityChange.getType(), elt, context);
        }
    }

    private void processStatusChanges(JApiCompatibility elt, Context context) {
        List<ViolationRule> violationRules;
        if (elt instanceof JApiHasChangeStatus && (violationRules = this.statusRules.get(((JApiHasChangeStatus)elt).getChangeStatus())) != null) {
            for (ViolationRule violationRule : violationRules) {
                context.maybeAddViolation(violationRule.maybeViolation(elt));
            }
        }
    }

    private void processGenericRules(JApiCompatibility elt, Context context) {
        for (ViolationRule genericRule : this.genericRules) {
            context.maybeAddViolation(genericRule.maybeViolation(elt));
        }
    }

    private static class Context
    implements ViolationCheckContextWithViolations {
        private final Map<String, List<Violation>> violations = new LinkedHashMap<String, List<Violation>>();
        private final Map<String, Object> userData = new LinkedHashMap<String, Object>();
        private final List<ViolationTransformer> transformers;
        private String currentClass;

        private Context(List<ViolationTransformer> transformers) {
            this.transformers = transformers;
        }

        void maybeAddViolation(Violation v) {
            ViolationTransformer transformer;
            if (v == null) {
                return;
            }
            if (this.currentClass == null) {
                throw new IllegalStateException();
            }
            Optional<Violation> violation = Optional.of(v);
            Iterator<ViolationTransformer> iterator = this.transformers.iterator();
            while (iterator.hasNext() && (violation = (transformer = iterator.next()).transform(this.currentClass, violation.get())).isPresent()) {
            }
            if (violation.isPresent()) {
                List violations = this.violations.computeIfAbsent(this.currentClass, k -> new ArrayList());
                violations.add(violation.get());
            }
        }

        @Override
        public String getClassName() {
            return this.currentClass;
        }

        @Override
        public Map<String, ?> getUserData() {
            return this.userData;
        }

        @Override
        public <T> T getUserData(String key) {
            return (T)this.userData.get(key);
        }

        @Override
        public <T> void putUserData(String key, T value) {
            this.userData.put(key, value);
        }

        @Override
        public Map<String, List<Violation>> getViolations() {
            return this.violations;
        }
    }
}

