/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.japicmp.report;

import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiCompatibilityChangeType;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.champeau.gradle.japicmp.report.CompatibilityChangeViolationRuleConfiguration;
import me.champeau.gradle.japicmp.report.GroovyReportRenderer;
import me.champeau.gradle.japicmp.report.PostProcessRuleConfiguration;
import me.champeau.gradle.japicmp.report.PostProcessViolationsRule;
import me.champeau.gradle.japicmp.report.RichReportRenderer;
import me.champeau.gradle.japicmp.report.RuleConfiguration;
import me.champeau.gradle.japicmp.report.SetupRule;
import me.champeau.gradle.japicmp.report.SetupRuleConfiguration;
import me.champeau.gradle.japicmp.report.StatusChangeViolationRuleConfiguration;
import me.champeau.gradle.japicmp.report.ViolationRule;
import me.champeau.gradle.japicmp.report.ViolationRuleConfiguration;
import me.champeau.gradle.japicmp.report.ViolationTransformer;
import me.champeau.gradle.japicmp.report.ViolationTransformerConfiguration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public abstract class RichReport {
    public RichReport() {
        this.getAddDefaultRules().convention((Object)false);
        this.getRenderer().convention(GroovyReportRenderer.class);
        this.getReportName().convention((Object)"rich-report.html");
    }

    public void addRule(Class<? extends ViolationRule> rule, Map<String, String> params) {
        this.getRules().add((Object)new ViolationRuleConfiguration(rule, params));
    }

    public void addRule(Class<? extends ViolationRule> rule) {
        this.addRule(rule, null);
    }

    public void addSetupRule(Class<? extends SetupRule> rule, Map<String, String> params) {
        this.getRules().add((Object)new SetupRuleConfiguration(rule, params));
    }

    public void addSetupRule(Class<? extends SetupRule> rule) {
        this.addSetupRule(rule, null);
    }

    public void addPostProcessRule(Class<? extends PostProcessViolationsRule> rule, Map<String, String> params) {
        this.getRules().add((Object)new PostProcessRuleConfiguration(rule, params));
    }

    public void addPostProcessRule(Class<? extends PostProcessViolationsRule> rule) {
        this.addPostProcessRule(rule, null);
    }

    public void addRule(JApiCompatibilityChangeType change, Class<? extends ViolationRule> rule, Map<String, String> params) {
        this.getRules().add((Object)new CompatibilityChangeViolationRuleConfiguration(rule, params, change));
    }

    public void addRule(JApiCompatibilityChangeType change, Class<? extends ViolationRule> rule) {
        this.addRule(change, rule, null);
    }

    public void addRule(JApiChangeStatus status, Class<? extends ViolationRule> rule, Map<String, String> params) {
        this.getRules().add((Object)new StatusChangeViolationRuleConfiguration(rule, params, status));
    }

    public void addRule(JApiChangeStatus status, Class<? extends ViolationRule> rule) {
        this.addRule(status, rule, null);
    }

    public void addViolationTransformer(Class<? extends ViolationTransformer> transformer) {
        this.getRules().add((Object)new ViolationTransformerConfiguration(transformer, null));
    }

    public void addViolationTransformer(Class<? extends ViolationTransformer> transformer, Map<String, String> params) {
        this.getRules().add((Object)new ViolationTransformerConfiguration(transformer, params));
    }

    public void renderer(Class<? extends RichReportRenderer> rendererType) {
        this.getRenderer().set(rendererType);
    }

    @Input
    public abstract Property<Class<? extends RichReportRenderer>> getRenderer();

    @Optional
    @Input
    public abstract ListProperty<String> getIncludedClasses();

    @Optional
    @Input
    public abstract ListProperty<String> getExcludedClasses();

    @Internal
    public abstract DirectoryProperty getDestinationDir();

    @Input
    public abstract Property<String> getReportName();

    @Optional
    @Input
    public abstract Property<String> getTitle();

    @Optional
    @Input
    public abstract Property<String> getDescription();

    @Input
    public abstract ListProperty<RuleConfiguration> getRules();

    @Input
    public abstract Property<Boolean> getAddDefaultRules();

    @OutputFile
    public Provider<RegularFile> getOutputFile() {
        return this.getDestinationDir().zip(this.getReportName(), Directory::file);
    }

    public Configuration toConfiguration() {
        return new Configuration((String)this.getReportName().get(), (Class)this.getRenderer().get(), (List)this.getIncludedClasses().getOrElse(Collections.emptyList()), (List)this.getExcludedClasses().getOrElse(Collections.emptyList()), (String)this.getTitle().getOrNull(), (String)this.getDescription().getOrNull(), (List)this.getRules().getOrElse(Collections.emptyList()), (Boolean)this.getAddDefaultRules().get(), ((RegularFile)this.getOutputFile().get()).getAsFile());
    }

    public static final class Configuration
    implements Serializable {
        private final String reportName;
        private final Class<? extends RichReportRenderer> renderer;
        private final List<String> includedClasses;
        private final List<String> excludedClasses;
        private final String title;
        private final String description;
        private final List<RuleConfiguration> rules;
        private final boolean addDefaultRules;
        private final File outputFile;

        public Configuration(String reportName, Class<? extends RichReportRenderer> renderer, List<String> includedClasses, List<String> excludedClasses, String title, String description, List<RuleConfiguration> rules, boolean addDefaultRules, File outputFile) {
            this.reportName = reportName;
            this.renderer = renderer;
            this.includedClasses = includedClasses;
            this.excludedClasses = excludedClasses;
            this.title = title;
            this.description = description;
            this.rules = rules;
            this.addDefaultRules = addDefaultRules;
            this.outputFile = outputFile;
        }

        public String getReportName() {
            return this.reportName;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public List<RuleConfiguration> getRules() {
            return this.rules;
        }

        public boolean isAddDefaultRules() {
            return this.addDefaultRules;
        }

        public File getOutputFile() {
            return this.outputFile;
        }

        public Class<? extends RichReportRenderer> getRenderer() {
            return this.renderer;
        }

        public List<String> getIncludedClasses() {
            return this.includedClasses;
        }

        public List<String> getExcludedClasses() {
            return this.excludedClasses;
        }

        public String toString() {
            return "ReportConfiguration{reportName='" + this.reportName + '\'' + ", renderer=" + this.renderer + ", includedClasses=" + this.includedClasses + ", excludedClasses=" + this.excludedClasses + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", rules=" + this.rules + ", addDefaultRules=" + this.addDefaultRules + ", outputFile=" + this.outputFile + '}';
        }
    }
}

