/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.japicmp;

import japicmp.filter.Filter;
import java.io.File;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.champeau.gradle.japicmp.JApiCmpWorkAction;
import me.champeau.gradle.japicmp.JApiCmpWorkerAction;
import me.champeau.gradle.japicmp.JapiCmpWorkParameters;
import me.champeau.gradle.japicmp.JapiCmpWorkerConfiguration;
import me.champeau.gradle.japicmp.filters.FilterConfiguration;
import me.champeau.gradle.japicmp.report.RichReport;
import me.champeau.gradle.japicmp.report.RuleConfiguration;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class JapicmpTask
extends DefaultTask {
    private final ConfigurableFileCollection additionalJapicmpClasspath;

    public JapicmpTask() {
        this.getFailOnModification().convention((Object)false);
        this.getFailOnSourceIncompatibility().convention((Object)false);
        this.getIgnoreMissingClasses().convention((Object)false);
        this.getIncludeSynthetic().convention((Object)false);
        this.getReportOnlySummary().convention((Object)false);
        this.getOnlyBinaryIncompatibleModified().convention((Object)false);
        this.getOnlyModified().convention((Object)false);
        this.getAccessModifier().convention((Object)"public");
        ConfigurableFileCollection classpath = this.getProject().getObjects().fileCollection();
        if (JavaVersion.current().isJava9Compatible()) {
            classpath.from(new Object[]{this.resolveJaxb()});
        }
        classpath.from(new Object[]{this.resolveGuava()});
        this.additionalJapicmpClasspath = classpath;
    }

    @TaskAction
    public void exec() {
        ConfigurableFileCollection oldArchives = this.getOldArchives();
        ConfigurableFileCollection newArchives = this.getNewArchives();
        List<JApiCmpWorkerAction.Archive> baseline = (List<JApiCmpWorkerAction.Archive>)this.getOldArchiveList().getOrElse(Collections.emptyList());
        List<JApiCmpWorkerAction.Archive> current = (List<JApiCmpWorkerAction.Archive>)this.getNewArchiveList().getOrElse(Collections.emptyList());
        if (baseline.isEmpty()) {
            List<JApiCmpWorkerAction.Archive> list = baseline = !oldArchives.isEmpty() ? JapicmpTask.toArchives((FileCollection)oldArchives) : this.inferArchives((FileCollection)this.getOldClasspath());
        }
        if (current.isEmpty()) {
            current = !newArchives.isEmpty() ? JapicmpTask.toArchives((FileCollection)newArchives) : this.inferArchives((FileCollection)this.getNewClasspath());
        }
        Map workerSystemProperties = (Map)this.getWorkerSystemProperties().getOrElse(Collections.emptyMap());
        this.execForNewGradle(baseline, current, workerSystemProperties);
    }

    private void execForNewGradle(final List<JApiCmpWorkerAction.Archive> baseline, final List<JApiCmpWorkerAction.Archive> current, final Map<String, ?> workerSystemProperties) {
        this.getWorkerExecutor().processIsolation((Action)new Action<ProcessWorkerSpec>(){

            public void execute(ProcessWorkerSpec spec) {
                spec.getClasspath().from(new Object[]{JapicmpTask.this.calculateWorkerClasspath()});
                spec.forkOptions((Action)new Action<JavaForkOptions>(){

                    public void execute(JavaForkOptions javaForkOptions) {
                        String maxWorkerHeap = (String)JapicmpTask.this.getMaxWorkerHeap().getOrNull();
                        if (maxWorkerHeap != null) {
                            javaForkOptions.setMaxHeapSize(maxWorkerHeap);
                        }
                        javaForkOptions.systemProperties(workerSystemProperties);
                    }
                });
            }
        }).submit(JApiCmpWorkAction.class, (Action)new Action<JapiCmpWorkParameters>(){

            public void execute(JapiCmpWorkParameters params) {
                params.getConfiguration().set((Object)JapicmpTask.this.calculateWorkerConfiguration(baseline, current));
            }
        });
    }

    private WorkerExecutor getWorkerExecutor() {
        return (WorkerExecutor)this.getServices().get(WorkerExecutor.class);
    }

    private Set<File> calculateWorkerClasspath() {
        HashSet<File> classpath = new HashSet<File>();
        for (FilterConfiguration configuration : (List)this.getIncludeFilters().getOrElse(Collections.emptyList())) {
            this.addClasspathFor(configuration.getFilterClass(), classpath);
        }
        for (FilterConfiguration configuration : (List)this.getExcludeFilters().getOrElse(Collections.emptyList())) {
            this.addClasspathFor(configuration.getFilterClass(), classpath);
        }
        if (this.getRichReport().isPresent()) {
            RichReport richReport = (RichReport)this.getRichReport().get();
            for (RuleConfiguration configuration : (List)richReport.getRules().getOrElse(Collections.emptyList())) {
                this.addClasspathFor(configuration.getRuleClass(), classpath);
            }
        }
        classpath.addAll(this.additionalJapicmpClasspath.getFiles());
        return classpath;
    }

    private JapiCmpWorkerConfiguration calculateWorkerConfiguration(List<JApiCmpWorkerAction.Archive> baseline, List<JApiCmpWorkerAction.Archive> current) {
        return new JapiCmpWorkerConfiguration((Boolean)this.getIncludeSynthetic().get(), (Boolean)this.getIgnoreMissingClasses().get(), (List)this.getPackageIncludes().getOrElse(Collections.emptyList()), (List)this.getPackageExcludes().getOrElse(Collections.emptyList()), (List)this.getClassIncludes().getOrElse(Collections.emptyList()), (List)this.getClassExcludes().getOrElse(Collections.emptyList()), (List)this.getMethodIncludes().getOrElse(Collections.emptyList()), (List)this.getMethodExcludes().getOrElse(Collections.emptyList()), (List)this.getFieldIncludes().getOrElse(Collections.emptyList()), (List)this.getFieldExcludes().getOrElse(Collections.emptyList()), (List)this.getAnnotationIncludes().getOrElse(Collections.emptyList()), (List)this.getAnnotationExcludes().getOrElse(Collections.emptyList()), (List)this.getIncludeFilters().getOrElse(Collections.emptyList()), (List)this.getExcludeFilters().getOrElse(Collections.emptyList()), (List)this.getCompatibilityChangeExcludes().getOrElse(Collections.emptyList()), JapicmpTask.toArchives((FileCollection)this.getOldClasspath()), JapicmpTask.toArchives((FileCollection)this.getNewClasspath()), baseline, current, (Boolean)this.getOnlyModified().get(), (Boolean)this.getOnlyBinaryIncompatibleModified().get(), (Boolean)this.getReportOnlySummary().get(), (Boolean)this.getFailOnSourceIncompatibility().get(), (String)this.getAccessModifier().get(), JapicmpTask.maybeFile(this.getXmlOutputFile()), JapicmpTask.maybeFile(this.getHtmlOutputFile()), JapicmpTask.maybeFile(this.getMdOutputFile()), JapicmpTask.maybeFile(this.getTxtOutputFile()), JapicmpTask.maybeFile(this.getSemverOutputFile()), (Boolean)this.getFailOnModification().get(), JapicmpTask.reportConfigurationOf(this.getRichReport()));
    }

    private static RichReport.Configuration reportConfigurationOf(Provider<RichReport> report) {
        if (report.isPresent()) {
            return ((RichReport)report.get()).toConfiguration();
        }
        return null;
    }

    private static File maybeFile(RegularFileProperty property) {
        if (property.isPresent()) {
            return (File)property.getAsFile().get();
        }
        return null;
    }

    private Configuration resolveJaxb() {
        Project project = this.getProject();
        DependencyHandler dependencies = project.getDependencies();
        return project.getConfigurations().detachedConfiguration(new Dependency[]{dependencies.create((Object)"javax.xml.bind:jaxb-api:2.3.1"), dependencies.create((Object)"com.sun.xml.bind:jaxb-core:4.0.3"), dependencies.create((Object)"com.sun.xml.bind:jaxb-impl:4.0.3"), dependencies.create((Object)"javax.activation:activation:1.1.1")});
    }

    private Configuration resolveGuava() {
        Project project = this.getProject();
        DependencyHandler dependencies = project.getDependencies();
        return project.getConfigurations().detachedConfiguration(new Dependency[]{dependencies.create((Object)"com.google.guava:guava:30.1.1-jre")});
    }

    private void addClasspathFor(Class<?> clazz, Set<File> classpath) {
        ProtectionDomain domain = clazz.getProtectionDomain();
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource != null) {
            try {
                classpath.add(new File(codeSource.getLocation().toURI()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private List<JApiCmpWorkerAction.Archive> inferArchives(FileCollection fc) {
        if (fc instanceof Configuration) {
            ArrayList<JApiCmpWorkerAction.Archive> archives = new ArrayList<JApiCmpWorkerAction.Archive>();
            Set firstLevelModuleDependencies = ((Configuration)fc).getResolvedConfiguration().getFirstLevelModuleDependencies();
            for (ResolvedDependency moduleDependency : firstLevelModuleDependencies) {
                this.collectArchives(archives, moduleDependency);
            }
            return archives;
        }
        return JapicmpTask.toArchives(fc);
    }

    private static List<JApiCmpWorkerAction.Archive> toArchives(FileCollection fc) {
        Set files = fc.getFiles();
        ArrayList<JApiCmpWorkerAction.Archive> archives = new ArrayList<JApiCmpWorkerAction.Archive>(files.size());
        for (File file : files) {
            archives.add(new JApiCmpWorkerAction.Archive(file, "unknown version"));
        }
        return archives;
    }

    private void collectArchives(Collection<JApiCmpWorkerAction.Archive> archives, ResolvedDependency resolvedDependency) {
        Set allModuleArtifacts = resolvedDependency.getAllModuleArtifacts();
        for (ResolvedArtifact resolvedArtifact : allModuleArtifacts) {
            String version = resolvedArtifact.getModuleVersion().getId().getVersion();
            archives.add(new JApiCmpWorkerAction.Archive(resolvedArtifact.getFile(), version));
        }
    }

    public void richReport(Action<? super RichReport> configureAction) {
        if (!this.getRichReport().isPresent()) {
            RichReport richReport = (RichReport)this.getProject().getObjects().newInstance(RichReport.class, new Object[0]);
            DirectoryProperty buildDirectory = this.getProject().getLayout().getBuildDirectory();
            richReport.getDestinationDir().convention(buildDirectory.dir("reports"));
            this.getRichReport().set((Object)richReport);
        }
        configureAction.execute(this.getRichReport().get());
    }

    @Input
    @Optional
    public abstract ListProperty<String> getPackageIncludes();

    @Input
    @Optional
    public abstract ListProperty<String> getPackageExcludes();

    @Input
    @Optional
    public abstract ListProperty<String> getClassIncludes();

    @Input
    @Optional
    public abstract ListProperty<String> getClassExcludes();

    @Input
    @Optional
    public abstract ListProperty<String> getMethodIncludes();

    @Input
    @Optional
    public abstract ListProperty<String> getMethodExcludes();

    @Input
    @Optional
    public abstract ListProperty<String> getFieldIncludes();

    @Input
    @Optional
    public abstract ListProperty<String> getFieldExcludes();

    @Input
    @Optional
    public abstract ListProperty<String> getAnnotationIncludes();

    @Input
    @Optional
    public abstract ListProperty<String> getAnnotationExcludes();

    @Input
    @Optional
    public abstract ListProperty<FilterConfiguration> getIncludeFilters();

    public void addIncludeFilter(Class<? extends Filter> includeFilterClass) {
        this.getIncludeFilters().add((Object)new FilterConfiguration(includeFilterClass));
    }

    @Input
    @Optional
    public abstract ListProperty<FilterConfiguration> getExcludeFilters();

    public void addExcludeFilter(Class<? extends Filter> excludeFilterClass) {
        this.getExcludeFilters().add((Object)new FilterConfiguration(excludeFilterClass));
    }

    @Input
    @Optional
    public abstract ListProperty<JApiCmpWorkerAction.Archive> getOldArchiveList();

    public void addOldArchives(Configuration config) {
        LinkedHashSet<JApiCmpWorkerAction.Archive> oldArchives = new LinkedHashSet<JApiCmpWorkerAction.Archive>();
        for (ResolvedDependency resolvedDependency : config.getResolvedConfiguration().getFirstLevelModuleDependencies()) {
            this.collectArchives(oldArchives, resolvedDependency);
        }
        this.getOldArchiveList().addAll(oldArchives);
    }

    @Input
    @Optional
    public abstract ListProperty<JApiCmpWorkerAction.Archive> getNewArchiveList();

    public void addNewArchives(Configuration config) {
        LinkedHashSet<JApiCmpWorkerAction.Archive> newArchives = new LinkedHashSet<JApiCmpWorkerAction.Archive>();
        for (ResolvedDependency resolvedDependency : config.getResolvedConfiguration().getFirstLevelModuleDependencies()) {
            this.collectArchives(newArchives, resolvedDependency);
        }
        this.getNewArchiveList().addAll(newArchives);
    }

    @Input
    @Optional
    public abstract ListProperty<String> getCompatibilityChangeExcludes();

    @Input
    @Optional
    public abstract Property<String> getAccessModifier();

    @Input
    public abstract Property<Boolean> getOnlyModified();

    @Input
    public abstract Property<Boolean> getOnlyBinaryIncompatibleModified();

    @Input
    public abstract Property<Boolean> getReportOnlySummary();

    @Input
    public abstract Property<Boolean> getFailOnSourceIncompatibility();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getXmlOutputFile();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getHtmlOutputFile();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getMdOutputFile();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getTxtOutputFile();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getSemverOutputFile();

    @Input
    public abstract Property<Boolean> getFailOnModification();

    @Input
    public abstract Property<Boolean> getIncludeSynthetic();

    @CompileClasspath
    public abstract ConfigurableFileCollection getOldClasspath();

    @CompileClasspath
    public abstract ConfigurableFileCollection getNewClasspath();

    @Optional
    @CompileClasspath
    public abstract ConfigurableFileCollection getOldArchives();

    @Optional
    @CompileClasspath
    public abstract ConfigurableFileCollection getNewArchives();

    @Input
    public abstract Property<Boolean> getIgnoreMissingClasses();

    @Optional
    @Nested
    public abstract Property<RichReport> getRichReport();

    @Optional
    @Input
    public abstract Property<String> getMaxWorkerHeap();

    @Optional
    @Input
    public abstract MapProperty<String, Object> getWorkerSystemProperties();
}

