/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.japicmp;

import japicmp.cmp.JApiCmpArchive;
import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.config.Options;
import japicmp.filter.AnnotationBehaviorFilter;
import japicmp.filter.AnnotationClassFilter;
import japicmp.filter.AnnotationFieldFilter;
import japicmp.filter.Filter;
import japicmp.filter.JavaDocLikeClassFilter;
import japicmp.filter.JavadocLikeBehaviorFilter;
import japicmp.filter.JavadocLikeFieldFilter;
import japicmp.filter.JavadocLikePackageFilter;
import japicmp.model.AccessModifier;
import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibilityChangeType;
import japicmp.model.JApiSemanticVersionLevel;
import japicmp.output.html.HtmlOutput;
import japicmp.output.html.HtmlOutputGenerator;
import japicmp.output.html.HtmlOutputGeneratorOptions;
import japicmp.output.markdown.MarkdownOutputGenerator;
import japicmp.output.semver.SemverOut;
import japicmp.output.stdout.StdoutOutputGenerator;
import japicmp.output.xml.XmlOutput;
import japicmp.output.xml.XmlOutputGenerator;
import japicmp.output.xml.XmlOutputGeneratorOptions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import me.champeau.gradle.japicmp.JapiCmpWorkerConfiguration;
import me.champeau.gradle.japicmp.filters.FilterConfiguration;
import me.champeau.gradle.japicmp.report.CompatibilityChangeViolationRuleConfiguration;
import me.champeau.gradle.japicmp.report.PostProcessRuleConfiguration;
import me.champeau.gradle.japicmp.report.PostProcessViolationsRule;
import me.champeau.gradle.japicmp.report.RichReportData;
import me.champeau.gradle.japicmp.report.RuleConfiguration;
import me.champeau.gradle.japicmp.report.SetupRule;
import me.champeau.gradle.japicmp.report.SetupRuleConfiguration;
import me.champeau.gradle.japicmp.report.Severity;
import me.champeau.gradle.japicmp.report.StatusChangeViolationRuleConfiguration;
import me.champeau.gradle.japicmp.report.Violation;
import me.champeau.gradle.japicmp.report.ViolationRule;
import me.champeau.gradle.japicmp.report.ViolationRuleConfiguration;
import me.champeau.gradle.japicmp.report.ViolationTransformer;
import me.champeau.gradle.japicmp.report.ViolationTransformerConfiguration;
import me.champeau.gradle.japicmp.report.ViolationsGenerator;
import org.gradle.api.GradleException;

public class JApiCmpWorkerAction
extends JapiCmpWorkerConfiguration
implements Runnable {
    @Inject
    public JApiCmpWorkerAction(JapiCmpWorkerConfiguration configuration) {
        super(configuration.includeSynthetic, configuration.ignoreMissingClasses, configuration.packageIncludes, configuration.packageExcludes, configuration.classIncludes, configuration.classExcludes, configuration.methodIncludes, configuration.methodExcludes, configuration.fieldIncludes, configuration.fieldExcludes, configuration.annotationIncludes, configuration.annotationExcludes, configuration.includeFilters, configuration.excludeFilters, configuration.compatibilityChangeExcludes, configuration.oldClasspath, configuration.newClasspath, configuration.oldArchives, configuration.newArchives, configuration.onlyModified, configuration.onlyBinaryIncompatibleModified, configuration.reportOnlySummary, configuration.failOnSourceIncompatibility, configuration.accessModifier, configuration.xmlOutputFile, configuration.htmlOutputFile, configuration.mdOutputFile, configuration.txtOutputFile, configuration.semverOutputFile, configuration.failOnModification, configuration.richReport);
    }

    private JarArchiveComparatorOptions createOptions() {
        JarArchiveComparatorOptions options = new JarArchiveComparatorOptions();
        options.setClassPathMode(JarArchiveComparatorOptions.ClassPathMode.TWO_SEPARATE_CLASSPATHS);
        options.setOldClassPath(this.oldClasspath.stream().map(a -> ((Archive)a).file.getAbsolutePath()).collect(Collectors.toList()));
        options.setNewClassPath(this.newClasspath.stream().map(a -> ((Archive)a).file.getAbsolutePath()).collect(Collectors.toList()));
        options.setIncludeSynthetic(this.includeSynthetic);
        options.getIgnoreMissingClasses().setIgnoreAllMissingClasses(this.ignoreMissingClasses);
        for (String packageInclude : this.packageIncludes) {
            options.getFilters().getIncludes().add(new JavadocLikePackageFilter(packageInclude, true));
        }
        for (String packageExclude : this.packageExcludes) {
            options.getFilters().getExcludes().add(new JavadocLikePackageFilter(packageExclude, true));
        }
        for (String classInclude : this.classIncludes) {
            options.getFilters().getIncludes().add(new JavaDocLikeClassFilter(classInclude));
        }
        for (String classExclude : this.classExcludes) {
            options.getFilters().getExcludes().add(new JavaDocLikeClassFilter(classExclude));
        }
        for (String methodInclude : this.methodIncludes) {
            options.getFilters().getIncludes().add(new JavadocLikeBehaviorFilter(methodInclude));
        }
        for (String methodExclude : this.methodExcludes) {
            options.getFilters().getExcludes().add(new JavadocLikeBehaviorFilter(methodExclude));
        }
        for (String fieldInclude : this.fieldIncludes) {
            options.getFilters().getIncludes().add(new JavadocLikeFieldFilter(fieldInclude));
        }
        for (String fieldExclude : this.fieldExcludes) {
            options.getFilters().getExcludes().add(new JavadocLikeFieldFilter(fieldExclude));
        }
        for (String annotationInclude : this.annotationIncludes) {
            options.getFilters().getIncludes().add(new AnnotationClassFilter(annotationInclude));
            options.getFilters().getIncludes().add(new AnnotationFieldFilter(annotationInclude));
            options.getFilters().getIncludes().add(new AnnotationBehaviorFilter(annotationInclude));
        }
        for (String annotationExclude : this.annotationExcludes) {
            options.getFilters().getExcludes().add(new AnnotationClassFilter(annotationExclude));
            options.getFilters().getExcludes().add(new AnnotationFieldFilter(annotationExclude));
            options.getFilters().getExcludes().add(new AnnotationBehaviorFilter(annotationExclude));
        }
        for (FilterConfiguration includeFilter : this.includeFilters) {
            options.getFilters().getIncludes().add(this.instantiateFilter(includeFilter));
        }
        for (FilterConfiguration excludeFilter : this.excludeFilters) {
            options.getFilters().getExcludes().add(this.instantiateFilter(excludeFilter));
        }
        for (String override : this.compatibilityChangeExcludes) {
            JApiCompatibilityChangeType overrideChange = JApiCompatibilityChangeType.valueOf((String)override);
            options.addOverrideCompatibilityChange(new JarArchiveComparatorOptions.OverrideCompatibilityChange(overrideChange, true, true, JApiSemanticVersionLevel.PATCH));
        }
        return options;
    }

    private Filter instantiateFilter(FilterConfiguration includeFilter) {
        try {
            return includeFilter.getFilterClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new GradleException("Unable to instantiate filter", (Throwable)e);
        }
    }

    @Override
    public void run() {
        JarArchiveComparatorOptions comparatorOptions = this.createOptions();
        JarArchiveComparator jarArchiveComparator = new JarArchiveComparator(comparatorOptions);
        this.generateOutput(jarArchiveComparator);
    }

    private static String prettyPrint(List<JApiCmpArchive> archives) {
        StringBuilder sb = new StringBuilder();
        archives.stream().sorted(Comparator.comparing(JApiCmpArchive::getFile)).forEachOrdered(archive -> {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(archive.getFile().getName());
        });
        return sb.toString();
    }

    private static List<JApiCmpArchive> toJapiCmpArchives(List<Archive> archives) {
        ArrayList<JApiCmpArchive> out = new ArrayList<JApiCmpArchive>(archives.size());
        for (Archive archive : archives) {
            out.add(archive.toJapicmpArchive());
        }
        return out;
    }

    private static String toClasspath(List<Archive> archives) {
        StringBuilder sb = new StringBuilder();
        for (Archive archive : archives) {
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(archive.file.getAbsolutePath());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateOutput(JarArchiveComparator jarArchiveComparator) {
        BufferedWriter writer;
        String output;
        Object output2;
        Options options = Options.newDefault();
        options.setOldClassPath(Optional.of(JApiCmpWorkerAction.toClasspath(this.oldClasspath)));
        options.setNewClassPath(Optional.of(JApiCmpWorkerAction.toClasspath(this.newClasspath)));
        List<JApiCmpArchive> baseline = JApiCmpWorkerAction.toJapiCmpArchives(this.oldArchives);
        List<JApiCmpArchive> current = JApiCmpWorkerAction.toJapiCmpArchives(this.newArchives);
        List jApiClasses = jarArchiveComparator.compare(baseline, current);
        options.setOldArchives(baseline);
        options.setNewArchives(current);
        options.setReportOnlyFilename(true);
        options.setOutputOnlyModifications(this.onlyModified);
        options.setOutputOnlyBinaryIncompatibleModifications(this.onlyBinaryIncompatibleModified);
        options.setReportOnlySummary(this.reportOnlySummary);
        options.setIncludeSynthetic(this.includeSynthetic);
        options.setAccessModifier(AccessModifier.valueOf((String)this.accessModifier.toUpperCase()));
        File reportFile = null;
        if (this.xmlOutputFile != null) {
            options.setXmlOutputFile(Optional.of(this.xmlOutputFile.getAbsolutePath()));
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(XmlOutputGenerator.class.getClassLoader());
                XmlOutputGeneratorOptions xmlOptions = new XmlOutputGeneratorOptions();
                XmlOutputGenerator xmlOutputGenerator = new XmlOutputGenerator(jApiClasses, options, xmlOptions);
                XmlOutput xmlOutput = xmlOutputGenerator.generate();
                XmlOutputGenerator.writeToFiles((Options)options, (XmlOutput)xmlOutput);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            reportFile = this.xmlOutputFile;
        }
        if (this.htmlOutputFile != null) {
            options.setHtmlOutputFile(Optional.of(this.htmlOutputFile.getAbsolutePath()));
            HtmlOutputGeneratorOptions htmlOptions = new HtmlOutputGeneratorOptions();
            HtmlOutputGenerator htmlOutputGenerator = new HtmlOutputGenerator(jApiClasses, options, htmlOptions);
            HtmlOutput htmlOutput = htmlOutputGenerator.generate();
            output2 = htmlOutput.getHtml();
            try {
                BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.htmlOutputFile), StandardCharsets.UTF_8));
                Object object = null;
                try {
                    writer2.write((String)output2);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (writer2 != null) {
                        if (object != null) {
                            try {
                                writer2.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            writer2.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new GradleException("Unable to write html report", (Throwable)ex);
            }
            reportFile = this.htmlOutputFile;
        }
        if (this.mdOutputFile != null) {
            MarkdownOutputGenerator markdownOutputGenerator = new MarkdownOutputGenerator(options, jApiClasses);
            output = markdownOutputGenerator.generate();
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.mdOutputFile), StandardCharsets.UTF_8));
                output2 = null;
                try {
                    writer.write(output);
                }
                catch (Throwable ex) {
                    output2 = ex;
                    throw ex;
                }
                finally {
                    if (writer != null) {
                        if (output2 != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable ex) {
                                ((Throwable)output2).addSuppressed(ex);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new GradleException("Unable to write markdown report", (Throwable)ex);
            }
            if (reportFile == null) {
                reportFile = this.mdOutputFile;
            }
        }
        if (this.txtOutputFile != null) {
            StdoutOutputGenerator stdoutOutputGenerator = new StdoutOutputGenerator(options, jApiClasses);
            output = stdoutOutputGenerator.generate();
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.txtOutputFile), StandardCharsets.UTF_8));
                output2 = null;
                try {
                    writer.write(output);
                }
                catch (Throwable ex) {
                    output2 = ex;
                    throw ex;
                }
                finally {
                    if (writer != null) {
                        if (output2 != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable ex) {
                                ((Throwable)output2).addSuppressed(ex);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new GradleException("Unable to write text report", (Throwable)ex);
            }
            if (reportFile == null) {
                reportFile = this.txtOutputFile;
            }
        }
        if (this.semverOutputFile != null) {
            SemverOut semverOut = new SemverOut(options, jApiClasses);
            output = semverOut.generate();
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.semverOutputFile), StandardCharsets.UTF_8));
                output2 = null;
                try {
                    writer.write(output);
                }
                catch (Throwable ex) {
                    output2 = ex;
                    throw ex;
                }
                finally {
                    if (writer != null) {
                        if (output2 != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable ex) {
                                ((Throwable)output2).addSuppressed(ex);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new GradleException("Unable to write semver", (Throwable)ex);
            }
            if (reportFile == null) {
                reportFile = this.semverOutputFile;
            }
        }
        boolean hasCustomViolations = false;
        if (this.richReport != null) {
            List<String> includedClasses = this.richReport.getIncludedClasses();
            List<String> excludedClasses = this.richReport.getExcludedClasses();
            ViolationsGenerator generator = new ViolationsGenerator(includedClasses, excludedClasses);
            List<RuleConfiguration> rules = this.richReport.getRules();
            for (RuleConfiguration ruleConfiguration : rules) {
                Map<String, String> map = ruleConfiguration.getArguments();
                Class ruleClass = ruleConfiguration.getRuleClass();
                try {
                    Object rule;
                    Object t = rule = map == null ? ruleClass.newInstance() : ruleClass.getConstructor(Map.class).newInstance(map);
                    if (ruleConfiguration.getClass() == SetupRuleConfiguration.class) {
                        generator.addRule((SetupRule)rule);
                        continue;
                    }
                    if (ruleConfiguration.getClass() == PostProcessRuleConfiguration.class) {
                        generator.addRule((PostProcessViolationsRule)rule);
                        continue;
                    }
                    if (ruleConfiguration.getClass() == ViolationRuleConfiguration.class) {
                        generator.addRule((ViolationRule)rule);
                        continue;
                    }
                    if (ruleConfiguration.getClass() == StatusChangeViolationRuleConfiguration.class) {
                        generator.addRule(((StatusChangeViolationRuleConfiguration)ruleConfiguration).getStatus(), (ViolationRule)rule);
                        continue;
                    }
                    if (ruleConfiguration.getClass() == CompatibilityChangeViolationRuleConfiguration.class) {
                        generator.addRule(((CompatibilityChangeViolationRuleConfiguration)ruleConfiguration).getChange(), (ViolationRule)rule);
                        continue;
                    }
                    if (ruleConfiguration.getClass() != ViolationTransformerConfiguration.class) continue;
                    generator.addViolationTransformer((ViolationTransformer)rule);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new GradleException("Unable to instantiate rule", (Throwable)e);
                }
            }
            if (this.richReport.isAddDefaultRules()) {
                generator.addDefaultRules();
            }
            Map<String, List<Violation>> violations = generator.toViolations(jApiClasses);
            for (List<Violation> list : violations.values()) {
                for (Violation violation : list) {
                    if (!violation.getSeverity().equals((Object)Severity.error)) continue;
                    hasCustomViolations = true;
                    break;
                }
                if (!hasCustomViolations) continue;
                break;
            }
            try {
                reportFile = this.richReport.getOutputFile();
                this.richReport.getRenderer().newInstance().render(reportFile, new RichReportData(this.richReport.getTitle(), this.richReport.getDescription(), violations));
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new GradleException("Unable to create renderer", (Throwable)reflectiveOperationException);
            }
        }
        if (this.failOnModification && JApiCmpWorkerAction.hasBreakingChange(jApiClasses, this.failOnSourceIncompatibility) || hasCustomViolations) {
            String reportLink;
            try {
                reportLink = reportFile != null ? new URI("file", "", reportFile.toURI().getPath(), null, null).toString() : null;
            }
            catch (URISyntaxException e) {
                reportLink = null;
            }
            StringBuilder message = new StringBuilder("Detected binary changes.\n").append("    - current: ").append(JApiCmpWorkerAction.prettyPrint(current)).append("\n    - baseline: ").append(JApiCmpWorkerAction.prettyPrint(baseline));
            if (reportLink != null) {
                message.append(".").append(System.lineSeparator()).append(System.lineSeparator());
                message.append("See failure report at ").append(reportLink);
            }
            throw new GradleException(message.toString());
        }
    }

    private static boolean hasBreakingChange(List<JApiClass> jApiClasses, boolean failOnSourceIncompatibility) {
        for (JApiClass jApiClass : jApiClasses) {
            if (jApiClass.isBinaryCompatible() && (!failOnSourceIncompatibility || jApiClass.isSourceCompatible())) continue;
            return true;
        }
        return false;
    }

    public static class Archive
    implements Serializable {
        private final File file;
        private final String version;

        public Archive(File file, String version) {
            this.file = file;
            this.version = version;
        }

        public String toString() {
            return this.file.getName();
        }

        public JApiCmpArchive toJapicmpArchive() {
            return new JApiCmpArchive(this.file, this.version);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof Archive && this.hashCode() == obj.hashCode();
        }

        public int hashCode() {
            return Objects.hash(this.file.getName(), this.version);
        }
    }
}

