/*
 * Decompiled with CFR 0.152.
 */
package kim.jeonghyeon.androidlibrary.util;

import android.annotation.SuppressLint;
import android.app.DownloadManager;
import android.content.Context;
import android.database.Cursor;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Environment;
import android.webkit.URLUtil;
import android.webkit.WebSettings;
import androidx.annotation.RequiresApi;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import kim.jeonghyeon.androidlibrary.BaseApplication;
import kim.jeonghyeon.androidlibrary.extension.GlobalFunctionsKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.Sdk27ServicesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010\u000bJ5\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tH\u0007\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0004J\b\u0010\u0011\u001a\u00020\u000fH\u0007J\b\u0010\u0012\u001a\u00020\u000fH\u0007\u00a8\u0006\u0013"}, d2={"Lkim/jeonghyeon/androidlibrary/util/NetworkUtil;", "", "()V", "checkAndDownload", "", "url", "", "mimeType", "headerMap", "", "downloadId", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Long;)Ljava/lang/Long;", "download", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)Ljava/lang/Long;", "isConnected", "", "isDownloading", "isMeteredConnected", "isUnmeteredConnected", "kotlin-simple-architecture_release"})
public final class NetworkUtil {
    public static final NetworkUtil INSTANCE;

    @SuppressLint(value={"MissingPermission"})
    public final boolean isConnected() {
        boolean $i$f$getCtx = false;
        boolean $i$f$getApp = false;
        NetworkInfo networkInfo = Sdk27ServicesKt.getConnectivityManager((Context)((Context)BaseApplication.Companion.getInstance())).getActiveNetworkInfo();
        return networkInfo != null ? networkInfo.isConnected() : false;
    }

    @SuppressLint(value={"MissingPermission"})
    public final boolean isMeteredConnected() {
        boolean $i$f$getCtx = false;
        boolean $i$f$getApp = false;
        return Sdk27ServicesKt.getConnectivityManager((Context)((Context)BaseApplication.Companion.getInstance())).isActiveNetworkMetered();
    }

    @SuppressLint(value={"MissingPermission"})
    public final boolean isUnmeteredConnected() {
        return this.isConnected() && !this.isMeteredConnected();
    }

    @RequiresApi(value=17)
    @Nullable
    public final Long checkAndDownload(@NotNull String url, @NotNull String mimeType, @Nullable Map<String, String> headerMap, @Nullable Long downloadId) {
        Long l;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        if (downloadId != null && this.isDownloading(downloadId)) {
            GlobalFunctionsKt.toast("Already downloading");
            l = downloadId;
        } else {
            GlobalFunctionsKt.toast("Download started");
            l = this.download(url, mimeType, headerMap);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=17)
    @Nullable
    public final Long download(@NotNull String url, @NotNull String mimeType, @Nullable Map<String, String> headerMap) {
        Long l;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        String fileName = URLUtil.guessFileName((String)url, null, (String)mimeType);
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)url));
        Map<String, String> map2 = headerMap;
        if (map2 != null) {
            Map<String, String> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Map<String, String> map3 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator = map3.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry<String, String> entry = $dstr$key$value;
                boolean bl3 = false;
                String string = entry.getKey();
                entry = $dstr$key$value;
                bl3 = false;
                String value = entry.getValue();
                request.addRequestHeader((String)key, value);
            }
        }
        request.setMimeType(mimeType);
        String string = "User-Agent";
        DownloadManager.Request request2 = request;
        boolean $i$f$getCtx = false;
        boolean $i$f$getApp = false;
        Context context = (Context)BaseApplication.Companion.getInstance();
        request2.addRequestHeader(string, WebSettings.getDefaultUserAgent((Context)context));
        request.setTitle((CharSequence)fileName);
        request.allowScanningByMediaScanner();
        request.setNotificationVisibility(1);
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, fileName);
        boolean $i$f$getCtx2 = false;
        boolean $i$f$getApp2 = false;
        DownloadManager dm = Sdk27ServicesKt.getDownloadManager((Context)((Context)BaseApplication.Companion.getInstance()));
        try {
            l = dm.enqueue(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            l = null;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDownloading(long downloadId) {
        boolean $i$f$getCtx = false;
        boolean $i$f$getApp = false;
        DownloadManager downloadManager = Sdk27ServicesKt.getDownloadManager((Context)((Context)BaseApplication.Companion.getInstance()));
        Object object = new DownloadManager.Query();
        boolean bl = false;
        boolean bl2 = false;
        DownloadManager.Query $this$apply = object;
        boolean bl3 = false;
        $this$apply.setFilterById(new long[]{downloadId});
        DownloadManager.Query query = object;
        object = (Closeable)downloadManager.query(query);
        bl = false;
        Throwable throwable = null;
        try {
            Cursor c22 = (Cursor)object;
            boolean bl4 = false;
            int c22 = c22.moveToFirst() ? c22.getInt(c22.getColumnIndex("status")) : -1;
        }
        catch (Throwable c22) {
            throwable = c22;
            throw c22;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        int n = c22;
        bl = false;
        boolean bl5 = false;
        int it = n;
        boolean bl6 = false;
        return it == 1 || it == 2;
    }

    private NetworkUtil() {
    }

    static {
        NetworkUtil networkUtil;
        INSTANCE = networkUtil = new NetworkUtil();
    }
}

