/*
 * Decompiled with CFR 0.152.
 */
package kim.jeonghyeon.androidlibrary.extension;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.app.ActivityManager;
import android.app.Service;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.provider.Settings;
import android.view.accessibility.AccessibilityManager;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kim.jeonghyeon.androidlibrary.BaseApplication;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0004\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f\u001a\u0015\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e*\u00020\u000f\u00a2\u0006\u0002\u0010\u0010\u001a\"\u0010\u0011\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u0012*\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t\u001a\n\u0010\u0013\u001a\u00020\u0005*\u00020\u000f\u001a\u0012\u0010\u0014\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000b\"\u0011\u0010\u0000\u001a\u00020\u00018G\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0016"}, d2={"jobScheduler", "Landroid/app/job/JobScheduler;", "getJobScheduler", "()Landroid/app/job/JobScheduler;", "isServiceOn", "", "T", "Landroid/app/Service;", "service", "Ljava/lang/Class;", "getDefaultLauncherPackageName", "", "Landroid/content/pm/PackageManager;", "getEnabledAccessibilityIds", "", "Landroid/view/accessibility/AccessibilityManager;", "(Landroid/view/accessibility/AccessibilityManager;)[Ljava/lang/String;", "isAccessibilityOn", "Landroid/accessibilityservice/AccessibilityService;", "isAccessibilitySettingOn", "isPackageInstalled", "packageName", "kotlin-simple-architecture_release"})
public final class ServiceExtKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <T extends Service> boolean isServiceOn(@NotNull Class<T> service) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        boolean $i$f$getCtx = false;
        boolean $i$f$getApp = false;
        Object object = ((Context)BaseApplication.Companion.getInstance()).getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager manager = (ActivityManager)object;
        List list = manager.getRunningServices(Integer.MAX_VALUE);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"manager.getRunningServices(Integer.MAX_VALUE)");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            ActivityManager.RunningServiceInfo it = (ActivityManager.RunningServiceInfo)element$iv;
            boolean bl2 = false;
            String string = service.getName();
            ComponentName componentName = it.service;
            Intrinsics.checkExpressionValueIsNotNull((Object)componentName, (String)"it.service");
            if (Intrinsics.areEqual((Object)string, (Object)componentName.getClassName())) {
                boolean $i$f$getCtx2 = false;
                boolean $i$f$getApp2 = false;
                String string2 = ((Context)BaseApplication.Companion.getInstance()).getPackageName();
                ComponentName componentName2 = it.service;
                Intrinsics.checkExpressionValueIsNotNull((Object)componentName2, (String)"it.service");
                if (Intrinsics.areEqual((Object)string2, (Object)componentName2.getPackageName())) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final <T extends AccessibilityService> boolean isAccessibilityOn(@NotNull AccessibilityManager $this$isAccessibilityOn, @NotNull Class<T> service) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAccessibilityOn, (String)"$this$isAccessibilityOn");
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        return ServiceExtKt.isServiceOn(service) ? ServiceExtKt.isAccessibilitySettingOn($this$isAccessibilityOn) : false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAccessibilitySettingOn(@NotNull AccessibilityManager $this$isAccessibilitySettingOn) {
        void $this$filterTo$iv$iv;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isAccessibilitySettingOn, (String)"$this$isAccessibilitySettingOn");
        boolean $i$f$getCtx = false;
        boolean $i$f$getApp = false;
        String string = Settings.Secure.getString((ContentResolver)((Context)BaseApplication.Companion.getInstance()).getContentResolver(), (String)"enabled_accessibility_services");
        if (string != null) {
            CharSequence charSequence = string;
            $i$f$getCtx = false;
            $i$f$getApp = false;
            Context context = (Context)BaseApplication.Companion.getInstance();
            String string2 = context.getPackageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ctx.packageName");
            bl = StringsKt.contains((CharSequence)charSequence, (CharSequence)string2, (boolean)true);
        } else {
            bl = false;
        }
        if (bl) return true;
        List list = $this$isAccessibilitySettingOn.getEnabledAccessibilityServiceList(-1);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"getEnabledAccessibilityS\u2026ceInfo.FEEDBACK_ALL_MASK)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AccessibilityServiceInfo it = (AccessibilityServiceInfo)element$iv$iv;
            boolean bl2 = false;
            AccessibilityServiceInfo accessibilityServiceInfo = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)accessibilityServiceInfo, (String)"it");
            String string3 = accessibilityServiceInfo.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.id");
            CharSequence charSequence = string3;
            boolean $i$f$getCtx2 = false;
            boolean $i$f$getApp2 = false;
            Context context = (Context)BaseApplication.Companion.getInstance();
            String string4 = context.getPackageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"ctx.packageName");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string4, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (!CollectionsKt.any((Iterable)((List)destination$iv$iv))) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String[] getEnabledAccessibilityIds(@NotNull AccessibilityManager $this$getEnabledAccessibilityIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$getEnabledAccessibilityIds, (String)"$this$getEnabledAccessibilityIds");
        List list = $this$getEnabledAccessibilityIds.getEnabledAccessibilityServiceList(-1);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"getEnabledAccessibilityS\u2026ceInfo.FEEDBACK_ALL_MASK)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AccessibilityServiceInfo accessibilityServiceInfo = (AccessibilityServiceInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = v1.getId();
            collection.add(string);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    @RequiresApi(value=21)
    @NotNull
    public static final JobScheduler getJobScheduler() {
        boolean $i$f$getCtx = false;
        boolean $i$f$getApp = false;
        Object object = ((Context)BaseApplication.Companion.getInstance()).getSystemService("jobscheduler");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.job.JobScheduler");
        }
        return (JobScheduler)object;
    }

    @Nullable
    public static final String getDefaultLauncherPackageName(@NotNull PackageManager $this$getDefaultLauncherPackageName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getDefaultLauncherPackageName, (String)"$this$getDefaultLauncherPackageName");
        Intent intent = new Intent("android.intent.action.MAIN");
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$apply = intent;
        boolean bl3 = false;
        $this$apply.addCategory("android.intent.category.HOME");
        bl = false;
        bl2 = false;
        Intent it = intent;
        boolean bl4 = false;
        ActivityInfo activityInfo = $this$getDefaultLauncherPackageName.resolveActivity((Intent)it, (int)0).activityInfo;
        return activityInfo == null ? null : (Intrinsics.areEqual((Object)"android", (Object)activityInfo.packageName) ? null : activityInfo.packageName);
    }

    public static final boolean isPackageInstalled(@NotNull PackageManager $this$isPackageInstalled, @NotNull String packageName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isPackageInstalled, (String)"$this$isPackageInstalled");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        try {
            $this$isPackageInstalled.getPackageInfo(packageName, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }
}

