package kim.jeonghyeon.db.kotlinsimplearchitecture

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.TransacterImpl
import com.squareup.sqldelight.db.SqlCursor
import com.squareup.sqldelight.db.SqlDriver
import com.squareup.sqldelight.internal.copyOnWriteList
import kim.jeonghyeon.db.Dictionary
import kim.jeonghyeon.db.DictionaryQueries
import kim.jeonghyeon.db.SimpleDB
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.collections.MutableList
import kotlin.jvm.JvmField
import kotlin.reflect.KClass

internal val KClass<SimpleDB>.schema: SqlDriver.Schema
  get() = SimpleDBImpl.Schema

internal fun KClass<SimpleDB>.newInstance(driver: SqlDriver): SimpleDB = SimpleDBImpl(driver)

private class SimpleDBImpl(
  driver: SqlDriver
) : TransacterImpl(driver), SimpleDB {
  override val dictionaryQueries: DictionaryQueriesImpl = DictionaryQueriesImpl(this, driver)

  object Schema : SqlDriver.Schema {
    override val version: Int
      get() = 1

    override fun create(driver: SqlDriver) {
      driver.execute(null, """
          |CREATE TABLE dictionary (
          |  key TEXT PRIMARY KEY,
          |  value TEXT
          |)
          """.trimMargin(), 0)
    }

    override fun migrate(
      driver: SqlDriver,
      oldVersion: Int,
      newVersion: Int
    ) {
    }
  }
}

private class DictionaryQueriesImpl(
  private val database: SimpleDBImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), DictionaryQueries {
  internal val get: MutableList<Query<*>> = copyOnWriteList()

  override fun <T : Any> get(key: String, mapper: (key: String, value: String?) -> T): Query<T> =
      GetQuery(key) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)
    )
  }

  override fun get(key: String): Query<Dictionary> = get(key, ::Dictionary)

  override fun set(key: String, value: String?) {
    driver.execute(1231745067, """
    |REPLACE INTO dictionary(key, value)
    |VALUES (?, ?)
    """.trimMargin(), 2) {
      bindString(1, key)
      bindString(2, value)
    }
    notifyQueries(1231745067, {database.dictionaryQueries.get})
  }

  private inner class GetQuery<out T : Any>(
    @JvmField
    val key: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(get, mapper) {
    override fun execute(): SqlCursor = driver.executeQuery(1231733535, """
    |SELECT *
    |FROM dictionary
    |WHERE key = ?
    """.trimMargin(), 1) {
      bindString(1, key)
    }

    override fun toString(): String = "Dictionary.sq:get"
  }
}
