package kim.jeonghyeon.db

import com.squareup.sqldelight.Transacter
import com.squareup.sqldelight.db.SqlDriver
import kim.jeonghyeon.db.kotlinsimplearchitecture.newInstance
import kim.jeonghyeon.db.kotlinsimplearchitecture.schema

interface SimpleDB : Transacter {
  val dictionaryQueries: DictionaryQueries

  companion object {
    val Schema: SqlDriver.Schema
      get() = SimpleDB::class.schema

    operator fun invoke(driver: SqlDriver): SimpleDB = SimpleDB::class.newInstance(driver)}
}
