// GENERATED by Simple Api Plugin
package kim.jeonghyeon.api
import kim.jeonghyeon.annotation.Api
import io.ktor.client.HttpClient
import io.ktor.client.request.post
import io.ktor.client.statement.HttpResponse
import io.ktor.client.statement.readText
import io.ktor.http.ContentType
import io.ktor.http.contentType
import kim.jeonghyeon.common.net.throwException
import kim.jeonghyeon.common.net.validateResponse
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonConfiguration
import kotlinx.serialization.json.json
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.builtins.list
import kotlinx.serialization.builtins.nullable
import kotlinx.serialization.builtins.set

class PreferenceApiImpl(val client: HttpClient, val baseUrl: String) : PreferenceApi {

    val mainPath = "kim/jeonghyeon/api/PreferenceApi"

    override suspend fun getString(key: String): String? {
        val subPath = "getString"
        val baseUrlWithoutSlash = if (baseUrl.last() == '/') baseUrl.take(baseUrl.lastIndex) else baseUrl
        val response = try {
            client.post<HttpResponse>(baseUrlWithoutSlash + "/" + mainPath + "/" + subPath) {
                contentType(ContentType.Application.Json)
                body = json {
                    "key" to key
                }
            }
        } catch (e: Exception) {
            client.throwException(e)
        }
    
        client.validateResponse(response)
        val json = Json(JsonConfiguration.Stable)
        return json.parse(String.serializer().nullable, response.readText())
    }
    
    override suspend fun setString(key: String, value: String?) {
        val subPath = "setString"
        val baseUrlWithoutSlash = if (baseUrl.last() == '/') baseUrl.take(baseUrl.lastIndex) else baseUrl
        val response = try {
            client.post<HttpResponse>(baseUrlWithoutSlash + "/" + mainPath + "/" + subPath) {
                contentType(ContentType.Application.Json)
                body = json {
                    "key" to key
                    "value" to value
                }
            }
        } catch (e: Exception) {
            client.throwException(e)
        }
    
        client.validateResponse(response)
    
    }
}