/*
 * Decompiled with CFR 0.152.
 */
package jfun.util.dict;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jfun.util.List;
import jfun.util.dict.DictContainer;
import jfun.util.dict.DictDumbContainer;
import jfun.util.dict.DictProxy;
import jfun.util.dict.DictProxyMigrator;
import jfun.util.dict.DictUpdate;
import jfun.util.dict.InvalidMethodCallException;
import jfun.util.dict.Update;
import jfun.util.dict.UpdateFactory;
import jfun.util.dict.UpdateVisitor;
import jfun.util.dict.Utils;

class DictHash
implements DictContainer,
Serializable {
    private final HashMap table;
    private DictProxy owner;

    public Map getUnderlying() {
        return this.table;
    }

    DictHash(HashMap table) {
        this.table = table;
    }

    private DictProxy finishUp(DictProxyMigrator migrator, ArrayList new_keys, ArrayList old_keys, ArrayList old_vals) {
        Object[] new_keys_arr = new_keys.toArray();
        Object[] old_keys_arr = old_keys.toArray();
        Object[] old_vals_arr = old_vals.toArray();
        if (new_keys_arr.length == 0 && old_keys_arr.length == 0) {
            return this.migrate(migrator.noChange());
        }
        return this.update(migrator, UpdateFactory.buildChanges(old_keys_arr, old_vals_arr, new_keys_arr));
    }

    private DictProxy applyChanges(DictProxyMigrator migrator, Object[] pkeys, Object[] pvals, Object[] rkeys) {
        ArrayList<Object> new_keys = new ArrayList<Object>();
        ArrayList<Object> old_keys = new ArrayList<Object>();
        ArrayList old_vals = new ArrayList();
        for (Object key : rkeys) {
            Object old;
            if (key == null || (old = this.table.get(key)) == null) continue;
            this.table.remove(key);
            old_keys.add(key);
            old_vals.add(old);
        }
        int psize = pkeys.length;
        for (int i = 0; i < psize; ++i) {
            Object key = pkeys[i];
            if (key == null) continue;
            Object val = pvals[i];
            Object old = this.table.get(key);
            if (old == val) continue;
            this.table.put(key, val);
            if (old == null) {
                new_keys.add(key);
                continue;
            }
            if (old == val) continue;
            old_keys.add(key);
            old_vals.add(old);
        }
        return this.finishUp(migrator, new_keys, old_keys, old_vals);
    }

    public DictProxy apply(final DictProxyMigrator migrator, Update upd) {
        upd.accept(new UpdateVisitor(){

            public void visitPut(Object key, Object val) {
                DictHash.this.put(migrator, key, val);
            }

            public void visitRemove(Object key) {
                DictHash.this.remove(migrator, key);
            }

            public void visitChanges(Object[] pkeys, Object[] pvals, Object[] rkeys) {
                DictHash.this.applyChanges(migrator, pkeys, pvals, rkeys);
            }
        });
        return this.owner;
    }

    public DictProxy puts(DictProxyMigrator migrator, Object[] keys, Object[] vals) {
        return this.applyChanges(migrator, keys, vals, Utils.array0);
    }

    public DictProxy removes(DictProxyMigrator migrator, Object[] keys) {
        return this.applyChanges(migrator, Utils.array0, Utils.array0, keys);
    }

    public DictProxy apply(DictProxyMigrator migrator, List updates) {
        BatchUpdate batch = new BatchUpdate();
        Object[] arr = new Update[updates.size()];
        updates.revArray(arr);
        for (int i = 0; i < arr.length; ++i) {
            arr[i].accept(batch);
        }
        ArrayList new_keys = batch.getNewKeys();
        ArrayList old_keys = batch.getOldKeys();
        ArrayList old_vals = batch.getOldVals();
        return this.finishUp(migrator, new_keys, old_keys, old_vals);
    }

    public DictProxy clone(DictProxy outer) {
        HashMap m = (HashMap)this.table.clone();
        DictHash inner = new DictHash(m);
        outer.initUnderlying(m);
        inner.setOwner(outer);
        outer.setState(inner);
        return outer;
    }

    public boolean containsKey(Object key) {
        return this.table.containsKey(key);
    }

    public Object get(Object key) {
        return this.table.get(key);
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public Object[] keys() {
        return this.table.keySet().toArray();
    }

    public Object[] values() {
        return this.table.values().toArray();
    }

    public Object[] keys(Object[] buf) {
        return this.table.keySet().toArray(buf);
    }

    public Object[] values(Object[] buf) {
        return this.table.values().toArray(buf);
    }

    public Map.Entry[] entries() {
        Set s = this.table.entrySet();
        Map.Entry[] ret = new Map.Entry[s.size()];
        s.toArray(ret);
        return ret;
    }

    private final DictProxy migrate(DictProxy outer) {
        return outer == this.owner ? this.owner : this.migrate(outer, new DictDumbContainer(outer));
    }

    private final DictProxy migrate(DictProxy outer, DictContainer inner) {
        this.owner.setState(inner);
        outer.setState(this);
        this.owner = outer;
        return this.owner;
    }

    private final DictProxy migrate(DictProxy outer, Update d) {
        return this.migrate(outer, new DictUpdate(d, outer));
    }

    public DictProxy put(DictProxyMigrator migrator, Object key, Object val) {
        if (key == null) {
            return migrator.noChange();
        }
        Object old = this.table.get(key);
        if (old == val) {
            return this.migrate(migrator.noChange());
        }
        if (old == null) {
            this.table.put(key, val);
            return this.migrate(migrator.changed(), UpdateFactory.buildUpdateRemove(key));
        }
        this.table.put(key, val);
        return this.migrate(migrator.changed(), UpdateFactory.buildUpdatePut(key, old));
    }

    private DictProxy update(DictProxyMigrator migrator, Update upd) {
        return this.migrate(migrator.changed(), upd);
    }

    public DictProxy remove(DictProxyMigrator migrator, Object key) {
        Object old = this.table.get(key);
        if (old == null) {
            return this.migrate(migrator.noChange());
        }
        this.table.remove(key);
        return this.migrate(migrator.changed(), UpdateFactory.buildUpdatePut(key, old));
    }

    void setOwner(DictProxy o) {
        this.owner = o;
    }

    public int size() {
        return this.table.size();
    }

    public void touch(DictProxy outer) {
        if (outer != this.owner) {
            throw new InvalidMethodCallException();
        }
    }

    private final class BatchUpdate
    implements UpdateVisitor {
        private final HashMap mem = new HashMap();
        private final ArrayList new_keys = new ArrayList();
        private final ArrayList old_keys = new ArrayList();
        private final ArrayList old_vals = new ArrayList();

        private BatchUpdate() {
        }

        public void visitPut(Object key, Object val) {
            if (!this.mem.containsKey(key)) {
                this.mem.put(key, "+");
                Object oldVal = DictHash.this.table.get(key);
                if (oldVal != val) {
                    DictHash.this.table.put(key, val);
                    if (oldVal == null) {
                        this.new_keys.add(key);
                    } else {
                        this.old_keys.add(key);
                        this.old_vals.add(oldVal);
                    }
                }
            }
        }

        public void visitRemove(Object key) {
            if (!this.mem.containsKey(key)) {
                this.mem.put(key, "-");
                Object oldVal = DictHash.this.table.get(key);
                if (oldVal != null) {
                    DictHash.this.table.remove(key);
                    this.old_keys.add(key);
                    this.old_vals.add(oldVal);
                }
            }
        }

        public void visitChanges(Object[] pkeys, Object[] pvals, Object[] rkeys) {
            int i;
            for (i = 0; i < rkeys.length; ++i) {
                this.visitRemove(rkeys[i]);
            }
            for (i = 0; i < pkeys.length; ++i) {
                this.visitPut(pkeys[i], pvals[i]);
            }
        }

        ArrayList getNewKeys() {
            return this.new_keys;
        }

        ArrayList getOldKeys() {
            return this.old_keys;
        }

        ArrayList getOldVals() {
            return this.old_vals;
        }
    }
}

