/*
 * Decompiled with CFR 0.152.
 */
package jfun.loader;

import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import jfun.loader.Definer;
import jfun.loader.Loader;

public class ClassLoaderAdapter
extends ClassLoader {
    private final Loader loader;
    private final Definer definer = new MyDefiner();

    public final Loader getLoader() {
        return this.loader;
    }

    public ClassLoaderAdapter(Loader loader) {
        this.loader = loader;
    }

    final Class defClass(String name, byte[] b, int off, int len) {
        return super.defineClass(name, b, off, len);
    }

    final Class defClass(String name, byte[] b, int off, int len, ProtectionDomain protectionDomain) {
        return super.defineClass(name, b, off, len, protectionDomain);
    }

    final Package defPackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    public URL getResource(String name) {
        return this.loader.lookupResource(name);
    }

    public Enumeration enumerateResources(String name) throws IOException {
        return this.loader.enumerateResources(name);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            c = this.loader.lookupClass(name, this.definer);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private final class MyDefiner
    implements Definer {
        private MyDefiner() {
        }

        public final Class defineClass(String name, byte[] b, int off, int len) {
            return ClassLoaderAdapter.this.defClass(name, b, off, len);
        }

        public final Class defineClass(String name, byte[] b, int off, int len, ProtectionDomain protectionDomain) {
            return ClassLoaderAdapter.this.defClass(name, b, off, len, protectionDomain);
        }

        public final Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
            return ClassLoaderAdapter.this.defPackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
        }
    }
}

