/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.recyclerview.animators;

import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewPropertyAnimatorCompat;
import androidx.core.view.ViewPropertyAnimatorListener;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import java.util.ArrayList;
import java.util.List;
import jp.wasabeef.recyclerview.animators.holder.AnimateViewHolder;
import jp.wasabeef.recyclerview.internal.ViewHelper;

public abstract class BaseItemAnimator
extends SimpleItemAnimator {
    private static final boolean DEBUG = false;
    private ArrayList<RecyclerView.ViewHolder> mPendingRemovals = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mPendingAdditions = new ArrayList();
    private ArrayList<MoveInfo> mPendingMoves = new ArrayList();
    private ArrayList<ChangeInfo> mPendingChanges = new ArrayList();
    private ArrayList<ArrayList<RecyclerView.ViewHolder>> mAdditionsList = new ArrayList();
    private ArrayList<ArrayList<MoveInfo>> mMovesList = new ArrayList();
    private ArrayList<ArrayList<ChangeInfo>> mChangesList = new ArrayList();
    protected ArrayList<RecyclerView.ViewHolder> mAddAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mMoveAnimations = new ArrayList();
    protected ArrayList<RecyclerView.ViewHolder> mRemoveAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mChangeAnimations = new ArrayList();
    protected Interpolator mInterpolator = new DecelerateInterpolator();

    public BaseItemAnimator() {
        this.setSupportsChangeAnimations(false);
    }

    public void setInterpolator(Interpolator mInterpolator) {
        this.mInterpolator = mInterpolator;
    }

    public void runPendingAnimations() {
        boolean additionsPending;
        boolean removalsPending = !this.mPendingRemovals.isEmpty();
        boolean movesPending = !this.mPendingMoves.isEmpty();
        boolean changesPending = !this.mPendingChanges.isEmpty();
        boolean bl = additionsPending = !this.mPendingAdditions.isEmpty();
        if (!(removalsPending || movesPending || additionsPending || changesPending)) {
            return;
        }
        for (RecyclerView.ViewHolder holder : this.mPendingRemovals) {
            this.doAnimateRemove(holder);
        }
        this.mPendingRemovals.clear();
        if (movesPending) {
            final ArrayList<MoveInfo> moves = new ArrayList<MoveInfo>();
            moves.addAll(this.mPendingMoves);
            this.mMovesList.add(moves);
            this.mPendingMoves.clear();
            Runnable mover = new Runnable(){

                @Override
                public void run() {
                    boolean removed = BaseItemAnimator.this.mMovesList.remove(moves);
                    if (!removed) {
                        return;
                    }
                    for (MoveInfo moveInfo : moves) {
                        BaseItemAnimator.this.animateMoveImpl(moveInfo.holder, moveInfo.fromX, moveInfo.fromY, moveInfo.toX, moveInfo.toY);
                    }
                    moves.clear();
                }
            };
            if (removalsPending) {
                View view = ((MoveInfo)moves.get((int)0)).holder.itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)mover, (long)this.getRemoveDuration());
            } else {
                mover.run();
            }
        }
        if (changesPending) {
            final ArrayList<ChangeInfo> changes = new ArrayList<ChangeInfo>();
            changes.addAll(this.mPendingChanges);
            this.mChangesList.add(changes);
            this.mPendingChanges.clear();
            Runnable changer = new Runnable(){

                @Override
                public void run() {
                    boolean removed = BaseItemAnimator.this.mChangesList.remove(changes);
                    if (!removed) {
                        return;
                    }
                    for (ChangeInfo change : changes) {
                        BaseItemAnimator.this.animateChangeImpl(change);
                    }
                    changes.clear();
                }
            };
            if (removalsPending) {
                RecyclerView.ViewHolder holder = ((ChangeInfo)changes.get((int)0)).oldHolder;
                ViewCompat.postOnAnimationDelayed((View)holder.itemView, (Runnable)changer, (long)this.getRemoveDuration());
            } else {
                changer.run();
            }
        }
        if (additionsPending) {
            final ArrayList<RecyclerView.ViewHolder> additions = new ArrayList<RecyclerView.ViewHolder>();
            additions.addAll(this.mPendingAdditions);
            this.mAdditionsList.add(additions);
            this.mPendingAdditions.clear();
            Runnable adder = new Runnable(){

                @Override
                public void run() {
                    boolean removed = BaseItemAnimator.this.mAdditionsList.remove(additions);
                    if (!removed) {
                        return;
                    }
                    for (RecyclerView.ViewHolder holder : additions) {
                        BaseItemAnimator.this.doAnimateAdd(holder);
                    }
                    additions.clear();
                }
            };
            if (removalsPending || movesPending || changesPending) {
                long removeDuration = removalsPending ? this.getRemoveDuration() : 0L;
                long moveDuration = movesPending ? this.getMoveDuration() : 0L;
                long changeDuration = changesPending ? this.getChangeDuration() : 0L;
                long totalDelay = removeDuration + Math.max(moveDuration, changeDuration);
                View view = ((RecyclerView.ViewHolder)additions.get((int)0)).itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)adder, (long)totalDelay);
            } else {
                adder.run();
            }
        }
    }

    protected void preAnimateRemoveImpl(RecyclerView.ViewHolder holder) {
    }

    protected void preAnimateAddImpl(RecyclerView.ViewHolder holder) {
    }

    protected abstract void animateRemoveImpl(RecyclerView.ViewHolder var1);

    protected abstract void animateAddImpl(RecyclerView.ViewHolder var1);

    private void preAnimateRemove(RecyclerView.ViewHolder holder) {
        ViewHelper.clear(holder.itemView);
        if (holder instanceof AnimateViewHolder) {
            ((AnimateViewHolder)holder).preAnimateRemoveImpl(holder);
        } else {
            this.preAnimateRemoveImpl(holder);
        }
    }

    private void preAnimateAdd(RecyclerView.ViewHolder holder) {
        ViewHelper.clear(holder.itemView);
        if (holder instanceof AnimateViewHolder) {
            ((AnimateViewHolder)holder).preAnimateAddImpl(holder);
        } else {
            this.preAnimateAddImpl(holder);
        }
    }

    private void doAnimateRemove(RecyclerView.ViewHolder holder) {
        if (holder instanceof AnimateViewHolder) {
            ((AnimateViewHolder)holder).animateRemoveImpl(holder, new DefaultRemoveVpaListener(holder));
        } else {
            this.animateRemoveImpl(holder);
        }
        this.mRemoveAnimations.add(holder);
    }

    private void doAnimateAdd(RecyclerView.ViewHolder holder) {
        if (holder instanceof AnimateViewHolder) {
            ((AnimateViewHolder)holder).animateAddImpl(holder, new DefaultAddVpaListener(holder));
        } else {
            this.animateAddImpl(holder);
        }
        this.mAddAnimations.add(holder);
    }

    public boolean animateRemove(RecyclerView.ViewHolder holder) {
        this.endAnimation(holder);
        this.preAnimateRemove(holder);
        this.mPendingRemovals.add(holder);
        return true;
    }

    protected long getRemoveDelay(RecyclerView.ViewHolder holder) {
        return Math.abs((long)holder.getOldPosition() * this.getRemoveDuration() / 4L);
    }

    public boolean animateAdd(RecyclerView.ViewHolder holder) {
        this.endAnimation(holder);
        this.preAnimateAdd(holder);
        this.mPendingAdditions.add(holder);
        return true;
    }

    protected long getAddDelay(RecyclerView.ViewHolder holder) {
        return Math.abs((long)holder.getAdapterPosition() * this.getAddDuration() / 4L);
    }

    public boolean animateMove(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        View view = holder.itemView;
        fromX = (int)((float)fromX + ViewCompat.getTranslationX((View)holder.itemView));
        fromY = (int)((float)fromY + ViewCompat.getTranslationY((View)holder.itemView));
        this.endAnimation(holder);
        int deltaX = toX - fromX;
        int deltaY = toY - fromY;
        if (deltaX == 0 && deltaY == 0) {
            this.dispatchMoveFinished(holder);
            return false;
        }
        if (deltaX != 0) {
            ViewCompat.setTranslationX((View)view, (float)(-deltaX));
        }
        if (deltaY != 0) {
            ViewCompat.setTranslationY((View)view, (float)(-deltaY));
        }
        this.mPendingMoves.add(new MoveInfo(holder, fromX, fromY, toX, toY));
        return true;
    }

    private void animateMoveImpl(final RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        View view = holder.itemView;
        final int deltaX = toX - fromX;
        final int deltaY = toY - fromY;
        if (deltaX != 0) {
            ViewCompat.animate((View)view).translationX(0.0f);
        }
        if (deltaY != 0) {
            ViewCompat.animate((View)view).translationY(0.0f);
        }
        this.mMoveAnimations.add(holder);
        final ViewPropertyAnimatorCompat animation = ViewCompat.animate((View)view);
        animation.setDuration(this.getMoveDuration()).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

            @Override
            public void onAnimationStart(View view) {
                BaseItemAnimator.this.dispatchMoveStarting(holder);
            }

            @Override
            public void onAnimationCancel(View view) {
                if (deltaX != 0) {
                    ViewCompat.setTranslationX((View)view, (float)0.0f);
                }
                if (deltaY != 0) {
                    ViewCompat.setTranslationY((View)view, (float)0.0f);
                }
            }

            @Override
            public void onAnimationEnd(View view) {
                animation.setListener(null);
                BaseItemAnimator.this.dispatchMoveFinished(holder);
                BaseItemAnimator.this.mMoveAnimations.remove(holder);
                BaseItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public boolean animateChange(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromX, int fromY, int toX, int toY) {
        if (oldHolder == newHolder) {
            return this.animateMove(oldHolder, fromX, fromY, toX, toY);
        }
        float prevTranslationX = ViewCompat.getTranslationX((View)oldHolder.itemView);
        float prevTranslationY = ViewCompat.getTranslationY((View)oldHolder.itemView);
        float prevAlpha = ViewCompat.getAlpha((View)oldHolder.itemView);
        this.endAnimation(oldHolder);
        int deltaX = (int)((float)(toX - fromX) - prevTranslationX);
        int deltaY = (int)((float)(toY - fromY) - prevTranslationY);
        ViewCompat.setTranslationX((View)oldHolder.itemView, (float)prevTranslationX);
        ViewCompat.setTranslationY((View)oldHolder.itemView, (float)prevTranslationY);
        ViewCompat.setAlpha((View)oldHolder.itemView, (float)prevAlpha);
        if (newHolder != null && newHolder.itemView != null) {
            this.endAnimation(newHolder);
            ViewCompat.setTranslationX((View)newHolder.itemView, (float)(-deltaX));
            ViewCompat.setTranslationY((View)newHolder.itemView, (float)(-deltaY));
            ViewCompat.setAlpha((View)newHolder.itemView, (float)0.0f);
        }
        this.mPendingChanges.add(new ChangeInfo(oldHolder, newHolder, fromX, fromY, toX, toY));
        return true;
    }

    private void animateChangeImpl(final ChangeInfo changeInfo) {
        View newView;
        RecyclerView.ViewHolder holder = changeInfo.oldHolder;
        View view = holder == null ? null : holder.itemView;
        RecyclerView.ViewHolder newHolder = changeInfo.newHolder;
        View view2 = newView = newHolder != null ? newHolder.itemView : null;
        if (view != null) {
            this.mChangeAnimations.add(changeInfo.oldHolder);
            final ViewPropertyAnimatorCompat oldViewAnim = ViewCompat.animate((View)view).setDuration(this.getChangeDuration());
            oldViewAnim.translationX((float)(changeInfo.toX - changeInfo.fromX));
            oldViewAnim.translationY((float)(changeInfo.toY - changeInfo.fromY));
            oldViewAnim.alpha(0.0f).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

                @Override
                public void onAnimationStart(View view) {
                    BaseItemAnimator.this.dispatchChangeStarting(changeInfo.oldHolder, true);
                }

                @Override
                public void onAnimationEnd(View view) {
                    oldViewAnim.setListener(null);
                    ViewCompat.setAlpha((View)view, (float)1.0f);
                    ViewCompat.setTranslationX((View)view, (float)0.0f);
                    ViewCompat.setTranslationY((View)view, (float)0.0f);
                    BaseItemAnimator.this.dispatchChangeFinished(changeInfo.oldHolder, true);
                    BaseItemAnimator.this.mChangeAnimations.remove(changeInfo.oldHolder);
                    BaseItemAnimator.this.dispatchFinishedWhenDone();
                }
            }).start();
        }
        if (newView != null) {
            this.mChangeAnimations.add(changeInfo.newHolder);
            final ViewPropertyAnimatorCompat newViewAnimation = ViewCompat.animate((View)newView);
            newViewAnimation.translationX(0.0f).translationY(0.0f).setDuration(this.getChangeDuration()).alpha(1.0f).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

                @Override
                public void onAnimationStart(View view) {
                    BaseItemAnimator.this.dispatchChangeStarting(changeInfo.newHolder, false);
                }

                @Override
                public void onAnimationEnd(View view) {
                    newViewAnimation.setListener(null);
                    ViewCompat.setAlpha((View)newView, (float)1.0f);
                    ViewCompat.setTranslationX((View)newView, (float)0.0f);
                    ViewCompat.setTranslationY((View)newView, (float)0.0f);
                    BaseItemAnimator.this.dispatchChangeFinished(changeInfo.newHolder, false);
                    BaseItemAnimator.this.mChangeAnimations.remove(changeInfo.newHolder);
                    BaseItemAnimator.this.dispatchFinishedWhenDone();
                }
            }).start();
        }
    }

    private void endChangeAnimation(List<ChangeInfo> infoList, RecyclerView.ViewHolder item) {
        for (int i = infoList.size() - 1; i >= 0; --i) {
            ChangeInfo changeInfo = infoList.get(i);
            if (!this.endChangeAnimationIfNecessary(changeInfo, item) || changeInfo.oldHolder != null || changeInfo.newHolder != null) continue;
            infoList.remove(changeInfo);
        }
    }

    private void endChangeAnimationIfNecessary(ChangeInfo changeInfo) {
        if (changeInfo.oldHolder != null) {
            this.endChangeAnimationIfNecessary(changeInfo, changeInfo.oldHolder);
        }
        if (changeInfo.newHolder != null) {
            this.endChangeAnimationIfNecessary(changeInfo, changeInfo.newHolder);
        }
    }

    private boolean endChangeAnimationIfNecessary(ChangeInfo changeInfo, RecyclerView.ViewHolder item) {
        boolean oldItem = false;
        if (changeInfo.newHolder == item) {
            changeInfo.newHolder = null;
        } else if (changeInfo.oldHolder == item) {
            changeInfo.oldHolder = null;
            oldItem = true;
        } else {
            return false;
        }
        ViewCompat.setAlpha((View)item.itemView, (float)1.0f);
        ViewCompat.setTranslationX((View)item.itemView, (float)0.0f);
        ViewCompat.setTranslationY((View)item.itemView, (float)0.0f);
        this.dispatchChangeFinished(item, oldItem);
        return true;
    }

    public void endAnimation(RecyclerView.ViewHolder item) {
        int i;
        View view = item.itemView;
        ViewCompat.animate((View)view).cancel();
        for (i = this.mPendingMoves.size() - 1; i >= 0; --i) {
            MoveInfo moveInfo = this.mPendingMoves.get(i);
            if (moveInfo.holder != item) continue;
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            this.dispatchMoveFinished(item);
            this.mPendingMoves.remove(i);
        }
        this.endChangeAnimation(this.mPendingChanges, item);
        if (this.mPendingRemovals.remove(item)) {
            ViewHelper.clear(item.itemView);
            this.dispatchRemoveFinished(item);
        }
        if (this.mPendingAdditions.remove(item)) {
            ViewHelper.clear(item.itemView);
            this.dispatchAddFinished(item);
        }
        for (i = this.mChangesList.size() - 1; i >= 0; --i) {
            ArrayList<ChangeInfo> changes = this.mChangesList.get(i);
            this.endChangeAnimation(changes, item);
            if (!changes.isEmpty()) continue;
            this.mChangesList.remove(i);
        }
        block2: for (i = this.mMovesList.size() - 1; i >= 0; --i) {
            ArrayList<MoveInfo> moves = this.mMovesList.get(i);
            for (int j = moves.size() - 1; j >= 0; --j) {
                MoveInfo moveInfo = moves.get(j);
                if (moveInfo.holder != item) continue;
                ViewCompat.setTranslationY((View)view, (float)0.0f);
                ViewCompat.setTranslationX((View)view, (float)0.0f);
                this.dispatchMoveFinished(item);
                moves.remove(j);
                if (!moves.isEmpty()) continue block2;
                this.mMovesList.remove(i);
                continue block2;
            }
        }
        for (i = this.mAdditionsList.size() - 1; i >= 0; --i) {
            ArrayList<RecyclerView.ViewHolder> additions = this.mAdditionsList.get(i);
            if (!additions.remove(item)) continue;
            ViewHelper.clear(item.itemView);
            this.dispatchAddFinished(item);
            if (!additions.isEmpty()) continue;
            this.mAdditionsList.remove(i);
        }
        if (this.mRemoveAnimations.remove(item)) {
            // empty if block
        }
        if (this.mAddAnimations.remove(item)) {
            // empty if block
        }
        if (this.mChangeAnimations.remove(item)) {
            // empty if block
        }
        if (this.mMoveAnimations.remove(item)) {
            // empty if block
        }
        this.dispatchFinishedWhenDone();
    }

    public boolean isRunning() {
        return !this.mPendingAdditions.isEmpty() || !this.mPendingChanges.isEmpty() || !this.mPendingMoves.isEmpty() || !this.mPendingRemovals.isEmpty() || !this.mMoveAnimations.isEmpty() || !this.mRemoveAnimations.isEmpty() || !this.mAddAnimations.isEmpty() || !this.mChangeAnimations.isEmpty() || !this.mMovesList.isEmpty() || !this.mAdditionsList.isEmpty() || !this.mChangesList.isEmpty();
    }

    private void dispatchFinishedWhenDone() {
        if (!this.isRunning()) {
            this.dispatchAnimationsFinished();
        }
    }

    public void endAnimations() {
        int j;
        int i;
        MoveInfo item;
        int i2;
        int count = this.mPendingMoves.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item = this.mPendingMoves.get(i2);
            View view = item.holder.itemView;
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            this.dispatchMoveFinished(item.holder);
            this.mPendingMoves.remove(i2);
        }
        count = this.mPendingRemovals.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item = this.mPendingRemovals.get(i2);
            this.dispatchRemoveFinished((RecyclerView.ViewHolder)item);
            this.mPendingRemovals.remove(i2);
        }
        count = this.mPendingAdditions.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item = this.mPendingAdditions.get(i2);
            ViewHelper.clear(((RecyclerView.ViewHolder)item).itemView);
            this.dispatchAddFinished((RecyclerView.ViewHolder)item);
            this.mPendingAdditions.remove(i2);
        }
        count = this.mPendingChanges.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            this.endChangeAnimationIfNecessary(this.mPendingChanges.get(i2));
        }
        this.mPendingChanges.clear();
        if (!this.isRunning()) {
            return;
        }
        int listCount = this.mMovesList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<MoveInfo> moves = this.mMovesList.get(i);
            count = moves.size();
            for (j = count - 1; j >= 0; --j) {
                MoveInfo moveInfo = moves.get(j);
                RecyclerView.ViewHolder item2 = moveInfo.holder;
                View view = item2.itemView;
                ViewCompat.setTranslationY((View)view, (float)0.0f);
                ViewCompat.setTranslationX((View)view, (float)0.0f);
                this.dispatchMoveFinished(moveInfo.holder);
                moves.remove(j);
                if (!moves.isEmpty()) continue;
                this.mMovesList.remove(moves);
            }
        }
        listCount = this.mAdditionsList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<RecyclerView.ViewHolder> additions = this.mAdditionsList.get(i);
            count = additions.size();
            for (j = count - 1; j >= 0; --j) {
                RecyclerView.ViewHolder item3 = additions.get(j);
                View view = item3.itemView;
                ViewCompat.setAlpha((View)view, (float)1.0f);
                this.dispatchAddFinished(item3);
                if (j < additions.size()) {
                    additions.remove(j);
                }
                if (!additions.isEmpty()) continue;
                this.mAdditionsList.remove(additions);
            }
        }
        listCount = this.mChangesList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<ChangeInfo> changes = this.mChangesList.get(i);
            count = changes.size();
            for (j = count - 1; j >= 0; --j) {
                this.endChangeAnimationIfNecessary(changes.get(j));
                if (!changes.isEmpty()) continue;
                this.mChangesList.remove(changes);
            }
        }
        this.cancelAll(this.mRemoveAnimations);
        this.cancelAll(this.mMoveAnimations);
        this.cancelAll(this.mAddAnimations);
        this.cancelAll(this.mChangeAnimations);
        this.dispatchAnimationsFinished();
    }

    void cancelAll(List<RecyclerView.ViewHolder> viewHolders) {
        for (int i = viewHolders.size() - 1; i >= 0; --i) {
            ViewCompat.animate((View)viewHolders.get((int)i).itemView).cancel();
        }
    }

    protected class DefaultRemoveVpaListener
    extends VpaListenerAdapter {
        RecyclerView.ViewHolder mViewHolder;

        public DefaultRemoveVpaListener(RecyclerView.ViewHolder holder) {
            this.mViewHolder = holder;
        }

        @Override
        public void onAnimationStart(View view) {
            BaseItemAnimator.this.dispatchRemoveStarting(this.mViewHolder);
        }

        @Override
        public void onAnimationCancel(View view) {
            ViewHelper.clear(view);
        }

        @Override
        public void onAnimationEnd(View view) {
            ViewHelper.clear(view);
            BaseItemAnimator.this.dispatchRemoveFinished(this.mViewHolder);
            BaseItemAnimator.this.mRemoveAnimations.remove(this.mViewHolder);
            BaseItemAnimator.this.dispatchFinishedWhenDone();
        }
    }

    protected class DefaultAddVpaListener
    extends VpaListenerAdapter {
        RecyclerView.ViewHolder mViewHolder;

        public DefaultAddVpaListener(RecyclerView.ViewHolder holder) {
            this.mViewHolder = holder;
        }

        @Override
        public void onAnimationStart(View view) {
            BaseItemAnimator.this.dispatchAddStarting(this.mViewHolder);
        }

        @Override
        public void onAnimationCancel(View view) {
            ViewHelper.clear(view);
        }

        @Override
        public void onAnimationEnd(View view) {
            ViewHelper.clear(view);
            BaseItemAnimator.this.dispatchAddFinished(this.mViewHolder);
            BaseItemAnimator.this.mAddAnimations.remove(this.mViewHolder);
            BaseItemAnimator.this.dispatchFinishedWhenDone();
        }
    }

    private static class VpaListenerAdapter
    implements ViewPropertyAnimatorListener {
        private VpaListenerAdapter() {
        }

        public void onAnimationStart(View view) {
        }

        public void onAnimationEnd(View view) {
        }

        public void onAnimationCancel(View view) {
        }
    }

    private static class ChangeInfo {
        public RecyclerView.ViewHolder oldHolder;
        public RecyclerView.ViewHolder newHolder;
        public int fromX;
        public int fromY;
        public int toX;
        public int toY;

        private ChangeInfo(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder) {
            this.oldHolder = oldHolder;
            this.newHolder = newHolder;
        }

        private ChangeInfo(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromX, int fromY, int toX, int toY) {
            this(oldHolder, newHolder);
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }

        public String toString() {
            return "ChangeInfo{oldHolder=" + this.oldHolder + ", newHolder=" + this.newHolder + ", fromX=" + this.fromX + ", fromY=" + this.fromY + ", toX=" + this.toX + ", toY=" + this.toY + '}';
        }
    }

    private static class MoveInfo {
        public RecyclerView.ViewHolder holder;
        public int fromX;
        public int fromY;
        public int toX;
        public int toY;

        private MoveInfo(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
            this.holder = holder;
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }
    }
}

