/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import androidx.annotation.NonNull;
import java.security.MessageDigest;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageSepiaToneFilter;
import jp.wasabeef.glide.transformations.gpu.GPUFilterTransformation;

public class SepiaFilterTransformation
extends GPUFilterTransformation {
    private static final int VERSION = 1;
    private static final String ID = "jp.wasabeef.glide.transformations.gpu.SepiaFilterTransformation.1";
    private float intensity;

    public SepiaFilterTransformation() {
        this(1.0f);
    }

    public SepiaFilterTransformation(float intensity) {
        super((GPUImageFilter)new GPUImageSepiaToneFilter());
        this.intensity = intensity;
        GPUImageSepiaToneFilter filter = (GPUImageSepiaToneFilter)this.getFilter();
        filter.setIntensity(this.intensity);
    }

    @Override
    public String toString() {
        return "SepiaFilterTransformation(intensity=" + this.intensity + ")";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SepiaFilterTransformation;
    }

    @Override
    public int hashCode() {
        return ID.hashCode() + (int)(this.intensity * 10.0f);
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.intensity).getBytes(CHARSET));
    }
}

