/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import androidx.annotation.NonNull;
import java.security.MessageDigest;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.filter.GPUImagePixelationFilter;
import jp.wasabeef.glide.transformations.gpu.GPUFilterTransformation;

public class PixelationFilterTransformation
extends GPUFilterTransformation {
    private static final int VERSION = 1;
    private static final String ID = "jp.wasabeef.glide.transformations.gpu.PixelationFilterTransformation.1";
    private float pixel;

    public PixelationFilterTransformation() {
        this(10.0f);
    }

    public PixelationFilterTransformation(float pixel) {
        super((GPUImageFilter)new GPUImagePixelationFilter());
        this.pixel = pixel;
        GPUImagePixelationFilter filter = (GPUImagePixelationFilter)this.getFilter();
        filter.setPixel(this.pixel);
    }

    @Override
    public String toString() {
        return "PixelationFilterTransformation(pixel=" + this.pixel + ")";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof PixelationFilterTransformation;
    }

    @Override
    public int hashCode() {
        return ID.hashCode() + (int)(this.pixel * 10.0f);
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.pixel).getBytes(CHARSET));
    }
}

