/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import android.content.Context;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageToonFilter;
import jp.wasabeef.glide.transformations.gpu.GPUFilterTransformation;

public class ToonFilterTransformation
extends GPUFilterTransformation {
    private float mThreshold;
    private float mQuantizationLevels;

    public ToonFilterTransformation(Context context) {
        this(context, Glide.get((Context)context).getBitmapPool());
    }

    public ToonFilterTransformation(Context context, BitmapPool pool) {
        this(context, pool, 0.2f, 10.0f);
    }

    public ToonFilterTransformation(Context context, float threshold, float quantizationLevels) {
        this(context, Glide.get((Context)context).getBitmapPool(), threshold, quantizationLevels);
    }

    public ToonFilterTransformation(Context context, BitmapPool pool, float threshold, float quantizationLevels) {
        super(context, pool, (GPUImageFilter)new GPUImageToonFilter());
        this.mThreshold = threshold;
        this.mQuantizationLevels = quantizationLevels;
        GPUImageToonFilter filter = (GPUImageToonFilter)this.getFilter();
        filter.setThreshold(this.mThreshold);
        filter.setQuantizationLevels(this.mQuantizationLevels);
    }

    @Override
    public String getId() {
        return "ToonFilterTransformation(threshold=" + this.mThreshold + ",quantizationLevels=" + this.mQuantizationLevels + ")";
    }
}

