/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;

public class CropTransformation
implements Transformation<Bitmap> {
    private BitmapPool mBitmapPool;
    private int mWidth;
    private int mHeight;
    private CropType mCropType = CropType.CENTER;

    public CropTransformation(Context context) {
        this(Glide.get((Context)context).getBitmapPool());
    }

    public CropTransformation(BitmapPool pool) {
        this(pool, 0, 0);
    }

    public CropTransformation(Context context, int width, int height) {
        this(Glide.get((Context)context).getBitmapPool(), width, height);
    }

    public CropTransformation(BitmapPool pool, int width, int height) {
        this(pool, width, height, CropType.CENTER);
    }

    public CropTransformation(Context context, int width, int height, CropType cropType) {
        this(Glide.get((Context)context).getBitmapPool(), width, height, cropType);
    }

    public CropTransformation(BitmapPool pool, int width, int height, CropType cropType) {
        this.mBitmapPool = pool;
        this.mWidth = width;
        this.mHeight = height;
        this.mCropType = cropType;
    }

    public Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap source = (Bitmap)resource.get();
        this.mWidth = this.mWidth == 0 ? source.getWidth() : this.mWidth;
        this.mHeight = this.mHeight == 0 ? source.getHeight() : this.mHeight;
        Bitmap.Config config = source.getConfig() != null ? source.getConfig() : Bitmap.Config.ARGB_8888;
        Bitmap bitmap = this.mBitmapPool.get(this.mWidth, this.mHeight, config);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)config);
        }
        float scaleX = (float)this.mWidth / (float)source.getWidth();
        float scaleY = (float)this.mHeight / (float)source.getHeight();
        float scale = Math.max(scaleX, scaleY);
        float scaledWidth = scale * (float)source.getWidth();
        float scaledHeight = scale * (float)source.getHeight();
        float left = ((float)this.mWidth - scaledWidth) / 2.0f;
        float top = this.getTop(scaledHeight);
        RectF targetRect = new RectF(left, top, left + scaledWidth, top + scaledHeight);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawBitmap(source, null, targetRect, null);
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public String getId() {
        return "CropTransformation(width=" + this.mWidth + ", height=" + this.mHeight + ", cropType=" + (Object)((Object)this.mCropType) + ")";
    }

    private float getTop(float scaledHeight) {
        switch (this.mCropType) {
            case TOP: {
                return 0.0f;
            }
            case CENTER: {
                return ((float)this.mHeight - scaledHeight) / 2.0f;
            }
            case BOTTOM: {
                return (float)this.mHeight - scaledHeight;
            }
        }
        return 0.0f;
    }

    public static enum CropType {
        TOP,
        CENTER,
        BOTTOM;

    }
}

