/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.sns;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.PublishRequest;
import jp.classmethod.aws.gradle.sns.AmazonSNSPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonSNSPublishMessageTask
extends ConventionTask {
    private String topicArn;
    private String message;
    private String subject;
    private String messageStructure;

    public AmazonSNSPublishMessageTask() {
        this.setDescription("Publish message to SNS");
        this.setGroup("AWS");
    }

    @TaskAction
    public void publishMessage() {
        String topicArn = this.getTopicArn();
        String message = this.getMessage();
        String subject = this.getSubject();
        String messageStructure = this.getMessageStructure();
        if (topicArn == null) {
            throw new GradleException("Must specify SNS topicArn");
        }
        if (message == null) {
            throw new GradleException("Must provide message to send to SNS");
        }
        AmazonSNSPluginExtension ext = (AmazonSNSPluginExtension)this.getProject().getExtensions().getByType(AmazonSNSPluginExtension.class);
        AmazonSNS sns = (AmazonSNS)ext.getClient();
        PublishRequest request = new PublishRequest().withTopicArn(topicArn).withMessage(message);
        if (subject != null) {
            request.setSubject(subject);
        }
        if (messageStructure != null) {
            request.setMessageStructure(messageStructure);
        }
        sns.publish(request);
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessageStructure() {
        return this.messageStructure;
    }

    public void setMessageStructure(String messageStructure) {
        this.messageStructure = messageStructure;
    }
}

