/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Region;
import jp.classmethod.aws.gradle.s3.AmazonS3PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class CreateBucketTask
extends ConventionTask {
    private static final String AWS_DEFAULT_REGION_NAME = "us-east-1 (default)";
    public String bucketName;
    public String region;
    public boolean ifNotExists;

    public CreateBucketTask() {
        this.setDescription("Create the Amazon S3 bucket.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createBucket() {
        String bucketName = this.getBucketName();
        String region = this.getRegion();
        if (bucketName == null) {
            throw new GradleException("bucketName is not specified");
        }
        AmazonS3PluginExtension ext = (AmazonS3PluginExtension)this.getProject().getExtensions().getByType(AmazonS3PluginExtension.class);
        AmazonS3 s3 = (AmazonS3)ext.getClient();
        if (this.isIfNotExists() && this.exists(s3)) {
            this.getLogger().info("Bucket already exists and won't be created. Use 'ifNotExists' to override.");
            return;
        }
        String regionName = AWS_DEFAULT_REGION_NAME;
        if (region == null) {
            s3.createBucket(bucketName);
        } else {
            regionName = this.getAwsRegionName(region);
            s3.createBucket(bucketName, region);
        }
        this.getLogger().info("S3 Bucket '{}' created at region '{}'", (Object)bucketName, (Object)regionName);
    }

    private String getAwsRegionName(String region) {
        try {
            return Region.fromValue((String)region).toString();
        }
        catch (IllegalArgumentException e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean exists(AmazonS3 s3) {
        String bucketName = this.getBucketName();
        try {
            s3.getBucketLocation(bucketName);
            return true;
        }
        catch (AmazonClientException e) {
            return false;
        }
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }
}

