/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.services.s3.AmazonS3Client;
import jp.classmethod.aws.gradle.common.BaseRegionAwarePluginExtension;
import org.gradle.api.Project;

public class AmazonS3PluginExtension
extends BaseRegionAwarePluginExtension<AmazonS3Client> {
    public static final String NAME = "s3";
    private Integer maxErrorRetry = -1;

    public AmazonS3PluginExtension(Project project) {
        super(project, AmazonS3Client.class);
    }

    @Override
    protected ClientConfiguration buildClientConfiguration() {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (this.maxErrorRetry > 0) {
            clientConfiguration.setMaxErrorRetry(this.maxErrorRetry.intValue());
        }
        return clientConfiguration;
    }

    @Override
    protected boolean isRegionRequired() {
        return false;
    }

    public Integer getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public void setMaxErrorRetry(Integer maxErrorRetry) {
        this.maxErrorRetry = maxErrorRetry;
    }
}

