/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.s3;

import com.amazonaws.services.s3.AmazonS3;
import jp.classmethod.aws.gradle.s3.AmazonS3PluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AmazonS3FileDeleteTask
extends ConventionTask {
    String bucketName;
    String key;

    public AmazonS3FileDeleteTask() {
        this.setDescription("Delete file from the Amazon S3 bucket.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void delete() {
        String bucketName = this.getBucketName();
        String key = this.getKey();
        if (bucketName == null) {
            throw new GradleException("bucketName is not specified");
        }
        if (key == null) {
            throw new GradleException("key is not specified");
        }
        AmazonS3PluginExtension ext = (AmazonS3PluginExtension)this.getProject().getExtensions().getByType(AmazonS3PluginExtension.class);
        AmazonS3 s3 = (AmazonS3)ext.getClient();
        this.getLogger().info("deleting... " + bucketName + "/" + key);
        s3.deleteObject(bucketName, key);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

