/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.lambda;

import com.amazonaws.services.lambda.model.VpcConfig;
import java.util.Collection;
import org.gradle.api.GradleException;

public class VpcConfigWrapper {
    private Collection<String> subnetIds;
    private Collection<String> securityGroupIds;

    public void validate() {
        boolean missingSecurityGroup;
        boolean missingSubnet = this.subnetIds == null || this.subnetIds.isEmpty();
        boolean bl = missingSecurityGroup = this.securityGroupIds == null || this.securityGroupIds.isEmpty();
        if (missingSubnet || missingSecurityGroup) {
            throw new GradleException("At least one subnet ID and one security group are required for a VpcConfig");
        }
    }

    public VpcConfig toVpcConfig() {
        this.validate();
        return new VpcConfig().withSubnetIds(this.subnetIds).withSecurityGroupIds(this.securityGroupIds);
    }

    public Collection<String> getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        this.subnetIds = subnetIds;
    }

    public Collection<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        this.securityGroupIds = securityGroupIds;
    }
}

