/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.lambda;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.Environment;
import com.amazonaws.services.lambda.model.ListTagsRequest;
import com.amazonaws.services.lambda.model.ListTagsResult;
import com.amazonaws.services.lambda.model.TagResourceRequest;
import com.amazonaws.services.lambda.model.UntagResourceRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationResult;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import jp.classmethod.aws.gradle.lambda.AWSLambdaPluginExtension;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSLambdaUpdateFunctionConfigurationTask
extends ConventionTask {
    private String functionName;
    private String role;
    private String handler;
    private String functionDescription;
    private Integer timeout;
    private Integer memorySize;
    private Map<String, String> environment;
    private Map<String, String> tags;
    private UpdateFunctionConfigurationResult updateFunctionConfiguration;

    public AWSLambdaUpdateFunctionConfigurationTask() {
        this.setDescription("Update Lambda function configuration.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createFunction() throws FileNotFoundException, IOException {
        String functionName = this.getFunctionName();
        if (functionName == null) {
            throw new GradleException("functionName is required");
        }
        AWSLambdaPluginExtension ext = (AWSLambdaPluginExtension)this.getProject().getExtensions().getByType(AWSLambdaPluginExtension.class);
        AWSLambda lambda = (AWSLambda)ext.getClient();
        UpdateFunctionConfigurationRequest request = new UpdateFunctionConfigurationRequest().withFunctionName(this.getFunctionName()).withRole(this.getRole()).withHandler(this.getHandler()).withDescription(this.getFunctionDescription()).withTimeout(this.getTimeout()).withMemorySize(this.getMemorySize()).withEnvironment(new Environment().withVariables(this.getEnvironment()));
        this.updateFunctionConfiguration = lambda.updateFunctionConfiguration(request);
        this.getLogger().info("Update Lambda function configuration requested: {}", (Object)this.updateFunctionConfiguration.getFunctionArn());
        this.tagFunction(lambda);
    }

    private void tagFunction(AWSLambda lambda) {
        if (this.getTags() != null) {
            ListTagsRequest listTagsRequest = new ListTagsRequest().withResource(this.getUpdateFunctionConfiguration().getFunctionArn());
            ListTagsResult listTagsResult = lambda.listTags(listTagsRequest);
            if (!listTagsResult.getTags().isEmpty()) {
                MapDifference tagDifferences = Maps.difference((Map)listTagsResult.getTags(), this.getTags());
                UntagResourceRequest untagResourceRequest = new UntagResourceRequest().withResource(this.getUpdateFunctionConfiguration().getFunctionArn()).withTagKeys(tagDifferences.entriesOnlyOnLeft().keySet());
                lambda.untagResource(untagResourceRequest);
            }
            if (!this.getTags().isEmpty()) {
                TagResourceRequest tagResourceRequest = new TagResourceRequest().withTags(this.getTags()).withResource(this.getUpdateFunctionConfiguration().getFunctionArn());
                lambda.tagResource(tagResourceRequest);
                this.getLogger().info("Update Lambda function tags requested: {}", (Object)this.getUpdateFunctionConfiguration().getFunctionArn());
            }
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getFunctionDescription() {
        return this.functionDescription;
    }

    public void setFunctionDescription(String functionDescription) {
        this.functionDescription = functionDescription;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySize(Integer memorySize) {
        this.memorySize = memorySize;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public UpdateFunctionConfigurationResult getUpdateFunctionConfiguration() {
        return this.updateFunctionConfiguration;
    }
}

