/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.lambda;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import jp.classmethod.aws.gradle.lambda.AWSLambdaPluginExtension;
import jp.classmethod.aws.gradle.lambda.S3File;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSLambdaUpdateFunctionCodeTask
extends ConventionTask {
    private String functionName;
    private File zipFile;
    private S3File s3File;
    private UpdateFunctionCodeResult updateFunctionCode;

    public AWSLambdaUpdateFunctionCodeTask() {
        this.setDescription("Update Lambda function code.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void updateFunctionCode() throws FileNotFoundException, IOException {
        UpdateFunctionCodeRequest request;
        AWSLambda lambda;
        block27: {
            String functionName = this.getFunctionName();
            if (functionName == null) {
                throw new GradleException("functionName is required");
            }
            if (this.zipFile == null && this.s3File == null || this.zipFile != null && this.s3File != null) {
                throw new GradleException("exactly one of zipFile or s3File is required");
            }
            AWSLambdaPluginExtension ext = (AWSLambdaPluginExtension)this.getProject().getExtensions().getByType(AWSLambdaPluginExtension.class);
            lambda = (AWSLambda)ext.getClient();
            request = new UpdateFunctionCodeRequest().withFunctionName(this.getFunctionName());
            if (this.zipFile != null) {
                try (RandomAccessFile raf = new RandomAccessFile(this.getZipFile(), "r");
                     FileChannel channel = raf.getChannel();){
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
                    buffer.load();
                    request = request.withZipFile((ByteBuffer)buffer);
                    break block27;
                }
            }
            this.s3File.validate();
            request = request.withS3Bucket(this.s3File.getBucketName()).withS3Key(this.s3File.getKey()).withS3ObjectVersion(this.s3File.getObjectVersion());
        }
        UpdateFunctionCodeResult updateFunctionCode = lambda.updateFunctionCode(request);
        this.getLogger().info("Update Lambda function requested: {}", (Object)updateFunctionCode.getFunctionArn());
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public S3File getS3File() {
        return this.s3File;
    }

    public void setS3File(S3File s3File) {
        this.s3File = s3File;
    }

    public UpdateFunctionCodeResult getUpdateFunctionCode() {
        return this.updateFunctionCode;
    }
}

