/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.lambda;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.AliasRoutingConfiguration;
import com.amazonaws.services.lambda.model.UpdateAliasRequest;
import com.amazonaws.services.lambda.model.UpdateAliasResult;
import groovy.lang.Closure;
import jp.classmethod.aws.gradle.lambda.AWSLambdaPluginExtension;
import jp.classmethod.aws.gradle.lambda.RoutingConfig;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;

public class AWSLambdaUpdateAliasTask
extends ConventionTask {
    private String functionName;
    private String aliasName;
    private String functionVersion;
    private String aliasDescription;
    @Nested
    private RoutingConfig routingConfig;
    private UpdateAliasResult updateAliasResult;

    public AWSLambdaUpdateAliasTask() {
        this.setDescription("Update Lambda Alias");
        this.setGroup("AWS");
    }

    @TaskAction
    public void updateFunctionAlias() {
        String functionName = this.getFunctionName();
        String aliasName = this.getAliasName();
        if (functionName == null) {
            throw new GradleException("functionName is required");
        }
        if (aliasName == null) {
            throw new GradleException("name for alias is required");
        }
        AWSLambda lambda = this.getAwsLambdaClient();
        UpdateAliasRequest updateAliasRequest = new UpdateAliasRequest().withFunctionName(functionName).withName(aliasName);
        if (this.getFunctionVersion() != null) {
            updateAliasRequest.withFunctionVersion(this.getFunctionVersion());
        }
        if (this.getDescription() != null) {
            updateAliasRequest.withDescription(this.getDescription());
        }
        if (this.getRoutingConfig() != null) {
            RoutingConfig routingConfig = this.getRoutingConfig();
            AliasRoutingConfiguration aliasRoutingConfiguration = routingConfig.getAliasRoutingConfiguration(functionName, this.getFunctionVersion());
            updateAliasRequest.withRoutingConfig(aliasRoutingConfiguration);
        }
        this.updateAliasResult = lambda.updateAlias(updateAliasRequest);
        this.getLogger().info("Update Lambda alias requested: {}, name: {}", (Object)functionName, (Object)aliasName);
    }

    private AWSLambda getAwsLambdaClient() {
        AWSLambdaPluginExtension ext = (AWSLambdaPluginExtension)this.getProject().getExtensions().getByType(AWSLambdaPluginExtension.class);
        return (AWSLambda)ext.getClient();
    }

    public void routingConfig(Closure<RoutingConfig> c) {
        c.setResolveStrategy(1);
        if (this.routingConfig == null) {
            this.routingConfig = new RoutingConfig();
        }
        c.setDelegate((Object)this.routingConfig);
        c.call();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public String getFunctionVersion() {
        return this.functionVersion;
    }

    public void setFunctionVersion(String functionVersion) {
        this.functionVersion = functionVersion;
    }

    public String getAliasDescription() {
        return this.aliasDescription;
    }

    public void setAliasDescription(String aliasDescription) {
        this.aliasDescription = aliasDescription;
    }

    public RoutingConfig getRoutingConfig() {
        return this.routingConfig;
    }

    public void setRoutingConfig(RoutingConfig routingConfig) {
        this.routingConfig = routingConfig;
    }

    public UpdateAliasResult getUpdateAliasResult() {
        return this.updateAliasResult;
    }
}

