/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.lambda;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.CreateAliasRequest;
import com.amazonaws.services.lambda.model.CreateAliasResult;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.Environment;
import com.amazonaws.services.lambda.model.FunctionCode;
import com.amazonaws.services.lambda.model.FunctionConfiguration;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.services.lambda.model.ListTagsRequest;
import com.amazonaws.services.lambda.model.ListTagsResult;
import com.amazonaws.services.lambda.model.ResourceNotFoundException;
import com.amazonaws.services.lambda.model.Runtime;
import com.amazonaws.services.lambda.model.TagResourceRequest;
import com.amazonaws.services.lambda.model.UntagResourceRequest;
import com.amazonaws.services.lambda.model.UpdateAliasRequest;
import com.amazonaws.services.lambda.model.UpdateAliasResult;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeResult;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationResult;
import com.amazonaws.services.lambda.model.VpcConfig;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import jp.classmethod.aws.gradle.lambda.AWSLambdaPluginExtension;
import jp.classmethod.aws.gradle.lambda.S3File;
import jp.classmethod.aws.gradle.lambda.VpcConfigWrapper;
import org.gradle.api.GradleException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSLambdaMigrateFunctionTask
extends ConventionTask {
    private String functionName;
    private String role;
    private Runtime runtime;
    private String handler;
    private String functionDescription;
    private Integer timeout;
    private Integer memorySize;
    private File zipFile;
    private S3File s3File;
    private VpcConfigWrapper vpc;
    private Map<String, String> environment;
    private Map<String, String> tags;
    private Boolean publish;
    private CreateFunctionResult createFunctionResult;
    private String alias;

    public AWSLambdaMigrateFunctionTask() {
        this.setDescription("Create / Update Lambda function.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createOrUpdateFunction() throws FileNotFoundException, IOException {
        String functionName = this.getFunctionName();
        File zipFile = this.getZipFile();
        S3File s3File = this.getS3File();
        if (functionName == null) {
            throw new GradleException("functionName is required");
        }
        if (zipFile == null && s3File == null || zipFile != null && s3File != null) {
            throw new GradleException("exactly one of zipFile or s3File is required");
        }
        if (s3File != null) {
            s3File.validate();
        }
        AWSLambdaPluginExtension ext = (AWSLambdaPluginExtension)this.getProject().getExtensions().getByType(AWSLambdaPluginExtension.class);
        AWSLambda lambda = (AWSLambda)ext.getClient();
        try {
            GetFunctionResult getFunctionResult = lambda.getFunction(new GetFunctionRequest().withFunctionName(functionName));
            FunctionConfiguration config = getFunctionResult.getConfiguration();
            if (config == null) {
                config = new FunctionConfiguration().withRuntime(Runtime.Nodejs);
            }
            this.updateFunctionConfiguration(lambda, config);
            this.updateFunctionCode(lambda);
        }
        catch (ResourceNotFoundException e) {
            this.getLogger().warn(e.getMessage());
            this.getLogger().warn("Creating function... {}", (Object)functionName);
            this.createFunction(lambda);
        }
    }

    private void createFunction(AWSLambda lambda) throws IOException {
        FunctionCode functionCode;
        block26: {
            File zipFile = this.getZipFile();
            S3File s3File = this.getS3File();
            if (zipFile != null) {
                try (RandomAccessFile raf = new RandomAccessFile(this.getZipFile(), "r");
                     FileChannel channel = raf.getChannel();){
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
                    buffer.load();
                    functionCode = new FunctionCode().withZipFile((ByteBuffer)buffer);
                    break block26;
                }
            }
            functionCode = new FunctionCode().withS3Bucket(s3File.getBucketName()).withS3Key(s3File.getKey()).withS3ObjectVersion(s3File.getObjectVersion());
        }
        CreateFunctionRequest request = new CreateFunctionRequest().withFunctionName(this.getFunctionName()).withRuntime(this.getRuntime()).withRole(this.getRole()).withHandler(this.getHandler()).withDescription(this.getFunctionDescription()).withTimeout(this.getTimeout()).withMemorySize(this.getMemorySize()).withPublish(this.getPublish()).withVpcConfig(this.getVpcConfig()).withEnvironment(new Environment().withVariables(this.getEnvironment())).withTags(this.getTags()).withCode(functionCode);
        this.createFunctionResult = lambda.createFunction(request);
        this.getLogger().info("Create Lambda function requested: {}", (Object)this.createFunctionResult.getFunctionArn());
        if (this.getAlias() != null) {
            this.createOrUpdateAlias(lambda, this.createFunctionResult.getVersion());
        }
    }

    private void updateFunctionCode(AWSLambda lambda) throws IOException {
        UpdateFunctionCodeRequest request;
        block27: {
            File zipFile = this.getZipFile();
            S3File s3File = this.getS3File();
            request = new UpdateFunctionCodeRequest().withFunctionName(this.getFunctionName());
            if (zipFile != null) {
                try (RandomAccessFile raf = new RandomAccessFile(this.getZipFile(), "r");
                     FileChannel channel = raf.getChannel();){
                    MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
                    buffer.load();
                    request = request.withZipFile((ByteBuffer)buffer);
                    break block27;
                }
            }
            request = request.withS3Bucket(s3File.getBucketName()).withS3Key(s3File.getKey()).withS3ObjectVersion(s3File.getObjectVersion());
        }
        if (this.getPublish() != null) {
            request.withPublish(this.getPublish());
        }
        UpdateFunctionCodeResult updateFunctionCode = lambda.updateFunctionCode(request);
        this.getLogger().info("Update Lambda function requested: {}", (Object)updateFunctionCode.getFunctionArn());
        if (this.getAlias() != null) {
            this.createOrUpdateAlias(lambda, updateFunctionCode.getVersion());
        }
    }

    private void updateFunctionConfiguration(AWSLambda lambda, FunctionConfiguration config) {
        Integer updateMemorySize;
        Integer updateTimeout;
        String updateDescription;
        String updateHandler;
        Runtime updateRuntime;
        String updateRole;
        String updateFunctionName = this.getFunctionName();
        if (updateFunctionName == null) {
            updateFunctionName = config.getFunctionName();
        }
        if ((updateRole = this.getRole()) == null) {
            updateRole = config.getRole();
        }
        if ((updateRuntime = this.getRuntime()) == null) {
            updateRuntime = Runtime.fromValue((String)config.getRuntime());
        }
        if ((updateHandler = this.getHandler()) == null) {
            updateHandler = config.getHandler();
        }
        if ((updateDescription = this.getFunctionDescription()) == null) {
            updateDescription = config.getDescription();
        }
        if ((updateTimeout = this.getTimeout()) == null) {
            updateTimeout = config.getTimeout();
        }
        if ((updateMemorySize = this.getMemorySize()) == null) {
            updateMemorySize = config.getMemorySize();
        }
        UpdateFunctionConfigurationRequest request = new UpdateFunctionConfigurationRequest().withFunctionName(updateFunctionName).withRole(updateRole).withRuntime(updateRuntime).withHandler(updateHandler).withDescription(updateDescription).withTimeout(updateTimeout).withVpcConfig(this.getVpcConfig()).withEnvironment(new Environment().withVariables(this.getEnvironment())).withMemorySize(updateMemorySize);
        UpdateFunctionConfigurationResult updateFunctionConfiguration = lambda.updateFunctionConfiguration(request);
        this.getLogger().info("Update Lambda function configuration requested: {}", (Object)updateFunctionConfiguration.getFunctionArn());
        this.tagFunction(lambda, config);
    }

    private void createOrUpdateAlias(AWSLambda lambda, String functionVersion) {
        this.getLogger().info("Create or Update alias {} for {}", (Object)this.getAlias(), (Object)functionVersion);
        try {
            this.updateAlias(lambda, functionVersion);
        }
        catch (ResourceNotFoundException e) {
            this.createAlias(lambda, functionVersion);
        }
    }

    private void updateAlias(AWSLambda lambda, String functionVersion) {
        UpdateAliasRequest updateAliasRequest = new UpdateAliasRequest().withFunctionName(this.getFunctionName()).withFunctionVersion(functionVersion).withName(this.getAlias());
        UpdateAliasResult updateAliasResult = lambda.updateAlias(updateAliasRequest);
        this.getLogger().info("Update Lambda alias requested: {}", (Object)updateAliasResult.getAliasArn());
    }

    private void createAlias(AWSLambda lambda, String functionVersion) {
        CreateAliasRequest createAliasRequest = new CreateAliasRequest().withFunctionName(this.getFunctionName()).withFunctionVersion(functionVersion).withName(this.getAlias());
        CreateAliasResult createAliasResult = lambda.createAlias(createAliasRequest);
        this.getLogger().info("Create Lambda alias requested: {}", (Object)createAliasResult.getAliasArn());
    }

    private VpcConfig getVpcConfig() {
        if (this.getVpc() != null) {
            return this.getVpc().toVpcConfig();
        }
        return null;
    }

    private void tagFunction(AWSLambda lambda, FunctionConfiguration config) {
        if (this.getTags() != null) {
            ListTagsRequest listTagsRequest = new ListTagsRequest().withResource(config.getFunctionArn());
            ListTagsResult listTagsResult = lambda.listTags(listTagsRequest);
            if (!listTagsResult.getTags().isEmpty()) {
                MapDifference tagDifferences = Maps.difference((Map)listTagsResult.getTags(), this.getTags());
                UntagResourceRequest untagResourceRequest = new UntagResourceRequest().withResource(config.getFunctionArn()).withTagKeys(tagDifferences.entriesOnlyOnLeft().keySet());
                lambda.untagResource(untagResourceRequest);
            }
            if (!this.getTags().isEmpty()) {
                TagResourceRequest tagResourceRequest = new TagResourceRequest().withTags(this.getTags()).withResource(config.getFunctionArn());
                lambda.tagResource(tagResourceRequest);
                this.getLogger().info("Update Lambda function tags requested: {}", (Object)config.getFunctionArn());
            }
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getFunctionDescription() {
        return this.functionDescription;
    }

    public void setFunctionDescription(String functionDescription) {
        this.functionDescription = functionDescription;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySize(Integer memorySize) {
        this.memorySize = memorySize;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public S3File getS3File() {
        return this.s3File;
    }

    public void setS3File(S3File s3File) {
        this.s3File = s3File;
    }

    public VpcConfigWrapper getVpc() {
        return this.vpc;
    }

    public void setVpc(VpcConfigWrapper vpc) {
        this.vpc = vpc;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Boolean getPublish() {
        return this.publish;
    }

    public void setPublish(Boolean publish) {
        this.publish = publish;
    }

    public CreateFunctionResult getCreateFunctionResult() {
        return this.createFunctionResult;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

