/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import jp.classmethod.aws.gradle.elasticbeanstalk.AwsBeanstalkPluginExtension;
import jp.classmethod.aws.gradle.s3.AmazonS3FileUploadTask;
import org.gradle.api.Project;

public class AWSElasticBeanstalkUploadBundleTask
extends AmazonS3FileUploadTask {
    private String extension = "zip";
    private String versionLabel;

    public AWSElasticBeanstalkUploadBundleTask() {
        this.setDescription("Upload Elastic Beanstalk application bundle file to S3.");
    }

    @Override
    public void upload() throws IOException {
        Project project = this.getProject();
        AwsBeanstalkPluginExtension ext = (AwsBeanstalkPluginExtension)project.getExtensions().getByType(AwsBeanstalkPluginExtension.class);
        AWSElasticBeanstalk eb = (AWSElasticBeanstalk)ext.getClient();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'_'HHmmss", Locale.ENGLISH);
        df.setTimeZone(TimeZone.getDefault());
        this.versionLabel = String.format(Locale.ENGLISH, "%s-%s", project.getVersion().toString(), df.format(new Date()));
        String artifactId = project.property("artifactId").toString();
        this.setBucketName(eb.createStorageLocation().getS3Bucket());
        this.setKey(String.format(Locale.ENGLISH, "eb-apps/%s/%s-%s.%s", artifactId, artifactId, this.versionLabel, this.extension));
        super.upload();
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }
}

