/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.aws.gradle.elasticbeanstalk;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationDescription;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;
import groovy.json.JsonParserType;
import groovy.json.JsonSlurper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.classmethod.aws.gradle.elasticbeanstalk.AwsBeanstalkPluginExtension;
import jp.classmethod.aws.gradle.elasticbeanstalk.EbConfigurationTemplateExtension;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;

public class AWSElasticBeanstalkCreateConfigurationTemplateTask
extends ConventionTask {
    private String appName;
    private Collection<EbConfigurationTemplateExtension> configurationTemplates = new ArrayList<EbConfigurationTemplateExtension>();
    private String defaultSolutionStackName = "64bit Amazon Linux 2013.09 running Tomcat 7 Java 7";

    public AWSElasticBeanstalkCreateConfigurationTemplateTask() {
        this.setDescription("Create / Migrate ElasticBeanstalk Configuration Templates.");
        this.setGroup("AWS");
    }

    @TaskAction
    public void createTemplate() {
        String appName = this.getAppName();
        AwsBeanstalkPluginExtension ext = (AwsBeanstalkPluginExtension)this.getProject().getExtensions().getByType(AwsBeanstalkPluginExtension.class);
        AWSElasticBeanstalk eb = (AWSElasticBeanstalk)ext.getClient();
        this.configurationTemplates.forEach(config -> {
            String templateName = config.getName();
            String templateDesc = config.getDesc();
            String solutionStackName = config.getSolutionStackName() != null ? config.getSolutionStackName() : this.getDefaultSolutionStackName();
            boolean deleteTemplateIfExists = config.isRecreate();
            try {
                List<ConfigurationOptionSetting> optionSettings = this.loadConfigurationOptions(config.getOptionSettings());
                List existingApps = eb.describeApplications(new DescribeApplicationsRequest().withApplicationNames(new String[]{appName})).getApplications();
                if (existingApps.isEmpty()) {
                    throw new IllegalArgumentException("App with name '" + appName + "' does not exist");
                }
                if (((ApplicationDescription)existingApps.get(0)).getConfigurationTemplates().contains(templateName)) {
                    if (deleteTemplateIfExists) {
                        eb.deleteConfigurationTemplate(new DeleteConfigurationTemplateRequest().withApplicationName(appName).withTemplateName(templateName));
                        this.getLogger().info("configuration template {} @ {} deleted", (Object)templateName, (Object)appName);
                    } else {
                        eb.updateConfigurationTemplate(new UpdateConfigurationTemplateRequest().withApplicationName(appName).withTemplateName(templateName).withDescription(templateDesc).withOptionSettings(optionSettings));
                        this.getLogger().info("configuration template {} @ {} updated", (Object)templateName, (Object)appName);
                        return;
                    }
                }
                eb.createConfigurationTemplate(new CreateConfigurationTemplateRequest().withApplicationName(appName).withTemplateName(templateName).withDescription(templateDesc).withSolutionStackName(solutionStackName).withOptionSettings(optionSettings));
                this.getLogger().info("configuration template {} @ {} created", (Object)templateName, (Object)appName);
            }
            catch (IOException e) {
                this.getLogger().error("IOException", (Throwable)e);
            }
        });
    }

    List<ConfigurationOptionSetting> loadConfigurationOptions(String json) {
        ArrayList<ConfigurationOptionSetting> options = new ArrayList<ConfigurationOptionSetting>();
        Collection c = (Collection)new JsonSlurper().setType(JsonParserType.LAX).parseText(json);
        c.forEach(it -> options.add(new ConfigurationOptionSetting((String)it.get("Namespace"), (String)it.get("OptionName"), (String)it.get("Value"))));
        return options;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Collection<EbConfigurationTemplateExtension> getConfigurationTemplates() {
        return this.configurationTemplates;
    }

    public void setConfigurationTemplates(Collection<EbConfigurationTemplateExtension> configurationTemplates) {
        this.configurationTemplates = configurationTemplates;
    }

    public String getDefaultSolutionStackName() {
        return this.defaultSolutionStackName;
    }

    public void setDefaultSolutionStackName(String defaultSolutionStackName) {
        this.defaultSolutionStackName = defaultSolutionStackName;
    }
}

